// WrappedSample.cpp
// AllegrosampleC++pbp[.
// 
#include "WrappedSample.h"
#include "GmEntry.h"


//public:static 
WrappedSample *WrappedSample::createN(char* aFileName){
	WrappedSample *self = new WrappedSample();
	if(self->constructE(aFileName) != ERROR_NONE){
		delete self;
		self = NULL;
	}
	return self;
}

//protected:virtual 
int WrappedSample::constructE(char* aFileName){
//	iSample = load_sample(aFileName);
	iSample = load_wav(aFileName);
	if(!iSample){
		return ERROR_GENERAL;
	}
	return ERROR_NONE;
}

WrappedSample::WrappedSample() :
	iSample(NULL) {
	iFreq = 1000;
	iVol = 0;
	iPan = 128;
	iLoop = 0;
}

//public:virtual 
WrappedSample::~WrappedSample(){
	if(iSample != NULL){
		destroy_sample(iSample);
		iSample = NULL;
	}
}

//public:virtual
int WrappedSample::playE(int aVol, int aPan, int aFreq, int aLoop){
	iVol = aVol;
	iPan = aPan;
	iFreq = aFreq;
	iLoop = aLoop;
	return play_sample(iSample, iVol, iPan, iFreq, iLoop);
}

//public:virtual 
void WrappedSample::adjust(int aVol, int aPan, int aFreq, int aLoop){
	iVol = aVol;
	iPan = aPan;
	iFreq = aFreq;
	iLoop = aLoop;
	adjust_sample(iSample, iVol, iPan, iFreq, iLoop);
}

//public:virtual 
void WrappedSample::update(){
	//nop;
}

//public:virtual 
void WrappedSample::stop(){
	stop_sample(iSample);
}

