#include "TStage.h"
#include "TSanta.h"
#include "TPeople.h"
#include "TPeople2.h"
#include "TDecor.h"
#include "TSock.h"
#include "TDream.h"

extern Settings *GE_settings;

TStage::TStage(GmTask *aParent) : GmTask(aParent){
	iParent = aParent;
	iX = 320;
	iY = 240;
	iAge = 0;
	iStatus = ST_TITLEINIT;
	this->setPriotiyy(GmTask::EPriorityExLow+10);
	iSprite[0] = NULL;
	iSprite[1] = NULL;
	iSprite[2] = NULL;
	iSprite[3] = NULL;
}

int TStage::initializeE(){
	GmMain *parent = (GmMain *)iParent;
	BITMAP *src = parent->getGmGfxN()->getSprite();

	iSprite[0] = create_sub_bitmap(src, 0*2, 64*2, 80*2, 16*2);
	if(!(iSprite[0])){
		return ERROR_GENERAL;
	}
	iSprite[1] = create_sub_bitmap(src, 96*2, 16*2, 32*2, 32*2);
	if(!(iSprite[1])){
		return ERROR_GENERAL;
	}
	iSprite[2] = create_sub_bitmap(src, 0*2, 80*2, 120*2, 48*2);
	if(!(iSprite[2])){
		return ERROR_GENERAL;
	}
	iSprite[3] = create_sub_bitmap(src, 0*2, 128*2, 160*2, 32*2);
	if(!(iSprite[3])){
		return ERROR_GENERAL;
	}

	return ERROR_NONE;
}

TStage::~TStage(){
	if(iSprite[0]){
		destroy_bitmap(iSprite[0]);
		iSprite[0] = NULL;
	}
	if(iSprite[1]){
		destroy_bitmap(iSprite[1]);
		iSprite[1] = NULL;
	}
	if(iSprite[2]){
		destroy_bitmap(iSprite[2]);
		iSprite[2] = NULL;
	}
	if(iSprite[3]){
		destroy_bitmap(iSprite[3]);
		iSprite[3] = NULL;
	}
}

void TStage::update(){
	GmMain *parent = (GmMain *)iParent;
	GmGfx *gfx = parent->getGmGfxN();
	BITMAP *dst = gfx->getBackBuffer();
	iAge++;

	switch(iStatus){
		case ST_TITLEINIT:{
			iAge = 0;
			parent->getGmInputN()->setListener(this);
			((GmMain *)iParent)->getGmSoundN()->stopToySound(4);
			((GmMain *)iParent)->getGmSoundN()->stopToySound(5);
			((GmMain *)iParent)->getGmSoundN()->playToySoundE(4, 1);
			iStatus = ST_TITLE;
		}break;
		case ST_TITLE:{
			//H\.
			int p = iAge + 200;//& 0x000000ff;
			for(int i = 0; i < 8; i++){
				draw_sprite(dst, iSprite[1], p % (dst->w), p % (dst->h) );
				p = p << 1;
			}
			//^CgS\.
			draw_sprite(dst, iSprite[0], (dst->w / 2) - (iSprite[0]->w / 2), (dst->h / 2) - (iSprite[0]->h / 2) + (fixcos(itofix(iAge&0x000000ff)) >> 13) );
			//nCXRA\
			textprintf_ex(dst, font, BB_MARGIN + 2, BB_MARGIN + 2, makecol(255,100,100), -1, "HIGH SCORE%7d", GE_settings->highScore);
		}break;
		case ST_GAMEINIT:{
			iAge = 0;
			parent->getGmInputN()->releaseListener(this);			
			GmTask *t = NULL;
			int i;

			srand(GE_getCurrentTime());
			GE_settings->score = 0;

			//.
			for(i = 0; i < 128; i++){
				t = TDecor::createN(iParent, (i == 0 ? 1 : 0));
				if(((GmMain *)iParent)->addChildE(t) != ERROR_NONE){
					delete t;
					t = NULL;
				}
				t = NULL;
			}

			//.
			for(i = 0; i < 20; i++){
				t = TSock::createN(iParent);
				if(((GmMain *)iParent)->addChildE(t) != ERROR_NONE){
					delete t;
				}
				t = NULL;
			}

			t = TSanta::createN(iParent);
			if(((GmMain *)iParent)->addChildE(t) != ERROR_NONE){
				delete t;
			}
			t = NULL;
			((GmMain *)iParent)->getGmSoundN()->stopToySound(4);
			((GmMain *)iParent)->getGmSoundN()->stopToySound(5);
			((GmMain *)iParent)->getGmSoundN()->playToySoundE(5, 1);
			iStatus = ST_GAME;
		}break;
		case ST_GAME:{
			//isɍ킹Ė邳w.
			gfx->setBrightness( getTime() );
			if(getTime() >= 128){
				iStatus = ST_OVERINIT;
			}

			//dream.
			if((iAge & 0x01f) == 0x01f){
				GmTask *t = TDream::createN(parent);
				if(parent->addChildE(t) != ERROR_NONE){
					delete t;
					t = NULL;
				}else{
					((TDream *)t)->setXY(rand() * (dst->w >> 1) / RAND_MAX + (dst->w >> 2), 440 + 32);
				}
				t = NULL;
			}
			//ǂ.
			if((iAge & 0x000003ff) == 0x000003ff){
				GmTask *t = TPeople::createN(parent);
				if(parent->addChildE(t) != ERROR_NONE){
					delete t;
					t = NULL;
				}else{
					//((TPeople *)t)->setXY(160, 320);
				}
				t = NULL;
			}
			if(key[KEY_Q]){
				iStatus = ST_RESET;
			}

			//drawing:
			rectfill(dst, BB_MARGIN, BB_MARGIN, BB_MARGIN + (128 - getTime()) * (dst->w - BB_MARGIN*2) / 128, BB_MARGIN+8, makecol(255,64,64) );
			draw_sprite(dst, iSprite[3], BB_MARGIN, dst->h - BB_MARGIN - iSprite[3]->h );
		}break;
		case ST_OVERINIT:{
			parent->getGmInputN()->setListener(this);
			iStatus = ST_OVER;
			iAge = 0;
		}break;
		case ST_OVER:{
			if(iAge < 128){
				gfx->setBrightness(128 + iAge);
			}else{
				gfx->setBrightness(255);
			}

			//ǂ.
			if(TSock::getEmptySocks() == 0 && (iAge & 0x0000000f) == 0x0000000f){
				GmTask *t = TPeople2::createN(parent);
				if(parent->addChildE(t) != ERROR_NONE){
					delete t;
				}
				t = NULL;
			}
			
			//draw something.
			int addY;
			if(iAge < 32){
				addY = -32 / iAge;
			}else{
				addY = 0;
			}
			draw_sprite(dst, iSprite[2], (dst->w / 2) - (iSprite[2]->w / 2), (dst->h / 2) - (iSprite[2]->h / 2) + (fixcos(itofix(iAge&0x000000ff)) >> 13) + addY );
			draw_sprite(dst, iSprite[3], BB_MARGIN, dst->h - BB_MARGIN - iSprite[3]->h );
		}break;
		case ST_RESET:{
			iStatus = ST_TITLEINIT;
			parent->requestFlood(this);
		}break;
		default:{
		}break;
	}
}

void TStage::keyPressed(int aKeyCode){
}
void TStage::keyReleased(int aKeyCode){
	if(iStatus == ST_TITLE && aKeyCode == KEY_Z){
		iStatus = ST_GAMEINIT;
	}else if(iStatus == ST_OVER && aKeyCode == KEY_Z){
		//nCXRAXV
		if(GE_settings->highScore < GE_settings->score){
			GE_settings->highScore = GE_settings->score;
		}
		iStatus = ST_RESET;
	}
}
