#include "TSock.h"
#include "TGift.h"
#include <typeinfo.h>

extern Settings *GE_settings;

//static init
int TSock::iEmptySocks = 0;

//static
TSock *TSock::createN(GmTask *aParent){
	TSock *self = new TSock(aParent);
	if(self->initializeE() != ERROR_NONE){
		delete self;
		self = NULL;
	}
	return self;
}

TSock::TSock(GmTask *aParent) : GmTask(aParent){
	iParent = aParent;
	iAge = 0;
	this->setPriotiyy(GmTask::EPriorityLow-5);

	iPat = 0;
	iSprite[0] = NULL;
	iSprite[1] = NULL;

	iX = 0;
	iY = 0;
	iXDiff = 0;
	iYDiff = 0;
	iFAngle = 0;
	iFDAngle = 0;

	iColW = 16;
	iColH = 16;

	TSock::iEmptySocks++;
}

TSock::initializeE(){
	GmGfx *gfx = NULL;
	gfx = ((GmMain *)iParent)->getGmGfxN();
	if(!gfx){
		return ERROR_NOT_EXISTS;
	}
	BITMAP *src = NULL;
	src = gfx->getSprite();
	if(!src){
		return ERROR_NOT_EXISTS;
	}
	BITMAP *dst = gfx->getBackBuffer();
	if(!dst){
		return ERROR_NOT_EXISTS;
	}

	//WN_.
	iXBase = (dst->w) >> 1;
	iYBase = 150 + 32;
	//c[_yW.
	iYDiff = fixtoi((fixsin(itofix(rand() * 64 / RAND_MAX))) * 240);
	//c[~ɌĂĊpx.
	iFAngle = itofix(rand() * 255 / RAND_MAX);
	//pxx.
	iFDAngle = itofix(1);

	//Eǂ̌C̊G.
	int type = 32 * (rand() * 2 / RAND_MAX);
	iSprite[0] = create_sub_bitmap(src, 64*2 + type, 16*2, 32, 32);
	if(!(iSprite[0])){
		return ERROR_GENERAL;
	}
	iSprite[1] = create_sub_bitmap(src, 64*2 + type, 32*2, 32, 32);
	if(!(iSprite[1])){
		return ERROR_GENERAL;
	}

	return ERROR_NONE;	
}

TSock::~TSock(){	
	if(iSprite[0]){
		destroy_bitmap(iSprite[0]);
		iSprite[0] = NULL;
	}
	if(iSprite[1]){
		destroy_bitmap(iSprite[1]);
		iSprite[1] = NULL;
	}
	if(iPat != 1){
		iEmptySocks--;
		if(iEmptySocks < 0){
			iEmptySocks = 0;
		}
	}
}



void TSock::update(){
	GmMain *parent = (GmMain *)iParent;
	BITMAP *dst = parent->getGmGfxN()->getBackBuffer();
	iAge++;

//move
	iFAngle = (0x00ffffff) & (iFAngle + iFDAngle);
	iXDiff = (int)( fixmul((fixcos(iFAngle)), fixdiv(itofix(iYDiff), itofix(240))  ) )>>9;

	iX = iXDiff + iXBase;
	iY = iYDiff + iYBase;
	
//drawing.
	if(isVisible()){
		draw_sprite(dst, iSprite[iPat], iX - (iSprite[iPat]->w >> 1), iY - (iSprite[iPat]->h >> 1));
		//fastline(dst, iX, iY, iXBase, iYBase, makecol(0,128,0));
		if(iPat == 0){
			iColW = 16;
			iColH = 16;
		}
	}else{
		iColW = 0;
		iColH = 0;
	}

	if(iPat == 1 && iAge < 8){
		circle(dst, iX, iY, iAge << 2, makecol(255,255,255));
		circle(dst, iX, iY, iAge << 1, makecol(255,255,255));
	}


}

void TSock::notifyCollision(GmTask *aTask){
	if(typeid(*aTask) == typeid(TGift)){
		iColW = 0;
		iColH = 0;
		iAge = 0;
		GE_settings->score += 500;
		iPat = 1;
		TSock::iEmptySocks--;
		if(TSock::iEmptySocks == 0){
			GE_settings->score += 2000;
		}
		((GmMain *)iParent)->getGmSoundN()->playToySoundE(3);
	}
}
