#include "TSanta.h"
#include "TGift.h"
#include "TDream.h"
#include "TSock.h"

extern Settings *GE_settings;

//static
TSanta *TSanta::createN(GmTask *aParent){
	TSanta *self = new TSanta(aParent);
	if(self->initializeE() != ERROR_NONE){
		delete self;
		self = NULL;
	}
	return self;
}

TSanta::TSanta(GmTask *aParent) : GmTask(aParent){
	iParent = aParent;
	iX = 320;
	iY = 60 + 32;
	iAge = 0;
	this->setPriotiyy(GmTask::EPriorityLow);

	for(int i = 0; i < TSanta_SPRITE_NUM; i++){
		iSprite[i] = NULL;
	}

	iDx = 0;
	iDy = 0;

	iAllowKey = 0;
	iPat = 0;

	iColW = 16;
	iColH = 16;

	iPow = 0;

	iStage = NULL;
}

TSanta::initializeE(){
	GmGfx *gfx = NULL;
	gfx = ((GmMain *)iParent)->getGmGfxN();
	if(!gfx){
		return ERROR_NOT_EXISTS;
	}
	BITMAP *src = NULL;
	src = gfx->getSprite();
	if(!src){
		return ERROR_NOT_EXISTS;
	}

	for(int i = 0; i < TSanta_SPRITE_NUM-1; i++){
		iSprite[i] = create_sub_bitmap(src, i*32, 0, 32, 32);
		if(!(iSprite[i])){
			return ERROR_GENERAL;
		}
	}
	iSprite[TSanta_SPRITE_NUM-1] = create_sub_bitmap(src, 0*2, 48*2, 32, 32);
	if(!(iSprite[TSanta_SPRITE_NUM-1])){
		return ERROR_GENERAL;
	}

	GmInput *in = NULL;
	in = ((GmMain *)iParent)->getGmInputN();
	if(!in){
		return ERROR_NOT_EXISTS;
	}
	in->setListener(this);

	iStage = (TStage *)((GmMain *)iParent)->getGmTaskByTypeN(typeid(TStage));

	return ERROR_NONE;	
}

TSanta::~TSanta(){
	if(iParent){
		GmInput *in = ((GmMain *)iParent)->getGmInputN();
		if(in){
			in->releaseListener(this);
		}
	}
	
	for(int i = 0; i < TSanta_SPRITE_NUM; i++){
		if(iSprite[i]){
			destroy_bitmap(iSprite[i]);
			iSprite[i] = NULL;
		}
	}
}


void TSanta::keyPressed(int aKeyCode){
	if(aKeyCode == KEY_LEFT){
		iAllowKey--;
	}
	if(aKeyCode == KEY_RIGHT){
		iAllowKey++;
	}
	if(aKeyCode == KEY_Z && iPow >= 3){
		iPow -= 3;
		GmTask *t = TGift::createN(iParent);
		if(((GmMain *)iParent)->addChildE(t) != ERROR_NONE){
			delete t;
			t = NULL;
		}else{
			((TGift *)t)->setXY(iX, iY);
			((GmMain *)iParent)->getGmSoundN()->playToySoundE(2);
		}
	}
}

void TSanta::keyReleased(int aKeyCode){
	if(aKeyCode == KEY_LEFT){
		iAllowKey++;
	}
	if(aKeyCode == KEY_RIGHT){
		iAllowKey--;
	}
}

void TSanta::update(){
	int i;
	GmMain *parent = (GmMain *)iParent;
	BITMAP *dst = parent->getGmGfxN()->getBackBuffer();
//	BITMAP *src = parent->getGmGfxN()->getSprite();
	iAge++;

	//Q[I[o[œ蔻
	if(iStage && iStage->getStatus() == TStage::ST_OVER){
		iColW = 0;
		iColH = 0;
		iAllowKey = 0;
	}


//move
	if(iDx > 0){
		iDx -= 16;
	}else if(iDx < 0){
		iDx += 16;
	}

	iDx += iAllowKey << 6;
	if(iDx < -(8<<4)){
		iDx = -(8<<4);
	}
	if(iDx > (8<<4)){
		iDx = (8<<4);
	}
	
	iX += iDx >> 4;
	if(iX < BB_MARGIN || dst->w - BB_MARGIN < iX){
		iX -= iDx >> 4;
	}
	iY += iDy >> 4;


//pattern update
	if(iStage && iStage->getStatus() == TStage::ST_OVER){
		while(iPat < 8){
			iPat += 4;
		}
	}else if(iAllowKey == 0){
		if(iPat < 4){
			iPat += 4;
		}
	}else if(iAllowKey > 0){
		iPat = 2;
	}else /*if iAllowKey < 0*/{
		iPat = 0;
	}
	iPat = (iPat & 0xfffffffe) | ((iAge >> 1) & 0x00000001);

//drawing.
	//gift stocks, etc
	int powX = 2 + BB_MARGIN;
	int powY = 12 + BB_MARGIN;
	for(i = 0; i < (iPow/3); i++){
		draw_sprite(dst, iSprite[TSanta_SPRITE_NUM-1], powX + i * 32, powY + 18);
	}
	for(i = 0; i < 2; i++){
		if(i < iPow%3){
			rectfill(dst, powX + i * 16, powY, powX + i * 16 + 14, powY + 14, makecol(255,100,100));
		}else{
			rect(dst, powX + i * 16, powY, powX + i * 16 + 14, powY + 14, makecol(255,100,100));
		}
	}
	textprintf_ex(dst, font, powX + 2 * 16 + 2, powY, makecol(255,100,100), -1, "SCORE%8d / HI%8d", GE_settings->score, GE_settings->highScore);
	//textprintf_ex(dst, font, powX + 2 * 16 + 2, powY+8, makecol(255,100,100), -1, "HIGH SCORE%7d", GE_settings->highScore);
	textprintf_ex(dst, font, powX + 2 * 16 + 2, powY + 9, makecol(255,100,100), -1, "%2d EMPTY SOCKS", TSock::getEmptySocks());


	//Santa
	draw_sprite(dst, iSprite[iPat], iX - (iSprite[iPat]->w >> 1),iY - (iSprite[iPat]->h >> 1));
}
void TSanta::notifyCollision(GmTask *aTask){
	if(typeid(*aTask) == typeid(TDream) && iPow < 30){
		iPow++;
		GE_settings->score += 100;
		((GmMain *)iParent)->getGmSoundN()->playToySoundE(1);
	}
}