#include "TPeople.h"
#include "TDream.h"

//static
TPeople *TPeople::createN(GmTask *aParent){
	TPeople *self = new TPeople(aParent);
	if(self->initializeE() != ERROR_NONE){
		delete self;
		self = NULL;
	}
	return self;
}

TPeople::TPeople(GmTask *aParent) : GmTask(aParent){
	iParent = aParent;
	iX = 0;
	iY = 0;
	iAge = 0;
	this->setPriotiyy(GmTask::EPriorityLow-9);

	iCol = makecol( (rand() * 2 / RAND_MAX) * 255, (rand() * 2 / RAND_MAX) * 255, (rand() * 2 / RAND_MAX) * 255);
	if(iCol == makecol(0,0,0)){
		iCol = makecol(255,0,0);
	}

	for(int i = 0; i < 4; i++){
		iSprite[i] = NULL;
	}

	iDx = 0;
	iDy = 0;

	iAllowKey = 0;
	iPat = 0;
}

TPeople::initializeE(){
	GmGfx *gfx = NULL;
	gfx = ((GmMain *)iParent)->getGmGfxN();
	if(!gfx){
		return ERROR_NOT_EXISTS;
	}
	BITMAP *src = NULL;
	src = gfx->getSprite();
	if(!src){
		return ERROR_NOT_EXISTS;
	}
	BITMAP *dst = gfx->getBackBuffer();
	if(!dst){
		return ERROR_NOT_EXISTS;
	}

	//side 01. ʂǂ瑤oĂ邩.
	int side = (rand() * 2 / RAND_MAX);
	iX = dst->w * side;
	iAllowKey = (side * -2) + 1;
	iY = 400 + 32;

	//side 01. j̎q̎q.
	side = (rand() * 2 / RAND_MAX);
	for(int i = 0; i < 4; i++){
		iSprite[i] = create_sub_bitmap(src, i*32, 32 + 32 * side, 32, 32);
		if(!(iSprite[i])){
			return ERROR_GENERAL;
		}
	}

	GmInput *in = NULL;
	in = ((GmMain *)iParent)->getGmInputN();
	if(!in){
		return ERROR_NOT_EXISTS;
	}

	return ERROR_NONE;	
}

TPeople::~TPeople(){	
	for(int i = 0; i < 4; i++){
		if(iSprite[i]){
			destroy_bitmap(iSprite[i]);
			iSprite[i] = NULL;
		}
	}
}



void TPeople::update(){
	GmMain *parent = (GmMain *)iParent;
	BITMAP *dst = parent->getGmGfxN()->getBackBuffer();
//	BITMAP *src = parent->getGmGfxN()->getSprite();
	iAge++;

	if((iAge & 0x0000000f) == 0x0000000f){
		GmTask *t = TDream::createN(iParent);
		if(((GmMain *)iParent)->addChildE(t) != ERROR_NONE){
			delete t;
			t = NULL;
		}else{
			((TDream *)t)->setXY(iX, iY);
		}
	}

//move
	if(iAllowKey > 0){
		iDx = 3<<4;
	}else if(iAllowKey < 0){
		iDx = -(3<<4);
	}
	iX += iDx >> 5;
	iY += iDy >> 5;

	if(iX < 0 || iX > dst->w || iY < 0 || iY > dst->h){
		setDelete();
	}

//pattern update
	if(iAllowKey > 0){
		iPat = 2;
	}else /*if iAllowKey < 0*/{
		iPat = 0;
	}
	iPat = (iPat & 0xfffffffe) | ((iAge >> 4) & 0x00000001);

//drawing.
	draw_sprite(dst, iSprite[iPat], iX - (iSprite[iPat]->w >> 1),iY - (iSprite[iPat]->h >> 1));
}
