#include "TGift.h"
#include "TSock.h"
#include <typeinfo.h>


TGift::TGift(GmTask *aParent) : GmTask(aParent){
	iParent = aParent;
	iX = 320;
	iY = 240;
	iAge = 0;
	this->setPriotiyy(GmTask::EPriorityLow-10);

	iSprite[0] = NULL;
	iSprite[1] = NULL;

	iDx = 0;
	iDy = 5;
	iPat = 0;

	iColW = 32;
	iColH = 32;
}

int TGift::initializeE(){
	GmGfx *gfx = NULL;
	gfx = ((GmMain *)iParent)->getGmGfxN();
	if(!gfx){
		return ERROR_NOT_EXISTS;
	}
	BITMAP *src = NULL;
	src = gfx->getSprite();
	if(!src){
		return ERROR_NOT_EXISTS;
	}

	//v[gQp^[.
	iSprite[0] = create_sub_bitmap(src, 0*2, 48*2, 32, 32);
	if(!(iSprite[0])){
		return ERROR_GENERAL;
	}
	iSprite[1] = create_sub_bitmap(src, 16*2, 48*2, 32, 32);
	if(!(iSprite[1])){
		return ERROR_GENERAL;
	}
	return ERROR_NONE;
}

TGift::~TGift(){
	if(iSprite[0]){
		destroy_bitmap(iSprite[0]);
		iSprite[0] = NULL;
	}
	if(iSprite[1]){
		destroy_bitmap(iSprite[1]);
		iSprite[1] = NULL;
	}
}

void TGift::update(){
	BITMAP *dst = ((GmMain *)iParent)->getGmGfxN()->getBackBuffer();
	iAge++;

	iX += iDx;
	iY += iDy;

	if(iX < 0 || iX > dst->w || iY < 0 || iY > dst->h){
		setDelete();
	}

	iPat = (iAge >> 1) & 0x00000001;

	draw_sprite(dst, iSprite[iPat], iX - (iSprite[iPat]->w >> 1), iY - (iSprite[iPat]->h >> 1));

}

void TGift::notifyCollision(GmTask *aTask){
	if(typeid(*aTask) == typeid(TSock)){
		setDelete();
		iColW = 0;
		iColH = 0;
	}
}