#include "TDream.h"
#include "TSanta.h"
#include <typeinfo.h>


TDream::TDream(GmTask *aParent) : GmTask(aParent){
	iParent = aParent;
	iX = 320;
	iY = 240;
	iAge = 0;
	this->setPriotiyy(GmTask::EPriorityLow-6);

	iSprite[0] = NULL;
	iSprite[1] = NULL;

	iDx = 0;
	iDy = -4;
	iPat = 0;

	iColW = 16;
	iColH = 16;
}

int TDream::initializeE(){
	GmMain *parent = ((GmMain *)iParent);
	GmGfx *gfx = NULL;
	gfx = parent->getGmGfxN();
	if(!gfx){
		return ERROR_NOT_EXISTS;
	}
	BITMAP *src = NULL;
	src = gfx->getSprite();
	if(!src){
		return ERROR_NOT_EXISTS;
	}

	//Eǂ̌C̊G.
	iSprite[0] = create_sub_bitmap(src, 0*2, 48*2, 32, 32);
	if(!(iSprite[0])){
		return ERROR_GENERAL;
	}
	iSprite[1] = create_sub_bitmap(src, 16*2, 48*2, 32, 32);
	if(!(iSprite[1])){
		return ERROR_GENERAL;
	}

	GmSound *sound = NULL;
	sound = parent->getGmSoundN();
	if(sound){
		sound->playToySoundE(0);
	}

	return ERROR_NONE;
}

TDream::~TDream(){
	if(iSprite[0]){
		destroy_bitmap(iSprite[0]);
		iSprite[0] = NULL;
	}
	if(iSprite[1]){
		destroy_bitmap(iSprite[1]);
		iSprite[1] = NULL;
	}
}

void TDream::update(){
	BITMAP *dst = ((GmMain *)iParent)->getGmGfxN()->getBackBuffer();
	iAge++;

	iDx += (rand() * 2 / RAND_MAX) * 2 - 1;
	iX += iDx >> 3;
	iY += iDy;

	if(iX < 0 || iX > dst->w || iY < 0 || iY > dst->h){
		setDelete();
	}

	iPat = (iAge >> 1) & 0x00000001;

	//draw_sprite(dst, iSprite[iPat], iX - (iSprite[iPat]->w >> 1), iY - (iSprite[iPat]->h >> 1));
	int angleBase = (iAge & 0x0000000f) << 4;
	int angle = 0;
	int prevX = fixtoi( fixmul(fixcos(itofix(0x000000ff & (angle + angleBase))), itofix(16)) + itofix(iX) );
	int prevY = fixtoi( fixmul(fixsin(itofix(0x000000ff & (angle + angleBase))), itofix(16)) + itofix(iY) );
	int nextX; int nextY;
	int span = 64;
	for(angle+=span; angle <= 256; angle+=span){
		nextX = fixtoi( fixmul(fixcos(itofix(0x000000ff & (angle + angleBase))), itofix(16)) + itofix(iX) );
		nextY = fixtoi( fixmul(fixsin(itofix(0x000000ff & (angle + angleBase))), itofix(16)) + itofix(iY) );
		fastline(dst, prevX+1, prevY+1, nextX+1, nextY+1, makecol(64,16,16));
		fastline(dst, prevX, prevY, nextX, nextY, makecol(255,64,64));
		prevX = nextX;
		prevY = nextY;
	}

}

void TDream::notifyCollision(GmTask *aTask){
	if(typeid(*aTask) == typeid(TSanta)){
		setDelete();
		iColW = 0;
		iColH = 0;
	}
}