#include "TDecor.h"

//static
TDecor *TDecor::createN(GmTask *aParent, int aDecType){
	TDecor *self = new TDecor(aParent);
	if(self->initializeE() != ERROR_NONE){
		delete self;
		self = NULL;
	}
	return self;
}

TDecor::TDecor(GmTask *aParent) : GmTask(aParent){
	iParent = aParent;
	iAge = 0;
	this->setPriotiyy(GmTask::EPriorityLow);

	iPat = 0;
	iSprite[0] = NULL;

	iX = 0;
	iY = 0;
	iXDiff = 0;
	iYDiff = 0;
	iFAngle = 0;
	iFDAngle = 0;
}

TDecor::initializeE(int aDecType){
	GmGfx *gfx = NULL;
	gfx = ((GmMain *)iParent)->getGmGfxN();
	if(!gfx){
		return ERROR_NOT_EXISTS;
	}
	BITMAP *src = NULL;
	src = gfx->getSprite();
	if(!src){
		return ERROR_NOT_EXISTS;
	}
	BITMAP *dst = gfx->getBackBuffer();
	if(!dst){
		return ERROR_NOT_EXISTS;
	}

	//WN_.
	iXBase = (dst->w) >> 1;
	iYBase = 150 + 32;
	//c[_yW.
	iYDiff = fixtoi((fixsin(itofix(rand() * 64 / RAND_MAX))) * 240);
	//c[~ɌĂĊpx.
	iFAngle = itofix(rand() * 255 / RAND_MAX);
	//pxx.
	iFDAngle = itofix(1);

	if(iYDiff < 16 || aDecType != 0){
		//_߂Ȃ琯ɂ.
		iSprite[0] = create_sub_bitmap(src, 192, 32, 64, 64);
		if(!(iSprite[0])){
			return ERROR_GENERAL;
		}
	}else{
		//̒烉_ɊG.
		int type = 16 * (rand() * 4 / RAND_MAX);
		iSprite[0] = create_sub_bitmap(src, 32*2 + type, 48*2, 16, 16);
		if(!(iSprite[0])){
			return ERROR_GENERAL;
		}
	}


	return ERROR_NONE;	
}

TDecor::~TDecor(){	
	if(iSprite[0]){
		destroy_bitmap(iSprite[0]);
		iSprite[0] = NULL;
	}
}



void TDecor::update(){
	GmMain *parent = (GmMain *)iParent;
	BITMAP *dst = parent->getGmGfxN()->getBackBuffer();
	iAge++;

//move
	iFAngle = (0x00ffffff) & (iFAngle + iFDAngle);
	iXDiff = (int)( fixmul((fixcos(iFAngle)), fixdiv(itofix(iYDiff), itofix(240))  ) )>>9;

	iX = iXDiff + iXBase;
	iY = iYDiff + iYBase;
	
//drawing.
	if(isVisible()){
		draw_sprite(dst, iSprite[0], iX - (iSprite[0]->w >> 1), iY - (iSprite[0]->h >> 1));
		//fastline(dst, iX, iY, iXBase, iYBase, makecol(0,128,0));
	}
}
