// GmSound.cpp
// Game(polytheremin) sound task
// TEh̍ĐǗƃ[U͂̎t.
#include "GmEntry.h"
#include "GmSound.h"
#include "GmMain.h"
#include <string.h>
#include <math.h>

//GmEntry
extern Settings *GE_settings;

//private static (ʓ|Ă̗Rstaticłyo)
//const char GmSound::iMappedKey[ToySoundNum] = { KEY_1, KEY_2, KEY_Q, KEY_W, KEY_A, KEY_S, KEY_Z, KEY_X };
char GmSound::iMappedKey[ToySoundNum] = { KEY_Q, KEY_W, KEY_E, KEY_R, KEY_A, KEY_S, KEY_D, KEY_F };

#if 0
static char GS_char_to_allegro_key(char aKey){
	switch(aKey){
	case '0':  return KEY_0;
	case '1':  return KEY_1;
	case '2':  return KEY_2;
	case '3':  return KEY_3;
	case '4':  return KEY_4;
	case '5':  return KEY_5;
	case '6':  return KEY_6;
	case '7':  return KEY_7;
	case '8':  return KEY_8;
	case '9':  return KEY_9;

	case 'A':  return KEY_A;
	case 'B':  return KEY_B;
	case 'C':  return KEY_C;
	case 'D':  return KEY_D;
	case 'E':  return KEY_E;
	case 'F':  return KEY_F;
	case 'G':  return KEY_G;
	case 'H':  return KEY_H;
	case 'I':  return KEY_I;
	case 'J':  return KEY_J;
	case 'K':  return KEY_K;
	case 'L':  return KEY_L;
	case 'M':  return KEY_M;
	case 'N':  return KEY_N;
	case 'O':  return KEY_O;
	case 'P':  return KEY_P;
	case 'Q':  return KEY_Q;
	case 'R':  return KEY_R;
	case 'S':  return KEY_S;
	case 'T':  return KEY_T;
	case 'U':  return KEY_U;
	case 'V':  return KEY_V;
	case 'W':  return KEY_W;
	case 'X':  return KEY_X;
	case 'Y':  return KEY_Y;
	case 'Z':  return KEY_Z;
	}
	return 0;
}
#endif

//public:static
GmSound *GmSound::createN(){
	GmSound *self = new GmSound();
	if(self->constructE() != ERROR_NONE){
		delete self;
		self = NULL;
	}
	return self;
}

//private:
GmSound::GmSound()
		{
	for(int i = 0; i < ToySoundNum; i++){
	iToySound[0] = NULL;
	}
}

//private:
int GmSound::constructE(){
	int ret, i;

	reserve_voices(10, 0);
	RETURN_IF_NEGATIVE(ret, install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL));

	for(i = 0; i < ToySoundNum; i++){
		ret = createToySoundE(i, GE_settings->soundFileName[i]);
		if(ret != ERROR_NONE){
			//t@CȂĂs.
			RELEASE_PRINT1("failed to open %s \n", GE_settings->soundFileName[i]);
			strcpy(GE_settings->soundFileName[i], "failed to load");
			GE_settings->soundFilePureFileName[i] = GE_settings->soundFileName[i];
		}else{
			RELEASE_PRINT1("%s \n", GE_settings->soundFileName[i]);
		}
	}

#if 0
	for(i = 0; i < ToySoundNum; i++){
		GmSound::iMappedKey[i] = GS_char_to_allegro_key(GE_settings->bindedKey[i]);
	}
#endif

	return ERROR_NONE;
}


//public:
GmSound::~GmSound(){
	for(int i = 0; i < ToySoundNum; i++){
		stopToySound(i);
		destroyToySound(i);
	}
}

//public
void GmSound::receiveMessage(char *aData){
	size_t len;
	int index = atoi(&(aData[0])) - 1; //1~8̃CfbNXw0~7ɂ
	//1ڂ͐ŁAXbg̃CfbNXw.
	if(0 <= index && index < ToySoundNum){
		//2ڂ͋؂̔pXy[X.
		if(aData[1] == ' '){
			//256܂ł̃t@CɑΉ.
			len = strlen(&(aData[2]));
			if(len < 256){
				if(changeToySoundE(index, &(aData[2])) == ERROR_NONE){
					strcpy(GE_settings->soundFileName[index], &(aData[2]));
					GE_settings->soundFilePureFileName[index] = get_filename(GE_settings->soundFileName[index]);
				}
			}
		}
	}
}

//public:
ToySound *GmSound::getToySoundN(int aIndex){
	if(aIndex < ToySoundNum){
		return iToySound[aIndex];
	}else{
		return NULL;
	}
}

//public:
void GmSound::update(){
//	int curVol, curFreq;
	int i;

	for(i = 0; i < ToySoundNum; i++){
		if(iToySound[i] != NULL){
			iToySound[i]->iSound->update();
		}
	}
	
	//}EXʒu𒆉set.
	//position_mouse((GmMain::getCurrentGmMain()->getGmGfxN()->getScreenW())>>1, (GmMain::getCurrentGmMain()->getGmGfxN()->getScreenH())>>1);
}

//private
int GmSound::changeToySoundE(int aIndex, char *aSampleFileName){
	WrappedSample *tmpSound = NULL;

	//͈̓`FbN.
	if(aIndex < ToySoundNum){

		//݂ȂXbgȂVɐďI.
		if(iToySound[aIndex] == NULL){
			return createToySoundE(aIndex, aSampleFileName);
		}

		//݂XbgȂ特̂ݓւ
		if(ustricmp(get_extension(aSampleFileName), "xm" ) == 0 ||
		   ustricmp(get_extension(aSampleFileName), "mod" ) == 0) {
			tmpSound = YMod::createN(aSampleFileName);
		}else{
			//wavTEh
			tmpSound = WrappedSample::createN(aSampleFileName);
		}

		if(!tmpSound){
			return ERROR_GENERAL;
		}

		iToySound[aIndex]->iSound->stop();
		delete iToySound[aIndex]->iSound;
		iToySound[aIndex]->iSound = tmpSound;
		iToySound[aIndex]->iVol = 0;
		playToySoundE(aIndex);
	}else{
		return ERROR_ARGUMENT;
	}
	return ERROR_NONE;
}

int GmSound::createToySoundE(int aIndex, char *aSampleFileName){
	ToySound *ret;
	WrappedSample *tmpSound = NULL;
	iToySound[aIndex] = NULL;
	
	if(ustricmp(get_extension(aSampleFileName), "xm" ) == 0 ||
	   ustricmp(get_extension(aSampleFileName), "mod" ) == 0) {
		tmpSound = YMod::createN(aSampleFileName);
	}else{
		//wavTEh
		tmpSound = WrappedSample::createN(aSampleFileName);
	}
	if(!tmpSound){
		return -1;
	}

	ret = (ToySound *)malloc(sizeof(ToySound));
	if(ret == NULL){
		return -1;
	}

	ret->iVol = VOL_MAX;
	ret->iPan = PAN_MID;
	ret->iFreq = FREQ_MID;
	ret->iLog10Freq = LOG10FREQ_MID;
	ret->iLog10FreqSnap = LOG10FREQ_MID;
	ret->iMute = FALSE;
	ret->iHold = 0;
	ret->iRestartFlag = FALSE;
	ret->iAdditionalFreq = 0;
	ret->iSound = tmpSound;
	iToySound[aIndex] = ret;
	return 0;
}

void GmSound::destroyToySound(int aIndex){
	if(iToySound[aIndex] == NULL){
		return;
	}
	delete iToySound[aIndex]->iSound;
	iToySound[aIndex]->iSound = NULL;

	free(iToySound[aIndex]);
	iToySound[aIndex] = NULL;
}

//public
int GmSound::playToySoundE(int aIndex, int aLoop){
	int vol;
	if(iToySound[aIndex] == NULL){
		return ERROR_NOT_EXISTS;
	}

	//Mute==TRUEȂ~[gAFALSEȂvol=iVol.
	if(iToySound[aIndex]->iMute){
		vol = iToySound[aIndex]->iVol - (iToySound[aIndex]->iMute)*20;
		if(vol < VOL_MIN){
			vol = VOL_MIN;
		}
	}else{
		vol = iToySound[aIndex]->iVol;
	}
	return iToySound[aIndex]->iSound->playE(vol, iToySound[aIndex]->iPan, iToySound[aIndex]->iFreq, aLoop);
}

//public
void GmSound::adjustToySound(int aIndex, int aLoop){
	int vol;
	int freq;
	if(iToySound[aIndex] == NULL){
		DEBUG_PRINT1("adjustToySound: #%d is null.\n", aIndex);
		return;
	}
	//Mute==TRUEȂ~[gAFALSEȂvol=iVol.
	if(iToySound[aIndex]->iMute){
		vol = iToySound[aIndex]->iVol - (iToySound[aIndex]->iMute)*20;
		if(vol < VOL_MIN){
			vol = VOL_MIN;
		}
	}else{
		vol = iToySound[aIndex]->iVol;
	}

	//hold==TRUEȂxBFALSEȂiFreq̂܂
	if(iToySound[aIndex]->iHold){
		freq = iToySound[aIndex]->iFreq / iToySound[aIndex]->iHold;
		if(freq < 1){
			freq = 1;
		}
	}else{
		freq = iToySound[aIndex]->iFreq;
	}

	//additionalFreqΓKɉZ.
	if(iToySound[aIndex]->iAdditionalFreq){
		int vf = iToySound[aIndex]->iAdditionalFreq*10;
		//+-1IN^[u܂.
		if(vf < -1 * freq/2){
			vf = -1 * freq/2;
			iToySound[aIndex]->iAdditionalFreq = vf / 10;
		}else if(vf > freq){
			vf = freq;
			iToySound[aIndex]->iAdditionalFreq = vf / 10;
		}

		freq = iToySound[aIndex]->iFreq + vf;
		//g[͕s.
		if(freq < 1){
			freq = 1;
		}
	}

	iToySound[aIndex]->iSound->adjust(vol, iToySound[aIndex]->iPan, freq, aLoop);
}

//public
void GmSound::stopToySound(int aIndex){
	if(iToySound[aIndex] == NULL){
		return;
	}
	iToySound[aIndex]->iSound->stop();
}


