// GmMain.h
// Game(polytheremin) main task
// C[v܂킵܂.
// ^XNǗNX̐`ɂȂ邩
#ifndef _STMAIN_HEAD_
#define _STMAIN_HEAD_

#include "GmGfx.h"
#include "GmSound.h"
#include "GmInput.h"
#include "StringReceiver.h"
#include "GmTask.h"

#define GM_STUFF_MAX (512)

class GmMain : public GmTask{
public:
	static GmMain *createN(GmTask *aParent);
	virtual ~GmMain();

	virtual void update();

	static GmMain *getCurrentGmMain(){
		return currentGmMain;
	}

	GmGfx *getGmGfxN(){
		return iGmGfx;
	}
	GmSound *getGmSoundN(){
		return iGmSound;
	}
	GmInput *getGmInputN(){
		return iGmInput;
	}
	GmTask *getGmTask(int aIndex){
		return iGmTask[aIndex];
	}
	GmTask *getGmTaskByTypeN(const type_info &aType);

	int addChildE(GmTask *aGmTask);
	int removeChildE(GmTask *aGmTask);
	void requestFlood(GmTask *aNoah);
protected:
	GmMain(GmTask *aParent);
	virtual int initializeE();
	void updateChild();
	void cleanupChild();
	void checkChildCollision();
	//iNoahȊȎSTask폜.
	void flood();

private:
	static GmMain *currentGmMain;
	StringReceiver *iStringReceiver;
	int iLoopCount;

protected:
	GmGfx *iGmGfx;
	GmSound *iGmSound;
	GmInput *iGmInput;

	GmTask *iGmTask[GM_STUFF_MAX];
	int iGmTaskNum;

	GmTask *iNoah;
};



#if 0
//initialize all tasks
int STMain_init();

//update all tasks and input operations
void STMain_update();

//finalize all tasks
void STMain_finalize();
#endif

/*class CharBase{
public:
	CharBase(int aX, aY){
		iX = aX;
		iY = aY;
		iLife = 1;
	}
	void ~CharBase();
	update();
	void draw();

	int getCharType();

	int getX();
	int getY();

	int getCollisionWidth();
	int getCollisionHeight();
	int collide(CharBase *aCollider);

	int isDead(){
		if(iLife > 0){
			return TRUE;
		}else{
			return FALSE;
		}
	}

private:
	int iCharType;

	int iX;
	int iY;

	int iColWidth;
	int iColHeight;

	int iLife;
}
*/

#endif //_STMAIN_HEAD_
