// GmMain.cpp
// Game(polytheremin) main task
// C[v܂킵܂.
#include "GmMain.h"
#include "GmEntry.h"
/*#include "GmGfx.h"
#include "GmSound.h"
#include "StringReceiver.h"
#include "GmInput.h"
#include "GmTask.h"*/

//#include "TSanta.h"
#include "TStage.h"

//#include "UserWindow.h"


//private static
GmMain* GmMain::currentGmMain = NULL;

//public: static:
GmMain *GmMain::createN(GmTask *aParent){
	GmMain *self = new GmMain(aParent);
	if(self->initializeE() != ERROR_NONE){
		delete self;
		self = NULL;
	}
	GmMain::currentGmMain = self;
	return self;
}

//private:
GmMain::GmMain(GmTask *aParent):
	iGmGfx(NULL),
	iGmSound(NULL),
	iGmInput(NULL),
	iStringReceiver(NULL),
	iLoopCount(0),
	iGmTaskNum(0),
	iNoah(NULL) {
	for(int i = 0; i < GM_STUFF_MAX; i++){
		iGmTask[i] = NULL;
	}
	iParent = aParent;
}

//private
int GmMain::initializeE(){
	int ret;

	set_window_title("SOCKS");

	RETURN_IF_NEGATIVE(ret, install_mouse());

	RETURN_IF_NEGATIVE(ret, install_keyboard());

	RETURN_ERROR_IF_NULL(iGmGfx, GmGfx::createN());

	RETURN_ERROR_IF_NULL(iGmSound, GmSound::createN());

	RETURN_ERROR_IF_NULL(iGmInput, GmInput::createN());

//͎gȂ.
//	RETURN_ERROR_IF_NULL(iStringReceiver, StringReceiver::createN());


	GmTask *t = NULL;
	RETURN_ERROR_IF_NULL(t, TStage::createN(this));
	if(addChildE(t) != ERROR_NONE){
		delete t;
		return ERROR_GENERAL;
	}
	t = NULL;

	return ERROR_NONE;
}

//public
GmMain::~GmMain(){
	delete iGmSound;
	iGmSound = NULL;
	delete iGmGfx;
	iGmGfx = NULL;
	delete iGmInput;
	iGmInput = NULL;
	for(int i = iGmTaskNum-1; i >= 0; i--){
		removeChildE(iGmTask[i]);
	}
	delete iStringReceiver;
	iStringReceiver = NULL;
	//̑̏I(mouseƂkeyboardƂ)allegroIɂĂ邻łBLł.
}

//public
void GmMain::update(){
	while(!GE_getExitFlag()){

		cleanupChild();
		updateChild();
		checkChildCollision();

		iGmGfx->update();//t[܂ł̃EGCg܂. łd.
		iGmSound->update();
		iGmInput->update();

		if(iNoah){
			flood();
		}
		if(key[KEY_ESC]){
			break;
		}

		//}`^XNōsV悭߂̂Ȃ
		//VisualBasicDoEventsɎ悤Ȃ́HƂƓȂƂ܂񂾂
		//܂̂Ƃ떳ĂႢ킩Ȃ
		yield_timeslice();

		//1b1AOXNvg̎Mpt@C̓ǂݍ݂݂.
		iLoopCount++;
		if(iStringReceiver && iLoopCount == 60){
			char *rec = iStringReceiver->getStringN();
			if(rec){
				iGmSound->receiveMessage(rec);
			}
			//rec ͊JȂB(stringReceiverJ)
			iLoopCount = 0;
		}
	}
	return;
}

void GmMain::updateChild(){
	int i;

	for(i = 0; i < GM_STUFF_MAX; i++){
		if(iGmTask[i]){
			iGmTask[i]->update();
		}
	}
}


int GmMain::addChildE(GmTask *aGmTask){
	if(!aGmTask){
		return ERROR_NULL;
	}
	if(iGmTaskNum < GM_STUFF_MAX){
		int i;
		for(i = 0; i < iGmTaskNum; i++){
			if(iGmTask[i]->getPriority() < aGmTask->getPriority()){
				int j;
				for(j = iGmTaskNum-1; j >= i; j--){
					iGmTask[j+1] = iGmTask[j];
				}
				iGmTask[i] = aGmTask;
				iGmTaskNum++;
				return ERROR_NONE;
			}
		}
		//priorityŒ̏ꍇ
		iGmTask[iGmTaskNum] = aGmTask;
		iGmTaskNum++;
		return ERROR_NONE;
	}else{
		return ERROR_NO_RESOURCES;
	}
}

void GmMain::cleanupChild(){
	for(int i = iGmTaskNum-1; i >= 0; i--){
		if(iGmTask[i]){
			if(iGmTask[i]->getDeleteFlag()){
				removeChildE(iGmTask[i]);
			}
		}
	}
}

int GmMain::removeChildE(GmTask *aGmTask){
	if(!aGmTask){
		return ERROR_NULL;
	}
	int i;
	for(i = 0; i < iGmTaskNum; i++){
		if(iGmTask[i] == aGmTask){
			delete iGmTask[i];
			if(i == iGmTaskNum-1){
				//Ō1.
				iGmTask[iGmTaskNum-1] = NULL;
				iGmTaskNum--;
				return ERROR_NONE;
			}else{
				int j;
				for(j = i+1; j < iGmTaskNum; j++){
					iGmTask[j-1] = iGmTask[j];
				}
				iGmTask[iGmTaskNum-1] = NULL;
				iGmTaskNum--;
				return ERROR_NONE;
			}
		}
	}
	return ERROR_NOT_EXISTS;

}

void GmMain::checkChildCollision(){
	int i, j;
	for(i = 0; i < GM_STUFF_MAX; i++){
		if(iGmTask[i] /*&& !(iGmTask[i]->getDeleteFlag())*/){
			for(j = i + 1; j < GM_STUFF_MAX; j++){
				if(iGmTask[j] /*&& !(iGmTask[i]->getDeleteFlag())*/){

					if( iGmTask[i]->getColW() && iGmTask[i]->getColH() && iGmTask[j]->getColW() && iGmTask[j]->getColH()
					  &&(abs(iGmTask[i]->getX() - iGmTask[j]->getX()) < ((iGmTask[i]->getColW() + iGmTask[j]->getColW())>>1) )
					  &&(abs(iGmTask[i]->getY() - iGmTask[j]->getY()) < ((iGmTask[i]->getColH() + iGmTask[j]->getColH())>>1) ) ){
						iGmTask[i]->notifyCollision(iGmTask[j]);
						iGmTask[j]->notifyCollision(iGmTask[i]);
					}
				}
			}
		}
	}
}



//Ɏw肵̈ȊÔׂĂTask폜.^̃C[W.
void GmMain::requestFlood(GmTask *aNoah){
	iNoah = aNoah;
}

//private
void GmMain::flood(){
	if(!iNoah){
		return;
	}
	int noahExists = FALSE;
	for(int i = iGmTaskNum-1; i >= 0; i--){
		if(iGmTask[i]){
			if(iGmTask[i] == iNoah){
				noahExists = TRUE;
			}else{
				removeChildE(iGmTask[i]);
			}
		}
	}

	if(!noahExists){
		addChildE(iNoah);
	}
	iNoah = NULL;
}

//w̌^̃IuWFNgTāAŏɌ̂Ԃ܂.
GmTask *GmMain::getGmTaskByTypeN(const type_info &aType){
	for(int i = 0; i < GM_STUFF_MAX; i++){
		if(iGmTask[i]){
			if(typeid(*iGmTask[i]) == aType){
				return iGmTask[i];
			}
		}
	}
	return NULL;
}
