// GmGfx.cpp
// Game(polytheremin) Graphics task
// ʂ̏EXVƃt[̃EGCg.
#include "GmEntry.h"
#include "GmGfx.h"
#include "GmSound.h"
#include "GmMain.h"


extern Settings *GE_settings;
extern double GE_log10(double aNum);

#define iBitCol (unsigned long(0x00ffffff))
#define iBitR   (unsigned long(0x00ff0000))
#define iBitG   (unsigned long(0x0000ff00))
#define iBitB   (unsigned long(0x000000ff))
#define DIRECT_PIXEL32(aBitmap, aX, aY) (((long *)aBitmap->line[aY])[aX])
#define DIRECT_PIXEL16(aBitmap, aX, aY) (((unsigned short *)aBitmap->line[aY])[aX])

//public:static
GmGfx *GmGfx::createN(){
	GmGfx *self = new GmGfx();
	if(self->constructE() != ERROR_NONE){
		delete self;
		self = NULL;
	}
	return self;
}

//private:
GmGfx::GmGfx() :
	iBackBuffer(NULL),
	iBackBuffer2(NULL),
	iSprite(NULL),
	iFilterRatio(1),
	iBrightness(0) {
}

//private:
int GmGfx::constructE(){
	int ret;

	//F̐ݒ
	ret = desktop_color_depth();
	if(ret == 0 /*|| ret < 16*/){
		RELEASE_PRINT1("ERROR: cant get desktop_color_depth (%d) \n", ret);
		return ERROR_GENERAL;
	}

	set_color_depth(ret);
	iColorDepth = ret;
	RELEASE_PRINT1("color_depth = %d \n", iColorDepth);
	if(iColorDepth != 32){
		RELEASE_PRINT0("not 32bit-color: No Background animation \n");
	}

	//ʃ[hݒ
	ret = 0;
	//tXN[w̏ꍇ܂tXN[ŏ݂
	if(!(GE_settings->showAsWindow)){
		ret = set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, GE_settings->screenW, GE_settings->screenH, 0,0);
	}
	//tXN[sE܂̓EChE[hw(ftHg)̏ꍇ
	if(ret < 0 || GE_settings->showAsWindow){
		ret = set_gfx_mode(GFX_AUTODETECT_WINDOWED, GE_settings->screenW, GE_settings->screenH, 0,0);
		if(ret >= 0){
			ret = set_display_switch_mode(SWITCH_BACKGROUND);
		}
	}
	if(ret < 0){
		return ret;
	}
	iScreenW = SCREEN_W;
	iScreenH = SCREEN_H;
	RELEASE_PRINT2("fgx_mode width = %d, height = %d \n", iScreenW, iScreenH);

	//30fpsvsyncł̂͂߂ǂȂ̂Ń^C}҂̂ݑΉ.
	//iRefreshRate = get_refresh_rate();
	iRefreshRate = 0;
	RELEASE_PRINT1("refresh rate = %d \n", iRefreshRate);

	//obNobt@.
	iBackBuffer = create_bitmap((iScreenW + BB_MARGIN*2), (iScreenH + BB_MARGIN*2));
	if(iBackBuffer == 0){
		return -1;
	}
	iBackBuffer2 = create_bitmap((iScreenW + BB_MARGIN*2), (iScreenH + BB_MARGIN*2));
	if(iBackBuffer2 == 0){
		return -1;
	}
	DEBUG_PRINT2("create backBuffer width = %d, height = %d \n", iBackBuffer->w, iBackBuffer->h);

	//XvCgǂݍ.
	BITMAP *tmpSprite = load_bitmap("./sprite.bmp", NULL);
	iSprite = create_bitmap_ex(bitmap_color_depth(tmpSprite), tmpSprite->w*2, tmpSprite->h*2);
	stretch_blit(tmpSprite, iSprite, 0,0, tmpSprite->w, tmpSprite->h, 0, 0, iSprite->w, iSprite->h);
	destroy_bitmap(tmpSprite);
	tmpSprite = NULL;

	//DirectAccessp̐F.. define邱Ƃɂ.
#if 0
	putpixel(iBackBuffer, 0, 0, makecol(255,255,255));
	putpixel(iBackBuffer, 1, 0, makecol(255,0,0));
	putpixel(iBackBuffer, 2, 0, makecol(0,255,0));
	putpixel(iBackBuffer, 3, 0, makecol(0,0,255));
	iBitCol = DIRECT_PIXEL32(iBackBuffer, 0, 0);
	iBitR = DIRECT_PIXEL32(iBackBuffer, 1, 0);
	iBitG = DIRECT_PIXEL32(iBackBuffer, 2, 0);
	iBitB = DIRECT_PIXEL32(iBackBuffer, 3, 0);
#endif
	
	DEBUG_PRINT4("white 0x%x, r 0x%x, g 0x%x, b 0x%x \n", iBitCol, iBitR, iBitG, iBitB);

	//ʃNA
	rectfill(iBackBuffer, 0,0, iBackBuffer->w, iBackBuffer->h, makecol(0,0,0));
	rectfill(iBackBuffer2, 0,0, iBackBuffer->w, iBackBuffer->h, makecol(0,0,0));
	
	//tB^𔽉f.
	iFilterRatio = GE_settings->filterRatio;

	return ERROR_NONE;
}

//public:
GmGfx::~GmGfx(){
	destroy_bitmap(iBackBuffer);
	destroy_bitmap(iBackBuffer2);
	destroy_bitmap(iSprite);
}


//public:
void GmGfx::update(){
	static int age = 0, prevTime = 0;

	//int iBlur = (mouse_x * 5 / this->iScreenW);
	if(iFilterRatio <= 0){
		blit(iBackBuffer, iBackBuffer2, 0,0, 0,0, iBackBuffer->w, iBackBuffer->h);
	}else{
		blitRomanticFilter(iBackBuffer, iBackBuffer2, iFilterRatio);
	}

	age++;
	if(age > 0x00ffffff){
		age = 0;
	}
	//globalScreenlock
	acquire_screen();

	//\XV
	blit(iBackBuffer2, screen, BB_MARGIN, BB_MARGIN, 0,0, iScreenW,iScreenH);

	//globalscreenunlock
	release_screen();

	//vsync҂B̊łwindowedłLۂB
	//ȂƂ̕`悪قnoWaitȁH
	if(iRefreshRate == 60){
		//1t[̏ɂԂo
		int curTime = GE_getCurrentTime();
		DEBUG_PRINT1("%d\n", curTime - prevTime);
		vsync();
		prevTime = GE_getCurrentTime();
	}else{
		//tbV[g60ȊȌꍇ̓^C}ő҂
		//1t[̏ɂԂo
		DEBUG_PRINT1("%d\n", GE_getCurrentTime() - prevTime);
		int curTime = GE_getCurrentTime();
		//̃Q[30fpsȂ̂33msec҂.
		while(prevTime <= curTime && curTime < prevTime + 33){
			yield_timeslice();
			curTime = GE_getCurrentTime();
		}
		prevTime = curTime;
	}

	//ʃNA
	//int clCol = mouse_y * 255 / this->iScreenH;
	rectfill(iBackBuffer, 0,0, iBackBuffer->w, iBackBuffer->h, makecol(iBrightness,iBrightness, fixsin(itofix(iBrightness>>2))>>8 ) );
	
	//textprintf_ex(iBackBuffer, font, 100, 100, makecol(255-iBrightness,0,iBrightness), -1, "bg:%x", iBrightness);

	return;
}


//ڂ̐F[xݒ@32bit̂܂ƂɍĂȂł
//#define blurColorBit16
#define blurColorBit32
//#define blurColorBitFree


//Horizontalɂڂ.ďcȂ.
//rbg}XN[܂Ă̂ŗΈȊO̐FƂȂꍇ.
//private
void GmGfx::blurScreenH(register BITMAP *aBitmap){
	int x,y;
//	int32 col;
	for(y=1; y < aBitmap->h - 1; y++){
		for(x=1; x < aBitmap->w - 1; x++){
#ifdef blurColorBitFree
			col = (iBitG & (getpixel(aBitmap, x,y-1)>>1)) + (iBitG & (getpixel(aBitmap, x,y+1)>>1));
			putpixel(aBitmap, x, y, col & iBitG);
#elif defined blurColorBit32
			DIRECT_PIXEL32(aBitmap, x, y) = (((DIRECT_PIXEL32(aBitmap, x, y-1)&iBitG) + (DIRECT_PIXEL32(aBitmap, x, y+1)&iBitG)) >> 1) & iBitG;
//			DIRECT_PIXEL32(aBitmap, x, y) = (( DIRECT_PIXEL32(aBitmap, x, y-1)        +  DIRECT_PIXEL32(aBitmap, x, y+1)       ) >> 1) & iBitG;
#elif defined blurColorBit16
			col = ( DIRECT_PIXEL16(aBitmap, x, y-1) >> 1) + (DIRECT_PIXEL16(aBitmap, x, y+1) >> 1);
			DIRECT_PIXEL16(aBitmap, x, y) = iBitG & col;
#endif
		}
	}
}


//cHorizontal&Verticalɂڂ.
//Ȃ.
//private
void GmGfx::blurScreenHV(register BITMAP *a_Bitmap){
	register int x,y;
	register int32 col, r, g, b;
	register BITMAP* aBitmap = a_Bitmap;

	for(y=1; y < aBitmap->h - 1; y++){
		for(x=1; x < aBitmap->w - 1; x++){
#ifdef blurColorBitFree
			//not support --;
#elif defined blurColorBit32
			col = DIRECT_PIXEL32(aBitmap, x,y-1);
			r = ((col & iBitR)>>2) & iBitR;
			g = ((col & iBitG)>>2) & iBitG;
			b = ((col & iBitB)>>2) & iBitB;

			col = DIRECT_PIXEL32(aBitmap, x-1,y);
			r += ((col & iBitR)>>2) & iBitR;
			g += ((col & iBitG)>>2) & iBitG;
			b += ((col & iBitB)>>2) & iBitB;

			col = DIRECT_PIXEL32(aBitmap, x+1,y);
			r += ((col & iBitR)>>2) & iBitR;
			g += ((col & iBitG)>>2) & iBitG;
			b += ((col & iBitB)>>2) & iBitB;

			col = DIRECT_PIXEL32(aBitmap, x,y+1);
			r += ((col & iBitR)>>2) & iBitR;
			g += ((col & iBitG)>>2) & iBitG;
			b += ((col & iBitB)>>2) & iBitB;

			DIRECT_PIXEL32(aBitmap, x, y) = (unsigned short)(r | g | b);
#elif defined blurColorBit16
			col = DIRECT_PIXEL16(aBitmap, x,y-1);
			r = ((col & iBitR)>>2) & iBitR;
			g = ((col & iBitG)>>2) & iBitG;
			b = ((col & iBitB)>>2) & iBitB;

			col = DIRECT_PIXEL16(aBitmap, x-1,y);
			r += ((col & iBitR)>>2) & iBitR;
			g += ((col & iBitG)>>2) & iBitG;
			b += ((col & iBitB)>>2) & iBitB;

			col = DIRECT_PIXEL16(aBitmap, x+1,y);
			r += ((col & iBitR)>>2) & iBitR;
			g += ((col & iBitG)>>2) & iBitG;
			b += ((col & iBitB)>>2) & iBitB;

			col = DIRECT_PIXEL16(aBitmap, x,y+1);
			r += ((col & iBitR)>>2) & iBitR;
			g += ((col & iBitG)>>2) & iBitG;
			b += ((col & iBitB)>>2) & iBitB;

			DIRECT_PIXEL16(aBitmap, x, y) = (unsigned short)(r | g | b);
#endif
		}
	}
}

//J[Ή.
#define blurColorBit32RGB
void GmGfx::blitBlurScreen(register BITMAP *aSrc, register BITMAP *aDst){
	int x,y;
	int endY = aSrc->h - BB_MARGIN;
	int endX = aSrc->w - BB_MARGIN;
	for(y=BB_MARGIN; y < endY; y++){
		for(x=BB_MARGIN; x < endX; x++){
#ifdef blurColorBitFree
			//no impl
#elif defined blurColorBit32RGB
			DIRECT_PIXEL32(aDst, x, y) =  
				(
					((
					(DIRECT_PIXEL32(aSrc, x, y-4)&iBitG) + 
					(DIRECT_PIXEL32(aSrc, x, y-3)&iBitG) + 
					(DIRECT_PIXEL32(aSrc, x, y-2)&iBitG) + 
					(DIRECT_PIXEL32(aSrc, x, y+1)&iBitG) + 
					(DIRECT_PIXEL32(aSrc, x, y  )&iBitG) + 
					(DIRECT_PIXEL32(aSrc, x, y+1)&iBitG) + 
					(DIRECT_PIXEL32(aSrc, x, y+2)&iBitG) + 
					(DIRECT_PIXEL32(aSrc, x, y+3)&iBitG)
					) >> 3) & iBitG 
				)
				+
				(
					((
					(DIRECT_PIXEL32(aSrc, x, y-4)&iBitB) + 
					(DIRECT_PIXEL32(aSrc, x, y-3)&iBitB) + 
					(DIRECT_PIXEL32(aSrc, x, y-2)&iBitB) + 
					(DIRECT_PIXEL32(aSrc, x, y+1)&iBitB) + 
					(DIRECT_PIXEL32(aSrc, x, y  )&iBitB) + 
					(DIRECT_PIXEL32(aSrc, x, y+1)&iBitB) + 
					(DIRECT_PIXEL32(aSrc, x, y+2)&iBitB) + 
					(DIRECT_PIXEL32(aSrc, x, y+3)&iBitB)
					) >> 3) & iBitB 
				)
				+
				(
					((
					(DIRECT_PIXEL32(aSrc, x, y-4)&iBitR) + 
					(DIRECT_PIXEL32(aSrc, x, y-3)&iBitR) + 
					(DIRECT_PIXEL32(aSrc, x, y-2)&iBitR) + 
					(DIRECT_PIXEL32(aSrc, x, y+1)&iBitR) + 
					(DIRECT_PIXEL32(aSrc, x, y  )&iBitR) + 
					(DIRECT_PIXEL32(aSrc, x, y+1)&iBitR) + 
					(DIRECT_PIXEL32(aSrc, x, y+2)&iBitR) + 
					(DIRECT_PIXEL32(aSrc, x, y+3)&iBitR)
					) >> 3) & iBitR
				);
#elif defined blurColorBit32
			DIRECT_PIXEL32(aDst, x, y) = ((
				(DIRECT_PIXEL32(aSrc, x, y-4)&iBitG) + 
				(DIRECT_PIXEL32(aSrc, x, y-3)&iBitG) + 
				(DIRECT_PIXEL32(aSrc, x, y-2)&iBitG) + 
				(DIRECT_PIXEL32(aSrc, x, y+1)&iBitG) + 
				(DIRECT_PIXEL32(aSrc, x, y  )&iBitG) + 
				(DIRECT_PIXEL32(aSrc, x, y+1)&iBitG) + 
				(DIRECT_PIXEL32(aSrc, x, y+2)&iBitG) + 
				(DIRECT_PIXEL32(aSrc, x, y+3)&iBitG)
				) >> 3) & iBitG;

#elif defined blurColorBit16
			//no impl
#endif
		}
	}
}


//#define DIRECT_PIXEL32(aBitmap, aX, aY) (((long *)aBitmap->line[aY])[aX])
#define DIRECT_GETLINE(aBitmap, aY) ((unsigned long *)aBitmap->line[aY])

//zł͂Ȃ|C^gƂō.̂.
void GmGfx::blitBlurScreen2(register BITMAP *aSrc, register BITMAP *aDst, int aDepth){
	int x,y;
	long depthPix = 1 << aDepth;
	int endY = aSrc->h - depthPix;
	int endX = aSrc->w - depthPix;

	unsigned long *curLine;
	unsigned long curCol;
	for(y=depthPix; y < endY; y++){
		curLine = DIRECT_GETLINE(aSrc, y) + depthPix;
#if 0
		curCol = 
				(
					((
					(*(curLine - 4) & iBitG) + 
					(*(curLine - 3) & iBitG) + 
					(*(curLine - 2) & iBitG) + 
					(*(curLine - 1) & iBitG) + 
					(*(curLine - 0) & iBitG) + 
					(*(curLine + 1) & iBitG) + 
					(*(curLine + 2) & iBitG) + 
					(*(curLine + 3) & iBitG)
					) >> 3) & iBitG 
				)
				+
				(
					((
					(*(curLine - 4) & iBitB) + 
					(*(curLine - 3) & iBitB) + 
					(*(curLine - 2) & iBitB) + 
					(*(curLine - 1) & iBitB) + 
					(*(curLine - 0) & iBitB) + 
					(*(curLine + 1) & iBitB) + 
					(*(curLine + 2) & iBitB) + 
					(*(curLine + 3) & iBitB)
					) >> 3) & iBitB 
				)
				+
				(
					((
					(*(curLine - 4) & iBitR) + 
					(*(curLine - 3) & iBitR) + 
					(*(curLine - 2) & iBitR) + 
					(*(curLine - 1) & iBitR) + 
					(*(curLine - 0) & iBitR) + 
					(*(curLine + 1) & iBitR) + 
					(*(curLine + 2) & iBitR) + 
					(*(curLine + 3) & iBitR)
					) >> 3) & iBitR 
				);
#else
		curCol = 0;
		unsigned long curR = 0;
		unsigned long curG = 0;
		unsigned long curB = 0;
		for(int i = -(depthPix>>1); i < (depthPix>>1); i++){
			curR += (*(curLine + i) & iBitR) >> 16 >> aDepth;
			curG += (*(curLine + i) & iBitG) >> 8 >> aDepth;
			curB += (*(curLine + i) & iBitB) >> aDepth;
		}
		curR = (curR << 16) & iBitR;
		curG = (curG <<  8) & iBitG;
		curB = (curB      ) & iBitB;
		curCol = (curR | curG | curB);
#endif
		for(x=depthPix; x < endX; x++){
			DIRECT_PIXEL32(aDst, x, y) =  curCol;
//			curCol += 
//					-(((*(curLine - depthPix) & iBitR) >> aDepth) & iBitR)
//					-(((*(curLine - depthPix) & iBitG) >> aDepth) & iBitG)
//					-(((*(curLine - depthPix) & iBitB) >> aDepth) & iBitB);
			curCol = ( ((curCol & iBitR) - (((*(curLine - (depthPix>>1)) & iBitR) >> aDepth) & iBitR) + (((*(curLine + (depthPix>>1)) & iBitR) >> aDepth) & iBitR)) & iBitR)
					|( ((curCol & iBitG) - (((*(curLine - (depthPix>>1)) & iBitG) >> aDepth) & iBitG) + (((*(curLine + (depthPix>>1)) & iBitG) >> aDepth) & iBitG)) & iBitG)
					|( ((curCol & iBitB) - (((*(curLine - (depthPix>>1)) & iBitB) >> aDepth) & iBitB) + (((*(curLine + (depthPix>>1)) & iBitB) >> aDepth) & iBitB)) & iBitB);

//			curCol = ( ((curCol & iBitR) + (((*(curLine + depthPix) & iBitR) >> aDepth) & iBitR)) & iBitR)
//					|( ((curCol & iBitG) + (((*(curLine + depthPix) & iBitG) >> aDepth) & iBitG)) & iBitG)
//					|( ((curCol & iBitB) + (((*(curLine + depthPix) & iBitB) >> aDepth) & iBitB)) & iBitB);

			*curLine++;
		}
	}
}

//ڂỎ摜Ƃ̉Z𓯎ɍs.
void GmGfx::blitRomanticFilter(register BITMAP *aSrc, register BITMAP *aDst, int aDepth){
	int x,y;
	long depthPix = 1 << aDepth;
	int endY = aSrc->h - depthPix;
	int endX = aSrc->w - depthPix;

	unsigned long *curLine;
	unsigned long curCol;
	for(y=depthPix; y < endY; y++){
		curLine = DIRECT_GETLINE(aSrc, y) + depthPix;
		unsigned long curR = 0;
		unsigned long curG = 0;
		unsigned long curB = 0;
		for(int i = -(depthPix>>1); i < (depthPix>>1); i++){
			curR += (*(curLine + i) & iBitR) >> 16 >> aDepth;
			curG += (*(curLine + i) & iBitG) >> 8 >> aDepth;
			curB += (*(curLine + i) & iBitB) >> aDepth;
		}
		curR = (curR << 16) & iBitR;
		curG = (curG <<  8) & iBitG;
		curB = (curB      ) & iBitB;
		curCol = (curR | curG | curB);
		for(x=depthPix; x < endX; x++){
			curR = (((curCol & iBitR)<<2) + (((*curLine) & iBitR)<<1)) >> 2;
			if(curR >iBitR){ curR = 0xffffffff & iBitR; }
			curR = curR & iBitR;
			curG = (((curCol & iBitG)<<2) + (((*curLine) & iBitG)<<1)) >> 2;
			if(curG > iBitG){ curG = 0xffffffff & iBitG; }
			curG = curG & iBitG;
			curB = (((curCol & iBitB)<<2) + (((*curLine) & iBitB)<<1)) >> 2;
			if(curB > iBitB){ curB = 0xffffffff & iBitB; }
			curB = curB & iBitB;

			DIRECT_PIXEL32(aDst, x, y) = (curR | curG | curB);
			curCol = ( ((curCol & iBitR) - (((*(curLine - (depthPix>>1)) & iBitR) >> aDepth) & iBitR) + (((*(curLine + (depthPix>>1)) & iBitR) >> aDepth) & iBitR)) & iBitR)
					|( ((curCol & iBitG) - (((*(curLine - (depthPix>>1)) & iBitG) >> aDepth) & iBitG) + (((*(curLine + (depthPix>>1)) & iBitG) >> aDepth) & iBitG)) & iBitG)
					|( ((curCol & iBitB) - (((*(curLine - (depthPix>>1)) & iBitB) >> aDepth) & iBitB) + (((*(curLine + (depthPix>>1)) & iBitB) >> aDepth) & iBitB)) & iBitB);

			*curLine++;
		}
	}
}