#include "TZako.h"
#include "TPlayer.h"
#include "TPBul.h"
#include "TShilu.h"

TZako::TZako(GmMain *aParent, fixed aX, fixed aY, int aCol) : T2DPoly(aParent){
	iParent = aParent;
	iX = aX;
	iY = aY;
	iAge = 0;
	iColor = aCol;
	this->setPriority(GmTask::EPriorityStandard);

	iAngle = itofix(GE_rand() * 255 / RAND_MAX);
	iSpeed = itofix(1);
	iPow = 5;

	iColW = itofix(5);
	iColH = itofix(5);
}

//virtual 
int TZako::initializeE(){
	iVtxNum = 5;
	iVtx[0] = itofix( 8);
	iVtx[1] = itofix( 0);

	iVtx[2] = itofix( 5);
	iVtx[3] = itofix( 5);


	iVtx[4] = itofix(-5);
	iVtx[5] = itofix( 5);

	iVtx[6] = itofix(-5);
	iVtx[7] = itofix(-5);

	iVtx[8] = itofix( 5);
	iVtx[9] = itofix(-5);

	iScale = itofix(2);
	return ERROR_NONE;
}

TZako::~TZako(){
}

void TZako::update(){
//	BITMAP *dst = iParent->getGmGfxN()->getBackBuffer();
//	BITMAP *src = iParent->getGmGfxN()->getSprite();
	TPlayer *player = dynamic_cast<TPlayer *>(iParent->getGmTaskByTypeN(typeid(TPlayer)));

	iAge++;

	if(player){
		fixed pAngle = fixatan2(player->getY() - iY, player->getX() - iX) & 0x00ffffff;
#if 1
		//iAnglepAngle܂ł̊px0`255ɂ.
		fixed diff = (pAngle - iAngle) & 0x00ffffff;
		if(diff < 0x007FFFFF){
			//px菬Ȃ玞vOK
			iAngle += itofix(1);
		}else{
			//pxȏȂ甽v̂ق.
			iAngle -= itofix(1);
		}
#endif
		iAngle &= 0x00ffffff;
	}

	iX += fixmul(fixcos(iAngle), iSpeed);
	iY += fixmul(fixsin(iAngle), iSpeed);

	if(iPow < 0 || iAge & 0xffffff00){
		TShilu::createAndAdd(iParent, iX, iY, iColor);
		if(iParent->getGmTaskNum() < GM_STUFF_MAX / 2){
			//]TƂ.
			TShilu::createAndAdd(iParent, iX, iY, iColor);
			TShilu::createAndAdd(iParent, iX, iY, iColor);
			TShilu::createAndAdd(iParent, iX, iY, iColor);
			TShilu::createAndAdd(iParent, iX, iY, iColor);
		}
		setDelete();
	}
}

void TZako::notifyCollision(GmTask *aTask){
	if(typeid(*aTask) == typeid(TPBul)){
		iPow--;
		TShilu::createAndAdd(iParent, iX, iY, iColor);
	}
}