#include "TStage.h"
#include "TPlayer.h"
//#include "TDBul.h"
#include "TZako.h"
#include "TWall.h"
#include "TMessage.h"
#include "TBackground.h"

extern Settings *GE_settings;

TStage::TStage(GmMain *aParent) : GmTask(aParent){
	iParent = aParent;
	iX = itofix(320);
	iY = itofix(240);
	iAge = 0;
	iDispRank = 0;
	iStatus = ST_TITLEINIT;
	iMenuCursor = 0;
	GE_settings->playerType = 0;
	iSelectedLevel = LEVEL_HARD;
	GE_settings->level = iSelectedLevel;

	this->setPriority(GmTask::EPriorityExLow+10);
	iSprite[0] = NULL;
	iSprite[1] = NULL;
	iSprite[2] = NULL;
	iSprite[3] = NULL;
}

int TStage::initializeE(){
	GmMain *parent = iParent;
	BITMAP *src = parent->getGmGfxN()->getSprite();

	//^Cg.
	iSprite[0] = create_sub_bitmap(src, 12*16*2, 1*16*2, 4*16*2, 2*16*2);
	//^Cgisolation
	//iSprite[0] = create_sub_bitmap(src, 12*16*2, 1*16*2, 9*8*2, 2*16*2);
	if(!(iSprite[0])){ return ERROR_GENERAL; }
	//reserved
	iSprite[1] = create_sub_bitmap(src, 0*16*2, 0*16*2, 1*8*2, 1*8*2);
	if(!(iSprite[1])){ return ERROR_GENERAL; }
	//reserved.
	iSprite[2] = create_sub_bitmap(src, 0*16*2, 0*16*2, 1*8*2, 1*8*2);
	if(!(iSprite[2])){ return ERROR_GENERAL; }
	//Q[I[o[.
	iSprite[3] = create_sub_bitmap(src, 0*16*2, 4*16*2, 9*8*2, 1*8*2);
	if(!(iSprite[3])){ return ERROR_GENERAL; }

	return ERROR_NONE;
}

TStage::~TStage(){
	if(iSprite[0]){
		destroy_bitmap(iSprite[0]);
		iSprite[0] = NULL;
	}
	if(iSprite[1]){
		destroy_bitmap(iSprite[1]);
		iSprite[1] = NULL;
	}
	if(iSprite[2]){
		destroy_bitmap(iSprite[2]);
		iSprite[2] = NULL;
	}
	if(iSprite[3]){
		destroy_bitmap(iSprite[3]);
		iSprite[3] = NULL;
	}
}

void TStage::update(){
	GmMain *parent = iParent;
	GmGfx *gfx = parent->getGmGfxN();
	BITMAP *dst = gfx->getBackBuffer();
	GmInput *in = iParent->getGmInputN();
	iAge++;

	switch(iStatus){
		case ST_TITLEINIT:{
			iAge = 0;
			iParent->getGmInputN()->setListener(this);
			iParent->getGmSoundN()->stopAll();
			iParent->getGmSoundN()->playToySoundE(5, 1);
			iParent->getGmSoundN()->getToySoundN(5)->iVol = 255;
			iParent->getGmSoundN()->adjustToySound(5,1);
			gfx->setBrightness(0);
			gfx->setBGType(GmGfx::BG_NONE);
			iStatus = ST_TITLE;
		}break;
		case ST_TITLE:{
			if(GE_settings->replay){
				//vC̓^CgʃXLbv.
				iStatus = ST_GAMEINIT;
			}
		}break;
		case ST_GAMEINIT:{
			GmTask *t = NULL;
			int i;

			iAge = 0;
			iDispRank = 0;
			parent->getGmInputN()->releaseListener(this);

			//vCO֘Ȁ.
			GE_srand(GE_getCurrentTime());
			if(GE_settings->replay){
				if(exists(GE_settings->replayFileName)
				&& ERROR_NONE == parent->getGmInputN()->startLog(GmInput::LOGMODE_PLAY, GE_settings->replayFileName)){
				//wt@C݂ȂĐ[h.
				}else{
					//ĐJnɎsL^[hɐ؂ւ.
					GE_settings->replay = FALSE;
					RELEASE_PRINT0("FAILED TO READ LOG!\n");
					//CREATE_AND_ADD(t, TMessage::createN(iParent, "FAILED TO READ LOG", 60*4));
					//t->setXY(itofix(0), itofix(-16));
				}
				t = NULL;
			}

			if(!(GE_settings->replay)){
				//L^[h.}EX̋OՂL^łȂfreeCamera͔Ή.
				if( !(GE_settings->freeCamera)
				&& (ERROR_NONE != parent->getGmInputN()->startLog(GmInput::LOGMODE_WRITE)) ){
					//̒iKł͂܂sȂƎv.
					RELEASE_PRINT0("FAILED TO START LOG!\n");
					CREATE_AND_ADD(t, TMessage::createN(iParent, "FAILED TO START LOG", 60*8));
					t->setXY(itofix(0), itofix(0));
				}
				t = NULL;
			}

			GE_settings->score = 0;
			t = TPlayer::createN(iParent, static_cast<TPlayer::SYMPTOM>(GE_settings->playerType), GE_settings->level);
			if(iParent->addChildE(t) != ERROR_NONE){
				delete t;
			}
			t = NULL;

			CREATE_AND_ADD(t, TWall::createN(iParent));
			t = NULL;
			iStatus = ST_GAME;

			//[hƂBGMݒ.
			if(GE_settings->level == LEVEL_SIKSIK){
				iParent->getGmSoundN()->playToySoundE(10, 1);
				//iParent->getGmSoundN()->stopToySound(5);
				//iParent->getGmSoundN()->stopToySound(6);
			}else{
				iParent->getGmSoundN()->stopAll();
				iParent->getGmSoundN()->playToySoundE(6, 1);
			}

			//[hƂɔwiݒ.
			if(GE_settings->level == LEVEL_SIKSIK){
				gfx->setBGType(GmGfx::BG_NONE);
				CREATE_AND_ADD(t, TBackground::createN(iParent));
				t = NULL;
			}else if(GE_settings->playerType == TPlayer::SCHIZOID){
				gfx->setBGType(GmGfx::BG_A);
			}else /* TPlayer::PARANOOID */{
				gfx->setBGType(GmGfx::BG_B);
			}
		}break;
		case ST_GAME:{
			if(key[KEY_Q]){
				iStatus = ST_RESET;
			}
			TPlayer *player = dynamic_cast<TPlayer *>(iParent->getGmTaskByTypeN(typeid(TPlayer)));
			if(!player){
				iStatus = ST_OVERINIT;
			}

			if((iAge & 0x00000f00) == 0x00000f00){
				GmTask *t = TZako::createN(iParent, itofix(GE_rand() * 640 / RAND_MAX - 320), itofix(GE_rand() * 480 / RAND_MAX - 240), makecol(GE_rand() * 255 / RAND_MAX, 128, 128));
				if(iParent->addChildE(t) != ERROR_NONE){
					delete t;
				}
				int a = sizeof(int);
				t = NULL;
			}
			iDispRank = iAge >> 12;
		}break;
		case ST_OVERINIT:{
			GmTask* t = NULL;
			int err = ERROR_NONE;
			if(!(GE_settings->replay)){
				//replay[hłȂ΁AL^vCۑ.
				err = parent->getGmInputN()->saveLog(REPLAY_DEFAULT_FILENAME);
				if(err != ERROR_NONE){
					//L^ɃG[.
					CREATE_AND_ADD(t, TMessage::createN(iParent, "FAILED TO SAVE REPLAY DATA", 60*3));
					t->setXY(itofix(0), itofix(0));
					t = NULL;
				}
			}
			// L^/Đ I.
			err = parent->getGmInputN()->endLog();
			iAge = 0;
			iStatus = ST_OVERNG;
			parent->getGmInputN()->setListener(this);
		}break;
		case ST_OVERNG:
		case ST_OVEROK:{
			//replay[hłȂ΃nCXRAXV. ɃXRÂߏɃ`FbN.
			if(!(GE_settings->replay)){
				if(GE_settings->score > GE_settings->getHighScore()){
					GE_settings->setHighScore(GE_settings->score);
				}
			}
		}break;
		case ST_RESET:{
			iStatus = ST_TITLEINIT;
			//fȂ̂ŃvCۑȂ.
			parent->getGmInputN()->endLog();
			parent->requestFlood(this);
		}break;
		default:{
		}break;
	}
	//J[\`.
	//draw_sprite(dst, iSprite[1], BB_MARGIN + in->getMouseX() - (iSprite[1]->w >> 1), BB_MARGIN + in->getMouseY() - (iSprite[1]->h >> 1));

	//vC[ʒuƊpx\.
	//TPlayer *player = dynamic_cast<TPlayer *>(iParent->getGmTaskByTypeN(typeid(TPlayer)));
	//if(player){
	//	textprintf_ex(dst, font, BB_MARGIN+2, BB_MARGIN+1 + 16, makecol(128,128,128), -1, "x: %8X, y: %8X, angle: %8X", player->getX(), player->getY(), player->getAngle());
	//}

#if 0 //joystickԕ\.
	if(num_joysticks > 0){
		int xPos = BB_MARGIN+2;
		int yPos = BB_MARGIN+1 + 16 + 16;
		int col = makecol(128,128,128);
 #undef RELEASE_PRINTV
		#define RELEASE_PRINTV(aVar) { \
			textprintf_ex(dst, font, xPos, yPos, col, -1, "%s == %d", # aVar, aVar);\
			yPos += 9; \
		}
 #undef RELEASE_PRINTV_S
		#define RELEASE_PRINTV_S(aVar) { \
			textprintf_ex(dst, font, xPos, yPos, col, -1, "%s == %s", # aVar, aVar);\
			yPos += 9; \
		}
		RELEASE_PRINTV(joy[0].flags);
		RELEASE_PRINTV(joy[0].num_buttons);
		RELEASE_PRINTV(joy[0].num_sticks);

		RELEASE_PRINTV_S(joy[0].stick[0].name);
		RELEASE_PRINTV(joy[0].stick[0].num_axis);
		RELEASE_PRINTV(joy[0].stick[0].flags);
		RELEASE_PRINTV_S(joy[0].stick[0].axis[0].name);
		RELEASE_PRINTV(joy[0].stick[0].axis[0].pos);
		RELEASE_PRINTV(joy[0].stick[0].axis[0].d1);
		RELEASE_PRINTV(joy[0].stick[0].axis[0].d2);
		RELEASE_PRINTV_S(joy[0].stick[0].axis[1].name);
		RELEASE_PRINTV(joy[0].stick[0].axis[1].pos);
		RELEASE_PRINTV(joy[0].stick[0].axis[1].d1);
		RELEASE_PRINTV(joy[0].stick[0].axis[1].d2);
		RELEASE_PRINTV_S(joy[0].stick[0].axis[2].name);
		RELEASE_PRINTV(joy[0].stick[0].axis[2].pos);
		RELEASE_PRINTV(joy[0].stick[0].axis[2].d1);
		RELEASE_PRINTV(joy[0].stick[0].axis[2].d2);

		RELEASE_PRINTV_S(joy[0].stick[1].name);
		RELEASE_PRINTV(joy[0].stick[1].num_axis);
		RELEASE_PRINTV(joy[0].stick[1].flags);
		RELEASE_PRINTV_S(joy[0].stick[1].axis[0].name);
		RELEASE_PRINTV(joy[0].stick[1].axis[0].pos);
		RELEASE_PRINTV(joy[0].stick[1].axis[0].d1);
		RELEASE_PRINTV(joy[0].stick[1].axis[0].d2);
		RELEASE_PRINTV_S(joy[0].stick[1].axis[1].name);
		RELEASE_PRINTV(joy[0].stick[1].axis[1].pos);
		RELEASE_PRINTV(joy[0].stick[1].axis[1].d1);
		RELEASE_PRINTV(joy[0].stick[1].axis[1].d2);

		RELEASE_PRINTV_S(joy[0].stick[2].name);
		RELEASE_PRINTV(joy[0].stick[2].num_axis);
		RELEASE_PRINTV(joy[0].stick[2].flags);
		RELEASE_PRINTV_S(joy[0].stick[2].axis[0].name);
		RELEASE_PRINTV(joy[0].stick[2].axis[0].pos);
		RELEASE_PRINTV(joy[0].stick[2].axis[0].d1);
		RELEASE_PRINTV(joy[0].stick[2].axis[0].d2);
		RELEASE_PRINTV_S(joy[0].stick[2].axis[1].name);
		RELEASE_PRINTV(joy[0].stick[2].axis[1].pos);
		RELEASE_PRINTV(joy[0].stick[2].axis[1].d1);
		RELEASE_PRINTV(joy[0].stick[2].axis[1].d2);

		RELEASE_PRINTV_S(joy[0].button[0].name);
		RELEASE_PRINTV(joy[0].button[0].b);
		RELEASE_PRINTV_S(joy[0].button[1].name);
		RELEASE_PRINTV(joy[0].button[1].b);
		RELEASE_PRINTV_S(joy[0].button[2].name);
		RELEASE_PRINTV(joy[0].button[2].b);
		RELEASE_PRINTV_S(joy[0].button[3].name);
		RELEASE_PRINTV(joy[0].button[3].b);
		RELEASE_PRINTV_S(joy[0].button[4].name);
		RELEASE_PRINTV(joy[0].button[4].b);
		RELEASE_PRINTV_S(joy[0].button[5].name);
		RELEASE_PRINTV(joy[0].button[5].b);
	}
#endif //joystickԕ\.

}


void TStage::draw(BITMAP* aDst, T2DCam* aCam){
	switch(iStatus){
		case ST_TITLE:{
			//^Cgʂ̔wi\.
			int lY = 0;
			for(int i = 0; i < 6; i++){
				lY = ((iAge + 4649) << i) & 0x01ff;
				//fastline(aDst, 0, lY, aDst->w, lY + (iAge & 0x0f), makecol(80 + i * 10, 0, 80 + i * 10));
				fastline(aDst, 0, lY, aDst->w, lY + (iAge & 0x0f), makecol(100 + i * 5, 0, 100 + i * 5));
			}

			//^CgS\.
			if(((iAge & 0x0000011) == 0x00000011) && (iAge & 0x00000300)){
				//draw_sprite(aDst, iSprite[0], (aDst->w / 2) - (iSprite[0]->w / 2) + (fixcos(itofix((iAge << 6)&0x000000ff)) >> 12), (aDst->h / 2) - (iSprite[0]->h / 2) );
				draw_sprite(aDst, iSprite[0], (aDst->w / 2) - (iSprite[0]->w / 2), (aDst->h / 2) - (iSprite[0]->h / 2) );
			}else{
				draw_sprite(aDst, iSprite[0], (aDst->w / 2) - (iSprite[0]->w / 2), (aDst->h / 2) - (iSprite[0]->h / 2) + (fixcos(itofix(iAge&0x000000ff)) >> 13) );
			}

			//j[\.
			int lineOffset = aDst->h / 4 * 3;
			int pLine = 0;
			textprintf_ex(aDst, font, BB_MARGIN + 64, lineOffset + pLine*16, makecol(255,255,255), -1, "<- LEVEL -> %s", GE_settings->getLevelName());
			pLine++;
			textprintf_ex(aDst, font, BB_MARGIN + 64, lineOffset + pLine*16, makecol(255,255,255), -1, "   SIDE A");
			pLine++;
			textprintf_ex(aDst, font, BB_MARGIN + 64, lineOffset + pLine*16, makecol(255,255,255), -1, "   SIDE B");
			pLine++;
			textprintf_ex(aDst, font, BB_MARGIN + 64, lineOffset + pLine*16, makecol(255,255,255), -1, "   EXIT");

			pLine = 1 + iMenuCursor;
			textprintf_ex(aDst, font, BB_MARGIN + 64, lineOffset + pLine*16, makecol(255,255,255), -1, ">>");
		}break;

		case ST_GAME:{
			if(GE_settings->replay  //vCĐ[h.
			&& !(iAge & 0x00000020) //_ŏ.
			&& !(key[KEY_ALT]) ){  //ALTŕ\}~(SSBep)
				//vCĐł邱Ƃ\.
				if(!(iAge & 0xFFFFFF00)){
					//Jn炵΂炭͒t߂ɕ\.
					textprintf_ex(aDst, font, BB_MARGIN + 8, (aDst->h / 2) - 32, makecol(192,192,128), -1, "REPLAY >");
					textprintf_ex(aDst, font, BB_MARGIN + 8, (aDst->h / 2) - 16, makecol(192,192,128), -1, "%s", GE_settings->replayFileName );
				}else{
					//΂炭ɕ\.
					textprintf_ex(aDst, font, BB_MARGIN + 8, aDst->h - BB_MARGIN - 35, makecol(192,192,128), -1, "REPLAY >");
					textprintf_ex(aDst, font, BB_MARGIN + 8, aDst->h - BB_MARGIN - 19, makecol(192,192,128), -1, "%s", GE_settings->replayFileName );
				}
			}
		}break;

		case ST_OVERNG:
		case ST_OVEROK:{
			//Q[I[o[ʂ̕\.
			int addY = 0;
			if(iAge < 32){
				addY = -32 / (iAge + 1);
			}
			int spriteIndex = 2;
			if(iStatus == ST_OVERNG){
				spriteIndex = 3;
			}
			draw_sprite(aDst, iSprite[spriteIndex], (aDst->w / 2) - (iSprite[spriteIndex]->w / 2), (aDst->h / 2) - (iSprite[spriteIndex]->h / 2) + (fixcos(itofix(iAge&0x000000ff)) >> 13) + addY );
		}break;

		default:{
		}break;
	}

	//XRA͏ɕ\.
	if(iMenuCursor != MENU_EXIT){
		textprintf_ex(aDst, font, BB_MARGIN+16, BB_MARGIN+1, makecol(255,255,255), -1, "SCORE%8d / HI%8d / EXTEND EVERY %d / LV.%s,%2d", GE_settings->score, GE_settings->getHighScore(), TPlayer::SCORE_EXTEND_EVERY, GE_settings->getLevelName(), iDispRank);
	}else{
		textprintf_ex(aDst, font, BB_MARGIN+16, BB_MARGIN+1, makecol(255,255,255), -1, "SCORE%8d / HI         / EXTEND EVERY %d / LV.%s,%2d", GE_settings->score, TPlayer::SCORE_EXTEND_EVERY, GE_settings->getLevelName(), iDispRank);
	}
}


//I𒆂̃j[ڂs.
void TStage::execMenu(){
	if(iStatus != ST_TITLE){
		return;
	}
	GmGfx* gfx = iParent->getGmGfxN();
	switch(iMenuCursor){
		case MENU_SCHIZOID:
			iStatus = ST_GAMEINIT;
			break;
		case MENU_PARANOID:
			iStatus = ST_GAMEINIT;
			break;
		case MENU_EXIT:
			//I.
			GE_setExitFlag();
			break;
		default:
			break;
	}
}


void TStage::keyPressed(int aKeyCode){
	if(iStatus == ST_TITLE){
		//^Cg j[̓͑Ή.
		switch(aKeyCode){
			case KEY_UP:
				iMenuCursor--;
				break;
			case KEY_DOWN:
				iMenuCursor++;
				break;
			case KEY_LEFT:
				//if(iMenuCursor != TStage::MENU_EXIT){
					iSelectedLevel--;
				//}
				break;
			case KEY_RIGHT:
				//if(iMenuCursor != TStage::MENU_EXIT){
					iSelectedLevel++;
				//}
				break;
			case KEY_Z:
			case KEY_X:
				execMenu();
				break;
			default:
				break;
		}

		//J[\ElmF.
		if(iMenuCursor < 0){
			iMenuCursor = MENU_ITEMCOUNT - 1;
		}else if(MENU_ITEMCOUNT <= iMenuCursor){
			iMenuCursor = 0;
		}
		//GlobalplayerʂXV.
		switch(iMenuCursor){
			case MENU_SCHIZOID:
				GE_settings->playerType = TPlayer::SCHIZOID;
				break;
			case MENU_PARANOID:
				GE_settings->playerType = TPlayer::PARANOID;
				break;
			default:
				break;
		}

		//ՓxElmF.
		int itemCount = LEVEL_ITEMCOUNT - 1;
		if(GE_settings->getTotalHighScore() > 200000){
			//nCXRAv_20_ȏŔo[WAbN.
			itemCount = LEVEL_ITEMCOUNT;
		}
		if(iSelectedLevel < 0){
			iSelectedLevel = itemCount - 1;
		}
		if(iSelectedLevel >= itemCount){
			iSelectedLevel = 0;
		}
		//GlobalȓՓxXV.
		GE_settings->level = iSelectedLevel;


	}
}


void TStage::keyReleased(int aKeyCode){
	if(aKeyCode == KEY_Z && iAge > 60 && (iStatus == ST_OVEROK || iStatus == ST_OVERNG)){
		//Q[I[o[^Cgʂɖ߂.
		iStatus = ST_RESET;
	}
}
