//TPlayer
//鎩@.

#ifndef __TPLAYER_HEAD__
#define __TPLAYER_HEAD__
#include "GmMain.h"
#include "TStage.h"

#define TPlayer_SPRITE_NUM (24)

class TPlayer : public GmTask , public KeyListener{
public:
	enum{
		DEFAULT_POW = 1
	};
	//@̎.
	enum SYMPTOM {
		SCHIZOID = 0, //΂܂.
		PARANOID,  //OW.
		SYMPTOM_MAX //vf.
	};
	enum LEVEL_VALUE {
		LEVEL_EASY = 130, //C[W[.
		LEVEL_HARD = 50, //n[h.
		LEVEL_SERIOUS = 15, //ނނ.
		LEVEL_SIKSIK = (75 | 0x10000000) //.
	};
	static TPlayer *createN(GmMain *aParent, SYMPTOM aSymptom, int aLevel);
	virtual ~TPlayer();
	virtual void update();

	virtual void keyPressed(int aKeyCode);
	virtual void keyReleased(int aKeyCode);
	virtual void TPlayer::notifyCollision(GmTask *aTask);
	virtual void draw(BITMAP* aDst, T2DCam* aCam);

	int getPow(){ return iPow;};
	void setStress(int aStress) { iStress = aStress; };
	int getStress() { return iStress; };
	int getScoreLevel() { return iScoreLevel; };
	enum {
		SCORE_EXTEND_EVERY = 10000, //GNXeh.
		STRESS_THRESHOLD_MAX = 1000, //Stress臒l̍ől.
		STRESS_THRESHOLD_MIN = 400, //Stress臒l̍ŏl.
		STRESS_CIRCLESIZE = 800,  //Stress\~̍őTCY. ʂ[傫.
		SCORELEVEL_BORDER = 1000    //_2{[h臒l.
	};

protected:
	TPlayer(GmMain *aParent = NULL);
	virtual int initializeE(SYMPTOM aSymptom, int aLevel);
	int initializeBitmapE(SYMPTOM aSymptom);
	void fire(SYMPTOM aSymptom);
	void addScoreLevel();

	BITMAP *iSprite[TPlayer_SPRITE_NUM];
	TStage *iStage;
	int iSpriteDir;

	int iAge;
	int iPow;
	fixed iVX;
	fixed iVY;

	fixed iTargetX;
	fixed iTargetY;

	SYMPTOM iSymptom;
	int iFireType;
	enum {
		FIRE_NONE = 0,
		FIRE_SHOOT,

		FIRE_SPAN = 2,
		FIRE_MAX_SPEED = 6,
		FIRE_MIN_SPEED = 1
	};
	fixed iFireAngle;
	fixed iVFireAngle;
	int iFireWait;

	enum {
		SPRITEDIR_UP = 0,
		SPRITEDIR_RIGHT = 3,
		SPRITEDIR_DOWN = 6,
		SPRITEDIR_LEFT = 9
	};

	int iStress; ///<XgXl, オ肷Ɩ\[h.
	int iStressThreshold; ///<XgXl̖\[h臒l.
	fixed iGameLevel; ///<Q[[hɂՓx. Jn͌Œ. iLevel̏㏸xɊ֘A.
	fixed iLevel; ///<݂̓Փx.Q[͏㏸.
	int iScoreLevel; ///<߂ĂXRA.(L[𗣂ƂɎ擾ł)
	int iScoreNextExtend; ///<1UP_.

	int iLostMind; ///<\[hۂ.
};


class TPlayerKasuri : public GmTask{
public:
	static TPlayerKasuri *createN(GmMain *aParent, TPlayer* aPlayer){
		TPlayerKasuri *self = new TPlayerKasuri(aParent, aPlayer);
		if(self->initializeE() != ERROR_NONE){
			delete self;
			self = NULL;
		}
		return self;
	}
	virtual int initializeE();
	virtual ~TPlayerKasuri();

	virtual void update();
	virtual void draw(BITMAP *aDst, T2DCam *aCam);
	virtual void notifyCollision(GmTask *aTask);

	//TCYaNum{܂.ʂ]ƌڂ̔Ɉaꍇ̎bΏ.ǎgĂȂ.
	void colSizeMul(fixed aNum){ iColW = fixmul(iColW, aNum); iColH = fixmul(iColH, aNum); }
protected:
	TPlayerKasuri(GmMain *aParent, TPlayer* aPlayer);

	TPlayer* iPlayer;
	int iAge;
};


#endif // __TPLAYER_HEAD__
