#include "TPlayer.h"
#include "TPBul.h"
//#include "TDBul.h"
#include "TShilu.h"
#include "TWall.h"
#include "TMessage.h"
extern Settings *GE_settings;

//static
TPlayer *TPlayer::createN(GmMain *aParent, SYMPTOM aSymptom, int aLevel){
	TPlayer *self = new TPlayer(aParent);
	if(self->initializeE(aSymptom, aLevel) != ERROR_NONE){
		delete self;
		self = NULL;
	}
	return self;
}

TPlayer::TPlayer(GmMain *aParent) : GmTask(aParent){
	iParent = aParent;
	iX = itofix(0);
	iY = itofix(0);
	iAge = 0;
	this->setPriority(GmTask::EPriorityLow);

	for(int i = 0; i < TPlayer_SPRITE_NUM; i++){
		iSprite[i] = NULL;
	}

	iColW = itofix(4);
	iColH = itofix(4);

	iStage = NULL;
	iPow = TPlayer::DEFAULT_POW;
	iTargetX = itofix(0);
	iTargetY = itofix(0);
	iVX = itofix(0);
	iVY = itofix(0);
	iAngle = 0;

	iSymptom = SCHIZOID;
	iFireType = FIRE_NONE;
	iFireAngle = itofix(-64);
	iVFireAngle = 0;
	iFireWait = FIRE_SPAN;

	iStress = 0;
	iStressThreshold = STRESS_THRESHOLD_MAX;
	iLevel = 1;
	iScoreLevel = 0;
	iScoreNextExtend = SCORE_EXTEND_EVERY;

	iLostMind = FALSE;
}

int TPlayer::initializeE(SYMPTOM aSymptom, int aLevel){
	iSymptom = aSymptom;
	if(ERROR_NONE != initializeBitmapE(iSymptom)){
		return ERROR_GENERAL;
	}
	iCurrentSprite = iSprite[8];
	iSpriteDir = SPRITEDIR_UP;

	GmTask* t = NULL;
	CREATE_AND_ADD(t, TPlayerKasuri::createN(iParent, this));
	if(!t){
		return ERROR_NO_RESOURCES;
	}
	switch(aLevel){
		case 0:
			iGameLevel = LEVEL_EASY;
			iAngle = 0;
			break;
		case 1:
			iGameLevel = LEVEL_HARD;
			iAngle = 0;
			break;
		case 2:
			iGameLevel = LEVEL_SERIOUS;
			iAngle = 0;
			break;
		case 3:
			iGameLevel = LEVEL_SIKSIK;
			//iAngle = itofix(32);
			//dynamic_cast<TPlayerKasuri*>(t)->colSizeMul(itofix(11) / 10);
			break;
		default:
			iGameLevel = LEVEL_HARD;
			iAngle = 0;
			break;
	}
	t = NULL;

	GmInput *in = NULL;
	in = iParent->getGmInputN();
	if(!in){
		return ERROR_NOT_EXISTS;
	}
	in->setListener(this);

	iStage = dynamic_cast<TStage *>(iParent->getGmTaskByTypeN(typeid(TStage)));

	return ERROR_NONE;	
}


int TPlayer::initializeBitmapE(SYMPTOM aSymptom){
	GmGfx *gfx = NULL;
	gfx = iParent->getGmGfxN();
	if(!gfx){
		return ERROR_NOT_EXISTS;
	}
	BITMAP *src = NULL;
	src = gfx->getSprite();
	if(!src){
		return ERROR_NOT_EXISTS;
	}
	switch(aSymptom){
		case SCHIZOID:{
			for(int i = 0; i < TPlayer_SPRITE_NUM / 2; i++){
				iSprite[i] = create_sub_bitmap(src, i*16*2, 0*16*2, 1*16*2, 1*16*2);
				if(!(iSprite[i])){
					return ERROR_GENERAL;
				}
			}
			for(int i = 0; i < TPlayer_SPRITE_NUM / 2; i++){
				iSprite[TPlayer_SPRITE_NUM / 2 + i] = create_sub_bitmap(src, i*16*2, 1*16*2, 1*16*2, 1*16*2);
				if(!(iSprite[TPlayer_SPRITE_NUM / 2 + i])){
					return ERROR_GENERAL;
				}
			}
		}break;
		case PARANOID:{
			for(int i = 0; i < TPlayer_SPRITE_NUM / 2; i++){
				iSprite[i] = create_sub_bitmap(src, i*16*2, 2*16*2, 1*16*2, 1*16*2);
				if(!(iSprite[i])){
					return ERROR_GENERAL;
				}
			}
			for(int i = 0; i < TPlayer_SPRITE_NUM / 2; i++){
				iSprite[TPlayer_SPRITE_NUM / 2 + i] = create_sub_bitmap(src, i*16*2, 3*16*2, 1*16*2, 1*16*2);
				if(!(iSprite[TPlayer_SPRITE_NUM / 2 + i])){
					return ERROR_GENERAL;
				}
			}
		}break;
		default:{
			return ERROR_ARGUMENT;
		}break;
	}
	return ERROR_NONE;
}


TPlayer::~TPlayer(){
	if(iParent){
		//͂̃XiJ.
		GmInput *in = iParent->getGmInputN();
		if(in){
			in->releaseListener(this);
		}

		//JX폜.
		GmTask* t = iParent->getGmTaskByTypeN(typeid(TPlayerKasuri));
		if(t){
			t->setDelete();
		}
	}
	
	for(int i = 0; i < TPlayer_SPRITE_NUM; i++){
		if(iSprite[i]){
			destroy_bitmap(iSprite[i]);
			iSprite[i] = NULL;
		}
	}
}


void TPlayer::keyPressed(int aKeyCode){

	switch (aKeyCode) {
	case KEY_UP:
		iVY-= itofix(1);
		break;
	case KEY_DOWN:
		iVY+= itofix(1);
		break;
	case KEY_LEFT:
		iVX-= itofix(1);
		break;
	case KEY_RIGHT:
		iVX+= itofix(1);
		break;
	case KEY_Z:
	case KEY_X:
		iFireType = FIRE_SHOOT;
		//if(iSymptom == PARANOID){
		//	iFireAngle = itofix(GE_rand() & 0x00ff);
		//}
		break;
	default:
		break;
	}
}

void TPlayer::keyReleased(int aKeyCode){
	switch (aKeyCode) {
	case KEY_UP:
		iVY+= itofix(1);
		break;
	case KEY_DOWN:
		iVY-= itofix(1);
		break;
	case KEY_LEFT:
		iVX+= itofix(1);
		break;
	case KEY_RIGHT:
		iVX-= itofix(1);
		break;
	case KEY_Z:
	case KEY_X:
		iFireType = FIRE_NONE;
		break;
	default:
		break;
	}
}

void TPlayer::update(){
	int i;
	GmMain *parent = iParent;
	GmInput *in = parent->getGmInputN();
	iAge++;
	//iLevel = iAge / 50 + iStress / 20;
	//iLevel = iAge / fixtoi(GE_settings->levelFixed) + iStress / 20;
	iLevel = iAge / (iGameLevel & 0x0fffffff) + iStress / 20;

#if 0
	if(iGameLevel == LEVEL_SIKSIK){
		//ʂ]ƂH.
		if((iAge & 0x000000e0) == 0x000000e0){
			//iAngle += 3 << 12;
			iAngle += 1 << 14;
		}
	}
#endif
	//iAngleɉpxňړ.
	if(iVX || iVY){
		fixed movAngle = fixatan2(iVY, iVX);
		fixed nextX = iX + fixmul(fixcos(iAngle + movAngle), itofix(2));
		fixed nextY = iY + fixmul(fixsin(iAngle + movAngle), itofix(2));
		if(abs(fixtoi(nextX)) < TWall::SIZE_HALF){
			iX = nextX;
		}
		if(abs(fixtoi(nextY)) < TWall::SIZE_HALF){
			iY = nextY;
		}
	}

	//ړ摜.
	int spriteIndex = 0;
	if(iVX || iVY){
		fixed angle = (fixatan2(iVY, iVX)) & 0x00ffffff;
		/*  */if(itofix(  0) <= angle && angle < itofix( 64)){
			iSpriteDir = SPRITEDIR_RIGHT;
		}else if(itofix( 64) <= angle && angle < itofix(128)){
			iSpriteDir = SPRITEDIR_DOWN;
		}else if(itofix(128) <= angle && angle < itofix(192)){
			iSpriteDir = SPRITEDIR_LEFT;
		}else if(itofix(192) <= angle && angle < itofix(256)){
			iSpriteDir = SPRITEDIR_UP;
		}
		spriteIndex = iSpriteDir + ((iAge >> 2) & 0x00000001);
	}else{
		spriteIndex = iSpriteDir + 2;
	}
	if(iLostMind){
		spriteIndex += 12;
	}
	iCurrentSprite = iSprite[spriteIndex];

	//pxXV.
	if(GE_settings->freeCamera){
		//freeCamera ON: }EXEŕ].
		iAngle += itofix(in->getMouseX() - (parent->getGmGfxN()->getScreenW() >> 1)) >> 2;
	}

	//pxiiŌŒ
	//iAngle = itofix(32);
	//]
	//iAngle += ftofix(0.04);

	//0~255͈̔͂ɐK(Ă񂾂).̕łővۂǃzg.
	iAngle &= 0x00ffffff;

	//Q[I[o[ŏ.
	if(iStage && (iStage->getStatus() == TStage::ST_OVEROK || iStage->getStatus() == TStage::ST_OVERNG)){
		iColW = 0;
		iColH = 0;
		setDelete();
		//iAllowKey = 0;
	}

	//iTargetX = in->getMouseX();
	//iTargetY = in->getMouseY();

	//ef^C~O.
	if(iFireWait == 0 || iLostMind /* || iGameLevel == LEVEL_SIKSIK */ ){
		//efw邩.
		if(iFireType == FIRE_SHOOT || iLostMind){
			//.
			fire(iSymptom);
		}else{
			//ef^C~OȂ: XRAvƃXgX㏸.
			if(iGameLevel == LEVEL_SIKSIK){
				iStress+=3;
			}else{
				iStress+=2;
			}
			if(iScoreLevel != 0){
				char scoreText[17];
				if(iScoreLevel > SCORELEVEL_BORDER){
					//1000_ȏȂ{[iX.
					GE_settings->score += iScoreLevel * 2;
					sprintf_s(scoreText, 17, "%d x2", iScoreLevel);
				}else{
					GE_settings->score += iScoreLevel;
					sprintf_s(scoreText, 17, "%d", iScoreLevel);
				}
				//擾XRA\.
				GmTask* t = NULL;
				CREATE_AND_ADD(t, TMessage::createN(iParent, scoreText));
				if(t){
					t->setXY(iX, iY + itofix(16));
				}
			}
			iScoreLevel = 0;
		}
	}else{
		iFireWait--;
	}

	//Stress臒l̍XV.
	if(iGameLevel == LEVEL_SIKSIK){
		iStressThreshold = STRESS_THRESHOLD_MAX * 2 - (iLevel / 4);
	}else{
		iStressThreshold = STRESS_THRESHOLD_MAX - iLevel;
	}
	if(iStressThreshold < STRESS_THRESHOLD_MIN){
		iStressThreshold = STRESS_THRESHOLD_MIN;
	}

	if(iLostMind){
		//\StressvZ.
		iScoreLevel = 0;
		iStress -= (iAge % 4 == 0) ? 1 : 0;
		if(iStress < 0){
			iStress = 0;
			iLostMind = FALSE;
		}
	}else{
		//ʏ펞StressvZ.
		if(iStress < 0){
			iStress = 0;
		}
		if(iStress > iStressThreshold){
			iLostMind = TRUE;
			iParent->getGmSoundN()->playToySoundE(7);
		}
	}

	//GNXeh.
	while(iScoreNextExtend < GE_settings->score){
		GmTask* t = NULL;
		CREATE_AND_ADD(t, TMessage::createN(iParent, "!EXTEND!"));
		if(t){
			t->setXY(iX, iY - itofix(48));
		}
		iParent->getGmSoundN()->playToySoundE(8);
		iScoreNextExtend += SCORE_EXTEND_EVERY;
		iPow++;
	}

	if(iGameLevel == LEVEL_SIKSIK){
		//񂾂BGMʂ.
		int vol = 255 - (iAge >> 4);
		if(vol > 0){
			ToySound* t = iParent->getGmSoundN()->getToySoundN(5);
			t->iVol = vol;
			iParent->getGmSoundN()->adjustToySound(5, 1);
		}else if(vol == 0){
			iParent->getGmSoundN()->stopToySound(5);
		}else{
			//
		}
	}
}//update() end

void TPlayer::addScoreLevel(){
	if(!iLostMind){
		//ʏ펞Stress炵ăXRAZ.
		if(iGameLevel == LEVEL_SIKSIK){
			iStress+=2;
		}else{
			iStress--;
		}
		iScoreLevel += 10;
		//{[iX擾OKԂɂȂvC[ɒʒm.
		if(iScoreLevel == SCORELEVEL_BORDER){
			GmTask* t = NULL;
			CREATE_AND_ADD(t, TMessage::createN(iParent, "x2"));
			if(t){
				t->setXY(iX, iY - itofix(16));
			}
			iParent->getGmSoundN()->playToySoundE(9);
		}
	}
}


//e.̃̕XRAZ.StressvZ.
void TPlayer::fire(SYMPTOM aSymptom){
	//Ɍ܂ł̔ˊԊuxw肩猈. ȁ[񂩕ςȎɂȂ.
	//iFireWait = FIRE_SPAN - (iLevel / 50);
	iFireWait = FIRE_SPAN - (iLevel / 50) + ((iGameLevel & 0x0fffffff) / 50) - 1;
	if(iFireWait < 0){
		iFireWait = 0;
	}

	//ex.
	fixed speed = itofix(1); //͉̏l.

	//e|.
	TPBul *t = NULL;

#if _DEBUG
	//fobOp. 200t[ڂŒe5̓Փx.
	if(200 < iAge && iAge < 210){
		iAge = 60*60*5;
		iPow = 5;
		//iColW = 0;
	}
	if(key[KEY_L]){
		iAge += 6;
	}
#endif

	//[hƂɈقȂ郁C̒e.
	switch(aSymptom){

		case SCHIZOID:{
			//Levelɉx.
			speed = itofix(FIRE_MIN_SPEED) + fixdiv(itofix(iLevel), itofix(250));
			if(speed > itofix(FIRE_MAX_SPEED)){
				speed = itofix(FIRE_MAX_SPEED);
			}

			//e𐶐.
			CREATE_AND_ADD(t, TPBul::createN(iParent, iX, iY, iFireAngle, speed, iSymptom) );
			t = NULL;
			addScoreLevel();

			//Ɍe̊pxݒ.
			iVFireAngle = fixdiv(itofix(iAge), itofix(32));
			iFireAngle += iVFireAngle;
			iFireAngle &= 0x00ffffff;
		}break;

		case PARANOID:{
			//Levelɉx.
			if((iAge & 0xffffe000) //uCN2ڂxeĂ݂.
			&& ((iAge << (3+16)) & 0x00ffffff) < 0x0006ffff ){
				speed = (3 << 13); //!! FIRE_MIN_SPEEDx !!
			}else{
				//ʏe. x**Ȃ炨悻uCN4ڂōō.
				int depthMax = (FIRE_MAX_SPEED - FIRE_MIN_SPEED);
				fixed speedDepth = fixdiv(itofix(iLevel), itofix((82 * 4) / depthMax));
				if(speedDepth > itofix(depthMax)){
					speedDepth = itofix(depthMax);
				}
				speed = itofix(FIRE_MIN_SPEED) + (speedDepth >> 1) + fixmul(fixsin( itofix(iAge<<2)/3 ), speedDepth >> 1 );
			}

			//܌e̊pxݒ.
			//E̕.                                                uCN̂тɔ].
			fixed spriteAngle = itofix( (-64 + ((iAge >> 9) * 64)) & 0x00ff) * (1 - ((iAge >> 11) & 0x02));

			//E񂾂isɌ.
			fixed diffAngle = ((spriteAngle - iFireAngle) & 0x00ffffff);
			if(diffAngle == 0){
				iFireAngle = spriteAngle;
			}else if(diffAngle < 0x007FFFFF){
				//px菬Ȃ玞vOK
				iFireAngle += itofix( 3 * (iFireWait + 1));
			}else{
				//pxȏȂ甽v̂ق.
				iFireAngle += itofix(-3 * (iFireWait + 1));
			}
			if(fixtoi(diffAngle -  0x007fffff) * fixtoi(((spriteAngle - iFireAngle) & 0x00ffffff) - 0x007fffff) < 0){
				//ڕWpxI[o[ꍇ.
				iFireAngle = spriteAngle;
			}

			//E̕.
			//fixed fireWidth = ( fixmul( fixcos(itofix(iAge)) + (1 << 16),itofix(32) ));
			fixed fireWidth = itofix(34) + ( fixmul( fixcos(itofix(iAge * 8 / 10)),itofix(34) ));
			fixed additionalAngle = 0;

			//͈͓̔ł΂T.
			iVFireAngle += fixdiv(itofix(iAge), itofix(30  /*32*/));
			additionalAngle = fixsin(iVFireAngle);
			additionalAngle = fixmul(additionalAngle, fireWidth);

			iFireAngle = iFireAngle & 0x00ffffff;
			additionalAngle = additionalAngle & 0x00ffffff;

			//e𐶐.
			CREATE_AND_ADD(t, TPBul::createN(iParent, iX, iY, iFireAngle + additionalAngle, speed, iSymptom) );
			t = NULL;
			addScoreLevel();
		}break;

#if 0 //20060513
		case PARANOID:{
			//Levelɉx.
			//speed = fixdiv(itofix(iLevel), itofix(166)) + itofix(1) + fixmul(fixsin( itofix(iAge<<3) ), itofix(2));
			//fixed speedDepth = (iAge << (16-12));
			fixed speedDepth = fixdiv(itofix(iLevel), itofix(60/*82*/));
			speed = /*fixdiv(itofix(iLevel), itofix(97)) + */ (speedDepth * 3 / 2) + fixmul(fixsin( itofix(iAge<<2)/3 ), speedDepth );
			if(speed > itofix(FIRE_MAX_SPEED)){
				speed = itofix(FIRE_MAX_SPEED);
			}else if(speed < itofix(1)){
				speed = itofix(1);
			}
			if(iAge & 0xffffe000){ //uCN2ڂxeĂ݂.
				if( ((iAge << (3+16)) & 0x00ffffff) < 0x0006ffff ){
					speed = (3 << 13);
				}
			}

			//܌e̊pxݒ.
			//̕.
			//iFireAngle = itofix(-64 + ((iAge >> 3) & 0xff)); //].
			fixed spriteAngle = itofix( (-64 + ((iAge >> 9) * 64)) & 0x00ff);;

			//񂾂isɌ.
			fixed diffAngle = ((spriteAngle - iFireAngle) & 0x00ffffff);
			if(diffAngle == 0){
				iFireAngle = spriteAngle;
			}else if(diffAngle < 0x007FFFFF){
				//px菬Ȃ玞vOK
				iFireAngle += itofix( 3 * (iFireWait + 1));
			}else{
				//pxȏȂ甽v̂ق.
				iFireAngle += itofix(-3 * (iFireWait + 1));
			}
			if(fixtoi(diffAngle -  0x007fffff) * fixtoi(((spriteAngle - iFireAngle) & 0x00ffffff) - 0x007fffff) < 0){
				//ڕWpxI[o[ꍇ.
				iFireAngle = spriteAngle;
			}

			//̕.
			fixed fireWidth = ( fixmul( fixcos(itofix(iAge)) + (1 << 16),itofix(32) ));
			fixed additionalAngle = 0;

			if((iAge & 0xfffff000) && 
			   ((iAge & 0x00000880) == 0x00000880) 
			   && FALSE
			){
				speed = fixdiv(itofix(iLevel), itofix(166)) + itofix(1) + fixmul(fixsin( itofix(iAge<<3) ), itofix(2));
				if(speed > itofix(FIRE_MAX_SPEED)){
					speed = itofix(FIRE_MAX_SPEED);
				}else if(speed < itofix(1)){
					speed = itofix(1);
				}
				//݂ƘAȂsing܁[.
				additionalAngle = fixmul(fixcos(fixdiv(itofix(iAge), itofix(1))), (fireWidth*2));
				//L.
				additionalAngle = fixmul(additionalAngle, fixmul(itofix((iAge * 3 >> 2) & 0x00ff), itofix(4)));
				additionalAngle = fixdiv(additionalAngle, itofix(0x00ff));
			}else{
				//΂T.
				iVFireAngle += fixdiv(itofix(iAge), itofix(32));
				additionalAngle = fixsin(iVFireAngle);
				additionalAngle = fixmul(additionalAngle, fireWidth);
			}
			iFireAngle = iFireAngle & 0x00ffffff;
			additionalAngle = additionalAngle & 0x00ffffff;
			//e𐶐.
			CREATE_AND_ADD(t, TPBul::createN(iParent, iX, iY, iFireAngle + additionalAngle, speed, iSymptom) );
			t = NULL;
			addScoreLevel();
			
		}break;
#endif //20060513

#if 0 //20060507
		case PARANOID:{
			//if(iAge & 0x01){
			//iColW = 0;
			//speed = itofix(FIRE_MAX_SPEED);
				//speed = fixmul(speed, fixsin( itofix((iAge & 0x000f)<<5) ) + itofix(1));
				//speed = fixmul(speed, fixsin( itofix((iAge & 0x007f)<<3) ) + itofix(1));
				//speed = speed + fixmul(fixsin( itofix((iAge & 0x007f)<<3) ), itofix(2));
				speed = fixmul(speed, 1 << 15);
				speed = speed + fixmul(fixsin( itofix(iAge<<3) ), itofix(3));
				if(speed > itofix(FIRE_MAX_SPEED)){
					speed = itofix(FIRE_MAX_SPEED);
				}else if(speed < (1 << 16)){
					speed = (1 << 16);
				}
			//}
			//܌e̊pxݒ.
			fixed spriteAngle;
 #if 0 //ĽɌ.
			switch(iSpriteDir){
				case SPRITEDIR_RIGHT:
					spriteAngle = 0;
					break;
				case SPRITEDIR_DOWN:
					spriteAngle = itofix(64);
					break;
				case SPRITEDIR_LEFT:
					spriteAngle = itofix(64*2);
					break;
				case SPRITEDIR_UP:
					spriteAngle = itofix(64*3);
					break;
				default:
					spriteAngle = 0;
					break;
			}
			spriteAngle = (spriteAngle + iAngle) & 0x00ffffff;
			//spriteAngle = (itofix(64*3) + iAngle) & 0x00ffffff; //OŒ.
			if(iVX || iVY){ //	iiɂĂ悤ɂȂ炱.JhɌƃQ[ɂȂȂ.
				spriteAngle = (fixatan2(iVY, iVX)) & 0x00ffffff;
			}
 #endif
			spriteAngle = itofix((iAge >> 4) & 0xff); 
			//񂾂isɌ.
			fixed diffAngle = ((spriteAngle - iFireAngle) & 0x00ffffff);
			//if(fixtoi(diffAngle) < 4 || 252 < fixtoi(diffAngle)){
			if(diffAngle == 0){
				iFireAngle = spriteAngle;
				iVFireAngle = 0;
			}else if(diffAngle < 0x007FFFFF){
				//px菬Ȃ玞vOK
				iVFireAngle = itofix( 3 * (iFireWait + 1));
			}else{
				//pxȏȂ甽v̂ق.
				iVFireAngle = itofix(-3 * (iFireWait + 1));
			}
			iFireAngle += iVFireAngle;
			if(fixtoi(diffAngle -  0x007fffff) * fixtoi(((spriteAngle - iFireAngle) & 0x00ffffff) - 0x007fffff) < 0){
				//ڕWpxI[o[.
				iFireAngle = spriteAngle;
				iVFireAngle = 0;
			}

			//̕.
			//int fireWidth = 10 + ((iAge >> 6) & 0x0000000f);
			//int fireWidth = 5 + ((iAge >> 7) & 0x0000000f);
			fixed fireWidth = ( fixmul( fixcos(itofix(iAge)) + (1 << 16),itofix(32) ));
			fixed additionalAngle = 0;
			//debug
			//iColW = 0;

			if((iAge & 0xfffff000)
			&& ((iAge & 0x00000880) == 0x00000880) 
			){
				//݂ƘAȂsing܁[.
				//additionalAngle = fixmul(fixcos(fixdiv(itofix(iAge), itofix(2))), itofix(fireWidth*2));
				additionalAngle = fixmul(fixcos(fixdiv(itofix(iAge), itofix(2))), (fireWidth*2));
				//L.
				additionalAngle = fixmul(additionalAngle, fixmul(itofix((iAge * 3 >> 2) & 0x00ff), itofix(4)));
				additionalAngle = fixdiv(additionalAngle, itofix(0x00ff));
			}else{
 #if 1
				//additionalAngle = (fixdiv( itofix( (iAge + 1) * (iAge / 2 + (iAge & 0x01)) ), itofix(32)) % itofix(fireWidth * 2 + 1));// - itofix(fireWidth);
				additionalAngle = fixsin(fixdiv( itofix( (iAge + 1) * (iAge / 2) + (iAge & 0x01) * (iAge/2 + 1) ), itofix(32)));
				additionalAngle = fixmul(additionalAngle, fireWidth);
				//additionalAngle += fixmul(fixsin((iAge << 24) & 0x00ffffff), itofix(2)); ///< ɂ܂@_ƒPȂ̂łƈӒn.
 #else
				//i͑Oɂ΂T.Xu.
				if((iAge & 0x0000007f) < 0x04){
					iFireAngle = itofix(GE_rand() & 0x00ff);
				}
				additionalAngle = (itofix( (iAge*4) % (fireWidth*2 + 1)) - itofix(fireWidth));
				additionalAngle = fixmul(additionalAngle, fixdiv(itofix(175), itofix(100))); ///< ԊuL. sv?
				additionalAngle += fixmul(fixsin((iAge << 24) & 0x00ffffff), itofix(2)); ///< ɂ܂@_ƒPȂ̂łƈӒn.
 #endif
			}
			//e𐶐.
			//TPBul *t = NULL;
			CREATE_AND_ADD(t, TPBul::createN(iParent, iX, iY, iFireAngle + additionalAngle, speed, iSymptom) );
			t = NULL;
		}break;
#endif //20060507

		default:{
		}break;
	}

	if(iLostMind){
		//\͂ƌ.xő.
		speed = itofix(FIRE_MAX_SPEED);
		switch(iAge & 0x00000030){
			case 0x00000010:{
				//cx.
				CREATE_AND_ADD(t, TPBul::createN(iParent, iX, iY, itofix(64) * (iAge & 0x03), speed, iSymptom) );
			}break;
			case 0x00000020:{
				//.
				CREATE_AND_ADD(t, TPBul::createN(iParent, iX, iY, itofix(128) * (iAge & 0x01), speed, iSymptom) );
			}break;
			case 0x00000030:{
				//ʏ펞̋t.
				CREATE_AND_ADD(t, TPBul::createN(iParent, iX, iY, itofix(128) + iFireAngle, speed, iSymptom) );
			}break;
			default: /* 0x00000000:*/ {
				//c.
				CREATE_AND_ADD(t, TPBul::createN(iParent, iX, iY, itofix(128) * (iAge & 0x01) + itofix(64), speed, iSymptom) );
			}break;
		}
	}
	//ʉ.
	iParent->getGmSoundN()->playToySoundE(0);
}


void TPlayer::notifyCollision(GmTask *aTask){
	if(typeid(*aTask) == typeid(TPBul)
	&& dynamic_cast<TPBul*>(aTask)->isOther()){
		aTask->setDelete();
		TShilu::createAndAdd(iParent, iX, iY, makecol(220,0,0), T2DPoly::FILL);
		TShilu::createAndAdd(iParent, iX, iY, makecol(220,0,0), T2DPoly::FILL);
		TShilu::createAndAdd(iParent, iX, iY, makecol(220,0,0), T2DPoly::FILL);
		iParent->getGmSoundN()->playToySoundE(3);
		iPow--;
		iScoreLevel = 0;
		//\͔eĂXgXl܂艺Ȃ.
		if(iLostMind){
			iStress -= iStressThreshold / 4;
		}else{
			iStress -= iStressThreshold;
		}
		if(iStress < 0){
			iStress = 0;
		}
		if(iPow <= 0){
			for(int i = 0; i < 128; i++){
				TShilu::createAndAdd(iParent, iX, iY, makecol(220,0,0), T2DPoly::FILL);
			}
			setDelete();
		}
	}
}

void TPlayer::draw(BITMAP* aDst, T2DCam* aCam){
#if _DEBUG //fobOp̏ԕ\.
	textprintf_ex(aDst, font, BB_MARGIN + 16, BB_MARGIN + 32, makecol(255,255,255), -1, "iStress    == %16d", iStress);
	textprintf_ex(aDst, font, BB_MARGIN + 16, BB_MARGIN + 48, makecol(255,255,255), -1, "iLevel     == %16d", iLevel);
	textprintf_ex(aDst, font, BB_MARGIN + 16, BB_MARGIN + 64, makecol(255,255,255), -1, "iAge       == %16d", iAge);
	textprintf_ex(aDst, font, BB_MARGIN + 16, BB_MARGIN + 80, makecol(255,255,255), -1, "iScoreLevel== %16d", iScoreLevel);
	textprintf_ex(aDst, font, BB_MARGIN + 16, BB_MARGIN + 96, makecol(255,255,255), -1, "TaskNum    == %16d", iParent->getGmTaskNum());
	textprintf_ex(aDst, font, BB_MARGIN + 16, BB_MARGIN + 112, makecol(255,255,255), -1, "iStressThre== %16d", iStressThreshold);
#endif
	//Pow\.
	textprintf_ex(aDst, font, BB_MARGIN + 16, BB_MARGIN + 16, makecol(255,255,255), -1, "Pow: %2d", iPow - 1);
	for(int i = 0; i < iPow - 1; i++){
		rectfill(aDst, BB_MARGIN+16, BB_MARGIN+26 + i*16, BB_MARGIN+16 + 12, BB_MARGIN+26 + i*16 + 12, makecol(255,255,255));
	}

	//BITMAP\.
	static_cast<GmTask*>(this)->GmTask::draw(aDst, aCam);

	//jՓ\.
	int x = fixtoi(getDrawingX(aCam));
	int y = fixtoi(getDrawingY(aCam));
	int size = (iStressThreshold - iStress) * STRESS_CIRCLESIZE / iStressThreshold;
	size = (size * size) / STRESS_CIRCLESIZE;
	circle(aDst, x + (size & 0x0A) - (size & 0x05), y +  - (size & 0x0A) + (size & 0x05), size, makecol(255,255,255));

	if(size < 100){
		//c肪TCYɂ100ȉȂ琔lł\.
		textprintf_ex(aDst, font, x + 2, y + 5, makecol(255,255,255), -1, "%4d", size);
	}
}




///ȉ̓JX蔻pIuWFNg.

//class TPlayerKasuri : public GmTask{
//public:
//virtual 
int TPlayerKasuri::initializeE(){
	return ERROR_NONE;
}

//virtual
TPlayerKasuri::~TPlayerKasuri(){
}

//protected:
TPlayerKasuri::TPlayerKasuri(GmMain *aParent, TPlayer* aPlayer) : GmTask(aParent){
	iPlayer = aPlayer;
	iColW = itofix(32);
	iColH = itofix(32);
	iAge = 0;
}

//virtual 
void TPlayerKasuri::update(){
	//{͖iPlayeriParentTĂȂȂȂ񂾂ǖʓ|Ȃ̂ł...
	//TPlayerKasuriÊiPlayerȂ̂ŎĂiPlayer݂͑͂.
	if(!(getDeleteFlag()) && iPlayer){
		iX = iPlayer->getX();
		iY = iPlayer->getY();
	}
	iAge++;
}


//virtual 
void TPlayerKasuri::draw(BITMAP *aDst, T2DCam *aCam){
	//Player,BITMAPȊỐ@GtFNgۂ̂Ȃǁ@`.
	//if(getDeleteFlag() || !iPlayer){
	//	return;
	//}
	//fixed x = iPlayer->getDrawingX(aCam);
	//fixed y = iPlayer->getDrawingY(aCam);
	//int size = (TPlayer::STRESS_MAX - iPlayer->getStress()) * TPlayer::STRESS_CIRCLESIZE / TPlayer::STRESS_MAX;
	//circle(aDst, fixtoi(x) + (size & 0x0A) - (size & 0x05), fixtoi(y) +  - (size & 0x0A) + (size & 0x05), size, makecol(255,255,255));
}

void TPlayerKasuri::notifyCollision(GmTask *aTask){
	if(typeid(*aTask) == typeid(TPBul)
	&& dynamic_cast<TPBul*>(aTask)->isOther()){
		if(!(getDeleteFlag()) && iPlayer){
			//Stress.
			int stress = iPlayer->getStress();
			stress-= iAge & 0x01;
			if(stress < 0){
				stress = 0;
			}
			iPlayer->setStress(stress);

			//JX_.
			int color;
			if(iPlayer->getScoreLevel() > TPlayer::SCORELEVEL_BORDER){
				GE_settings->score++;
				color = makecol(220, 90, 150);
			}else{
				color = makecol(150, 90, 220);
			}

			//jДƌʉ.
			//if(iParent->getGmTaskNum() < GM_STUFF_MAX / 2){
				TShilu::createAndAdd(iParent, iX, iY, color);
			//}
			iParent->getGmSoundN()->playToySoundE(4);
		}
	}
}
