//TPBul.h
//TPlayer̒e.

#ifndef __TPBUL_HEAD__
#define __TPBUL_HEAD__
#include "GmMain.h"
#include "T2DPoly.h"
#include "TPlayer.h" ///<SYMPTOM

#define TPBul_VTX_NUM (16)

class TPBul : public T2DPoly {
public:
	static TPBul *createN(GmMain *aParent, fixed aX, fixed aY, fixed aAngle, fixed aSpeed, int aSymptom = 0, fixed aTargetX = 0, fixed aTargetY = 0){
		TPBul *self = new TPBul(aParent, aX, aY, aAngle, aSpeed, aSymptom, aTargetX, aTargetY);
		if(self->initializeE() != ERROR_NONE){
			delete self;
			self = NULL;
		}
		return self;
	}
	virtual int initializeE();
	virtual ~TPBul();
	virtual void update();

	void notifyCollision(GmTask *aTask);
	int getCol(){ return iColor;};

	enum PBUL_TYPE{
		PARANO_SELF,
		PARANO_OTHER,
		SCHIZO_SELF,
		SCHIZO_OTHER
	};
	PBUL_TYPE getBulType() {return iBulType; };

	int isOther(/*TPlayer::SYMPTOM aSymptom*/){
		if(iBulType == SCHIZO_OTHER /* && aSymptom == TPlayer::SCHIZOID */){
			return TRUE;
		}
		if(iBulType == PARANO_OTHER /* && aSymptom == TPlayer::PARANOID */){
			return TRUE;
		}
		return FALSE;
	};
protected:
	TPBul(GmMain *aParent, fixed aX, fixed aY, fixed aAngle, fixed aSpeed, int aSymptom, fixed aTargetX, fixed aTargetY);
	void flipPropertyByType(PBUL_TYPE aType);
	int iAge;
	int iStatus;
//	int iCol;
	int iPow;
	fixed iTargetX;
	fixed iTargetY;

//	fixed iVtx[TPBul_VTX_NUM*2];
//	int iVtxNum;

//	fixed iAngle;
//	fixed iScale;
	PBUL_TYPE iBulType;
};



#endif // __TPBUL_HEAD__
