#include "TPBul.h"
#include "TZako.h"
#include "TWall.h"
#include "TPlayer.h"

TPBul::TPBul(GmMain *aParent, fixed aX, fixed aY, fixed aAngle, fixed aSpeed, int aSymptom, fixed aTargetX, fixed aTargetY) : T2DPoly(aParent){
	iParent = aParent;
	iX = aX;
	iY = aY;
	iAngle = aAngle;
	iAge = 0;
	this->setPriority(GmTask::EPriorityStandard);

	iStatus = 0;
	//iColor = makecol(64 + (GE_rand() * 96 / RAND_MAX), 128, 192);
	//iColor = makecol(0,0,255);
	iPow = 2;
	iSpeed = aSpeed;
	iTargetX = aTargetX;
	iTargetY = aTargetY;

	iScale = fixdiv(itofix(6), itofix(10)); // 0.6{.
	iColW = fixmul(itofix(8), iScale); //4.8
	iColH = iColW;
	iPolyType = T2DPoly::POLYTYPE(FILL);
	if(aSymptom == TPlayer::PARANOID){
		flipPropertyByType(PARANO_OTHER); // ->SELF
	}else{
		flipPropertyByType(SCHIZO_OTHER); // ->SELF
	}
}

//public virtual 
int TPBul::initializeE(){
	iVtxNum = 4;
	//E̞`.
	iVtx[0] = itofix(10);
	iVtx[1] = itofix(0);

	iVtx[2] = itofix(-10);
	iVtx[3] = itofix(-8);

	iVtx[4] = itofix(-5);
	iVtx[5] = itofix(0);

	iVtx[6] = itofix(-10);
	iVtx[7] = itofix(8);

	return ERROR_NONE;
}


//public virtual
TPBul::~TPBul(){
}

void TPBul::flipPropertyByType(PBUL_TYPE aType){
	switch(aType){
		case SCHIZO_SELF:
			iBulType = SCHIZO_OTHER;
			iColor = makecol(255,128,128);
			break;
		case SCHIZO_OTHER:
			iBulType = SCHIZO_SELF;
			iColor = makecol(64,64,128);
			//iColor = makecol(60,50,100);
			//iColor = makecol(70,60,100);
			break;
		case PARANO_SELF:{
			iBulType = PARANO_OTHER;
			//iColor = makecol(128,160,255);
			//iColor = makecol(128, 128 + ((iSpeed >> (16 - 4)) & 0x7f), 255);
			int speedx16 = (iSpeed >> (16 - 4)) & 0x7f; // ~96
			iColor = makecol(128 + speedx16 / 2, 128 + speedx16 / 2, 255);
			}break;
		case PARANO_OTHER:{
			iBulType = PARANO_SELF;
			//iColor = makecol(110,40,64);
			//iColor = makecol(110,20 +  + ((iSpeed >> (16 - 4)) & 0x7f),64);
			//iColor = makecol(90,((iSpeed >> (16 - 4)) & 0x7f),50);
			int speedx8 = (iSpeed >> (16 - 3)) & 0x7f; // ~48
			iColor = makecol(96 + speedx8, 32, 48 + speedx8);
			}break;
		default:
			break;
	}
}


void TPBul::update(){
	BITMAP *dst = iParent->getGmGfxN()->getBackBuffer();
//	BITMAP *src = iParent->getGmGfxN()->getSprite();
	iAge++;

	if(iStatus == 0) {
		//i.
		fixed nextX = iX + fixmul(fixcos(iAngle), iSpeed);
		fixed nextY = iY + fixmul(fixsin(iAngle), iSpeed);
		//ǔ.
		if(abs(fixtoi(nextX)) > TWall::SIZE_HALF
		|| abs(fixtoi(nextY)) > TWall::SIZE_HALF){
			//ǂɓĔ.
			if(abs(fixtoi(nextX)) > TWall::SIZE_HALF){
				iAngle = -(iAngle - itofix(64)) + itofix(64);
			}else{
				iAngle = -iAngle;
			}
			//iAngle &= 0x00ffffff;
			//ƑȂ.
			//iSpeed = fixmul(iSpeed, ftofix(1.2));
			iSpeed = fixmul(iSpeed, fixdiv(itofix(12), itofix(10)));

			//Flip
			if(iBulType == SCHIZO_OTHER || iBulType == PARANO_OTHER){
				flipPropertyByType(iBulType);
				iStatus = 1;
			}else{
				flipPropertyByType(iBulType);
				//ʉ.
				iParent->getGmSoundN()->playToySoundE(2);
			}

			//꒰dłǁ[BB@ĂꂾAvCIeB1t[ɕs񂾂ȁB[...
			//vCIeBɂ\[g𖈃t[sHƂH_CWEuȂ.
			//iParent->removeChildE(this);
			//iParent->addChildE(this);
		}
		iX += fixmul(fixcos(iAngle), iSpeed);
		iY += fixmul(fixsin(iAngle), iSpeed);
	}else if(iStatus == 1){
			iVtxNum = 8;
			iVtx[0] = itofix( 20);
			iVtx[1] = itofix( 20);

			iVtx[2] = itofix(  0);
			iVtx[3] = itofix( 15);

			iVtx[4] = itofix(-20);
			iVtx[5] = itofix( 20);

			iVtx[6] = itofix(-15);
			iVtx[7] = itofix(  0);

			iVtx[8] = itofix(-20);
			iVtx[9] = itofix(-20);

			iVtx[10] = itofix(  0);
			iVtx[11] = itofix(-15);

			iVtx[12] = itofix( 20);
			iVtx[13] = itofix(-20);

			iVtx[14] = itofix( 15);
			iVtx[15] = itofix(  0);
			iStatus = 2;
			iPow+=2;
			iParent->getGmSoundN()->playToySoundE(1);
	}else{
		if(iStatus < 7){
			iScale = fixmul(iScale, fixdiv(itofix(105), itofix(100))); // *1.05
		}else if(20 < iStatus){
			iScale = fixmul(iScale, fixdiv(itofix(8), itofix(10))); // *0.8
		}
		iStatus++;
		iAngle += itofix(12);
		if(35 < iStatus){
			setDelete();
		}
	}


}

//ՓˎɌĂ΂.
//public virtual 
void TPBul::notifyCollision(GmTask *aTask){
	if(typeid(*aTask) == typeid(TZako)){
		iPow--;
		if(iPow <= 0){
			this->setDelete();
			iColW = 0;
			iColH = 0;
		}
		if(iStatus == 0){
			iStatus = 1;
		}
	}
}