#include "TMessage.h"
#include "GmEntry.h"
#include "T2DCam.h"

//public:
//static 
TMessage* TMessage::createN(GmMain *aParent, char* aString, int aDelay){
	TMessage *self = new TMessage(aParent);
	if(self->initializeE(aString, aDelay) != ERROR_NONE){
		delete self;
		self = NULL;
	}
	return self;
}


//virtual 
int TMessage::initializeE(char* aString, int aDelay){
	int i;
	//Rs[...
	//̈TCY-1܂ŃRs[Ă,l̓RXgN^0NAĂ̂ŏI[͕ۏႳ.
	for(i = 0; i < TMESSAGE_STRING_LENGTH-1 && aString[i] != '\0'; i++){
		iString[i] = aString[i];
		iLength++;
	}
	iDelay = aDelay;
	return ERROR_NONE;
}


//virtual 
TMessage::~TMessage(){
}



//virtual 
void TMessage::update(){
	iAge++;
	if(iAge > iDelay){
		setDelete();
	}

	//iColor = iColor ^ 0xffffffff;
	//iY += ftofix(iAge / (float)30.0);
	iY += fixdiv(itofix(iAge), itofix(30));
}

//virtual 
void TMessage::draw(BITMAP* aDst, T2DCam *aCam){
	if(!aDst
	|| !aCam){
		return;
	}
	fixed x;
	fixed y;
	
	//J̕],gk.
	x =  fixmul(aCam->getScale(), fixmul(fixcos(aCam->getAngle()), iX - aCam->getX() ) - fixmul(fixsin(aCam->getAngle()), iY - aCam->getY() )) + itofix((aCam)->getScreenCenterX());
	y =  fixmul(aCam->getScale(), fixmul(fixsin(aCam->getAngle()), iX - aCam->getX() ) + fixmul(fixcos(aCam->getAngle()), iY - aCam->getY() )) + itofix((aCam)->getScreenCenterY());

	textprintf_ex(aDst, font, fixtoi(x) - (text_length(font, iString) / 2), fixtoi(y), iColor, -1, "%s", iString);
}



//virtual void update();
//virtual void draw(BITMAP *aDst, T2DCam *aCam);
//protected:
TMessage::TMessage(GmMain *aParent): GmTask(aParent){
	iColW = 0;
	iColH = 0;
	iX = itofix(0);
	iY = itofix(0);
	for(int i = 0; i < TMESSAGE_STRING_LENGTH; i++){
		iString[i] = '\0';
	}
	iLength = 0;
	iAge = 0;
	iDelay = 0;
	iColor = makecol(192,192,128);
	this->setPriority(EPriorityExLow);
}



