#include "TBackground.h"

//public:
//virtual 

int TBackground::initializeE(){
	iVtxNum = T2DPoly_VTX_NUM;
	for(int i = 0; i < T2DPoly_VTX_NUM*2; i++){
		iVtx[i] = i * 7 * (-1 + ((i<<1) & 0x02));
	}
	return ERROR_NONE;
}


//virtual 
TBackground::~TBackground(){
}


//virtual 
void TBackground::update(){
	iAge++;
	for(int i = 0; i < T2DPoly_VTX_NUM*2; i++){
		iVtx[i] += ((i & 0x07) + 1) * (-1 + ((i<<1) & 0x02));
		//iVtx[i] = (iVtx[i] * iVtx[i] / 16)  * (-1 + ((i<<1) & 0x02));
		if(iVtx[i] < -400 || 400 < iVtx[i]){
			iVtx[i] = ((iAge & 0x0f) + 1) * (-1 + ((i<<1) & 0x02));
		}
	}
	iAngle += 1 << 15;
}

//virtual 
void TBackground::draw(BITMAP *aDst, T2DCam *aCam){
	int col = makecol(80, 80, 80);
	int baseX = (aDst->w / 2);
	int baseY = (aDst->h / 2);
	fixed xA1, yA1, xA2, yA2;
	int xB1, yB1, xB2, yB2;
	for(int i = 0; i < T2DPoly_VTX_NUM*2; i++){
		xA1 = itofix(iVtx[i]);
		yA1 = itofix(-(aDst->h));
		xA2 = itofix(iVtx[i]);
		yA2 = itofix(aDst->h);

		xB1 = fixtoi( fixmul(fixcos(iAngle), xA1) - fixmul(fixsin(iAngle), yA1) );
		yB1 = fixtoi( fixmul(fixsin(iAngle), xA1) + fixmul(fixcos(iAngle), yA1) );
		xB2 = fixtoi( fixmul(fixcos(iAngle), xA2) - fixmul(fixsin(iAngle), yA2) );
		yB2 = fixtoi( fixmul(fixsin(iAngle), xA2) + fixmul(fixcos(iAngle), yA2) );
		
		fastline(aDst, baseX + xB1, baseY + yB1, baseX + xB2, baseY + yB2, col);
	}
}

//protected:
TBackground::TBackground(GmMain *aParent): T2DPoly(aParent){
	this->setPriority(GmTask::EPriorityHigh);
	iColW = itofix(0);
	iColH = itofix(0);
	iX = itofix(0);
	iY = itofix(0);
	iAge = 0;
}



