#include "T2DPoly.h"
#include "T2DCam.h"


T2DPoly::T2DPoly(GmMain *aParent) : GmTask(aParent){
	this->setPriority(GmTask::EPriorityStandard);
	iParent = aParent;
	iX = itofix(0);
	iY = itofix(0);

	for(int i = 0; i < T2DPoly_VTX_NUM*2; i++){
		iVtx[i] = itofix(0);
	}
	iVtxNum = 0;

	iAngle = itofix(0);
	iScale = itofix(1);
	iColor = makecol(255,255,255);
	iSpeed = itofix(0);
	iPolyType = POLYTYPE(LINE);
}

//public virtual 
int T2DPoly::initializeE(){
#if 0 //:E̞`.
	iVtxNum = 4;
	iVtx[0] = itofix(20);
	iVtx[1] = itofix(0);

	iVtx[2] = itofix(-20);
	iVtx[3] = itofix(-16);

	iVtx[4] = itofix(-10);
	iVtx[5] = itofix(0);

	iVtx[6] = itofix(-20);
	iVtx[7] = itofix(16);
#endif
	return ERROR_NONE;
}


//public virtual
T2DPoly::~T2DPoly(){
}

void T2DPoly::update(){
	iX += fixmul(fixcos(iAngle), iSpeed);
	iY += fixmul(fixsin(iAngle), iSpeed);

	//TCYĂƁ[ɔf.
	iColW = fixmul(itofix(32), iScale);
	iColH = iColW;
}


//ē\łȂȂ邯Ǎ͖Ȃ炢[...
static int vtx[T2DPoly_VTX_NUM*2];
static fixed scale;
//public
void T2DPoly::draw(BITMAP *aDst, T2DCam *aCam){
	if(iVtxNum == 0){
		return;
	}

	fixed aCamScale = aCam->getScale();
	fixed aCamAngle = aCam->getAngle();

	//draw
	if(aCamScale == itofix(1)){
		scale = iScale;
	}else{
		scale = fixmul(iScale, aCamScale);
	}

	fixed x;
	fixed y;
	for(int i = 0; i < iVtxNum; i++){
		//_],gk.
		//x          =         fixmul(iScale,           fixmul(fixcos(iAngle),    iVtx[i*2]) - fixmul(fixsin(iAngle),    iVtx[i*2+1])) + (iX - aCam->getX());
		//y          =         fixmul(iScale,           fixmul(fixsin(iAngle),    iVtx[i*2]) + fixmul(fixcos(iAngle),    iVtx[i*2+1])) + (iY - aCam->getY());
		x          =         fixmul(iScale,           fixmul(fixcos(iAngle),    iVtx[i<<1]) - fixmul(fixsin(iAngle),    iVtx[(i<<1)+1])) + (iX - aCam->getX());
		y          =         fixmul(iScale,           fixmul(fixsin(iAngle),    iVtx[i<<1]) + fixmul(fixcos(iAngle),    iVtx[(i<<1)+1])) + (iY - aCam->getY());
		//J̕],gk.
//		vtx[i*2  ] = fixtoi( fixmul(aCam->getScale(), fixmul(fixcos(aCamAngle), x        ) - fixmul(fixsin(aCamAngle), y          ))) + aCam->getX();
//		vtx[i*2+1] = fixtoi( fixmul(aCam->getScale(), fixmul(fixsin(aCamAngle), x        ) + fixmul(fixcos(aCamAngle), y          ))) + aCam->getY();
//		vtx[i*2  ] = fixtoi( fixmul(aCam->getScale(), fixmul(fixcos(aCamAngle), x        ) - fixmul(fixsin(aCamAngle), y          ))) + aCam->getScreenCenterX();
//		vtx[i*2+1] = fixtoi( fixmul(aCam->getScale(), fixmul(fixsin(aCamAngle), x        ) + fixmul(fixcos(aCamAngle), y          ))) + aCam->getScreenCenterY();
		vtx[(i<<1)  ] = fixtoi( fixmul(aCam->getScale(), fixmul(fixcos(aCamAngle), x        ) - fixmul(fixsin(aCamAngle), y          ))) + aCam->getScreenCenterX();
		vtx[(i<<1)+1] = fixtoi( fixmul(aCam->getScale(), fixmul(fixsin(aCamAngle), x        ) + fixmul(fixcos(aCamAngle), y          ))) + aCam->getScreenCenterY();
	}
	if(iPolyType == POLYTYPE(FILL)){
		polygon(aDst, iVtxNum, vtx, iColor);
	}else{ //LINE
		fastline(aDst, vtx[0], vtx[1], vtx[(iVtxNum-1)*2], vtx[(iVtxNum-1)*2+1], iColor);
		//for(int i = 0; i < iVtxNum-1; i++){
		//	fastline(aDst, vtx[i*2], vtx[i*2+1], vtx[(i+1)*2], vtx[(i+1)*2+1], iColor);
		//}
		for(int i = 0; i < iVtxNum-1; i++){
			fastline(aDst, vtx[i<<1], vtx[(i<<1)+1], vtx[(i+1)<<1], vtx[((i+1)<<1)+1], iColor);
		}
	}
}
