#include "GmTask.h"
#include "GmEntry.h"
#include "T2DPoly.h"
#include "T2DCam.h"

#if _DEBUG
 //static init
 int GmTask::iTaskNum = 0;
 int GmTask::iTaskMaxNum = 0;
#endif

//public:static
GmTask *GmTask::createN(GmMain *aParent){
	GmTask *self = new GmTask(aParent);
	if(self->initializeE() != ERROR_NONE){
		delete self;
		self = NULL;
	}
	return self;
}

//public:
GmTask::~GmTask(){
	//DONT delete iParent!!
	iParent = NULL;
	iCurrentSprite = NULL;
#if _DEBUG
	GmTask::iTaskNum--;
#endif
}

//public:virtual
//t[1Ă΂֐.
void GmTask::update(){
}


//protected:
GmTask::GmTask(GmMain *aParent){
	iParent = aParent;
	iCurrentSprite = NULL;
	iX = itofix(320);
	iY = itofix(240);
	iDeleteFlag = FALSE;
	this->setPriority(GmTask::EPriorityStandard);
	iColW = itofix(0);
	iColH = itofix(0);
	iAngle = itofix(0);
	iScale = itofix(1);
	iLinkNext = NULL;
	iLinkPrev = NULL;

#if _DEBUG
	GmTask::iTaskNum++;
	if(GmTask::iTaskNum > GmTask::iTaskMaxNum){
		GmTask::iTaskMaxNum++;
	}
#endif
}

//protected:virtual
int GmTask::initializeE(){
	return ERROR_NONE;
}

//virtual
void GmTask::draw(BITMAP* aDst, T2DCam* aCam){
	if(!iCurrentSprite
	|| !aDst
	|| !aCam){
		return;
	}
	fixed x;
	fixed y;
	
	//J̕],gk.
	x =  fixmul(aCam->getScale(), fixmul(fixcos(aCam->getAngle()), iX - aCam->getX() ) - fixmul(fixsin(aCam->getAngle()), iY - aCam->getY() )) + itofix((aCam)->getScreenCenterX());
	y =  fixmul(aCam->getScale(), fixmul(fixsin(aCam->getAngle()), iX - aCam->getX() ) + fixmul(fixcos(aCam->getAngle()), iY - aCam->getY() )) + itofix((aCam)->getScreenCenterY());
	if(iAngle + aCam->getAngle() == 0){
		//]Ȃ.
		if(fixmul(iScale, aCam->getScale()) == itofix(1)){
			//gkȂ.
			draw_sprite(aDst, iCurrentSprite, fixtoi(x) - (iCurrentSprite->w >> 1), fixtoi(y) - (iCurrentSprite->h >> 1));
			return;
		}else{
			//gk.
			
		}
	
	}
	pivot_scaled_sprite(aDst, iCurrentSprite, fixtoi(x), fixtoi(y), iCurrentSprite->w >> 1, iCurrentSprite->h >> 1, iAngle + aCam->getAngle(), fixmul(iScale, aCam->getScale()));
	//pivot_sprite(dst, iCurrentBitmap, x, y, iCurrentBitmap->w >> 1, iCurrentBitmap->h >> 1, iAngle);	
}

fixed GmTask::getDrawingX(T2DCam* aCam){
	return fixmul(aCam->getScale(), fixmul(fixcos(aCam->getAngle()), iX - aCam->getX() ) - fixmul(fixsin(aCam->getAngle()), iY - aCam->getY() )) + itofix((aCam)->getScreenCenterX());
}
fixed GmTask::getDrawingY(T2DCam* aCam){
	return fixmul(aCam->getScale(), fixmul(fixsin(aCam->getAngle()), iX - aCam->getX() ) + fixmul(fixcos(aCam->getAngle()), iY - aCam->getY() )) + itofix((aCam)->getScreenCenterY());
}
