// GmSound.h
// TEh̍ĐǗƃ[U͂̎t.
#ifndef _GMSOUND_HEAD_
#define _GMSOUND_HEAD_

#include "WrappedSample.h"
#include "YMod.h"
#include "WrappedSample.h"

//Volumeɐݒ\ȍőEŏƂ܂Ȃ̒l.
#define VOL_MAX 255
#define VOL_MIN 0
#define VOL_MID 128

//Panɐݒ\ȍőEŏEԒl. ԂŃZ^[o܂.
#define PAN_MAX 0
#define PAN_MIN 255
#define PAN_MID 128

//Frequencyɐݒ\ȍőEŏEԒl. ԒlƂ̃Tv̑x.
#define FREQ_MAX (2000)
#define FREQ_MIN (500)
#define FREQ_MID (1000)
#define LOG10FREQ_MAX ((double)3.30102999566398)
#define LOG10FREQ_MIN ((double)2.69897000433602)
#define LOG10FREQ_MID ((double)3.00000000000000)
#define LOG10FREQ_STEP ((double)0.02508583297200) 


#define REG255_VOL(aToySound) ((aToySound)->iVol)

#define REG255_PAN(aToySound) ((aToySound)->iPan)
#define REG255_FREQ(aToySound) (((aToySound)->iFreq - FREQ_MIN) * 255 / (FREQ_MAX - FREQ_MIN))

#define REG1000_VOL(aToySound) (((aToySound)->iVol) * 1000 / VOL_MAX)
#define REG1000_PAN(aToySound) (((aToySound)->iPan) * 1000 / PAN_MAX)
#define REG1000_FREQ(aToySound) (((aToySound)->iFreq - FREQ_MIN) * 1000 / (FREQ_MAX - FREQ_MIN))

#define REG1000_LOG10FREQ(aToySound) (((aToySound)->iLog10Freq - LOG10FREQ_MIN) * 1000 / (LOG10FREQ_MAX - LOG10FREQ_MIN))
#define REG1000_LOG10FREQSNAP(aToySound) (((aToySound)->iLog10FreqSnap - LOG10FREQ_MIN) * 1000 / (LOG10FREQ_MAX - LOG10FREQ_MIN))


typedef struct ToySound{
	int iVol;
	int iPan;
	int iFreq;
	double iLog10Freq;
	double iLog10FreqSnap;
	//ZԂŉʂutF[hAEgv@\iMuteŐ䂵Ă܂.
	int iMute;
	//ꎞIɑx傫@\hold()ƌĂł܂.
	int iHold;
	//X^[gςȂnopɂ邽߂̃tO.
	int iRestartFlag;
	//ꎞIȑx
	int iAdditionalFreq;
//	int iAdditionalFreqLog10;
	WrappedSample *iSound;
} ToySound;

#define ToySoundNum 11

class GmSound{
public:
	static GmSound *createN();
	~GmSound();
	void update();

	ToySound *getToySoundN(int aIndex);
	void receiveMessage(char *aData);

	//CfbNXw肵ToySound𑀍BcreateɐĂȂCfbNX͒Pɖ܂.
	void adjustToySound(int aIndex, int aLoop = 0);
	int playToySoundE(int aIndex, int aLoop = 0);
	void stopToySound(int aIndex);
	void stopAll();
private:
	GmSound();
	int constructE();

	//CfbNXw肵ToySound𑀍BcreateɐĂȂCfbNX͒Pɖ܂.
	int createToySoundE(int aIndex, char *aSampleFileName);
	int changeToySoundE(int aIndex, char *aFileName);
	void destroyToySound(int aIndex);
//	void holdToySound(int aIndex);
//	void restartToySound(int aIndex);
private:
	ToySound *iToySound[ToySoundNum];
	static char iMappedKey[ToySoundNum];
};

#endif //_GMSOUND_HEAD_
