// GmMain.cpp
// C[v܂킵܂.
#include "GmMain.h"
#include "GmEntry.h"
#include "T2DCam.h"
#include "TStage.h"
//#include "UserWindow.h"

extern Settings *GE_settings;

//private static
GmMain* GmMain::currentGmMain = NULL;

//public: static:
GmMain *GmMain::createN(GmMain *aParent){
	GmMain *self = new GmMain(aParent);
	if(self->initializeE() != ERROR_NONE){
		delete self;
		self = NULL;
	}
	GmMain::currentGmMain = self;
	return self;
}

//private:
GmMain::GmMain(GmMain *aParent):
	iGmGfx(NULL),
	iGmSound(NULL),
	iGmInput(NULL),
	//iStringReceiver(NULL),
	iLoopCount(0),
	iGmTaskNum(0),
	iNoah(NULL),
	iGmTaskTop(NULL),
	iT2DCam(NULL) {
	iParent = aParent;
}

//private
int GmMain::initializeE(){
	int ret;

	set_window_title("˕");

	RETURN_IF_NEGATIVE(ret, install_keyboard());

	RETURN_ERROR_IF_NULL(iGmGfx, GmGfx::createN());

	RETURN_ERROR_IF_NULL(iGmSound, GmSound::createN());

	RETURN_ERROR_IF_NULL(iGmInput, GmInput::createN());

//͎gȂ.
//	RETURN_ERROR_IF_NULL(iStringReceiver, StringReceiver::createN());

	GmTask *t = NULL;//temp

	//J͊Ԉč폜Ƃ܂̂ChildƂ͕ʂɊǗ.Ƃɂ悤..
	RETURN_ERROR_IF_NULL(t, T2DCam::createN(this));
	iT2DCam = dynamic_cast<T2DCam *>(t);
	t = NULL;

	//Q[̃C^XN𐶐.
	RETURN_ERROR_IF_NULL(t, TStage::createN(this));
	if(addChildE(t) != ERROR_NONE){
		delete t;
		return ERROR_GENERAL;
	}
	t = NULL;

	return ERROR_NONE;
}

//public
GmMain::~GmMain(){
	GmTask* t;
	while(iGmTaskTop){
		t = iGmTaskTop;
		removeChildE(t);
		delete t;
	}
	delete iT2DCam;
	iT2DCam = NULL;
	delete iGmSound;
	iGmSound = NULL;
	delete iGmGfx;
	iGmGfx = NULL;
	delete iGmInput;
	iGmInput = NULL;
	//delete iStringReceiver;
	//iStringReceiver = NULL;
	//̑̏I(mouseƂkeyboardƂ)allegroIɂĂ邻łBLł.
}

//public
//C[v.
void GmMain::update(){
#if _DEBUG
	int fDump = FALSE;
#endif
	RELEASE_PRINT1("start mainloop @ %d\n", GE_getCurrentTime());
	while(!GE_getExitFlag()){

		cleanupChild();
		updateChild();
		iT2DCam->update();
		drawChild();
		checkChildCollision();

		iGmGfx->update();//t[܂ł̃EGCg܂. łd.
		iGmSound->update();
		iGmInput->update();

		if(iNoah){
			flood();
		}
		if(key[KEY_ESC]){
			break;
		}

#if _DEBUG
		if(!fDump 
		&& (GE_settings->score > 30000)){
			//Nŏ30000_𒴂ƂɏԂo͂.
			fDump = TRUE;
			dumpChild();
		}
#endif
		yield_timeslice();

		iLoopCount++;
	}
	RELEASE_PRINT1("exit mainloop @ %d\n", GE_getCurrentTime());
	return;
}

void GmMain::updateChild(){
	GmTask *t;
	for(t = iGmTaskTop; t /* != NULL*/; t = t->getLinkNext()){
		t->update();
	}
}
void GmMain::drawChild(){
	GmTask *t;
	for(t = iGmTaskTop; t /* != NULL*/; t = t->getLinkNext()){
		t->draw(iGmGfx->getBackBuffer(), iT2DCam);
	}
}


int GmMain::addChildE(GmTask *aGmTask){
	if(!aGmTask){
		return ERROR_NULL;
	}
	if(GM_STUFF_MAX <= iGmTaskNum){
		//^XN.
		return ERROR_NO_RESOURCES;
	}

	if(iGmTaskTop == NULL){
		//ŏ1ڂ̏ꍇ.
		iGmTaskTop = aGmTask;
		iGmTaskTop->setLinkPrev(NULL);
		iGmTaskTop->setLinkNext(NULL);
		iGmTaskNum++;
		return ERROR_NONE;
	}

	GmTask *t;
	for(t = iGmTaskTop; t /* != NULL*/ ; t = t->getLinkNext()){
		if(t->getPriority() <= aGmTask->getPriority()){
			//t->prev  t ̊ԂaGmTaskreturn.
			insert(t->getLinkPrev(), aGmTask, t);

			//prev==NULLȂ킿擪ɒǉꍇAiGmTaskTop̎wΏۂς.
			if(!aGmTask->getLinkPrev()){
				iGmTaskTop = aGmTask;
			}
			break;
		}else if(!(t->getLinkNext())){
			// t > aGmTaskAŌɒBꍇ.
			insert(t, aGmTask, NULL);
			break;
		}
	}
	
	if(!t){
		//ɓ邱Ƃ͖nY...
		allegro_message("!!!UNEXPECTED STATUS!!!@addChildE");
		RELEASE_PRINT0("!!!UNEXPECTED STATUS!!!@addChildE\n");
		return ERROR_GENERAL;
	}
	iGmTaskNum++;
	return ERROR_NONE;
}


// A-B-C̏ɕׂ܂.B͕K{AA,CNULLł.
void GmMain::insert(GmTask* aA, GmTask* aB, GmTask* aC){
	if(!aB){
		return;
	}

	if(aA){
		aA->setLinkNext(aB);
	}
	aB->setLinkPrev(aA);
	aB->setLinkNext(aC);
	if(aC){
		aC->setLinkPrev(aB);
	}
}



//DeleteFlag̗Task폜.
void GmMain::cleanupChild(){
	GmTask *t;
	GmTask *tempLinkNext;
	for(t = iGmTaskTop; t /* != NULL*/;){
		//폜ONextƂĂ.
		tempLinkNext = t->getLinkNext();
		if(t->getDeleteFlag()){
			removeChildE(t);
			delete t;
			t = NULL;
			if(!iGmTaskTop){
				//ChildTaskȂꍇ.
				break;
			}
		}
		t = tempLinkNext;
	}
}

//wTaskǗO.
int GmMain::removeChildE(GmTask *aGmTask){
	if(!aGmTask || !iGmTaskTop){
		return ERROR_NULL;
	}
	GmTask *t;
	for(t = iGmTaskTop; t /* !- NULL */; t = t->getLinkNext()){
		if(t == aGmTask){
			if(!t->getLinkNext() && !t->getLinkPrev()){
				//Ō1removeꍇ.
				iGmTaskTop = NULL;
			}else{
				if(t->getLinkPrev()){
					t->getLinkPrev()->setLinkNext(t->getLinkNext());
				}else{
					//prev==NULL,Ȃ킿擪^XN폜.Ȃ̂2Ԗڂ̃^XN擪ɂ.
					iGmTaskTop = t->getLinkNext();
				}
				if(t->getLinkNext()){
					t->getLinkNext()->setLinkPrev(t->getLinkPrev());
				}
			}
			//delete t;
			t = NULL;
			iGmTaskNum--;
			return ERROR_NONE;
		}
	}
	return ERROR_NOT_EXISTS;
}

void GmMain::checkChildCollision(){
	GmTask *t;
	GmTask *t2;
	for(t = iGmTaskTop; t /* != NULL */; t = t->getLinkNext()){
		for(t2 = t->getLinkNext(); t2 /* != NULL */; t2 = t2->getLinkNext()){
			if( t->getColW() && t->getColH() && t2->getColW() && t2->getColH()
			  &&(abs(t->getX() - t2->getX()) < ((t->getColW() + t2->getColW())>>1) )
			  &&(abs(t->getY() - t2->getY()) < ((t->getColH() + t2->getColH())>>1) ) ){
				t->notifyCollision(t2);
				t2->notifyCollision(t);
			}
		}
	}
	return;
}



//Ɏw肵̈ȊÔׂĂ폜.^̃C[W.
void GmMain::requestFlood(GmTask *aNoah){
	iNoah = aNoah;
}

//private
void GmMain::flood(){
	if(!iNoah){
		return;
	}
	int noahExists = FALSE;
	GmTask *t;

	//iNoahȊȎSĂsetDelete()
	for(t = iGmTaskTop; t /* != NULL */; t = t->getLinkNext()){
		if(t == iNoah){
			noahExists = TRUE;
		}else{
			t->setDelete();
		}
	}
	//setDelete()̂ۂɍ폜.
	cleanupChild();

	//childiNoahȂꍇǉĂ.sv.
	if(!noahExists){
		addChildE(iNoah);
	}
	iNoah = NULL;
}

//w̌^̃^XNTāAŏɌ̂Ԃ܂.
GmTask *GmMain::getGmTaskByTypeN(const type_info &aType){
	GmTask *t;
	for(t = iGmTaskTop; t /* != NULL */; t = t->getLinkNext()){
		if(typeid(*t) == aType){
			//.
			return t;
		}
	}
	//Ȃ.
	return NULL;
}


//child̏Ԃo͂
void GmMain::dumpChild(){
	GmTask *t;
	DEBUG_PRINT1("%d childs{\n", iGmTaskNum);
	for(t = iGmTaskTop; t /* != NULL */; t = t->getLinkNext()){
		DEBUG_PRINT6("addr(%8x), Pri(%4d), xy(%8d,%8d), colWH(%8d,%8d)", t, t->getPriority(), t->getX(), t->getY(), t->getColW(), t->getColH());
		DEBUG_PRINT1("name:%s\n", typeid(t).name());
	}
	DEBUG_PRINT1("%d childs}\n", iGmTaskNum);
}
