// GmInput.h
// [U͂Ǘ܂.
#include "GmEntry.h"
#include "GmInput.h"

extern Settings *GE_settings;

static int GI_char_to_allegro_key(char aKey){
	switch(aKey){
	case '0':  return KEY_0;
	case '1':  return KEY_1;
	case '2':  return KEY_2;
	case '3':  return KEY_3;
	case '4':  return KEY_4;
	case '5':  return KEY_5;
	case '6':  return KEY_6;
	case '7':  return KEY_7;
	case '8':  return KEY_8;
	case '9':  return KEY_9;

	case 'A':  return KEY_A;
	case 'B':  return KEY_B;
	case 'C':  return KEY_C;
	case 'D':  return KEY_D;
	case 'E':  return KEY_E;
	case 'F':  return KEY_F;
	case 'G':  return KEY_G;
	case 'H':  return KEY_H;
	case 'I':  return KEY_I;
	case 'J':  return KEY_J;
	case 'K':  return KEY_K;
	case 'L':  return KEY_L;
	case 'M':  return KEY_M;
	case 'N':  return KEY_N;
	case 'O':  return KEY_O;
	case 'P':  return KEY_P;
	case 'Q':  return KEY_Q;
	case 'R':  return KEY_R;
	case 'S':  return KEY_S;
	case 'T':  return KEY_T;
	case 'U':  return KEY_U;
	case 'V':  return KEY_V;
	case 'W':  return KEY_W;
	case 'X':  return KEY_X;
	case 'Y':  return KEY_Y;
	case 'Z':  return KEY_Z;
	}
	return KEY_NAN;
}



//public:static 
GmInput *GmInput::createN(){
	GmInput *self = new GmInput();
	if(self->initializeE() != ERROR_NONE){
		delete self;
		self = NULL;
	}
	return self;
}

//public:
GmInput::~GmInput(){
	//AllegroĂ邩svۂ.
	//remove_joystick();
	delete iLog;
}

//public:
void GmInput::setListener(KeyListener *aKeyListener){
	iKeyListener = aKeyListener;
	for(int j = 0; j < GI_KEY_NUM; j++){
		iBindedKeyStatus[j] = 0;
	}

	if(iLog && !(iLog->isLogging())){
		iLog->setListener(aKeyListener);
	}
}

//public:
void GmInput::releaseListener(KeyListener *aKeyListener){
	if(iKeyListener != aKeyListener){
		return;
	}
	iKeyListener = NULL;

	if(iLog && !(iLog->isLogging())){
		iLog->releaseListener(aKeyListener);
	}
}


//OJn.
//L^̓ftHgt@Cĝő2͍ƂӖȂ.
//Đ͈̃t@CŃf[^ǂ݂܂.
int GmInput::startLog(int aMode, char* aFileName){
	int ret = ERROR_NONE;
	if(iLog){
		delete iLog;
		iLog = NULL;
	}
	if(aMode == LOGMODE_WRITE){
		//L^Jn.
		iLog = GmKeyLogger::createN();
	}else /* LOGMODE_PLAY */{
		//ĐJn.
		iLog = GmKeyLogger::createN(aFileName);
	}
	if(!iLog){
		ret = ERROR_GENERAL;
	}
	return ret;
}

//OI.
//L^̓t@Cw肵ďoƂł܂.
//t@Cw肵ȂƕۑȂ̂Œ.
int GmInput::endLog(){
	if(!iLog){
		return ERROR_NOT_EXISTS;
	}
	int ret = ERROR_NONE;
	if((iLog->isLogging())){
		//L^I.ۑ͕ʊ֐ɂ.
		//if(aFileName){
		//	ret = iLog->writeToFile(aFileName);
		//}
	}else{
		//ĐI.
		//Ƃɂ邱Ƃ͂Ȃ͂.
	}
	delete iLog;
	iLog = NULL;
	return ret;
}
int GmInput::saveLog(char* aFileName){
	if(iLog && aFileName){
		return iLog->writeToFileE(aFileName);
	}
	return ERROR_NOT_EXISTS;
}


//public:
void GmInput::update(){
	int i, j;

	//mouse&keyboardXV(ōXVȂ炵Ĥpoll modeɂĂ).
	//}EXԍXV.
	if(iMouseEnabled){
		poll_mouse();
		iMouseX = mouse_x;
		iMouseY = mouse_y;
		iMouseBtn = mouse_b;
		//FPSnȂ}EXW𒆉ɃZbg邩.
		if(GE_settings->freeCamera){
			position_mouse(SCREEN_W >> 1, SCREEN_H>>1);
		}
	}

	if(iJoystickEnabled){
		poll_joystick();
	}

	poll_keyboard();

	if(iLog && !(iLog->isLogging())){
		//iLog݂AL^ł͂Ȃ(==Đ).
		//̏ꍇ,Xiւ̒ʒmiLogiLog->updateōs.
	}else{
		//iLog݂ȂA܂͋L^.
		updateRealDevice();
	}

	if(iLog){
		iLog->update();
	}
}

void GmInput::updateRealDevice(){
	int i,j;

	for(i = 0; i < iBindedKeyNum; i++){

		//L[ԂAllegro擾čXV.
		int prevKeyStatus = iBindedKeyStatus[i];
		iBindedKeyStatus[i] = FALSE;
		for(j = 0; j < GI_KEY_ARRAY_NUM; j++){

			switch(iBindedKey[j][i]){
			//}EX{^.
			case KEY_MOUSE_LBUTTON:
				iBindedKeyStatus[i] |= (iMouseBtn & 1);
				//if(iMouseBtn & 1){
				//	iBindedKeyStatus[i] = TRUE;
				//}
				break;
			case KEY_MOUSE_RBUTTON:
				iBindedKeyStatus[i] |= (iMouseBtn & 2);
				//if(iMouseBtn & 2){
				//	iBindedKeyStatus[i] = TRUE;
				//}
				break;
			case KEY_MOUSE_MIDBUTTON: 
				iBindedKeyStatus[i] |= (iMouseBtn & 4);
				//if(iMouseBtn & 4){
				//	iBindedKeyStatus[i] = TRUE;
				//}
				break;

			//WCXeBbN.
			case KEY_JOY_UP:
				iBindedKeyStatus[i] |= *iJoyUp;
				//if(*iJoyUp){
				//	iBindedKeyStatus[i] = TRUE;
				//}
				break;
			case KEY_JOY_DOWN:
				iBindedKeyStatus[i] |= *iJoyDown;
				//if(*iJoyDown){
				//	iBindedKeyStatus[i] = TRUE;
				//}
				break;
			case KEY_JOY_LEFT:
				iBindedKeyStatus[i] |= *iJoyLeft;
				//if(*iJoyLeft){
				//	iBindedKeyStatus[i] = TRUE;
				//}
				break;
			case KEY_JOY_RIGHT:
				iBindedKeyStatus[i] |= *iJoyRight;
				//if(*iJoyRight){
				//	iBindedKeyStatus[i] = TRUE;
				//}
				break;
			case KEY_JOY_BUTTON1:
				iBindedKeyStatus[i] |= *iJoyButton1;
				//if(*iJoyButton1){
				//	iBindedKeyStatus[i] = TRUE;
				//}
				break;
			case KEY_JOY_BUTTON2:
				iBindedKeyStatus[i] |= *iJoyButton2;
				//if(*iJoyButton2){
				//	iBindedKeyStatus[i] = TRUE;
				//}
				break;
			case KEY_JOY_BUTTON3:
				iBindedKeyStatus[i] |= *iJoyButton3;
				//if(*iJoyButton3){
				//	iBindedKeyStatus[i] = TRUE;
				//}
				break;
			case KEY_JOY_BUTTON4:
				iBindedKeyStatus[i] |= *iJoyButton4;
				//if(*iJoyButton4){
				//	iBindedKeyStatus[i] = TRUE;
				//}
				break;

			case KEY_NAN:
				//蓖ăL[Ȃ.
				break;
			default:
				//}EXȊÕL[.
				iBindedKeyStatus[i] |= key[iBindedKey[j][i]];
				break;
			}//end switch
		}
		
		//0Ԃ̃L[R[hŃXiɒʒm.
		if(iKeyListener){
			//if((prevKeyStatus) & !(iBindedKeyStatus[i])){
			if((prevKeyStatus) && !(iBindedKeyStatus[i])){
				//Ƃ.
				iKeyListener->keyReleased(iBindedKey[0][i]);
				if(iLog){
					iLog->keyReleased(iBindedKey[0][i]);
				}
			//}else if(!(prevKeyStatus) & (iBindedKeyStatus[i])){
			}else if(!(prevKeyStatus) && (iBindedKeyStatus[i])){
				//Ƃ.
				iKeyListener->keyPressed(iBindedKey[0][i]);
				if(iLog){
					iLog->keyPressed(iBindedKey[0][i]);
				}
			}
		}
	}//next i
}

//private:
GmInput::GmInput():
iMouseEnabled(FALSE),
iMouseX(0),
iMouseY(0),
iMouseBtn(0),
iJoystickEnabled(FALSE),
iBindedKeyNum(0),
iKeyListener(NULL),
iLog(NULL) {
	//܂KEY_NANŃNA.
	for(int i = 0; i < GI_KEY_ARRAY_NUM; i++){
		for(int j = 0; j < GI_KEY_NUM; j++){
			iBindedKey[i][j] = KEY_NAN;
			iBindedKeyStatus[j] = 0;//iJԂ̂͂ƃ_ǂ.
		}
	}
}

//private:
int GmInput::initializeE(){
	int i = 0;
	//ftHgL[`.ێĝ͂܂̂Ƃ7L[ɂĂ݂.
	iBindedKeyNum = 7;
	i = 0;
	iBindedKey[i][0] = KEY_UP;
	iBindedKey[i][1] = KEY_DOWN;
	iBindedKey[i][2] = KEY_LEFT;
	iBindedKey[i][3] = KEY_RIGHT;
	iBindedKey[i][4] = KEY_Z;
	iBindedKey[i][5] = KEY_X;
	iBindedKey[i][6] = KEY_C;

	i = 1;
	iBindedKey[i][0] = KEY_8_PAD;
	iBindedKey[i][1] = KEY_2_PAD;
	iBindedKey[i][2] = KEY_4_PAD;
	iBindedKey[i][3] = KEY_6_PAD;
	iBindedKey[i][4] = KEY_SPACE;
	iBindedKey[i][5] = KEY_NAN;
	iBindedKey[i][6] = KEY_NAN;
	
	i = 2;
	//[U`L[oChǂݍ.
	for(int j = 0; iBindedKeyNum < GI_KEY_NUM; j++){
		iBindedKey[i][j] = GI_char_to_allegro_key(GE_settings->bindedKey[j]);
		if(iBindedKey[i][j] == KEY_NAN){
			break;
		}
	}

	i = 3;
	//FPSƃ}EX̃{^.
	if(install_mouse() >= 0){
		RELEASE_PRINT0("use mouse.\n");
		iMouseEnabled = TRUE;
		iBindedKey[i][0] = KEY_W;
		iBindedKey[i][1] = KEY_S;
		iBindedKey[i][2] = KEY_A;
		iBindedKey[i][3] = KEY_D;
		iBindedKey[i][4] = KEY_MOUSE_LBUTTON;
		iBindedKey[i][5] = KEY_MOUSE_RBUTTON;
		iBindedKey[i][6] = KEY_MOUSE_MIDBUTTON;
	}else{
		RELEASE_PRINT0("failed to install_mouse.\n");
	}

	i = 4;
	//joypadȂǂȂ.TBD.
	if(install_joystick(JOY_TYPE_AUTODETECT) == 0
	&& num_joysticks > 0){
		RELEASE_PRINT1("%d Joystick(s) found.\n", num_joysticks);
		RELEASE_PRINTV(joy[0].flags);
		RELEASE_PRINTV(joy[0].num_buttons);
		RELEASE_PRINTV(joy[0].num_sticks);

		RELEASE_PRINTV_S(joy[0].stick[0].name);
		RELEASE_PRINTV(joy[0].stick[0].num_axis);
		RELEASE_PRINTV(joy[0].stick[0].flags);
		RELEASE_PRINTV_S(joy[0].stick[0].axis[0].name);
		RELEASE_PRINTV_S(joy[0].stick[0].axis[1].name);
		RELEASE_PRINTV_S(joy[0].stick[0].axis[2].name);

		RELEASE_PRINTV_S(joy[0].stick[1].name);
		RELEASE_PRINTV(joy[0].stick[1].num_axis);
		RELEASE_PRINTV(joy[0].stick[1].flags);
		RELEASE_PRINTV_S(joy[0].stick[1].axis[0].name);
		RELEASE_PRINTV_S(joy[0].stick[1].axis[1].name);
		RELEASE_PRINTV_S(joy[0].stick[1].axis[2].name);

		RELEASE_PRINTV_S(joy[0].stick[2].name);
		RELEASE_PRINTV(joy[0].stick[2].num_axis);
		RELEASE_PRINTV(joy[0].stick[2].flags);
		RELEASE_PRINTV_S(joy[0].stick[2].axis[0].name);
		RELEASE_PRINTV_S(joy[0].stick[2].axis[1].name);
		RELEASE_PRINTV_S(joy[0].stick[2].axis[2].name);

		RELEASE_PRINTV_S(joy[0].button[0].name);
		RELEASE_PRINTV(joy[0].button[0].b);
		RELEASE_PRINTV_S(joy[0].button[1].name);
		RELEASE_PRINTV(joy[0].button[1].b);
		RELEASE_PRINTV_S(joy[0].button[2].name);
		RELEASE_PRINTV(joy[0].button[2].b);
		RELEASE_PRINTV_S(joy[0].button[3].name);
		RELEASE_PRINTV(joy[0].button[3].b);
		RELEASE_PRINTV_S(joy[0].button[4].name);
		RELEASE_PRINTV(joy[0].button[4].b);
		RELEASE_PRINTV_S(joy[0].button[5].name);
		RELEASE_PRINTV(joy[0].button[5].b);

		iJoyLeft  = &(joy[0].stick[0].axis[0].d1);
		iJoyRight = &(joy[0].stick[0].axis[0].d2);
		iJoyUp    = &(joy[0].stick[0].axis[1].d1);
		iJoyDown  = &(joy[0].stick[0].axis[1].d2);
		iJoyButton1 = &(joy[0].button[0].b);
		iJoyButton2 = &(joy[0].button[1].b);
		iJoyButton3 = &(joy[0].button[2].b);
		iJoyButton4 = &(joy[0].button[3].b);

		iJoystickEnabled = TRUE;
		iBindedKey[i][0] = KEY_JOY_UP;
		iBindedKey[i][1] = KEY_JOY_DOWN;
		iBindedKey[i][2] = KEY_JOY_LEFT;
		iBindedKey[i][3] = KEY_JOY_RIGHT;
		iBindedKey[i][4] = KEY_JOY_BUTTON1;
		iBindedKey[i][5] = KEY_JOY_BUTTON2;
		iBindedKey[i][6] = KEY_JOY_BUTTON3;
	}else{
		RELEASE_PRINT0("failed to install_joystick.\n");
	}

	return ERROR_NONE;
}






//class GmKeyLogger : public KeyListener{
//public:
//static 
GmKeyLogger* GmKeyLogger::createN(char* aFileName){
	GmKeyLogger* self = new GmKeyLogger();
	if(self->initializeE(aFileName) != ERROR_NONE){
		self = NULL;
	}
	return self;
}

//L^KeyListenerC^[tF[XoRŃL[n.
//virtual 
void GmKeyLogger::keyPressed(int aKeyCode){ 
	putLog(aKeyCode, KEY_PRESSED);
}


//virtual 
void GmKeyLogger::keyReleased(int aKeyCode){ 
	putLog(aKeyCode, KEY_RELEASED);	
}

//private
void GmKeyLogger::putLog(int aKey, int aState){
	if(iListener){
		//Xiꍇ͍ĐȂ̂ŋL^͕s.
		return;
	}
	if(!iLogArray || iLogArrayLength <= iLogCount){
		//̈悪ȂȂ.reallocĎɐi.
		iLogArray = static_cast<GmKeyLogToken*>(realloc(iLogArray, sizeof(GmKeyLogToken) * (iLogArrayLength + ALLOC_BLOCKSIZE)));
		//śHNULLԂȂ`FbNreturn
		iLogArrayLength += ALLOC_BLOCKSIZE;
	}
	//.
	GmKeyLogToken stroke = {iFrameCount, aKey, aState};
	iLogArray[iLogCount] = stroke;
	iFrameCount = 0;
	iLogCount++;
}


//Đ͎tΏۂKeyListenerƂēo^.
void GmKeyLogger::setListener(KeyListener *aKeyListener){
	iListener = aKeyListener;
}

//ĐfɂKeyListener.
void GmKeyLogger::releaseListener(KeyListener *aKeyListener){
	if(aKeyListener == iListener){
		//CloseFile;
		iListener = NULL;
	}
}



//ĐIɕۑ.
int GmKeyLogger::writeToFileE(char* aFileName){
	//writeToFile
	FILE *fp; fopen_s(&fp, aFileName, "w");
	if(fp){
		//Ƃ肠̃t@Cwb_.
		fprintf(fp, KEYLOG_FILEHEADER1, KEYLOG_FILEVERSION);
		fprintf(fp, KEYLOG_FILEHEADER2, iLogCount);
		fprintf(fp, KEYLOG_FILEHEADER3, GE_settings->score);
		fprintf(fp, KEYLOG_FILEHEADER4, iRandSeed);
		fprintf(fp, KEYLOG_FILEHEADER5, GE_settings->level);
		fprintf(fp, KEYLOG_FILEHEADER6, GE_settings->playerType);
		fprintf(fp, KEYLOG_FILEHEADER_FINAL, KEYLOG_FILEVERSION); //o[W2񏑂.
		//eLXgo.
		for(int i = 0; i < iLogCount; i++){
			fprintf(fp, KEYLOG_DATAFORMAT, iLogArray[i].iFrameToWait, iLogArray[i].iKey, iLogArray[i].iState);
		}
		fclose(fp);
		return ERROR_NONE;
	}else{
		return ERROR_GENERAL;
	}
}

//vUpdate.
void GmKeyLogger::update(){
	if(iListener){
		//XiȂĐ.
		//ɑΉ邽FrameToWait!=0ɂȂ܂ŉ.
		while(iLogArray[iLogCount].iFrameToWait <= iFrameCount){
			if(iLogArrayLength <= iLogCount){
				//Đ.
				return;
			}
			if(iLogArray[iLogCount].iState == KEY_PRESSED){
				iListener->keyPressed(iLogArray[iLogCount].iKey);
			}else{
				iListener->keyReleased(iLogArray[iLogCount].iKey);
			}
			iLogCount++;
			iFrameCount = 0;
		}
	}else{
		//XiȂȂL^.
		//Ƃ͂Ăupdateł邱Ƃ͖.
	}
	iFrameCount++;
}

//private:	
GmKeyLogger::GmKeyLogger(){
	iLogCount = NULL;
	iFrameCount = 0;

	iLogArray = NULL;
	iLogArrayLength = 0;

	iListener = NULL;
	iLogging = FALSE;
	iRandSeed = 0;
}
int GmKeyLogger::initializeE(char* aFileName){
	if(!aFileName){
		//L^郂[hŃCX^X𐶐.
		iLogging = TRUE;
		iLogArray = static_cast<GmKeyLogToken*>(realloc(iLogArray, sizeof(GmKeyLogToken) * (iLogArrayLength + ALLOC_BLOCKSIZE)));
		//śHNULLԂȂ`FbNreturn
		iLogArrayLength += ALLOC_BLOCKSIZE;
		//seedĊoĂ.Ōɕۑ̂.
		iRandSeed = GE_rand();
		GE_srand(iRandSeed);
	}else{
		//Đ郂[hŃCX^X𐶐.
		//Ȃ̂Ńt@Cf[^ǂ.
		iLogging = FALSE;
		FILE *fp; fopen_s(&fp, aFileName, "r");
		if(fp){
			int version = 0;
			int length = 0;
			int score = 0;
			int seed = 0;
			int level = 0;
			int type = 0;
			//Ƃ肠̃wb_ǂݍ.
			fscanf_s(fp, KEYLOG_FILEHEADER1, &version);
			fscanf_s(fp, KEYLOG_FILEHEADER2, &length);
			fscanf_s(fp, KEYLOG_FILEHEADER3, &score);
			fscanf_s(fp, KEYLOG_FILEHEADER4, &seed);
			fscanf_s(fp, KEYLOG_FILEHEADER5, &level);
			fscanf_s(fp, KEYLOG_FILEHEADER6, &type);
			fscanf_s(fp, KEYLOG_FILEHEADER_FINAL, &version); //o[W2ǂ.
			if(version != KEYLOG_FILEVERSION
			|| length == 0) {
				fclose(fp);
				return ERROR_NOT_EXISTS;
			}
			GE_srand(seed);
			GE_settings->level = level;
			GE_settings->playerType = type;
			iLogArray = static_cast<GmKeyLogToken*>(realloc(iLogArray, sizeof(GmKeyLogToken) * (length)));
			//śHNULLԂȂ`FbNreturn
			iLogArrayLength = length;
			//f[^{̂̓ǂݍ,
			int ret = 0;
			for(int i = 0; i < length; i++){
				ret = fscanf_s(fp, KEYLOG_DATAFORMAT, &(iLogArray[i].iFrameToWait), &(iLogArray[i].iKey), &(iLogArray[i].iState));
				if(ret == 0 || ret == EOF){
					fclose(fp);
					return ERROR_ARGUMENT;
				}
			}
			//.
			iLogCount = 0;
			fclose(fp);
		}
	}

	return ERROR_NONE;
}

GmKeyLogger::~GmKeyLogger(){
	if(iLogArray){
		free(iLogArray);
		iLogArray = NULL;
	}
}

//int iReadPointer;
//int iReadCount;

//GmKeyLogToken* iLogArray;
//int iLogArrayLength;
//ALLOC_BLOCKSIZE = 1024;



