// GmGfx.cpp
// ʂ̏EXVƃt[̃EGCg.
#include "GmEntry.h"
#include "GmGfx.h"
#include "GmSound.h"
#include "GmMain.h"


extern Settings *GE_settings;

#define iBitCol   (unsigned long(0x00ffffff))
#define iBitR     (unsigned long(0x00ff0000))
#define iBitG     (unsigned long(0x0000ff00))
#define iBitB     (unsigned long(0x000000ff))
#define iBitOverR (unsigned long(0xff000000))
#define iBitOverG (unsigned long(0xffff0000))
#define iBitOverB (unsigned long(0xffffff00))
#define DIRECT_PIXEL32(aBitmap, aX, aY) (((long *)aBitmap->line[aY])[aX])
#define DIRECT_PIXEL16(aBitmap, aX, aY) (((unsigned short *)aBitmap->line[aY])[aX])

//public:static
GmGfx *GmGfx::createN(){
	GmGfx *self = new GmGfx();
	if(self->constructE() != ERROR_NONE){
		delete self;
		self = NULL;
	}
	return self;
}

//private:
GmGfx::GmGfx() :
	iBackBuffer(NULL),
	iBackBuffer2(NULL),
	iSprite(NULL),
	iBackgroundImageA(NULL),
	iBackgroundImageB(NULL),
	iFilterRatio(1),
	iBrightness(0),
	iAge(0),
	iPrevTime(0),
	iBackgroundType(BG_A) {
}

//private: 
int GmGfx::constructE(){
	const int reqColorDepth = 16;
	const int reqRefreshRate = 60;
	int ret;

	//F̊mF.reqColorDepthȏȂOK.
	ret = desktop_color_depth();
	if(ret < reqColorDepth){
		RELEASE_PRINT1("ERROR: desktop_color_depth (%d) \n", ret);
		return ERROR_GENERAL;
	}
	iColorDepth = ret;
	RELEASE_PRINT1("color_depth = %d \n", iColorDepth);
	//Fݒ. 
	set_color_depth(iColorDepth);

	//tbV[gݒ.
	request_refresh_rate(reqRefreshRate);

	//ʃ[hݒ.
	ret = 0;
	//tXN[w̏ꍇ܂tXN[ŏ݂.
	if(!(GE_settings->showAsWindow)){
		ret = set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, GE_settings->screenW, GE_settings->screenH, 0,0);
	}
	//tXN[sE܂̓EChE[hw(ftHg)̏ꍇ.
	if(ret < 0 || GE_settings->showAsWindow){
		ret = set_gfx_mode(GFX_AUTODETECT_WINDOWED, GE_settings->screenW, GE_settings->screenH, 0,0);
		if(ret >= 0){
			ret = set_display_switch_mode(SWITCH_BACKGROUND);
		}
	}
	if(ret < 0){
		return ret;
	}
	iScreenW = SCREEN_W;
	iScreenH = SCREEN_H;
	RELEASE_PRINT2("gfx_mode width = %d, height = %d \n", iScreenW, iScreenH);

	//tbV[g擾.60Ȃvsync҂ŁAȊOȂ^C}ŃEGCgƂ܂.
	iRefreshRate = get_refresh_rate();
	RELEASE_PRINT1("refresh rate = %d \n", iRefreshRate);
	if(iRefreshRate != reqRefreshRate){
		iRefreshRate = 0;
		RELEASE_PRINT0(" (to wait for vsync, set the refresh rate of your Display to 60Hz.)\n");
	}
	iRefreshSpanInMsec = 1000 / 60;

	//obNobt@.
	iBackBuffer = create_bitmap_ex(iColorDepth, (iScreenW + BB_MARGIN*2), (iScreenH + BB_MARGIN*2));
	//iBackBuffer = create_video_bitmap((iScreenW + BB_MARGIN*2), (iScreenH + BB_MARGIN*2));
	if(iBackBuffer == 0){
		return -1;
	}
	iBackBuffer2 = create_bitmap_ex(iColorDepth, (iScreenW + BB_MARGIN*2), (iScreenH + BB_MARGIN*2));
	//iBackBuffer2 = create_video_bitmap((iScreenW + BB_MARGIN*2), (iScreenH + BB_MARGIN*2));
	if(iBackBuffer2 == 0){
		return -1;
	}
	DEBUG_PRINT2("create backBuffer width = %d, height = %d \n", iBackBuffer->w, iBackBuffer->h);
	rectfill(iBackBuffer, 0,0, iBackBuffer->w, iBackBuffer->h, makecol(0,0,0));
	rectfill(iBackBuffer2, 0,0, iBackBuffer->w, iBackBuffer->h, makecol(0,0,0));

	//XvCgǂݍ.
	RGB pal[256];
	BITMAP *fileSprite = load_bitmap("data\\sprite.bmp", NULL);
	if(!fileSprite){
		allegro_message("failed to open bitmap");
		return ERROR_NOT_EXISTS;
	}
//	if(iColorDepth == 8 && bitmap_color_depth(tmpSprite) == 8){
//		set_palette(pal);
//	}
	BITMAP *tmpSprite = NULL;
	RETURN_ERROR_IF_NULL(tmpSprite, create_bitmap_ex(iColorDepth, fileSprite->w, fileSprite->h)); //[N.
	blit(fileSprite, tmpSprite, 0, 0, 0, 0, fileSprite->w, fileSprite->h);

	RETURN_ERROR_IF_NULL(iSprite, create_bitmap_ex(iColorDepth, tmpSprite->w*2, 5*16*2)); //[N.
	stretch_blit(tmpSprite, iSprite, 0,0, iSprite->w/2, iSprite->h/2, 0, 0, iSprite->w, iSprite->h);

	RETURN_ERROR_IF_NULL(iBackgroundImageA, create_bitmap_ex(iColorDepth, 320*2, 240*2)); //[N.
	stretch_blit(tmpSprite, iBackgroundImageA, 0,5*16, iBackgroundImageA->w/2, iBackgroundImageA->h/2, 0, 0, iBackgroundImageA->w, iBackgroundImageA->h);
	RETURN_ERROR_IF_NULL(iBackgroundImageB, create_bitmap_ex(iColorDepth, 320*2, 240*2)); //[N.
	stretch_blit(tmpSprite, iBackgroundImageB, 0,5*16 + 240, iBackgroundImageB->w/2, iBackgroundImageB->h/2, 0, 0, iBackgroundImageB->w, iBackgroundImageB->h);

	destroy_bitmap(tmpSprite);
	destroy_bitmap(fileSprite);
	tmpSprite = NULL;

	//tB^𔽉f.
	if(iColorDepth == 32){
		iFilterRatio = GE_settings->filterRatio;
	}else{
		iFilterRatio = 0;
	}

	iBrightness = 128;

	iPrevTime = GE_getCurrentTime();
	return ERROR_NONE;
}

//public:
GmGfx::~GmGfx(){
	destroy_bitmap(iBackBuffer);
	destroy_bitmap(iBackBuffer2);
	destroy_bitmap(iSprite);
	destroy_bitmap(iBackgroundImageA);
	destroy_bitmap(iBackgroundImageB);
}


//public:
void GmGfx::update(){
	iAge++;

	//KvȂtB^.
	//iFilterRatio = (mouse_x * 8 / this->iScreenW);
	if(iFilterRatio != 0){
		//screenvideoBitmapȂ̂Œx. memoryBitmapiBackBuffer2ɈUo.
		blitRomanticFilter(iBackBuffer, iBackBuffer2, iFilterRatio);
	}

	//screenւ̓]̑OɃ^C~O.
	//܂1t[̏ɂԂdebugo.
	DEBUG_PRINT1("%d\n", GE_getCurrentTime() - iPrevTime);
	if(iPrevTime > GE_getCurrentTime()){
		//Ot[̎̂ق傫Ȃ^C}I[o[t[uԂȂ̂ŁA...߂Ă̎̓m[EGCg.
	}else{
		if(iRefreshRate == 60){
			//tbV[g60Ȃvsync҂.
			if(GE_getCurrentTime() <= iPrevTime + iRefreshSpanInMsec){
				vsync();
				//rest(1);
			}
		}else{
			//tbV[g60ȊȌꍇ̓eLg[Ƀ^C}ő҂.
			//̃Q[60fpsڎŵ(1000/60)16msec҂.
			while(GE_getCurrentTime() < iPrevTime + iRefreshSpanInMsec){
				yield_timeslice();
			}
		}
	}
	iPrevTime = GE_getCurrentTime();

	//\XV
	acquire_screen();
	if(iFilterRatio <= 0){
		blit(iBackBuffer, screen, BB_MARGIN, BB_MARGIN, 0,0, iScreenW,iScreenH);
	}else{
		blit(iBackBuffer2, screen, BB_MARGIN, BB_MARGIN, 0,0, iScreenW,iScreenH);
	}
	release_screen();

	//obNobt@̃NA.
	if(iBackgroundImageA || iBackgroundImageA){
		switch(iBackgroundType){
			case BG_A:
				blit(iBackgroundImageA, iBackBuffer, 0,0, BB_MARGIN,BB_MARGIN, iBackgroundImageA->w, iBackgroundImageA->h);
				break;
			case BG_B:
				blit(iBackgroundImageB, iBackBuffer, 0,0, BB_MARGIN,BB_MARGIN, iBackgroundImageB->w, iBackgroundImageB->h);
				break;
			default:
				rectfill(iBackBuffer, 0,0, iBackBuffer->w, iBackBuffer->h, makecol(iBrightness, iBrightness, iBrightness) );
				break;
		}
	}else{
		rectfill(iBackBuffer, 0,0, iBackBuffer->w, iBackBuffer->h, makecol(iBrightness, iBrightness, iBrightness) );
	}

	return;
}



//#define DIRECT_PIXEL32(aBitmap, aX, aY) (((long *)aBitmap->line[aY])[aX])
#define DIRECT_GETLINE(aBitmap, aY) ((unsigned long *)aBitmap->line[aY])

//ZEZƂRGB܂Ƃ߂Ă؂ɉZ.
#define RGB_PARALLEL 1
//ZRGB܂Ƃ߂ĉZ.ڂ̌덷Ȃ̂ŏLCȂ.
//#define RGB_PARALLEL_ADD 1

//blitBlurScreen2ɉāAڂỎ摜Ƃ̉Z𓯎ɍs. Z̐[x̓CCJQ.
void GmGfx::blitRomanticFilter(register BITMAP *aSrc, register BITMAP *aDst, int aDepth){
	int x,y;
	long depthPix = 1 << aDepth;//Ȃ񂩂̕ӂungied/unsigned ۂH
	unsigned long depthMask = (0x00808080 >> (aDepth-1)) - 0x00010101;
	int endY = aDst->h;
	int endX = aDst->w - (depthPix>>1);
	if(endX <= depthPix || endY <= depthPix){
		return;
	}

	unsigned long *curLine; //].
	unsigned long *dst;     //].
	unsigned long curCol;   //ڂr̐F.
	unsigned long curR = 0;
	unsigned long curG = 0;
	unsigned long curB = 0;
	unsigned long a1;       //e|.
	for(y = 0; y != endY; y++){
		curLine = DIRECT_GETLINE(aSrc, y);
		dst = DIRECT_GETLINE(aDst, y) + (depthPix>>1);
#if RGB_PARALLEL
		//܂ԍ̃sNZڂ̒lo.
		curCol = 0;
		for(int i = 0; i < depthPix; i++){
			curCol += ((*(curLine + i)) >> aDepth) & depthMask;
		}
#else
		curR = 0;
		curG = 0;
		curB = 0;
		for(int i = 0; i < depthPix; i++){
			curR += (*(curLine + i) & iBitR) >> (16 + aDepth);
			curG += (*(curLine + i) & iBitG) >> (8 + aDepth);
			curB += (*(curLine + i) & iBitB) >> aDepth;
		}
		curR = (curR << 16) & iBitR;
		curG = (curG <<  8) & iBitG;
		curB = (curB      ) & iBitB;
		curCol = (curR | curG | curB);
#endif
		curLine += depthPix >> 1;
		for(x = depthPix>>1; x != endX; x++){
#if RGB_PARALLEL | RGB_PARALLEL_ADD
			//curColsrc1:2ŖOaZďo.
			a1 = ((curCol & 0x00fefeff) + (((*curLine) & 0x00fcfcff)>>1));
			*dst = a1 | ((a1 & 0x01010100) - ((a1 & 0x01010100)>>8));
#else
			curR = (((curCol & iBitR)<<1) + ((*curLine) & iBitR)) >> 1;
			if(curR & iBitOverR){ curR = iBitR; } else { curR = curR & iBitR; }
			curG = (((curCol & iBitG)<<1) + ((*curLine) & iBitG)) >> 1;
			if(curG & iBitOverG){ curG = iBitG; } else { curG = curG & iBitG; }
			curB = (((curCol & iBitB)<<1) + ((*curLine) & iBitB)) >> 1;
			if(curB & iBitOverB){ curB = iBitB; } else { curB = curB & iBitB; }
			*dst = (curR | curG | curB);
#endif
#if RGB_PARALLEL
			//ԍ̃sNZ̐FĂԉE̎̐F𑫂Ƃłڂ̒S炵Ă.

			//[RGBlOaZ.܂萳młȂC.
			a1 = ((curCol & 0x00fefeff) | 0x80000000) - (((*(curLine - (depthPix>>1))) >> aDepth) & depthMask & 0x00fefeff);
			curCol =  0x00ffffff & ( a1 & ~((a1 & 0x01010100) - ((a1 & 0x01010100)>>8)) );

			//E[̎RGBlZ.(aDepthVtgĂ̂ŖOa邱Ƃ͖ Ǝv)
			curCol += ((*(curLine + (depthPix>>1))) >> aDepth) & depthMask;
#else
			curCol = ( ((curCol & iBitR) - (((*(curLine - (depthPix>>1)) & iBitR) >> aDepth) & iBitR) + (((*(curLine + (depthPix>>1)) & iBitR) >> aDepth) & iBitR)) & iBitR)
					|( ((curCol & iBitG) - (((*(curLine - (depthPix>>1)) & iBitG) >> aDepth) & iBitG) + (((*(curLine + (depthPix>>1)) & iBitG) >> aDepth) & iBitG)) & iBitG)
					|( ((curCol & iBitB) - (((*(curLine - (depthPix>>1)) & iBitB) >> aDepth) & iBitB) + (((*(curLine + (depthPix>>1)) & iBitB) >> aDepth) & iBitB)) & iBitB);
#endif
			curLine++;
			dst++;
		}
	}
}