// GmEntry.h
#ifndef _GMENTRY_HEAD_
#define _GMENTRY_HEAD_

#include "ALLEGRO.H"
#include <typeinfo.h>

/*already defined. see include\allegro\base.h
#define TRUE -1
#define FALSE 0
*/

#include "stdio.h" //printf-debugging
#define RELEASE_PRINT0(aStr) printf(aStr)
#define RELEASE_PRINT1(aStr, aArg1) printf(aStr, aArg1)
#define RELEASE_PRINT2(aStr, aArg1, aArg2) printf(aStr, aArg1, aArg2)
#define RELEASE_PRINT3(aStr, aArg1, aArg2, aArg3) printf(aStr, aArg1, aArg2, aArg3)
#define RELEASE_PRINT4(aStr, aArg1, aArg2, aArg3, aArg4) printf(aStr, aArg1, aArg2, aArg3, aArg4)
#define RELEASE_PRINT5(aStr, aArg1, aArg2, aArg3, aArg4, aArg5) printf(aStr, aArg1, aArg2, aArg3, aArg4, aArg5)
#define RELEASE_PRINT6(aStr, aArg1, aArg2, aArg3, aArg4, aArg5, aArg6) printf(aStr, aArg1, aArg2, aArg3, aArg4, aArg5, aArg6)

#if _DEBUG
//#if 1

	#define DEBUG_PRINT0(aStr) printf(aStr)
	#define DEBUG_PRINT1(aStr, aArg1) printf(aStr, aArg1)
	#define DEBUG_PRINT2(aStr, aArg1, aArg2) printf(aStr, aArg1, aArg2)
	#define DEBUG_PRINT3(aStr, aArg1, aArg2, aArg3) printf(aStr, aArg1, aArg2, aArg3)
	#define DEBUG_PRINT4(aStr, aArg1, aArg2, aArg3, aArg4) printf(aStr, aArg1, aArg2, aArg3, aArg4)
	#define DEBUG_PRINT5(aStr, aArg1, aArg2, aArg3, aArg4, aArg5) printf(aStr, aArg1, aArg2, aArg3, aArg4, aArg5)
	#define DEBUG_PRINT6(aStr, aArg1, aArg2, aArg3, aArg4, aArg5, aArg6) printf(aStr, aArg1, aArg2, aArg3, aArg4, aArg5, aArg6)
#else
	#define DEBUG_PRINT0(aStr) 
	#define DEBUG_PRINT1(aStr, aArg1) 
	#define DEBUG_PRINT2(aStr, aArg1, aArg2) 
	#define DEBUG_PRINT3(aStr, aArg1, aArg2, aArg3) 
	#define DEBUG_PRINT4(aStr, aArg1, aArg2, aArg3, aArg4) 
	#define DEBUG_PRINT5(aStr, aArg1, aArg2, aArg3, aArg4, aArg5)
	#define DEBUG_PRINT6(aStr, aArg1, aArg2, aArg3, aArg4, aArg5, aArg6)
#endif

#define RELEASE_PRINTV(aVar) { \
	RELEASE_PRINT2("%s == %d\n", # aVar, aVar);\
}
#define RELEASE_PRINTV_S(aVar) { \
	RELEASE_PRINT2("%s == %s\n", # aVar, aVar);\
}

//ERRORS
//windows.h̃G[ƖOԂ邱ƂĂ܂BvΏ.
#define ERROR_NONE (0)
#define ERROR_GENERAL (-1)
#define ERROR_ARGUMENT (-2)
#define ERROR_NOT_EXISTS (-3)
#define ERROR_NO_RESOURCES (-4)
#define ERROR_NULL (-5)

//ERROR HANDLERS
//܂g񂶂Ȃ.
//todo: 
//		returnOɉł悤ɂ悤(cleanup stackƂ)
//		void^̊֐ł͎gȂǂǂ.
#define RETURN_IF_NEGATIVE(aRet, aOperation) { \
	aRet = aOperation; \
	if(aRet < 0){ \
		RELEASE_PRINT2("ERROR: %d returned @ %s\n", aRet, # aOperation);\
		return aRet; \
	} \
}

#define RETURN_IF_ERROR(aRet, aOperation) { \
	aRet = aOperation; \
	if(aRet != ERROR_NONE){ \
		RELEASE_PRINT2("ERROR: %d returned @ %s\n", aRet, # aOperation);\
		return aRet; \
	} \
}

#define RETURN_IF_NULL(aRet, aOperation) { \
	aRet = aOperation;\
	if(aRet == NULL) {\
		RELEASE_PRINT1("ERROR: NULL returned @ %s\n", # aOperation);\
		return NULL; \
	} \
}

#define RETURN_ERROR_IF_NULL(aRet, aOperation) { \
	aRet = aOperation;\
	if(aRet == NULL) {\
		RELEASE_PRINT1("ERROR: NULL returned @ %s\n", # aOperation);\
		return ERROR_NULL; \
	} \
}

int GE_getCurrentTime();

void GE_setExitFlag();
int GE_getExitFlag();

int GE_rand();
void GE_srand(int aSeed);

class Settings{
public:
	//st@CpX.
	char exePath[256];
	//EChE\[hۂ
	int showAsWindow;
	//ʂ̕E(܂ňŎw肳ꂽl)
	int screenW;
	int screenH;
	//tB^̋.
	int filterRatio;
	//L[oCh
	char bindedKey[16+1];

	//t@C̐.
	int soundFileNum;
	//t@C(tpXŊi[邱)ւ̃|C^.
	char soundFileName[16][256];
	//,t@Cւ̃|C^.ɕ\p.
	char* soundFilePureFileName[16];

	//XRAƃnCXRA.sɏ܂...
	int score;

	//t[J[hON/OFF(}EXŉ]Egk)
	int freeCamera;
	//Փx㏸.vZintɂ邯ǂƂ肠fixedŒ`ĂĂ݂.
	//fixed levelFixed;

	//vCt@C.
	char replayFileName[256];
	//vCĐ[hۂ.
	int replay;

	enum{
		NUM_PLAYER_TYPE = 2,
		NUM_LEVEL = 4
	};
	//vC[.
	int playerType;
	//Փx.
	int level;

	//player, levelɉănCXRAXV.
	void setHighScore(int aScore);
	//player, levelɉnCXRA擾.
	int getHighScore();
	//ex̃nCXRAv_.
	int getTotalHighScore();

	void saveHighScore(const char* aFileName);
	void loadHighScore(const char* aFileName);

	//ՓxƂ̖O擾.
	const char* getLevelName();
private:
	//nCXRA̓[hʂɂꂼꎝ.vf͂Ƃ肠߂̃eLg[.
	int highScore[NUM_PLAYER_TYPE][NUM_LEVEL];

};

#define REPLAY_DEFAULT_FILENAME "LASTPLAY.log"

#endif //_GMENTRY_HEAD_
