#ifndef	_MOD_H__000314_1610		/* QdCN[hh~̔ԕ */
#define	_MOD_H__000314_1610

#define LogMsg printf
typedef long           S32;
typedef unsigned long  U32;
typedef short          S16;
typedef unsigned short U16;
typedef signed char    S8;
typedef unsigned char  U8;
typedef float          F32;
typedef double         F64;

#ifndef TRUE
	#define TRUE -1
#endif
#ifndef FALSE
	#define FALSE 0
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define		MAX_PATTERNS				( 256 )
#define		MAX_INSTRUMENTS				( 128 )
#define		MAX_SAMPLES_IN_INSTRUMENT	( 16 )
#define		MAX_SAMPLES					( MAX_INSTRUMENTS * MAX_SAMPLES_IN_INSTRUMENT )
#define		MAX_CHANNELS				( 64 )


/*
	\̂̌^
*/

/* ^ÕtbN */
typedef struct tag_ENVELOPE			ENVELOPE ;
typedef struct tag_MOD				MOD ;
typedef struct tag_XM_ID			XM_ID ;
typedef struct tag_XM_HEADER		XM_HEADER ;
typedef struct tag_XM_PATTERN		XM_PATTERN ;
typedef struct tag_XM_SAMPLE		XM_SAMPLE ;
typedef struct tag_XM_INSTRUMENT	XM_INSTRUMENT ;
typedef struct tag_CHANSTAT			CHANSTAT ;

/* CXgD[g̃Gx[v_ */
struct tag_ENVELOPE {
	U16		x ;						/* Gx[v_ x W */
	U16		y ;						/* Gx[v_ y W */
};

/* t̋Ȃ̏Ԃ\ */
struct tag_MOD {
	S32	FormatType ;			/* tH[}bg^Cv */

	S32	bLoopMode ;				/* [vĐ[hH TRUE / FALSE */
	S32	bAutoGainControl ;		/* QCRg[邩H TRUE / FALSE */
	S32	bDone ;					/* ĐIH TRUE / FALSE */

	S32	TickCount ;				/* e|p */
	S32	nTickPerRow ;			/* e|pi1 Row  tick j*/
	S32	BPM ;					/* BPM */
	S32	nWavePerSec ;			/* WAVE o̓foCX̎g(Hz) */
	S32	nWavePerTick ;			/* ŏ荞ݒPʊԓ̐g` */
	S32	nRestWave ;				/* ̊荞݂܂ł̎cg`f[^ */

	S32	Row ;					/* p^[f[^XLʒu */
	S32	BreakSequence ;			/* iSequencej*/
	S32	BreakRow ;				/* iRowj*/
	S32	PatternDelay ;			/* R}h EEx pxiRow Pʁj */
	S32	FinePatternDelay ;		/* R}h X6x pxiTick Pʁj */

	S32	idxSequenceData ;		/* V[PXf[^ǂݎʒu */

	S32	GlobalVolume_ ;			/* O[o{[i0x00_ ` 0x40_j*/
	S32	GlobalVolumeSlide ;		/* O[o{[AXChl */
	S32	GlobalVolumeScale_ ;	/* Ŝ̉ʃXP[Oli0_ ` 1_j*/
	S32	GainControlScale_ ;		/* QCp ʃXP[Oli0_ ` 1_j*/

	/* v`mCY΍ */
	S32	AntiNoiseVal_L ;		/* g`̏ClA */
	S32	AntiNoiseVal_R ;		/* g`̏ClAE */


	/* XM ` wb_[ ̂P */
	struct tag_XM_ID {
		char	aszID_Text[ 17 ];		/* XM `ʕ */
		char	aszModuleName[ 21 ];	/* f[^̖Oi1]Ɂj*/
		S32		ID_Byte ;				/* XM `ʗp */
		char	aszTrackerName[ 21 ];	/* {f[^쐬gbJ[i1]Ɂj*/
		S32		VersionNumber ;			/* f[^̃o[Wio[ */
	} XmId ;

	/* XM ` wb_[ ̂Q */
	struct tag_XM_HEADER {
		S32		HeaderSize ;			/* wb_[̈̃TCY */
		S32		SongLength ;			/* aPatternOrderTable ̒ɊZAȂ̑S */
		S32		RestartPosition ;		/* Ȃ̃[vAAʒu */
		S32		NumberOfChannels ;		/* `l */
		S32		NumberOfPatterns ;		/*  Pattern  */
		S32		NumberOfInstruments ;	/*  Instrument  */
		S32		Flags ;					/*
											bit 0 :	0 Ȃ AmigaPeriod [h
													1 Ȃ `g[h
										*/
		S32		DefaultTempo ;			/* 1 Row  Tick AftHgl */
		S32		DefaultBPM ;			/* BPM ftHgl */
		U8		aPatternOrderTable[ 256 ];	/* t Pattern ̏\e[u */
	} XmHeader ;

	/* p^[̏ */
	struct tag_XM_PATTERN {
		S32		PatternHeaderLength ;	/* wb_[̈̃TCY */
		S32		PackingType ;			/* Pattern ̈k`i 0 炵j*/
		S32		NumberOfRowsInPattern ;	/* Pattern ̑ Row  */
		S32		PackedPatterndataSize ;	/* kꂽԂł Pattern ̃f[^TCY */

		/* [N̈ */
		U8		*pPatternData ;			/* p^[f[^ւ̃|C^[ */
	} *(apXM_PATTERN[ MAX_PATTERNS ]);

	/* TvȌ */
	struct tag_XM_SAMPLE {
		void	*pSampleData ;			/* TvOf[^ւ̃|C^[ */
		S32		SampleLength ;			/* TvOf[^̔g`vf */
		S32		SampleLoopStart ;		/* TvÕ[vJnʒuig`vfPʁj*/
		S32		SampleLoopLength ;		/* TvÕ[vԂ̒ig`vfPʁj*/
		S32		Volume ;				/* TvÕftHg */
		S32		FineTune ;				/* TvÕftHg FineTune l */
		S32		Type ;					/*
											Bit 0-1:	00	= No loop
														01	= Forward loop
														10	= Ping-pong loop
											Bit 4:		 0	=  8-bit sampledata
														 1	= 16-bit sampledata
										*/
		S32		Panning ;				/* TvÕftHgpʒu */
		S32		RelativeNoteNumber ;	/* K̏Cl */
		S32		Reserved ;				/* \̈ */
		char	aszSampleName[23];		/* TvO̖Oi1]Ɂj*/

		/* [N̈ */
		S32		VoiceMode ;				/* etO */
	} *(apXM_SAMPLE[ MAX_SAMPLES ]);

	/* CXgD[g̏ */
	struct tag_XM_INSTRUMENT {
		S32			InstrumentSize ;				/* f[^TCY */
		char		aszInstrumentName[ 23 ];		/* CXgD[g̖Oi1]Ɂj*/
		S32			InstrumentType ;				/* CXgD[ǧ`i 0 炵j*/
		S32			NumberOfSamplesInInstrument ;	/* ̃CXgD[gɊ܂܂TvO */
		S32			SampleHeaderSize ;				/* TvÕwb_[̃TCY */
		U8			aSampleNumberForAllNotes[ 96 ];	/* SKʂ̃TvOԍ */
		ENVELOPE	aPointsForVolumeEnvelope[ 12 ];		/* {[Gx[v̐_iő 12j*/
		ENVELOPE	aPointsForPanningEnvelope[ 12 ];	/* pGx[v̐_iő 12j*/
		S32			NumberOfVolumePoints ;			/* {[Gx[v̐_̐ */
		S32			NumberOfPanningPoints ;			/* pGx[v̐_̐ */
		S32			VolumeSustainPoint ;			/* {[Gx[ṽTXeC|Cg */
		S32			VolumeLoopStartPoint ;			/* {[Gx[ṽ[vJnʒu */
		S32			VolumeLoopEndPoint ;			/* {[Gx[ṽ[vIʒu */
		S32			PanningSustainPoint ;			/* pGx[ṽTXeC|Cg */
		S32			PanningLoopStartPoint ;			/* pGx[ṽ[vJnʒu */
		S32			PanningLoopEndPoint ;			/* pGx[ṽ[vIʒu */
		S32			VolumeType ;					/*
														bit 0:	0 = Gx[v OFF
																1 = Gx[v ON
															1:	0 = TXeC OFF
																1 = TXeC ON
															2:	0 = [v OFF
																1 = [v ON
													*/
		S32			PanningType ;					/*
														bit 0:	0 = Gx[v OFF
																1 = Gx[v ON
															1:	0 = TXeC OFF
																1 = TXeC ON
															2:	0 = [v OFF
																1 = [v ON
													*/
		S32			AutoVibratoType ;				/* ru[gAg` */
		S32			AutoVibratoSweep ;				/* ru[gAMAX UɓB܂ł Tick  */
		S32			AutoVibratoDepth ;				/* ru[gAMAX U */
		S32			AutoVibratoRate ;				/* ru[gAUx */
		S32			VolumeFadeout ;					/* KeyOff ̃tF[hAEgx */
		S32			Reserved ;						/* \̈ */

		/* [N̈ */
		XM_SAMPLE	*apAllNoteXM_SAMPLE[ 96 ];		/* SKʃTvOւ̃|C^[ */
		U8			VolumeEnvelopeTable[ 325 ];		/* WJς݂́A{[Gx[v */
		U8			PanningEnvelopeTable[ 325 ];	/* WJς݂́ApGx[v */
	} *(apXM_INSTRUMENT[ MAX_INSTRUMENTS ]);

	/* e`l̏ */
	struct tag_CHANSTAT {
		/* ݂ Row ̓eiNoteDelay ̒xǂݍ݂lj*/
		S32	idxNowPatternNote ;
		S32	idxNowRealNote ;
		S32	NowVolumeColumn ;
		S32	NowCommand ;
		S32	NowParam ;
		S32	NowPeriod_ ;
		S32	idxNowInst ;

		/* CXgD[gւ̃|C^[ */
		XM_INSTRUMENT	*pPendingXM_INSTRUMENT ;
		XM_INSTRUMENT	*pPlayingXM_INSTRUMENT ;

		/* TvOւ̃|C^[ */
		XM_SAMPLE		*pPlayingXM_SAMPLE ;

		/* ŌɉꂽL[ԍ */
		S32	idxLastRealNote ;

		/* period ֌W */
		S32	PendingPeriod_ ;
		S32	PlayingPeriod_ ;
		S32	FinalPeriod_ ;
		S32	PeriodLowLimit_ ;			/*  */
		S32	PeriodHighLimit_ ;			/*  */

		/* FineTune ֌W */
		S32	PlayingFineTune ;

		/* ʊ֌W */
		S32	PlayingVolume_ ;			/*i0x00_ ` 0x40_j*/
		S32	FinalVolume_ ;				/*i0x00_ ` 0x40_j*/
		S32	FinalVolume_L_ ;			/*i0x00_ ` 0x40_j*/
		S32	FinalVolume_R_ ;			/*i0x00_ ` 0x40_j*/
		S32	VolumeSlide ;				/* ʃXChl */
		S32	FineVolumeSlide ;			/* ʃXChliFineVolumeSlide pj*/
		S32	VolumeScale_ ;				/* `lPʂ̉ʃXP[Oli0_ ` 1_j*/

		/* p֌W */
		S32	PlayingPanning_ ;			/*i:0x000_ ` 0x0FF_:Ej*/
		S32	FinalPanning_ ;				/*i:0x000_ ` 0x100_:Ej*/
		S32	PanningSlide ;				/* p XChliR}h Pxy pj*/

		/* Gx[v֌W */
		S32	idxVolumeEnvelopeTable ;	/* {[Gx[ṽe[uQƈʒu */
		S32	idxPanningEnvelopeTable ;	/* pGx[ṽe[uQƈʒu */

		/* Vibrato ֌W */
		S32	VibratoType ;				/* ^Cv */
		S32	VibratoPosition_ ;			/* g`ʒu */
		S32	VibratoRate ;				/* x */
		S32	VibratoDepth ;				/* U */

		/* Tremolo ֌W */
		S32	TremoloType ;				/* ^Cv */
		S32	TremoloPosition_ ;			/* g`ʒu */
		S32	TremoloRate ;				/* x */
		S32	TremoloDepth ;				/* U */

		/* Portamento ֌W */
		S32	PortamentoInc ;				/* period ZʁiPortamento pj*/
		S32	TonePortamentoInc ;			/* period ZʁiTone-Portamento pj*/
		S32	TonePortamentoDst_ ;		/* period ڕWliTone-Portamento pj*/
		S32	FinePortamentoInc ;			/* period ZʁiFine-Portamento pj*/
		S32	ExtraFinePortamentoInc ;	/* period ZʁiExtra Fine-Portamento pj*/

		/* Arpeggio ֌W */
		S32	ArpeggioPeriod_[2] ;
		S32	idxArpeggio ;				/* 0 -> 1 -> 2 JԂ */

		/* TremoriR}h Txyj֌W */
		S32	TremorCount ;				/* JE^[ */
		S32	TremorOnTime ;				/* KeyOn ԁitick j*/
		S32	TremorOffTime ;				/* KeyOff ԁitick j*/
		S32	bTremorMute ;				/* ~[gԂH TRUE / FALSE */

		/* Multi retrigiR}h Rxyj֌W */
		S32	MultiRetrigCount ;			/* JE^[ */
		S32	MultiRetrigInterval ;		/* Ԋu */
		S32	MultiRetrigVolumeChange ;	/* ʂ̕ω̂ */

		/* Panbrello ֌W */
		S32	PanbrelloType ;				/* ^Cv */
		S32	PanbrelloPosition ;			/* g`ʒu */
		S32	PanbrelloRate ;				/* x */
		S32	PanbrelloDepth ;			/* U */

		/* Pattern loopiR}h E6xj֌W */
		S32	PatternLoopCount ;			/* [v񐔃JEgp */
		S32	PatternLoopRow ;			/* [v|CgiRowj*/

		/* KEYOFF tF[hAEg֌W */
		S32	bFadeOut ;					/* tF[hAEgH TRUE / FALSE */
		S32	FadeOutVolume_1_15_16 ;		/* tF[hAEgpAʔ{iŒ菭 16 bitj*/

		/* Auto-Vibrato ֌W */
		S32	AutoVibratoPosition ;		/* g`ʒu */
		S32	AutoVibratoDepth_ ;			/* U */

		/* Surround ֌W */
		S32	bSurround ;					/* Surround ͗LH TRUE / FALSE */

		/* ̑낢 */
		U32	SamplePosition_ ;			/* TvO̍Đʒu */
		U32	SampleRate_ ;				/* TvO̍Đ[g */
		U32	SampleOffset ;				/* R}h 9xx Ŏw肵ItZbgliŌɎw肵lj*/
		U32	SampleHighOffset ;			/* R}h XAx Ŏw肵ItZbgliŌɎw肵lj*/
		S32	bGrissando ;				/* Grissando ͗LH TRUE / FALSE */
		S32	VolumeColumnContinueValue ;	/* VolumeColumn pA continue Čp */

		/* v`mCY΍ */
		XM_SAMPLE	*pLastPlayingXM_SAMPLE ;	/* ÕTvO */
		U32	LastSamplePosition_ ;		/* ÕTvO̍Đʒu */
		S32	LastWaveVal_L ;				/* g`̍ŏIlA */
		S32	LastWaveVal_R ;				/* g`̍ŏIlAE */
		S32	LastSampleVolume_L_ ;		/* ʂ̍ŏIlA */
		S32	LastSampleVolume_R_ ;		/* ʂ̍ŏIlAE */
	} aCHANSTAT[ MAX_CHANNELS ];
};


/*
	MOD f[^̓ǂݍ

	ߒlETRUE  = 
		EFALSE = s
*/
S32 MOD__LoadSong(
	 MOD	*pMOD		/* this |C^[ */
	,void	*pMusDat_	/* Ƀt@Cǂݍ݁Ã|C^[Ɏw */
	,S32	 lMusDat	/* f[^TCY */
);


/*
	MOD f[^̔j

	ߒlETRUE  = 
		EFALSE = s
*/
S32 MOD__ReleaseSong(
	 MOD	*pMOD		/* this |C^[ */
);


/*
	ʂ̐ݒ

	ߒlETRUE  = 
		EFALSE = s
*/
S32 MOD__Set_Volume(
	 MOD	*pMOD		/* this |C^[ */
	,S32	Volume		/*  0 ` 256iȏɂݒ\j*/
);


/*
	Đ[g̐ݒ

	ߒlETRUE  = 
		EFALSE = s
*/
S32 MOD__Set_nWavePerSec(
	 MOD	*pMOD			/* this |C^[ */
	,S32	nWavePerSec		/* WAVE o̓foCX̎g(Hz) */
);


/*
	[vĐ[h / 񃋁[vĐ[h ̎w

	ߒlETRUE  = 
		EFALSE = s
*/
S32 MOD__Set_bLoopMode(
	 MOD	*pMOD			/* this |C^[ */
	,S32	bLoopMode		/* [vĐ[hH TRUE / FALSE */
);


/*
	QCRg[邩ǂ ̎w

	ߒlETRUE  = 
		EFALSE = s
*/
S32 MOD__Set_bAutoGainControl(
	 MOD	*pMOD				/* this |C^[ */
	,S32	bAutoGainControl	/* QCRg[邩H TRUE / FALSE */
);


/*
	Đip[^[A擪Đj

	ߒlETRUE  = 
		EFALSE = s
*/
S32 MOD__InitPlay(
	 MOD	*pMOD		/* this |C^[ */
);


/*
	MOD f[^̍Đ

	ߒlETRUE  = 
		EFALSE = s
*/
S32 MOD__PlaySong(
	 MOD	*pMOD			/* this |C^[ */
	,U32	*pWaveOutPut	/* g`o͐iL R ЂƂ܂Ƃ߂ɂāAU32 Pʂŏo͂j*/
	,S32	 nWaveOutPut	/* o͔g` */
);


/*
	MOD \̂̔j

	ߒlETRUE  = 
		EFALSE = s
*/
S32 MOD__Destruct(
	MOD	*p		/* this |C^[ */
);


/*
	MOD \̂̊mۂƏ

	ߒlF	mۂ\̂ւ̃|C^[
			NULL Ȃ玸s
*/
MOD *MOD__Create(
);


#ifdef __cplusplus
}
#endif


#endif		/* ԕ[ */
