/*
	Ȉ MOD / XM vC[i2001 / 03 / 08 Łj
													by t@~x̂
*/
//#include "_allinc2.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "_mod.h"


#undef		WARNING_LEVEL
#define		WARNING_LEVEL		( 0 )

#define		TYPE_NOTAVAILABLE	( 0 )
#define		TYPE_MOD			( 1 )
#define		TYPE_S3M			( 2 )
#define		TYPE_XM				( 3 )
#define		TYPE_IT				( 4 )

#undef		SFT
#define		SFT					( 12 )			/* Œ菬rbg */
#undef		ONE
#define		ONE					(1 << 12)		/* Œ菬\L 1 */
#undef		DECIMAL
#define		DECIMAL				((1 << 12) - 1)	/* Œ菬́Aop */

#define		ENV_ON				( 1 )
#define 	ENV_SUSTAIN			( 2 )
#define		ENV_LOOP			( 4 )

#define		SMP_LOOP			( 1 )
#define		SMP_PINGPONGLOOP	( 2 )
#define		SMP_16BIT			( 16 )

#define		VM_ON				( 1 )
#define		VM_LOOP				( 2 )
#define		VM_16BIT			( 4 )

#define		LINEAR_FREQUENCY	( 1 )



/* Vibrato Tremolo Panbrello Auto-Vibrato ʔg`f[^ */
static const S32 _aaWaveTable[7][64] =
{
	/* 0 : TCg */
	{
		    0,  12,  25,  37,  49,  60,  71,  81,  90,  98, 106, 112, 117, 122, 125, 126
		, 127, 126, 125, 122, 117, 112, 106,  98,  90,  81,  71,  60,  49,  37,  25,  12
		,   0, -12, -25, -37, -49, -60, -71, -81, -90, -98,-106,-112,-117,-122,-125,-126
		,-127,-126,-125,-122,-117,-112,-106, -98, -90, -81, -71, -60, -49, -37, -25, -12
	}
	,
	/* 1 : TCgi]j*/
	{
		    0, -12, -25, -37, -49, -60, -71, -81, -90, -98,-106,-112,-117,-122,-125,-126
		,-127,-126,-125,-122,-117,-112,-106, -98, -90, -81, -71, -60, -49, -37, -25, -12
		,   0,  12,  25,  37,  49,  60,  71,  81,  90,  98, 106, 112, 117, 122, 125, 126
		, 127, 126, 125, 122, 117, 112, 106,  98,  90,  81,  71,  60,  49,  37,  25,  12
	}
	,
	/* 2 : mRMg */
	{
		    0,  -4,  -8, -12, -16, -20, -24, -28, -32, -36, -40, -44, -48, -52, -56, -60
		, -64, -68, -72, -76, -80, -84, -88, -92, -96,-100,-104,-108,-112,-116,-120,-124
		, 127, 123, 119, 115, 111, 107, 103,  99,  95,  91,  87,  83,  79,  75,  71,  67
		,  63,  59,  55,  51,  47,  43,  39,  35,  31,  27,  23,  19,  15,  11,   7,   3
	}
	,
	/* 3 : mRMgi]j*/
	{
		    0,   4,   8,  12,  16,  20,  24,  28,  32,  36,  40,  44,  48,  52,  56,  60
		,  64,  68,  72,  76,  80,  84,  88,  92,  96, 100, 104, 108, 112, 116, 120, 124
		,-127,-123,-119,-115,-111,-107,-103, -99, -95, -91, -87, -83, -79, -75, -71, -67
		, -63, -59, -55, -51, -47, -43, -39, -35, -31, -27, -23, -19, -15, -11,  -7,  -3
	}
	,
	/* 4 : `g */
	{
		  127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127
		, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127
		,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127
		,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127
	}
	,
	/* 5 : `gi]j*/
	{
		 -127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127
		,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127,-127
		, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127
		, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127
	}
	,
	/* 6 : _g */
	{
		   98,-127, -43,  88, 102,  41, -65, -94, 125,  20, -71, -86, -70, -32, -16, -96
		,  17,  72, 107,  -5, 116, -69, -62, -40,  10, -61,  65, 109, -18, -38, -13, -76
		, -23,  88,  21, -94,   8, 106,  21,-112,   6, 109,  20, -88, -30,   9,-127, 118
		,  42, -34,  89,  -4, -51, -72,  21, -29, 112, 123,  84,-101, -92,  98, -54, -95
	}
};

/* Vibrato Tremolo Panbrello Auto-Vibrato eg`̊蓖 */
static const S32 _aVibratoWaveType[4]		= { 0 , 2 , 4 , 6 };
static const S32 _aTremoloWaveType[4]		= { 0 , 2 , 4 , 6 };
static const S32 _aPanbrelloWaveType[4]		= { 0 , 2 , 4 , 6 };
static const S32 _aAutoVibratoWaveType[5]	= { 1 , 5 , 3 , 2 , 6 };



/*
	XM_PATTERN \̂̔j

	ߒlETRUE  = 
		EFALSE = s
*/
static S32 XM_PATTERN__Destruct(
	XM_PATTERN *p		/* this |C^[ */
){
	if(	p == NULL ) return( FALSE );

	if(	p->pPatternData != NULL ){
//		FreeMemory( p->pPatternData );
		free( p->pPatternData );
		p->pPatternData = NULL ;
	}
//	FreeMemory( p );
	free( p );
	return( TRUE );
}



/*
	XM_PATTERN \̂̊mۂƏ

	ߒlF	mۂ\̂ւ̃|C^[
			NULL Ȃ玸s
*/
static XM_PATTERN *XM_PATTERN__Create(
){
	S32	i ;
	S32	size = sizeof( XM_PATTERN );
//	XM_PATTERN	*p = AllocMemory( size );
	XM_PATTERN	*p = malloc( size );

	if( p == NULL ) return( NULL );

	/* ʓ|Ȃ̂łOŃNA */
	for( i=0 ; i<size ; i++ ) ((U8*)p)[i] = 0 ;

	/* o[̏l */
	p->pPatternData = NULL ;

	return( p );
}



/*
	XM_INSTRUMENT \̂̔j

	ߒlETRUE  = 
		EFALSE = s
*/
static S32 XM_INSTRUMENT__Destruct(
	XM_INSTRUMENT *p		/* this |C^[ */
){
	if(	p == NULL ) return( FALSE );

//	FreeMemory( p );
	free( p );
	return( TRUE );
}



/*
	XM_INSTRUMENT \̂̊mۂƏ

	ߒlF	mۂ\̂ւ̃|C^[
			NULL Ȃ玸s
*/
static XM_INSTRUMENT *XM_INSTRUMENT__Create(
){
	S32	i ;
	S32	size = sizeof( XM_INSTRUMENT );
//	XM_INSTRUMENT	*p = AllocMemory( size );
	XM_INSTRUMENT	*p = malloc( size );

	if( p == NULL ) return( NULL );

	/* ʓ|Ȃ̂łOŃNA */
	for( i=0 ; i<size ; i++ ) ((U8*)p)[i] = 0 ;

	/* o[̏l */
	for( i=0 ; i<96 ; i++ ) p->apAllNoteXM_SAMPLE[ i ] = NULL ;

	return( p );
}



/*
	XM_SAMPLE \̂̔j

	ߒlETRUE  = 
		EFALSE = s
*/
static S32 XM_SAMPLE__Destruct(
	XM_SAMPLE *p		/* this |C^[ */
){
	if(	p == NULL ) return( FALSE );

	if(	p->pSampleData != NULL ){
//		FreeMemory( p->pSampleData );
		free( p->pSampleData );
		p->pSampleData = NULL ;
	}
//	FreeMemory( p );
	free( p );
	return( TRUE );
}



/*
	XM_SAMPLE \̂̊mۂƏ

	ߒlF	mۂ\̂ւ̃|C^[
			NULL Ȃ玸s
*/
static XM_SAMPLE *XM_SAMPLE__Create(
){
	S32	i ;
	S32	size = sizeof( XM_SAMPLE );
//	XM_SAMPLE	*p = AllocMemory( size );
	XM_SAMPLE	*p = malloc( size );

	if( p == NULL ) return( NULL );

	/* ʓ|Ȃ̂łOŃNA */
	for( i=0 ; i<size ; i++ ) ((U8*)p)[i] = 0 ;

	/* o[̏l */
	p->pSampleData = NULL ;

	return( p );
}



/*
	XM `Ƃ݂Ȃēǂݍ

	ߒlETRUE  = 
		EFALSE = s
*/
static S32 MOD__LoadSongAsXM(
	 MOD	*pMOD
	,void	*pMusDat_
	,S32	 lMusDat
){
	U8	*pMusDat = (U8*)pMusDat_ ;
	S32	ofs = 0 ;

	if(	pMOD == NULL ) return( FALSE );

	/* XM_ID */
	{
		/* ȃf[^Oɔr */
		if(	lMusDat - ofs < 60 ){
			#if (WARNING_LEVEL >= 2)
				LogMsg(
					"MOD__LoadSongAsXM : \n"
					"	f[^TCYsĂ܂BXM_ID ǂݍ߂܂B\n"
					"	ǂݍ݂LZ܂B\n"
				);
			#endif
			MOD__ReleaseSong( pMOD );
			return( FALSE );
		}

		/* f[^ǂݍ */
		memcpy( &pMOD->XmId.aszID_Text[0]		,  &pMusDat[ ofs +  0 ] , 17 );
		memcpy( &pMOD->XmId.aszModuleName[0]	,  &pMusDat[ ofs + 17 ] , 20 );
		pMOD->XmId.aszModuleName[20] = 0 ;	/* I_ */
		pMOD->XmId.ID_Byte			= (S32)*((U8*) &pMusDat[ ofs + 37 ]);
		memcpy( &pMOD->XmId.aszTrackerName[0]	,  &pMusDat[ ofs + 38 ] , 20 );
		pMOD->XmId.aszTrackerName[20] = 0 ;	/* I_ */
		pMOD->XmId.VersionNumber	= (S32)*((U16*)&pMusDat[ ofs + 58 ]);
		ofs += 60 ;

		/* ʕ̊mF */
		if(	memcmp( "Extended Module:" , &(pMOD->XmId.aszID_Text[0]) , 16 ) != 0
		||	pMOD->XmId.ID_Byte != 0x1a
		){
			#if (WARNING_LEVEL >= 2)
				LogMsg(
					"MOD__LoadSongAsXM : \n"
					"	XM `ʕ񂪑݂܂B\n"
					"	ǂݍ݂LZ܂B\n"
				);
			#endif
			MOD__ReleaseSong( pMOD );
			return( FALSE );
		}

		/* f[^`̃o[WmF */
		if(	pMOD->XmId.VersionNumber < 0x103 ){
			#if (WARNING_LEVEL >= 2)
				LogMsg(
					"MOD__LoadSongAsXM : \n"
					"	tH[}bg̃o[WÂ܂B\n"
					"	ǂݍ݂LZ܂B\n"
				);
			#endif
			MOD__ReleaseSong( pMOD );
			return( FALSE );
		}

		#if (WARNING_LEVEL >= 2)
			LogMsg(
				"MOD__LoadSongAsXM : ModName = %s \n"
				,pMOD->XmId.aszModuleName
			);

			LogMsg(
				"MOD__LoadSongAsXM : TrackerName = %s \n"
				,pMOD->XmId.aszTrackerName
			);
		#endif
	}


	/* XM_HEADER */
	{
		/* ȃf[^Oɔr */
		if(	lMusDat - ofs < 276 ){
			#if (WARNING_LEVEL >= 2)
				LogMsg(
					"MOD__LoadSongAsXM : \n"
					"	f[^TCYsĂ܂BXM_HEADER ǂݍ߂܂B\n"
					"	ǂݍ݂LZ܂B\n"
				);
			#endif
			MOD__ReleaseSong( pMOD );
			return( FALSE );
		}

		/* f[^ǂݍ */
		pMOD->XmHeader.HeaderSize			= (S32)*((S32*)&pMusDat[ ofs +  0 ]);
		pMOD->XmHeader.SongLength			= (S32)*((U16*)&pMusDat[ ofs +  4 ]);
		pMOD->XmHeader.RestartPosition		= (S32)*((U16*)&pMusDat[ ofs +  6 ]);
		pMOD->XmHeader.NumberOfChannels		= (S32)*((U16*)&pMusDat[ ofs +  8 ]);
		pMOD->XmHeader.NumberOfPatterns		= (S32)*((U16*)&pMusDat[ ofs + 10 ]);
		pMOD->XmHeader.NumberOfInstruments	= (S32)*((U16*)&pMusDat[ ofs + 12 ]);
		pMOD->XmHeader.Flags				= (S32)*((U16*)&pMusDat[ ofs + 14 ]);
		pMOD->XmHeader.DefaultTempo			= (S32)*((U16*)&pMusDat[ ofs + 16 ]);
		pMOD->XmHeader.DefaultBPM			= (S32)*((U16*)&pMusDat[ ofs + 18 ]);
		memcpy( &(pMOD->XmHeader.aPatternOrderTable[0])	,  &pMusDat[ ofs + 20 ] , 256 );
		ofs += pMOD->XmHeader.HeaderSize ;

		#if (WARNING_LEVEL >= 3)
			LogMsg(
				"MOD__LoadSongAsXM : \n"
				"	pMOD->XmHeader.HeaderSize          %d \n"
				"	pMOD->XmHeader.SongLength          %d \n"
				"	pMOD->XmHeader.RestartPosition     %d \n"
				"	pMOD->XmHeader.NumberOfChannels    %d \n"
				"	pMOD->XmHeader.NumberOfPatterns    %d \n"
				"	pMOD->XmHeader.NumberOfInstruments %d \n"
				"	pMOD->XmHeader.Flags               %d \n"
				"	pMOD->XmHeader.DefaultTempo        %d \n"
				"	pMOD->XmHeader.DefaultBPM          %d \n"
				,pMOD->XmHeader.HeaderSize
				,pMOD->XmHeader.SongLength
				,pMOD->XmHeader.RestartPosition
				,pMOD->XmHeader.NumberOfChannels
				,pMOD->XmHeader.NumberOfPatterns
				,pMOD->XmHeader.NumberOfInstruments
				,pMOD->XmHeader.Flags
				,pMOD->XmHeader.DefaultTempo
				,pMOD->XmHeader.DefaultBPM
			);
		#endif

		/* ȃf[^Oɔr */
		if(	pMOD->XmHeader.SongLength > 256
		||	pMOD->XmHeader.SongLength == 0
		||	pMOD->XmHeader.NumberOfChannels > MAX_CHANNELS
		||	pMOD->XmHeader.NumberOfChannels == 0
		||	pMOD->XmHeader.NumberOfPatterns > MAX_PATTERNS
		||	pMOD->XmHeader.NumberOfPatterns == 0
		||	pMOD->XmHeader.NumberOfInstruments > MAX_INSTRUMENTS
		||	pMOD->XmHeader.NumberOfInstruments == 0
		){
			#if (WARNING_LEVEL >= 2)
				LogMsg(
					"MOD__LoadSongAsXM : \n"
					"	XM_HEADER ɖȒl܂܂Ă܂B\n"
					"	ǂݍ݂LZ܂B\n"
				);
			#endif
			MOD__ReleaseSong( pMOD );
			return( FALSE );
		}
	}


	/* XM_PATTERN ̓ǂݍ */
	{
		S32	idxPattern ;
		S32	i ;

		for( idxPattern = 0 ; idxPattern < pMOD->XmHeader.NumberOfPatterns ; idxPattern++ ){
			S32	Size ;
			XM_PATTERN	*pXM_PATTERN = XM_PATTERN__Create( );

			/* sH */
			if(	pXM_PATTERN == NULL ){
				#if (WARNING_LEVEL >= 1)
					LogMsg(
						"MOD__LoadSongAsXM : \n"
						"	XM_PATTERN \̂̊mۂɎs܂B\n"
						"	ǂݍ݂LZ܂B\n"
					);
				#endif
				MOD__ReleaseSong( pMOD );
				return( FALSE );
			}

			pMOD->apXM_PATTERN[ idxPattern ] = pXM_PATTERN ;

			/* ȃf[^Oɔr */
			if(	lMusDat - ofs < 9 ){
				#if (WARNING_LEVEL >= 2)
					LogMsg(
						"MOD__LoadSongAsXM : \n"
						"	f[^TCYsĂ܂BXM_PATTERN ǂݍ߂܂B\n"
						"	ǂݍ݂LZ܂B\n"
					);
				#endif
				MOD__ReleaseSong( pMOD );
				return( FALSE );
			}

			/* f[^ǂݍ */
			pXM_PATTERN->PatternHeaderLength	= (S32)*((S32*)&pMusDat[ ofs +  0 ]);
			pXM_PATTERN->PackingType			= (S32)*((U8*) &pMusDat[ ofs +  4 ]);
			pXM_PATTERN->NumberOfRowsInPattern	= (S32)*((U16*)&pMusDat[ ofs +  5 ]);
			pXM_PATTERN->PackedPatterndataSize	= (S32)*((U16*)&pMusDat[ ofs +  7 ]);
			ofs += 9 ;

			#if (WARNING_LEVEL >= 3)
				LogMsg(
					"MOD__LoadSongAsXM : \n"
					"	pXM_PATTERN->PatternHeaderLength   %d \n"
					"	pXM_PATTERN->PackingType           %d \n"
					"	pXM_PATTERN->NumberOfRowsInPattern %d \n"
					"	pXM_PATTERN->PackedPatterndataSize %d \n"
					,pXM_PATTERN->PatternHeaderLength
					,pXM_PATTERN->PackingType
					,pXM_PATTERN->NumberOfRowsInPattern
					,pXM_PATTERN->PackedPatterndataSize
				);
			#endif

			/* ȃf[^Oɔr */
			if(	pXM_PATTERN->NumberOfRowsInPattern == 0 ){
				#if (WARNING_LEVEL >= 2)
					LogMsg(
						"MOD__LoadSongAsXM : \n"
						"	XM_PATTERN ɖȒl܂܂Ă܂B\n"
						"	ǂݍ݂LZ܂B\n"
					);
				#endif
				MOD__ReleaseSong( pMOD );
				return( FALSE );
			}

			/* p^[WJ̃m */
			Size = 5 * pXM_PATTERN->NumberOfRowsInPattern * pMOD->XmHeader.NumberOfChannels ;
//			pXM_PATTERN->pPatternData = AllocMemory( Size );
			pXM_PATTERN->pPatternData = malloc( Size );

			/* sH */
			if(	pXM_PATTERN->pPatternData == NULL ){
				#if (WARNING_LEVEL >= 1)
					LogMsg(
						"MOD__LoadSongAsXM : \n"
						"	p^[WJ惁̊mۂɎs܂B\n"
						"	ǂݍ݂LZ܂B\n"
					);
				#endif
				MOD__ReleaseSong( pMOD );
				return( FALSE );
			}

			/* 0 NA */
			for( i=0 ; i<Size ; i++ ) pXM_PATTERN->pPatternData[ i ] = 0 ;

			/* ȃf[^Oɔr */
			if(	lMusDat - ofs < pXM_PATTERN->PackedPatterndataSize ){
				#if (WARNING_LEVEL >= 2)
					LogMsg(
						"MOD__LoadSongAsXM : \n"
						"	f[^TCYsĂ܂Bkp^[f[^ǂݍ߂܂B\n"
						"	ǂݍ݂LZ܂B\n"
					);
				#endif
				MOD__ReleaseSong( pMOD );
				return( FALSE );
			}

			if(	pXM_PATTERN->PackedPatterndataSize ){
				S32	PackLeft	= pXM_PATTERN->PackedPatterndataSize ;
				U8	*pUnPacked	= pXM_PATTERN->pPatternData ;
				U8	*pPacked	= &pMusDat[ ofs ];

				while( PackLeft ){
					U8	Flag = *pPacked++ ;
					PackLeft-- ;

					/* kĂ邩H */
					if(	Flag & 0x80 ){
						/* Note */
						if(	Flag & 0x01 ){
							*pUnPacked++ = *pPacked++ ;
							PackLeft-- ;
						} else {
							pUnPacked++ ;
						}
						/* Instrument */
						if(	Flag & 0x02 ){
							*pUnPacked++ = *pPacked++ ;
							PackLeft-- ;
						} else {
							pUnPacked++ ;
						}
						/* Volume column */
						if(	Flag & 0x04 ){
							*pUnPacked++ = *pPacked++ ;
							PackLeft-- ;
						} else {
							pUnPacked++ ;
						}
						/* Effect */
						if(	Flag & 0x08 ){
							*pUnPacked++ = *pPacked++ ;
							PackLeft-- ;
						} else {
							pUnPacked++ ;
						}
						/* Effect parameter */
						if(	Flag & 0x10 ){
							*pUnPacked++ = *pPacked++ ;
							PackLeft-- ;
						} else {
							pUnPacked++ ;
						}
					} else {
						*pUnPacked++ = Flag ;			/* Note */
						*pUnPacked++ = *pPacked++ ;		/* Instrument */
						*pUnPacked++ = *pPacked++ ;		/* Volume column */
						*pUnPacked++ = *pPacked++ ;		/* Effect */
						*pUnPacked++ = *pPacked++ ;		/* Effect parameter */
						PackLeft -= 4 ;
					}
				}

				ofs += pXM_PATTERN->PackedPatterndataSize ;
			}
		}
	}

	/* XM_INSTRUMENT ̓ǂݍ */
	{
		S32	idxInst ;

		for( idxInst = 0 ; idxInst < pMOD->XmHeader.NumberOfInstruments ; idxInst++ ){
			XM_INSTRUMENT	*pXM_INSTRUMENT = XM_INSTRUMENT__Create( );

			/* sH */
			if(	pXM_INSTRUMENT == NULL ){
				#if (WARNING_LEVEL >= 1)
					LogMsg(
						"MOD__LoadSongAsXM : \n"
						"	XM_INSTRUMENT \̂̊mۂɎs܂B\n"
						"	ǂݍ݂LZ܂B\n"
					);
				#endif
				MOD__ReleaseSong( pMOD );
				return( FALSE );
			}

			pMOD->apXM_INSTRUMENT[ idxInst ] = pXM_INSTRUMENT ;

			/* ȃf[^Oɔr */
			if(	lMusDat - ofs < 29 ){
				#if (WARNING_LEVEL >= 2)
					LogMsg(
						"MOD__LoadSongAsXM : \n"
						"	f[^TCYsĂ܂BXM_INSTRUMENTi+28 ܂Łjǂݍ߂܂B\n"
						"	ǂݍ݂LZ܂B\n"
					);
				#endif
				MOD__ReleaseSong( pMOD );
				return( FALSE );
			}

			/* f[^ǂݍ */
			pXM_INSTRUMENT->InstrumentSize				= (S32)*((S32*)&pMusDat[ ofs +  0 ]);
			memcpy( &pXM_INSTRUMENT->aszInstrumentName[0]			,  &pMusDat[ ofs +  4 ] , 22 );
			pXM_INSTRUMENT->aszInstrumentName[22] = 0 ;		/* I_ */
			pXM_INSTRUMENT->InstrumentType				= (S32)*((U8*) &pMusDat[ ofs + 26 ]);
			pXM_INSTRUMENT->NumberOfSamplesInInstrument	= (S32)*((U16*)&pMusDat[ ofs + 27 ]);

			#if (WARNING_LEVEL >= 3)
				LogMsg(
					"MOD__LoadSongAsXM : \n"
					"	pXM_INSTRUMENT->InstrumentSize              %d \n"
					"	pXM_INSTRUMENT->aszInstrumentName           %s \n"
					"	pXM_INSTRUMENT->InstrumentType              %d \n"
					"	pXM_INSTRUMENT->NumberOfSamplesInInstrument %d \n"
					,pXM_INSTRUMENT->InstrumentSize
					,pXM_INSTRUMENT->aszInstrumentName
					,pXM_INSTRUMENT->InstrumentType
					,pXM_INSTRUMENT->NumberOfSamplesInInstrument
				);
			#endif

			/* ȃf[^Oɔr */
			if(	pXM_INSTRUMENT->NumberOfSamplesInInstrument > MAX_SAMPLES_IN_INSTRUMENT ){
				#if (WARNING_LEVEL >= 2)
					LogMsg(
						"MOD__LoadSongAsXM : \n"
						"	ȉ̒lsłB\n"
						"	pXM_INSTRUMENT->NumberOfSamplesInInstrument = %d \n"
						"	ǂݍ݂LZ܂B\n"
					);
				#endif
				MOD__ReleaseSong( pMOD );
				return( FALSE );
			}

			if(	pXM_INSTRUMENT->NumberOfSamplesInInstrument == 0 ){
				ofs += pXM_INSTRUMENT->InstrumentSize ;

			} else {
				/* ȃf[^Oɔr */
				if(	lMusDat - ofs < 243 ){
					#if (WARNING_LEVEL >= 2)
						LogMsg(
							"MOD__LoadSongAsXM : \n"
							"	f[^TCYsĂ܂BXM_INSTRUMENTi+29 ȍ~jǂݍ߂܂B\n"
							"	ǂݍ݂LZ܂B\n"
						);
					#endif
					MOD__ReleaseSong( pMOD );
					return( FALSE );
				}

				/* f[^ǂݍ */
				pXM_INSTRUMENT->SampleHeaderSize			= (S32)*((S32*)&pMusDat[ ofs +  29 ]);
				memcpy( &pXM_INSTRUMENT->aSampleNumberForAllNotes[0]	,  &pMusDat[ ofs +  33 ] , 96 );
				memcpy( &pXM_INSTRUMENT->aPointsForVolumeEnvelope[0]	,  &pMusDat[ ofs + 129 ] , 48 );
				memcpy( &pXM_INSTRUMENT->aPointsForPanningEnvelope[0]	,  &pMusDat[ ofs + 177 ] , 48 );
				pXM_INSTRUMENT->NumberOfVolumePoints		= (S32)*((U8*) &pMusDat[ ofs + 225 ]);
				pXM_INSTRUMENT->NumberOfPanningPoints		= (S32)*((U8*) &pMusDat[ ofs + 226 ]);
				pXM_INSTRUMENT->VolumeSustainPoint			= (S32)*((U8*) &pMusDat[ ofs + 227 ]);
				pXM_INSTRUMENT->VolumeLoopStartPoint		= (S32)*((U8*) &pMusDat[ ofs + 228 ]);
				pXM_INSTRUMENT->VolumeLoopEndPoint			= (S32)*((U8*) &pMusDat[ ofs + 229 ]);
				pXM_INSTRUMENT->PanningSustainPoint			= (S32)*((U8*) &pMusDat[ ofs + 230 ]);
				pXM_INSTRUMENT->PanningLoopStartPoint		= (S32)*((U8*) &pMusDat[ ofs + 231 ]);
				pXM_INSTRUMENT->PanningLoopEndPoint			= (S32)*((U8*) &pMusDat[ ofs + 232 ]);
				pXM_INSTRUMENT->VolumeType					= (S32)*((U8*) &pMusDat[ ofs + 233 ]);
				pXM_INSTRUMENT->PanningType					= (S32)*((U8*) &pMusDat[ ofs + 234 ]);
				pXM_INSTRUMENT->AutoVibratoType				= (S32)*((U8*) &pMusDat[ ofs + 235 ]);
				pXM_INSTRUMENT->AutoVibratoSweep			= (S32)*((U8*) &pMusDat[ ofs + 236 ]);
				pXM_INSTRUMENT->AutoVibratoDepth			= (S32)*((U8*) &pMusDat[ ofs + 237 ]);
				pXM_INSTRUMENT->AutoVibratoRate				= (S32)*((U8*) &pMusDat[ ofs + 238 ]);
				pXM_INSTRUMENT->VolumeFadeout				= (S32)*((U16*)&pMusDat[ ofs + 239 ]);
				pXM_INSTRUMENT->Reserved					= (S32)*((U16*)&pMusDat[ ofs + 241 ]);
				ofs += pXM_INSTRUMENT->InstrumentSize ;

				#if (WARNING_LEVEL >= 3)
					LogMsg(
						"MOD__LoadSongAsXM : \n"
						"	pXM_INSTRUMENT->SampleHeaderSize      %d \n"
						"	pXM_INSTRUMENT->NumberOfVolumePoints  %d \n"
						"	pXM_INSTRUMENT->NumberOfPanningPoints %d \n"
						"	pXM_INSTRUMENT->VolumeSustainPoint    %d \n"
						"	pXM_INSTRUMENT->VolumeLoopStartPoint  %d \n"
						"	pXM_INSTRUMENT->VolumeLoopEndPoint    %d \n"
						"	pXM_INSTRUMENT->PanningSustainPoint   %d \n"
						"	pXM_INSTRUMENT->PanningLoopStartPoint %d \n"
						"	pXM_INSTRUMENT->PanningLoopEndPoint   %d \n"
						"	pXM_INSTRUMENT->VolumeType            %d \n"
						"	pXM_INSTRUMENT->PanningType           %d \n"
						"	pXM_INSTRUMENT->VibratoType           %d \n"
						"	pXM_INSTRUMENT->VibratoSweep          %d \n"
						"	pXM_INSTRUMENT->VibratoDepth          %d \n"
						"	pXM_INSTRUMENT->VibratoRate           %d \n"
						"	pXM_INSTRUMENT->VolumeFadeout         %d \n"
						"	pXM_INSTRUMENT->Reserved              %d \n"
						,pXM_INSTRUMENT->SampleHeaderSize
						,pXM_INSTRUMENT->NumberOfVolumePoints
						,pXM_INSTRUMENT->NumberOfPanningPoints
						,pXM_INSTRUMENT->VolumeSustainPoint
						,pXM_INSTRUMENT->VolumeLoopStartPoint
						,pXM_INSTRUMENT->VolumeLoopEndPoint
						,pXM_INSTRUMENT->PanningSustainPoint
						,pXM_INSTRUMENT->PanningLoopStartPoint
						,pXM_INSTRUMENT->PanningLoopEndPoint
						,pXM_INSTRUMENT->VolumeType
						,pXM_INSTRUMENT->PanningType
						,pXM_INSTRUMENT->AutoVibratoType
						,pXM_INSTRUMENT->AutoVibratoSweep
						,pXM_INSTRUMENT->AutoVibratoDepth
						,pXM_INSTRUMENT->AutoVibratoRate
						,pXM_INSTRUMENT->VolumeFadeout
						,pXM_INSTRUMENT->Reserved
					);

					#if 1
						/* eL[Ɋ蓖ĂꂽTvOԍ\ */
						{
							S32	i , j ;
							LogMsg( "	pXM_INSTRUMENT->aSampleNumberForAllNotes[] = { \n" );
							for( i=0 ; i<96 ; i+=12 ){
								LogMsg( "		" );
								for( j=i ; j<i+12 ; j++ ){
									LogMsg(
										"%03d "
										,pXM_INSTRUMENT->aSampleNumberForAllNotes[j]
									);
								}
								LogMsg( "\n" );
							}
							LogMsg( "	} \n" );
						}
					#endif
				#endif


				/* ȃf[^OɏC */
				if(	pXM_INSTRUMENT->NumberOfVolumePoints	> 12 ) pXM_INSTRUMENT->NumberOfVolumePoints		= 12 ;
				if(	pXM_INSTRUMENT->NumberOfPanningPoints	> 12 ) pXM_INSTRUMENT->NumberOfPanningPoints	= 12 ;
				if(	pXM_INSTRUMENT->VolumeSustainPoint		> 11 ) pXM_INSTRUMENT->VolumeSustainPoint		= 11 ;
				if(	pXM_INSTRUMENT->VolumeLoopStartPoint	> 11 ) pXM_INSTRUMENT->VolumeLoopStartPoint		= 11 ;
				if(	pXM_INSTRUMENT->VolumeLoopEndPoint		> 11 ) pXM_INSTRUMENT->VolumeLoopEndPoint		= 11 ;
				if(	pXM_INSTRUMENT->PanningSustainPoint		> 11 ) pXM_INSTRUMENT->PanningSustainPoint		= 11 ;
				if(	pXM_INSTRUMENT->PanningLoopStartPoint	> 11 ) pXM_INSTRUMENT->PanningLoopStartPoint	= 11 ;
				if(	pXM_INSTRUMENT->PanningLoopEndPoint		> 11 ) pXM_INSTRUMENT->PanningLoopEndPoint		= 11 ;

				/* Gx[vωɓWJăe[u */
				{
					S32	idxPoint ;

					if(	pXM_INSTRUMENT->VolumeType & ENV_ON ){
						for( idxPoint = 0 ; idxPoint <= 11 ; idxPoint++ ){
							/* EĒGx[vf[^␳ */
							if(	pXM_INSTRUMENT->aPointsForVolumeEnvelope[ idxPoint ].x > 324 ){
								pXM_INSTRUMENT->aPointsForVolumeEnvelope[ idxPoint ].x = 324 ;
							}
							/* I[o[t[ */
							if(	pXM_INSTRUMENT->aPointsForVolumeEnvelope[ idxPoint ].y > 255 ){
								pXM_INSTRUMENT->aPointsForVolumeEnvelope[ idxPoint ].y = 255 ;
							}
						}

						for( idxPoint = 0 ; idxPoint < pXM_INSTRUMENT->NumberOfVolumePoints - 1 ; idxPoint++ ){
							S32	x , y , dx , dy ;

							x	= pXM_INSTRUMENT->aPointsForVolumeEnvelope[ idxPoint ].x ;
							y	= pXM_INSTRUMENT->aPointsForVolumeEnvelope[ idxPoint ].y ;
							dx	= pXM_INSTRUMENT->aPointsForVolumeEnvelope[ idxPoint + 1 ].x - x ;
							dy	= pXM_INSTRUMENT->aPointsForVolumeEnvelope[ idxPoint + 1 ].y - y ;

							/* ׂ̋Ԃ܂Ő`⊮ */
							if(	dx ){
								for( x = 0 ; x < dx ; x++ ){
									pXM_INSTRUMENT->VolumeEnvelopeTable[
										x + pXM_INSTRUMENT->aPointsForVolumeEnvelope[ idxPoint ].x
									] =	(U8)(y + dy * x / dx) ;
								}
							}

							/* I_ɒBAŏIle[u[܂ňێ */
							if( idxPoint == pXM_INSTRUMENT->NumberOfVolumePoints - 2 ){
								for( x = pXM_INSTRUMENT->aPointsForVolumeEnvelope[ idxPoint + 1 ].x ; x < 325 ; x++ ){
									U16	Val = pXM_INSTRUMENT->aPointsForVolumeEnvelope[ idxPoint + 1 ].y ;
									pXM_INSTRUMENT->VolumeEnvelopeTable[ x ] = (U8)Val ;
								}
							}
						}

						/* _io[Ae[uItZbgɕϊ */
						pXM_INSTRUMENT->VolumeSustainPoint
						=	pXM_INSTRUMENT->aPointsForVolumeEnvelope[ pXM_INSTRUMENT->VolumeSustainPoint ].x ;
						pXM_INSTRUMENT->VolumeLoopStartPoint
						=	pXM_INSTRUMENT->aPointsForVolumeEnvelope[ pXM_INSTRUMENT->VolumeLoopStartPoint ].x ;
						pXM_INSTRUMENT->VolumeLoopEndPoint
						=	pXM_INSTRUMENT->aPointsForVolumeEnvelope[ pXM_INSTRUMENT->VolumeLoopEndPoint ].x ;

						/* [vԂ̒ 0 ̎́A[v𖳌 */
						if(	pXM_INSTRUMENT->VolumeLoopStartPoint == pXM_INSTRUMENT->VolumeLoopEndPoint ){
							pXM_INSTRUMENT->VolumeType &= ~ENV_LOOP ;
						}
					}

					if(	pXM_INSTRUMENT->PanningType & ENV_ON ){
						for( idxPoint = 0 ; idxPoint <= 11 ; idxPoint++ ){
							/* EĒGx[vf[^␳ */
							if(	pXM_INSTRUMENT->aPointsForPanningEnvelope[ idxPoint ].x > 324 ){
								pXM_INSTRUMENT->aPointsForPanningEnvelope[ idxPoint ].x = 324 ;
							}
							/* I[o[t[ */
							if(	pXM_INSTRUMENT->aPointsForVolumeEnvelope[ idxPoint ].y > 255 ){
								pXM_INSTRUMENT->aPointsForVolumeEnvelope[ idxPoint ].y = 255 ;
							}
						}

						for( idxPoint = 0 ; idxPoint < pXM_INSTRUMENT->NumberOfPanningPoints - 1 ; idxPoint++ ){
							S32 x , y , dx , dy ;

							x	= pXM_INSTRUMENT->aPointsForPanningEnvelope[ idxPoint ].x ;
							y	= pXM_INSTRUMENT->aPointsForPanningEnvelope[ idxPoint ].y ;
							dx	= pXM_INSTRUMENT->aPointsForPanningEnvelope[ idxPoint + 1 ].x - x ;
							dy	= pXM_INSTRUMENT->aPointsForPanningEnvelope[ idxPoint + 1 ].y - y ;

							/* ׂ̋Ԃ܂Ő`⊮ */
							if( dx ){
								for( x = 0 ; x < dx ; x++ ){
									pXM_INSTRUMENT->PanningEnvelopeTable[
										x + pXM_INSTRUMENT->aPointsForPanningEnvelope[ idxPoint ].x
									] =	(U8)(y + dy * x / dx) ;
								}
							}

							/* I_ɒBAŏIle[u[܂ňێ */
							if(	idxPoint == pXM_INSTRUMENT->NumberOfPanningPoints - 2 ){
								for( x = pXM_INSTRUMENT->aPointsForPanningEnvelope[ idxPoint + 1 ].x ; x < 325 ; x++ ){
									U16	Val = pXM_INSTRUMENT->aPointsForPanningEnvelope[ idxPoint + 1 ].y ;
									pXM_INSTRUMENT->PanningEnvelopeTable[ x ] = (U8)Val ;
								}
							}
						}

						/* _io[Ae[uItZbgɕϊ */
						pXM_INSTRUMENT->PanningSustainPoint
						=	pXM_INSTRUMENT->aPointsForPanningEnvelope[ pXM_INSTRUMENT->PanningSustainPoint ].x ;
						pXM_INSTRUMENT->PanningLoopStartPoint
						=	pXM_INSTRUMENT->aPointsForPanningEnvelope[ pXM_INSTRUMENT->PanningLoopStartPoint ].x ;
						pXM_INSTRUMENT->PanningLoopEndPoint
						=	pXM_INSTRUMENT->aPointsForPanningEnvelope[ pXM_INSTRUMENT->PanningLoopEndPoint ].x ;

						/* [vԂ̒ 0 ̎́A[v𖳌 */
						if(	pXM_INSTRUMENT->PanningLoopStartPoint == pXM_INSTRUMENT->PanningLoopEndPoint ){
							pXM_INSTRUMENT->PanningType &= ~ENV_LOOP ;
						}
					}
				}

				/*
					XM_SAMPLE ̓ǂݍ
					XM ̖ȃtH[}bg̓sAXebvQɕȂ΂ȂȂB
				*/
				{
					S32	idxLocalSample ;

					/* XebvP */
					for( idxLocalSample = 0
					;	 idxLocalSample < pXM_INSTRUMENT->NumberOfSamplesInInstrument
					;	 idxLocalSample++
					){
						S32	reserve ;
						S32	idxSample = idxInst * MAX_SAMPLES_IN_INSTRUMENT + idxLocalSample ;
						XM_SAMPLE	*pXM_SAMPLE = XM_SAMPLE__Create( );
						pMOD->apXM_SAMPLE[ idxSample ] = pXM_SAMPLE ;

						/* sH */
						if(	pXM_SAMPLE == NULL ){
							#if (WARNING_LEVEL >= 1)
								LogMsg(
									"MOD__LoadSongAsXM : \n"
									"	XM_SAMPLE \̂̊mۂɎs܂B\n"
									"	ǂݍ݂LZ܂B\n"
								);
							#endif
							MOD__ReleaseSong( pMOD );
							return( FALSE );
						}

						/* f[^ǂݍ */
						pXM_SAMPLE->SampleLength		= (S32)*((S32*)&pMusDat[ ofs +  0 ]);
						pXM_SAMPLE->SampleLoopStart		= (S32)*((S32*)&pMusDat[ ofs +  4 ]);
						pXM_SAMPLE->SampleLoopLength	= (S32)*((S32*)&pMusDat[ ofs +  8 ]);
						pXM_SAMPLE->Volume				= (S32)*((U8*) &pMusDat[ ofs + 12 ]);
						pXM_SAMPLE->FineTune			= (S32)*((S8*) &pMusDat[ ofs + 13 ]);
						pXM_SAMPLE->Type				= (S32)*((U8*) &pMusDat[ ofs + 14 ]);
						pXM_SAMPLE->Panning				= (S32)*((U8*) &pMusDat[ ofs + 15 ]);
						pXM_SAMPLE->RelativeNoteNumber	= (S32)*((S8*) &pMusDat[ ofs + 16 ]);
						pXM_SAMPLE->Reserved			= (S32)*((U8*) &pMusDat[ ofs + 17 ]);
						memcpy( &pXM_SAMPLE->aszSampleName[0]		,  &pMusDat[ ofs + 18 ] , 22 );
						pXM_SAMPLE->aszSampleName[22] = 0 ;		/* I_ */
						ofs += pXM_INSTRUMENT->SampleHeaderSize ;

						#if (WARNING_LEVEL >= 3)
							LogMsg(
								"MOD__LoadSongAsXM : \n"
								"	pXM_SAMPLE->SampleLength       %d \n"
								"	pXM_SAMPLE->SampleLoopStart    %d \n"
								"	pXM_SAMPLE->SampleLoopLength   %d \n"
								"	pXM_SAMPLE->Volume             %d \n"
								"	pXM_SAMPLE->FineTune           %d \n"
								"	pXM_SAMPLE->Type               %d \n"
								"	pXM_SAMPLE->Panning            %d \n"
								"	pXM_SAMPLE->RelativeNoteNumber %d \n"
								"	pXM_SAMPLE->Reserved           %d \n"
								"	pXM_SAMPLE->aszSampleName      %s \n"
								,pXM_SAMPLE->SampleLength
								,pXM_SAMPLE->SampleLoopStart
								,pXM_SAMPLE->SampleLoopLength
								,pXM_SAMPLE->Volume
								,pXM_SAMPLE->FineTune
								,pXM_SAMPLE->Type
								,pXM_SAMPLE->Panning
								,pXM_SAMPLE->RelativeNoteNumber
								,pXM_SAMPLE->Reserved
								,pXM_SAMPLE->aszSampleName
							);
						#endif

						/* [vԂ̒ 0 ܂́A 0 ȂA[v𖳌 */
						if(	pXM_SAMPLE->SampleLoopLength == 0
						||	pXM_SAMPLE->SampleLength == 0
						){
							pXM_SAMPLE->Type &= ~(SMP_LOOP | SMP_PINGPONGLOOP);
							pXM_SAMPLE->SampleLoopStart  = 0 ;
							pXM_SAMPLE->SampleLoopLength = 0 ;
						}

						if(	pXM_SAMPLE->Type & (SMP_LOOP | SMP_PINGPONGLOOP) ){
							/* ȃf[^Oɔr */
							if(	pXM_SAMPLE->SampleLength < pXM_SAMPLE->SampleLoopStart + pXM_SAMPLE->SampleLoopLength ){
								#if (WARNING_LEVEL >= 2)
									LogMsg(
										"MOD__LoadSongAsXM : \n"
										"	TvOf[^TCYƁA[vԂ̒̐Ă܂B\n"
										"	ǂݍ݂LZ܂B\n"
									);
								#endif
								MOD__ReleaseSong( pMOD );
								return( FALSE );
							}
						}

						/* [vWJ̃TvOf[^̑S */
						reserve = pXM_SAMPLE->SampleLength ;
						if(	pXM_SAMPLE->Type & SMP_PINGPONGLOOP ) reserve += pXM_SAMPLE->SampleLoopLength ;

						/* KvȂATvOf[^̈̃m */
						if(	reserve ){
							/*
								v`mCY΍̂߁A]ɊmہB
								reserve ͗vfłȂoCgł_ɒӁB
							*/
//							void	*pSampleData = AllocMemory( reserve + 512 );
							void	*pSampleData = malloc( reserve + 512 );
							pXM_SAMPLE->pSampleData = pSampleData ;

							/* sH */
							if(	pSampleData == NULL ){
								#if (WARNING_LEVEL >= 1)
									LogMsg(
										"MOD__LoadSongAsXM : \n"
										"	TvOf[^ǂݍݐ惁̊mۂɎs܂B\n"
										"	ǂݍ݂LZ܂B\n"
									);
								#endif
								MOD__ReleaseSong( pMOD );
								return( FALSE );
							}
						} else {
							pXM_SAMPLE->pSampleData	= NULL ;
						}
					}

					/* XebvQ */
					for( idxLocalSample = 0
					;	 idxLocalSample < pXM_INSTRUMENT->NumberOfSamplesInInstrument
					;	 idxLocalSample++
					){
						S32	idxSample = idxInst * MAX_SAMPLES_IN_INSTRUMENT + idxLocalSample ;
						XM_SAMPLE	*pXM_SAMPLE = pMOD->apXM_SAMPLE[ idxSample ];

						/* mۂĂȂ珈 */
						if(	pXM_SAMPLE->pSampleData != NULL ){
							/* ȃf[^Oɔr */
							if(	lMusDat - ofs < pXM_SAMPLE->SampleLength ){
								#if (WARNING_LEVEL >= 2)
									LogMsg(
										"MOD__LoadSongAsXM : \n"
										"	f[^TCYsĂ܂BTvOf[^ǂݍ߂܂B\n"
										"	ǂݍ݂LZ܂B\n"
									);
								#endif
								MOD__ReleaseSong( pMOD );
								return( FALSE );
							}

							/* g`f[^̓ǂݍ */
							memcpy( pXM_SAMPLE->pSampleData , &pMusDat[ ofs ] , pXM_SAMPLE->SampleLength );
							ofs += pXM_SAMPLE->SampleLength ;

							pXM_SAMPLE->VoiceMode = VM_ON ;
							if(	pXM_SAMPLE->Type & (SMP_LOOP | SMP_PINGPONGLOOP) ){
								pXM_SAMPLE->VoiceMode |= VM_LOOP ;
							}

							/*
								l -> ےl ̕ϊB
								I[o[t[ĂA␳Ȃ̂B
							*/
							if(	pXM_SAMPLE->Type & SMP_16BIT ){
								S32	Cnt		= pXM_SAMPLE->SampleLength >> 1 ;	/* PvfQoCg */
								S32	OldVal	= 0 ;
								S32	NewVal	= 0 ;
								S16	*pScan	= (S16 *)pXM_SAMPLE->pSampleData ;

								pXM_SAMPLE->VoiceMode |= VM_16BIT ;
								while( Cnt-- > 0 ){
									NewVal = *pScan + OldVal ;
									*pScan++ = (S16)NewVal ;
									OldVal = NewVal ;
								}
							} else {
								S32	Cnt		= pXM_SAMPLE->SampleLength ;		/* PvfPoCg */
								S32	OldVal	= 0 ;
								S32	NewVal	= 0 ;
								S8	*pScan	= (S8 *)pXM_SAMPLE->pSampleData ;

								while( Cnt-- > 0 ){
									NewVal = *pScan + OldVal ;
									*pScan++ = (S8)NewVal ;
									OldVal = NewVal ;
								}
							}

							/* s|[vWJ */
							if(	pXM_SAMPLE->Type & SMP_PINGPONGLOOP ){
								pXM_SAMPLE->VoiceMode |= VM_LOOP ;
								if(	pXM_SAMPLE->Type & SMP_16BIT ){
									S32	Cnt = pXM_SAMPLE->SampleLoopLength >> 1 ;
									S8	*pSampleData = pXM_SAMPLE->pSampleData ;
									S16	*pSrc	= (S16 *)(pSampleData
														+ pXM_SAMPLE->SampleLoopStart
														+ pXM_SAMPLE->SampleLoopLength
														- 2 );
									S16	*pDst	= (S16 *)(pSampleData
														+ pXM_SAMPLE->SampleLoopStart
														+ pXM_SAMPLE->SampleLoopLength
														);

									while( Cnt-- > 0 ) *pDst++ = *pSrc-- ;
								} else {
									S32	Cnt = pXM_SAMPLE->SampleLoopLength ;
									S8	*pSampleData = pXM_SAMPLE->pSampleData ;
									S8	*pSrc	= (S8 *)( pSampleData
														+ pXM_SAMPLE->SampleLoopStart
														+ pXM_SAMPLE->SampleLoopLength
														- 2 );
									S8	*pDst	= (S8 *)( pSampleData
														+ pXM_SAMPLE->SampleLoopStart
														+ pXM_SAMPLE->SampleLoopLength
														);

									while( Cnt-- > 0 ) *pDst++ = *pSrc-- ;
								}
								/* WĴŁA[vԂ̒͂Q{ɂȂ */
								pXM_SAMPLE->SampleLoopLength <<= 1 ;
							}

							/* 16 BIT Tv́A̒Pʂϊ */
							if(	pXM_SAMPLE->Type & SMP_16BIT ){
								pXM_SAMPLE->SampleLength	 >>= 1 ;
								pXM_SAMPLE->SampleLoopStart	 >>= 1 ;
								pXM_SAMPLE->SampleLoopLength >>= 1 ;
							}

							if(	pXM_SAMPLE->VoiceMode & VM_LOOP ){
								/* SampleLength ̍ĎZo */
								pXM_SAMPLE->SampleLength = pXM_SAMPLE->SampleLoopStart + pXM_SAMPLE->SampleLoopLength ;

								/* `⊮̘Â߁A[ɂPvfRs[ */
								if(	pXM_SAMPLE->Type & SMP_16BIT ){
									S16	*pSampleData = (S16*)pXM_SAMPLE->pSampleData ;
									pSampleData[ pXM_SAMPLE->SampleLength ] = pSampleData[ pXM_SAMPLE->SampleLoopStart ];
								} else {
									S8	*pSampleData = (S8*)pXM_SAMPLE->pSampleData ;
									pSampleData[ pXM_SAMPLE->SampleLength ] = pSampleData[ pXM_SAMPLE->SampleLoopStart ];
								}

							} else {
								/* L[Itv`mCY΍ig`̍ŏIvfXɌj*/
								if(	pXM_SAMPLE->Type & SMP_16BIT ){
									S16	*pSampleData = (S16*)pXM_SAMPLE->pSampleData ;
									S32	LastVal_ = pSampleData[ pXM_SAMPLE->SampleLength - 1 ] << SFT ;
									S32	i ;
									for( i=0 ; i<256 ; i++ ){
										pSampleData[ pXM_SAMPLE->SampleLength + i ] = (S16)(LastVal_ >> SFT) ;
										LastVal_ -= LastVal_ >> 6 ;
									}
								} else {
									S8	*pSampleData = (S8*)pXM_SAMPLE->pSampleData ;
									S32	LastVal_ = pSampleData[ pXM_SAMPLE->SampleLength - 1 ] << SFT ;
									S32	i ;
									for( i=0 ; i<256 ; i++ ){
										pSampleData[ pXM_SAMPLE->SampleLength + i ] = (S8)(LastVal_ >> SFT) ;
										LastVal_ -= LastVal_ >> 6 ;
									}
								}
								pXM_SAMPLE->SampleLength += 255 ;	/* 1 vf̗]T */
							}
						}
					}
				}

				/* S Note Ή̃TvOf[^ւ̃|C^[Őɋ߂Ă */
				{
					S32	idxNote ;
					for( idxNote = 0 ; idxNote <= 95 ; idxNote++ ){
						S32	idxSample = pXM_INSTRUMENT->aSampleNumberForAllNotes[ idxNote ];

						if(	0 <= idxSample
						&&	idxSample < MAX_SAMPLES_IN_INSTRUMENT
						){
							pXM_INSTRUMENT->apAllNoteXM_SAMPLE[ idxNote ]
							=	pMOD->apXM_SAMPLE[ idxInst * MAX_SAMPLES_IN_INSTRUMENT + idxSample ];
						} else {
							pXM_INSTRUMENT->apAllNoteXM_SAMPLE[ idxNote ] = NULL ;
						}
					}
				}
			}
		}
	}

	return( TRUE );
}



/*
	MOD `Ƃ݂Ȃēǂݍ

	ߒlETRUE  = 
		EFALSE = s
*/
static S32 MOD__LoadSongAsMOD(
	 MOD	*pMOD
	,void	*pMusDat_
	,S32	 lMusDat
){
	U8	*pMusDat = (U8*)pMusDat_ ;
	S32	i ;
	S32	ofs = 0 ;

	if(	pMOD == NULL ) return( FALSE );

	/* ȃf[^Oɔr */
	if(	lMusDat < 1080+4 ){
		#if (WARNING_LEVEL >= 2)
			LogMsg(
				"MOD__LoadSongAsMOD : \n"
				"	f[^TCYsĂ܂B\n"
				"	ǂݍ݂LZ܂B\n"
			);
		#endif
		MOD__ReleaseSong( pMOD );
		return( FALSE );
	}

	/* f[^ǂݍ */
	memcpy( &pMOD->XmId.aszModuleName[0] , &pMusDat[ ofs + 0 ] , 20 );
	pMOD->XmId.aszModuleName[19] = 0 ;	/* I_ */
	ofs += 20 ;

	#if (WARNING_LEVEL >= 2)
		LogMsg(
			"MOD__LoadSongAsMOD : ModName = %s \n"
			,pMOD->XmId.aszModuleName
		);
	#endif

	/*
		tH[}bgʂATvOf[^ƁA`lmB
		ʎqꍇ́Äʒup^[f[^̏o_ƂȂA
		TvOf[^ 15 ނƂȂ邪Â悤ȌÂf[^ɂ͑ΉȂB
	*/
	{
		struct {
			char	*pszExt ;
			S32		idxChannel ;
			S32		idxInst ;
		} ExtInfo[] = {
			 { "M.K." , 4 , 31 }		/* protracker 4 channel */
			,{ "M!K!" , 4 , 31 }		/* protracker 4 channelip^[ Row ς炵Hj*/
			,{ "M&K!" , 4 , 31 }
			,{ "FLT4" , 4 , 31 }		/* startracker 4 channel */
			,{ "FLT8" , 4 , 31 }		/* A4ch Ƃ炵B*/
			,{ "N.T." , 4 , 15 }		/* Â 0xFxx R}hɂe|ݒLɂȂ΂ȂȂ */
			,{ "CD81" , 8 , 31 }		/* atari oktalyzer 8 channel */
			,{ "OKTA" , 8 , 31 }		/* atari oktalyzer 8 channel */
			,{ "TDZ1" , 1 , 31 }
			,{ "TDZ2" , 2 , 31 }
			,{ "TDZ3" , 3 , 31 }
			,{ "TDZ4" , 4 , 31 }
			,{ "TDZ5" , 5 , 31 }
			,{ "TDZ6" , 6 , 31 }
			,{ "TDZ7" , 7 , 31 }
			,{ "TDZ8" , 8 , 31 }
			,{ "TDZ9" , 9 , 31 }
			,{ "1CHN" , 1 , 31 }
			,{ "2CHN" , 2 , 31 }
			,{ "3CHN" , 3 , 31 }
			,{ "4CHN" , 4 , 31 }		/* fasttracker 4 channel */
			,{ "5CHN" , 5 , 31 }
			,{ "6CHN" , 6 , 31 }		/* fasttracker 6 channel */
			,{ "7CHN" , 7 , 31 }
			,{ "8CHN" , 8 , 31 }		/* fasttracker 8 channel */
			,{ "9CHN" , 9 , 31 }
			,{ "10CH" ,10 , 31 }
			,{ "11CH" ,11 , 31 }
			,{ "12CH" ,12 , 31 }
			,{ "13CH" ,13 , 31 }
			,{ "14CH" ,14 , 31 }
			,{ "15CH" ,15 , 31 }
			,{ "16CH" ,16 , 31 }
			,{ "17CH" ,17 , 31 }
			,{ "18CH" ,18 , 31 }
			,{ "19CH" ,19 , 31 }
			,{ "20CH" ,20 , 31 }
			,{ "21CH" ,21 , 31 }
			,{ "22CH" ,22 , 31 }
			,{ "23CH" ,23 , 31 }
			,{ "24CH" ,24 , 31 }
			,{ "25CH" ,25 , 31 }
			,{ "26CH" ,26 , 31 }
			,{ "27CH" ,27 , 31 }
			,{ "28CH" ,28 , 31 }
			,{ "29CH" ,29 , 31 }
			,{ "30CH" ,30 , 31 }
			,{ "31CH" ,31 , 31 }
			,{ "32CH" ,32 , 31 }
			,{ "16CN" ,16 , 31 }		/* taketracker 16 channel */
			,{ "32CN" ,32 , 31 }		/* taketracker 32 channel */
			,{ "    " , 4 , 15 }
			,{  NULL  , 0 ,  0 }
		};

		#if (WARNING_LEVEL >= 2)
		{
			char	aExt[5];
			aExt[0] = pMusDat[1080] ;
			aExt[1] = pMusDat[1081] ;
			aExt[2] = pMusDat[1082] ;
			aExt[3] = pMusDat[1083] ;
			aExt[4] = 0 ;

			LogMsg(
				"MOD__LoadSongAsMOD : +1080 ʎq = [%s] \n"
				,aExt
			);
		}
		#endif

		i = 0 ;
		while( -1 ){
			/* I_ɒBُI */
			if(	ExtInfo[ i ].pszExt == NULL ){
				#if (WARNING_LEVEL >= 2)
					LogMsg(
						"MOD__LoadSongAsMOD : "
						"	s +1080 ʎqłBǂݍ݂LZ܂B\n"
					);
				#endif
				MOD__ReleaseSong( pMOD );
				return( FALSE );
			}

			/* ʎqvAF */
			if(	pMusDat[1080] == ExtInfo[ i ].pszExt[0]
			&&	pMusDat[1081] == ExtInfo[ i ].pszExt[1]
			&&	pMusDat[1082] == ExtInfo[ i ].pszExt[2]
			&&	pMusDat[1083] == ExtInfo[ i ].pszExt[3]
			){
				pMOD->XmHeader.NumberOfChannels		= ExtInfo[ i ].idxChannel ;
				pMOD->XmHeader.NumberOfInstruments	= ExtInfo[ i ].idxInst ;
				#if (WARNING_LEVEL >= 3)
					LogMsg(
						"MOD__LoadSongAsMOD : \n"
						"	+1080 ʎq̔Fɐ܂B\n"
						"	`l = %d , TvOf[^ = %d \n"
						,pMOD->XmHeader.NumberOfChannels
						,pMOD->XmHeader.NumberOfInstruments
					);
				#endif
				break ;
			}

			i++ ;
		}
	}


	/* TvOf[^̏擾 */
	{
		S32	idxInst ;

		/* XM_SAMPLE */
		for( idxInst = 0 ; idxInst < pMOD->XmHeader.NumberOfInstruments ; idxInst++ ){
			S32	idxSample = idxInst * MAX_SAMPLES_IN_INSTRUMENT ;
			XM_SAMPLE		*pXM_SAMPLE ; 

			/* XM_SAMPLE \̂̊m */
			pMOD->apXM_SAMPLE[ idxSample ] = pXM_SAMPLE = XM_SAMPLE__Create( );

			/* sH */
			if(	pXM_SAMPLE == NULL ){
				#if (WARNING_LEVEL >= 1)
					LogMsg(
						"MOD__LoadSongAsMOD : \n"
						"	XM_SAMPLE \̂̊mۂɎs܂B\n"
						"	ǂݍ݂LZ܂B\n"
					);
				#endif
				MOD__ReleaseSong( pMOD );
				return( FALSE );
			}

			/* XM_SAMPLE \̂̏ */
			{
				pXM_SAMPLE->Type				= 0 ;
				pXM_SAMPLE->Panning				= 0x80 ;
				pXM_SAMPLE->RelativeNoteNumber	= 0 ;
				pXM_SAMPLE->Reserved			= 0 ;

				/* TvOf[^̖O擾 */
				memcpy( &pXM_SAMPLE->aszSampleName[0] , &pMusDat[ ofs ] , 21 );
				pXM_SAMPLE->aszSampleName[21] = 0 ;		/* I_ */
				ofs += 22 ;

				/*
					TvOf[^̒擾B
					Q{Ă͂߂āAoCgƂȂB
				*/
				pXM_SAMPLE->SampleLength = (U32)( ((U32)pMusDat[ ofs + 0 ] << 8)
												| ((U32)pMusDat[ ofs + 1 ] << 0) );
				pXM_SAMPLE->SampleLength *= 2 ;
				ofs += 2 ;

				/*
					K̉Kɍ킹邽߂̏ClB
					 4 bit  0 ł邱ƁB
				*/
				{
					S32	Val = pMusDat[ ofs ] & 15 ;
					if(	Val >= 8 ){
						Val = Val - 16 ;
					}
					pXM_SAMPLE->FineTune = Val << 4 ;
				}
				ofs++ ;

				/* TvOf[^̃ftHgʁi 0 - 64 ̒lj*/
				pXM_SAMPLE->Volume = pMusDat[ ofs ];
				ofs++ ;

				/*
					TvOf[^̃[vJnʒuB
					Q{Ă͂߂āAoCgƂȂB
				*/
				pXM_SAMPLE->SampleLoopStart	= (S32)( ((U32)pMusDat[ ofs + 0 ] << 8)
													|((U32)pMusDat[ ofs + 1 ] << 0) );
				pXM_SAMPLE->SampleLoopStart	*= 2 ;
				ofs += 2 ;

				/*
					TvOf[^̃[vԂ̒B
					Q{Ă͂߂āAoCgƂȂB
				*/
				pXM_SAMPLE->SampleLoopLength = (S32)( ((U32)pMusDat[ ofs + 0 ] << 8)
													| ((U32)pMusDat[ ofs + 1 ] << 0) );
				pXM_SAMPLE->SampleLoopLength *= 2 ;
				ofs += 2 ;

				/* TvÕ[vĐL̔ */
				if(	pXM_SAMPLE->SampleLoopLength <= 2
				||	pXM_SAMPLE->SampleLength == 0
				){
					pXM_SAMPLE->Type &= ~(SMP_LOOP | SMP_PINGPONGLOOP);
					pXM_SAMPLE->SampleLoopStart  = 0 ;
					pXM_SAMPLE->SampleLoopLength = 0 ;
				} else {
					pXM_SAMPLE->Type |= SMP_LOOP ;

					/* ȃf[^Oɔr */
					if(	pXM_SAMPLE->SampleLength < pXM_SAMPLE->SampleLoopStart + pXM_SAMPLE->SampleLoopLength ){
						#if (WARNING_LEVEL >= 2)
							LogMsg(
								"MOD__LoadSongAsMOD : \n"
								"	TvOf[^TCYƁA[vԂ̒̐Ă܂B\n"
								"	ǂݍ݂LZ܂B\n"
							);
						#endif
						MOD__ReleaseSong( pMOD );
						return( FALSE );
					}
				}

				/* ǂ݂݌ʂ̃j^O */
				#if (WARNING_LEVEL >= 3)
					LogMsg(
						"MOD__LoadSongAsMOD : \n"
						"	pXM_SAMPLE->SampleLength       %d \n"
						"	pXM_SAMPLE->SampleLoopStart    %d \n"
						"	pXM_SAMPLE->SampleLoopLength   %d \n"
						"	pXM_SAMPLE->Volume             %d \n"
						"	pXM_SAMPLE->FineTune           %d \n"
						"	pXM_SAMPLE->Type               %d \n"
						"	pXM_SAMPLE->Panning            %d \n"
						"	pXM_SAMPLE->RelativeNoteNumber %d \n"
						"	pXM_SAMPLE->Reserved           %d \n"
						"	pXM_SAMPLE->aszSampleName      %s \n"
						,pXM_SAMPLE->SampleLength
						,pXM_SAMPLE->SampleLoopStart
						,pXM_SAMPLE->SampleLoopLength
						,pXM_SAMPLE->Volume
						,pXM_SAMPLE->FineTune
						,pXM_SAMPLE->Type
						,pXM_SAMPLE->Panning
						,pXM_SAMPLE->RelativeNoteNumber
						,pXM_SAMPLE->Reserved
						,pXM_SAMPLE->aszSampleName
					);
				#endif
			}
		}

		/* XM_INSTRUMENT */
		for( idxInst = 0 ; idxInst < pMOD->XmHeader.NumberOfInstruments ; idxInst++ ){
			S32	idxSample = idxInst * MAX_SAMPLES_IN_INSTRUMENT ;
			XM_INSTRUMENT	*pXM_INSTRUMENT ;

			/* XM_INSTRUMENT \̂̊m */
			pMOD->apXM_INSTRUMENT[ idxInst ] = pXM_INSTRUMENT = XM_INSTRUMENT__Create( );

			/* sH */
			if(	pXM_INSTRUMENT == NULL ){
				#if (WARNING_LEVEL >= 1)
					LogMsg(
						"MOD__LoadSongAsMOD : \n"
						"	XM_INSTRUMENT \̂̊mۂɎs܂B\n"
						"	ǂݍ݂LZ܂B\n"
					);
				#endif
				MOD__ReleaseSong( pMOD );
				return( FALSE );
			}

			/* XM_INSTRUMENT \̂̏ */
			{
				pXM_INSTRUMENT->InstrumentSize				= 0 ;
				pXM_INSTRUMENT->aszInstrumentName[0]		= 0 ;
				pXM_INSTRUMENT->InstrumentType				= 0 ;
				pXM_INSTRUMENT->NumberOfSamplesInInstrument	= 1 ;
				pXM_INSTRUMENT->SampleHeaderSize			= 0 ;
				for( i=0 ; i<96 ; i++ ){
					pXM_INSTRUMENT->aSampleNumberForAllNotes[i] = (U8)idxInst ;
				}
				for( i=0 ; i<12 ; i++ ){
					pXM_INSTRUMENT->aPointsForVolumeEnvelope[i].x	= 0 ;
					pXM_INSTRUMENT->aPointsForVolumeEnvelope[i].y	= 0 ;
					pXM_INSTRUMENT->aPointsForPanningEnvelope[i].x	= 0 ;
					pXM_INSTRUMENT->aPointsForPanningEnvelope[i].y	= 0 ;
				}
				pXM_INSTRUMENT->NumberOfVolumePoints		= 0 ;
				pXM_INSTRUMENT->NumberOfPanningPoints		= 0 ;
				pXM_INSTRUMENT->VolumeSustainPoint			= 0 ;
				pXM_INSTRUMENT->VolumeLoopStartPoint		= 0 ;
				pXM_INSTRUMENT->VolumeLoopEndPoint			= 0 ;
				pXM_INSTRUMENT->PanningSustainPoint			= 0 ;
				pXM_INSTRUMENT->PanningLoopStartPoint		= 0 ;
				pXM_INSTRUMENT->PanningLoopEndPoint			= 0 ;
				pXM_INSTRUMENT->VolumeType					= 0 ;
				pXM_INSTRUMENT->PanningType					= 0 ;
				pXM_INSTRUMENT->AutoVibratoType				= 0 ;
				pXM_INSTRUMENT->AutoVibratoSweep			= 0 ;
				pXM_INSTRUMENT->AutoVibratoDepth			= 0 ;
				pXM_INSTRUMENT->AutoVibratoRate				= 0 ;
				pXM_INSTRUMENT->VolumeFadeout				= 0 ;
				pXM_INSTRUMENT->Reserved					= 0 ;

				for( i=0 ; i<96 ; i++ ){
					pXM_INSTRUMENT->apAllNoteXM_SAMPLE[ i ]	= pMOD->apXM_SAMPLE[ idxSample ];
				}
				for( i=0 ; i<325 ; i++ ){
					pXM_INSTRUMENT->VolumeEnvelopeTable[ i ]	= 0 ;
					pXM_INSTRUMENT->PanningEnvelopeTable[ i ]	= 0 ;
				}
			}
		}
	}


	/* I[_[e[ȗSi1 ` 128j*/
	pMOD->XmHeader.SongLength = pMusDat[ ofs ];
	ofs++ ;

	/*
		NoiseTracker I[_[e[ũs[g|CgƂoCgB
		ProTracker W[ł͖ӖȂ̂ŁAXLbvB
	*/
	ofs++ ;


	/* p^[I[_[e[uƁAp^[f[^̎擾 */
	{
		S32	idxPattern ;
		S32	idxRow ;
		S32	idxCannel ;

		/* p^[I[_[e[u̎擾iMOD `ł́A128 byte Œj*/
		memcpy( &pMOD->XmHeader.aPatternOrderTable[0] , &pMusDat[ ofs ] , 128 );
		ofs += 128 ;

		/* p^[I[_[e[u̍ő̒lAp^[f[^łB*/
		pMOD->XmHeader.NumberOfPatterns = 0 ;
		for( i=0 ; i<=127 ; i++ ){
			if(	pMOD->XmHeader.NumberOfPatterns < pMOD->XmHeader.aPatternOrderTable[i] + 1 ){
				pMOD->XmHeader.NumberOfPatterns = pMOD->XmHeader.aPatternOrderTable[i] + 1 ;
			}
		}

		#if (WARNING_LEVEL >= 3)
			LogMsg(
				"MOD__LoadSongAsMOD : \n"
				"	pMOD->XmHeader.NumberOfPatterns	= %d \n"
				,pMOD->XmHeader.NumberOfPatterns
			);
		#endif

		/* +1080 tH[}bgʎqXLbv */
		ofs += 4 ;

		/* ȃf[^Oɔr */
		if(	lMusDat - ofs <	  pMOD->XmHeader.NumberOfChannels
							* pMOD->XmHeader.NumberOfPatterns
							* 64	/* MOD `ł́Ap^[f[^ 64 Row */
							* 4
		){
			#if (WARNING_LEVEL >= 3)
				LogMsg(
					"MOD__LoadSongAsMOD : \n"
					"	f[^TCYsĂ܂Bp^[f[^ǂݍ߂܂B\n"
					"	ǂݍ݂LZ܂B\n"
				);
			#endif
			MOD__ReleaseSong( pMOD );
			return( FALSE );
		}

		for( idxPattern = 0 ; idxPattern < pMOD->XmHeader.NumberOfPatterns ; idxPattern++ ){
			XM_PATTERN	*pXM_PATTERN ;

			/* XM_PATTERN \̂̊m */
			pMOD->apXM_PATTERN[ idxPattern ] = pXM_PATTERN = XM_PATTERN__Create( );

			/* sH */
			if(	pXM_PATTERN == NULL ){
				#if (WARNING_LEVEL >= 1)
					LogMsg(
						"MOD__LoadSongAsMOD : \n"
						"	XM_PATTERN \̂̊mۂɎs܂B\n"
						"	ǂݍ݂LZ܂B\n"
					);
				#endif
				MOD__ReleaseSong( pMOD );
				return( FALSE );
			}

			/* XM_PATTERN \̂̏ */
			{
				pXM_PATTERN->PatternHeaderLength	= 0 ;
				pXM_PATTERN->PackingType			= 0 ;
				pXM_PATTERN->NumberOfRowsInPattern	= 64 ;	/* MOD `ł́Ap^[f[^ 64 Row */
				pXM_PATTERN->PackedPatterndataSize	= 0 ;

				pXM_PATTERN->pPatternData
				=	malloc( pMOD->XmHeader.NumberOfChannels * pXM_PATTERN->NumberOfRowsInPattern * 5 );
//				=	AllocMemory( pMOD->XmHeader.NumberOfChannels * pXM_PATTERN->NumberOfRowsInPattern * 5 );

				if(	pXM_PATTERN->pPatternData == NULL ){
					#if (WARNING_LEVEL >= 1)
						LogMsg(
							"MOD__LoadSongAsMOD : ُ펖Ԕ \n"
							"	p^[f[^̈̊mۂɎs܂B\n"
							"	ǂݍ݂LZ܂B\n"
						);
					#endif
					MOD__ReleaseSong( pMOD );
					return( FALSE );
				}
			}

			/*
				MOD ` -> XM `̕ϊsǂݍށB
				MOD `̃p^[f[^́AP`lARow * 4 oCgō\B
				XM  `̃p^[f[^́AP`lARow * 5 oCgō\B
			*/
			for( idxRow = 0 ; idxRow < pXM_PATTERN->NumberOfRowsInPattern ; idxRow++ ){
				for( idxCannel = 0 ; idxCannel < pMOD->XmHeader.NumberOfChannels ; idxCannel++ ){
					static const S32 _aPeriodTable[] =
					{
						0x6B0,0x650,0x5F5,0x5A0,0x54F,0x503,0x4BB,0x477,0x436,0x3FA,0x3C1,0x38B,	/* Octave 0 */
						0x358,0x328,0x2FB,0x2D0,0x2A7,0x281,0x25D,0x23B,0x21B,0x1FD,0x1E0,0x1C5,	/* Octave 1 */
						0x1AC,0x194,0x17D,0x168,0x154,0x141,0x12F,0x11E,0x10E,0x0FE,0x0F0,0x0E3,	/* Octave 2 */
						0x0D6,0x0CA,0x0BF,0x0B4,0x0AA,0x0A0,0x097,0x08F,0x087,0x07F,0x078,0x071,	/* Octave 3 */
						0x06B,0x065,0x05F,0x05A,0x055,0x050,0x04C,0x047,0x043,0x040,0x03C,0x039,	/* Octave 4 */
						0x035,0x032,0x030,0x02D,0x02A,0x028,0x026,0x024,0x022,0x020,0x01E,0x01C,	/* Octave 5 */
						0x01B,0x019,0x018,0x016,0x015,0x014,0x013,0x012,0x011,0x010,0x00F,0x00E		/* Octave 6 */
					};

					S32	idxInst		= ((pMusDat[ ofs + 2 ] >> 4) & 0x0F) | (pMusDat[ ofs + 0 ] & 0xF0) ;
					S32	Period		= pMusDat[ ofs + 1 ] | ((pMusDat[ ofs + 0 ] & 0x0F) << 8) ;
					S32	Command		= pMusDat[ ofs + 2 ] & 0x0F ;
					S32	Param		= pMusDat[ ofs + 3 ];

					S32	idxKey		= 0 ;
					S32	VolumeColumn= 0 ;
					S32	i ;

					/* Period -> Key ϊie[uAł߂Ȓlj*/
					if(	Period ){
						for( i = 0 ; i <= 7*12-2 ; i++ ){
							if(	Period >= _aPeriodTable[i] + ((_aPeriodTable[i+1] - _aPeriodTable[i]) >> 1) ){
								idxKey = i+1 ;
								break ;
							}
						}
						idxKey += 24 ;
					}

					/*
						MOD `ł́AFwsAVolume column ɃftHgʂ
						w肷̂ƓʂB
					*/
					if(	idxInst ){
						XM_SAMPLE *pXM_SAMPLE = pMOD->apXM_SAMPLE[ MAX_SAMPLES_IN_INSTRUMENT * (idxInst - 1) ];
						if(	pXM_SAMPLE != NULL ){
							VolumeColumn = pXM_SAMPLE->Volume + 0x10 ;
						}
					}

					/* o */
					{
						S32	zxc = (idxRow * pMOD->XmHeader.NumberOfChannels + idxCannel) * 5 ;
						pXM_PATTERN->pPatternData[ zxc + 0 ] = (U8)idxKey ;
						pXM_PATTERN->pPatternData[ zxc + 1 ] = (U8)idxInst ;
						pXM_PATTERN->pPatternData[ zxc + 2 ] = (U8)VolumeColumn ;
						pXM_PATTERN->pPatternData[ zxc + 3 ] = (U8)Command ;
						pXM_PATTERN->pPatternData[ zxc + 4 ] = (U8)Param ;
					}

					ofs += 4 ;
				}
			}
		}

		/* Lȃp^[f[^ALȃ|C^[蓖āAȍ~ NULL ƂB*/
		for( idxPattern = pMOD->XmHeader.NumberOfPatterns ; idxPattern < MAX_PATTERNS ; idxPattern++ ){
			pMOD->apXM_PATTERN[ idxPattern ] = NULL ;
		}
	}


	/* TvOf[^̓ǂ݂ */
	{
		S32	idxInst ;

		for( idxInst = 0 ; idxInst < pMOD->XmHeader.NumberOfInstruments ; idxInst++ ){
			XM_SAMPLE *pXM_SAMPLE = pMOD->apXM_SAMPLE[ MAX_SAMPLES_IN_INSTRUMENT * idxInst ];

			if(	pXM_SAMPLE != NULL ){
				S32	len = pXM_SAMPLE->SampleLength ;

				if(	len ){
					/* ȃf[^Oɔr */
					if(	lMusDat - ofs < len ){
						#if (WARNING_LEVEL >= 2)
							LogMsg(
								"MOD__LoadSongAsMOD : \n"
								"	f[^TCYsĂ܂BTvOf[^ǂݍ߂܂B\n"
								"	ǂݍ݂LZ܂B\n"
							);
						#endif
						MOD__ReleaseSong( pMOD );
						return( FALSE );
					}

					/* mہiv`mCY΍̂߁A]ɊmہjB*/
//					pXM_SAMPLE->pSampleData = AllocMemory( len + 256 );
					pXM_SAMPLE->pSampleData = malloc( len + 256 );

					if(	pXM_SAMPLE->pSampleData == NULL ){
						#if (WARNING_LEVEL >= 1)
							LogMsg(
								"MOD__LoadSongAsMOD : ُ펖Ԕ \n"
								"	TvOf[^̈̊mۂɎs܂B\n"
								"	ǂݍ݂LZ܂B\n"
							);
						#endif
						MOD__ReleaseSong( pMOD );
						return( FALSE );
					}

					#if (WARNING_LEVEL >= 3)
						LogMsg(
							"MOD__LoadSongAsMOD : \n"
							"	TvOf[^ %d ǂ݂݁Blen = %d \n"
							,idxInst
							,len
						);
					#endif

					memcpy( pXM_SAMPLE->pSampleData , &pMusDat[ ofs ] , len );
					ofs += len ;

					pXM_SAMPLE->VoiceMode = VM_ON ;

					if(	pXM_SAMPLE->Type & SMP_LOOP ){
						pXM_SAMPLE->VoiceMode |= VM_LOOP ;

						/* SampleLength ̍ĎZo */
						pXM_SAMPLE->SampleLength = pXM_SAMPLE->SampleLoopStart + pXM_SAMPLE->SampleLoopLength ;

						/* `⊮̘Â߁A[ɂPvfRs[ */
						{
							S8	*pSampleData = (S8*)pXM_SAMPLE->pSampleData ;
							pSampleData[ pXM_SAMPLE->SampleLength ] = pSampleData[ pXM_SAMPLE->SampleLoopStart ];
						}

					} else {
						/* L[Itv`mCY΍ig`̍ŏIvfXɌj*/
						S8	*pSampleData = (S8*)pXM_SAMPLE->pSampleData ;
						S32	LastVal_ = pSampleData[ pXM_SAMPLE->SampleLength - 1 ] << SFT ;
						S32	i ;
						for( i=0 ; i<256 ; i++ ){
							pSampleData[ pXM_SAMPLE->SampleLength + i ] = (S8)(LastVal_ >> SFT) ;
							LastVal_ -= LastVal_ >> 6 ;
						}

						pXM_SAMPLE->SampleLength += 255 ;	/* 1 vf̗]T */
					}
				}
			}
		}
	}

	/* ̑ */
	pMOD->XmId.aszID_Text[0]				= 0 ;			/* I_ */
	pMOD->XmId.ID_Byte						= 0 ;			/* _~[ */
	pMOD->XmId.aszTrackerName[0]			= 0 ;			/* I_ */
	pMOD->XmId.VersionNumber				= 0 ;			/* _~[ */
	pMOD->XmHeader.HeaderSize				= 0 ;			/* _~[ */
	pMOD->XmHeader.RestartPosition			= 0 ;			/* _~[ */
	pMOD->XmHeader.Flags					= 0 ;
	pMOD->XmHeader.DefaultTempo				= 6 ;
	pMOD->XmHeader.DefaultBPM				= 125 ;

	return( TRUE );
}



/*
	MOD f[^̓ǂݍ

	ߒlETRUE  = 
		EFALSE = s
*/
S32 MOD__LoadSong(
	 MOD	*pMOD		/* this |C^[ */
	,void	*pMusDat_	/* Ƀt@Cǂݍ݁Ã|C^[Ɏw */
	,S32	 lMusDat	/* f[^TCY */
){
	if(	pMOD == NULL ) return( FALSE );

	/* O܂ł̌Âf[^j */
	MOD__ReleaseSong( pMOD );

	/* XM `H */
	if(	MOD__LoadSongAsXM( pMOD , pMusDat_ , lMusDat ) ){
		pMOD->FormatType = TYPE_XM ;
		MOD__InitPlay( pMOD );

		#if (WARNING_LEVEL >= 2)
			LogMsg(
				"MOD__LoadSong : XM `Ƃēǂݍ݂܂B\n"
			);
		#endif

		return( TRUE );
	}

	/* MOD `H */
	if(	MOD__LoadSongAsMOD( pMOD , pMusDat_ , lMusDat ) ){
		pMOD->FormatType = TYPE_MOD ;
		MOD__InitPlay( pMOD );

		#if (WARNING_LEVEL >= 2)
			LogMsg(
				"MOD__LoadSong : MOD `Ƃēǂݍ݂܂B\n"
			);
		#endif

		return( TRUE );
	}

	/* Ȍ^Ƃ݂Ȃ */
	pMOD->FormatType = TYPE_NOTAVAILABLE ;
	return( FALSE );
}



/*
	MOD f[^̔j

	ߒlETRUE  = 
		EFALSE = s
*/
S32 MOD__ReleaseSong(
	 MOD	*pMOD		/* this |C^[ */
){
	S32	i ;

	if(	pMOD == NULL ) return( FALSE );

	for( i=0 ; i<MAX_PATTERNS ; i++ ){
		if(	pMOD->apXM_PATTERN[i] != NULL ){
			XM_PATTERN__Destruct( pMOD->apXM_PATTERN[i] );
			pMOD->apXM_PATTERN[i] = NULL ;
		}
	}

	for( i=0 ; i<MAX_INSTRUMENTS ; i++ ){
		if(	pMOD->apXM_INSTRUMENT[i] != NULL ){
			XM_INSTRUMENT__Destruct( pMOD->apXM_INSTRUMENT[i] );
			pMOD->apXM_INSTRUMENT[i] = NULL ;
		}
	}

	for( i=0 ; i<MAX_SAMPLES ; i++ ){
		if(	pMOD->apXM_SAMPLE[i] != NULL ){
			XM_SAMPLE__Destruct( pMOD->apXM_SAMPLE[i] );
			pMOD->apXM_SAMPLE[i] = NULL ;
		}
	}

	pMOD->FormatType = TYPE_NOTAVAILABLE ;

	return( TRUE );
}



/*
	Key -> Period_ ϊ

	ߒl : Period_
*/
static S32	MOD__KeyToPeriod_(
	 MOD	*pMOD
	,S32	Key
	,S32	FineTune
){
	S32	Period_ ;

	if(	pMOD == NULL ) return( FALSE );

	if(	Key < 0 )	Key = 0 ;
	if(	Key > 118 )	Key = 118 ;

	if(	pMOD->XmHeader.Flags & LINEAR_FREQUENCY ){
	/* `g[h */
		Period_ = ((10*12*16*4 - Key*16*4) << SFT) - (FineTune << (SFT - 1)) ;
		return( Period_ );

	} else {
	/* AmigaPeriod [h */
		static const U32 aAmigaFreqTable[] =
		{
			  907, 900, 894, 887, 881, 875, 868, 862, 856, 850, 844, 838, 832, 826, 820, 814
			, 808, 802, 796, 791, 785, 779, 774, 768, 762, 757, 752, 746, 741, 736, 730, 725
			, 720, 715, 709, 704, 699, 694, 689, 684, 678, 675, 670, 665, 660, 655, 651, 646
			, 640, 636, 632, 628, 623, 619, 614, 610, 604, 601, 597, 592, 588, 584, 580, 575
			, 570, 567, 563, 559, 555, 551, 547, 543, 538, 535, 532, 528, 524, 520, 516, 513
			, 508, 505, 502, 498, 494, 491, 487, 484, 480, 477, 474, 470, 467, 463, 460, 457
			, 453, 450, 447, 443, 440, 437, 434, 431, 428
		};
		S32	offset = (Key % 12) << 3 ;
		S32	nShift = Key / 12 ;
		S32	RoughFineTune ;
		S32	FineFineTune ;
		S32	Val ;

		if(	FineTune >= 0 ){
			RoughFineTune	= FineTune / 16 ;
			FineFineTune	= FineTune & 15 ;
		} else {
			RoughFineTune	= (FineTune - 15) / 16 ;
			FineFineTune	= FineTune & 15 ;
		}

		Val =	(	aAmigaFreqTable[ 8 + offset + RoughFineTune ] * (16 - FineFineTune)
				+	aAmigaFreqTable[ 9 + offset + RoughFineTune ] * FineFineTune
				) * 2 ;

		nShift -= SFT ;
		if(	nShift > 0 ) Val >>=  nShift ;
		if(	nShift < 0 ) Val <<= -nShift ;

		return( Val );
	}
}



/*
	Period_ -> Key ϊ

	ߒl : Key
*/
static S32	MOD__Period_ToKey(
	 MOD	*pMOD
	,S32	Period_
	,S32	FineTune
){
	if(	pMOD == NULL ) return( FALSE );

	if(	pMOD->XmHeader.Flags & LINEAR_FREQUENCY ){
	/* `g[h */
		S32	Key =	(	(10*12*16*4 << SFT) - (FineTune << (SFT - 1)) - Period_
					+	(16*4 << SFT)/2		/* ľܓ */
					) / (16*4 << SFT) ;
		return( Key );

	} else {
	/* AmigaPeriod [h */
		S32	Key ;
		S32	BestKey	= -1 ;
		S32	Min		= 0x7FFFFFFF ;

		for( Key = 0 ; Key <= 118 ; Key++ ){
			S32	zxc = abs( Period_ - MOD__KeyToPeriod_( pMOD , Key , FineTune ) );

			if(	zxc <= Min ){
				Min		= zxc ;
				BestKey	= Key ;
			}
		}

		return( BestKey );
	}
}



/*
	ʂ̐ݒ

	ߒlETRUE  = 
		EFALSE = s
*/
S32 MOD__Set_Volume(
	 MOD	*pMOD		/* this |C^[ */
	,S32	Volume		/*  0 ` 256iȏɂݒ\j*/
){
	if(	pMOD == NULL ) return( FALSE );

	if(	Volume <= 0 )	Volume = 0 ;	/* Ȓl */
	pMOD->GlobalVolumeScale_ = ONE * Volume >> 8 ;

	return( TRUE );
}



/*
	Đ[g̐ݒ

	ߒlETRUE  = 
		EFALSE = s
*/
S32 MOD__Set_nWavePerSec(
	 MOD	*pMOD			/* this |C^[ */
	,S32	nWavePerSec		/* WAVE o̓foCX̎g(Hz) */
){
	if(	pMOD == NULL ) return( FALSE );

	if(	nWavePerSec <= 0 )	nWavePerSec	= 44100 ;	/* Ȓl */
	pMOD->nWavePerSec = nWavePerSec ;

	return( TRUE );
}



/*
	[vĐ[h / 񃋁[vĐ[h ̎w

	ߒlETRUE  = 
		EFALSE = s
*/
S32 MOD__Set_bLoopMode(
	 MOD	*pMOD			/* this |C^[ */
	,S32	bLoopMode		/* [vĐ[hH TRUE / FALSE */
){
	if(	pMOD == NULL ) return( FALSE );

	pMOD->bLoopMode = bLoopMode ;

	return( TRUE );
}



/*
	QCRg[邩ǂ ̎w

	ߒlETRUE  = 
		EFALSE = s
*/
S32 MOD__Set_bAutoGainControl(
	 MOD	*pMOD				/* this |C^[ */
	,S32	bAutoGainControl	/* QCRg[邩H TRUE / FALSE */
){
	if(	pMOD == NULL ) return( FALSE );

	pMOD->bAutoGainControl = bAutoGainControl ;

	return( TRUE );
}



/*
	PatternLoop ̕A_Ap^[̐擪ɐݒu

	p^[؂ւ莞ɁAKs邱ƁB
	R}h E6x ɂāAA_ݒuȂꍇ̑΍łB

	ߒlETRUE  = 
		EFALSE = s
*/
static S32 MOD__InitPatternLoop(
	 MOD	*pMOD
){
	S32	i ;

	if(	pMOD == NULL ) return( FALSE );

	/* e`l̏Ԃ */
	for( i=0 ; i<MAX_CHANNELS ; i++ ){
		CHANSTAT *pCHANSTAT = &(pMOD->aCHANSTAT[ i ]);
		pCHANSTAT->PatternLoopRow	= 0 ;
		pCHANSTAT->PatternLoopCount	= 0 ;
	}

	return( TRUE );
}



/*
	Đip[^[A擪Đj

	ߒlETRUE  = 
		EFALSE = s
*/
S32 MOD__InitPlay(
	 MOD	*pMOD		/* this |C^[ */
){
	S32	i ;

	if(	pMOD == NULL ) return( FALSE );

	if(	pMOD->FormatType == TYPE_NOTAVAILABLE ) return( FALSE );

	pMOD->bDone				= FALSE ;

	pMOD->TickCount			= 0 ;
	pMOD->nTickPerRow		= pMOD->XmHeader.DefaultTempo ;
	pMOD->BPM				= pMOD->XmHeader.DefaultBPM ;
	pMOD->nWavePerTick		= (pMOD->nWavePerSec * 5) / (pMOD->BPM * 2);
	pMOD->nRestWave			= 0 ;

	pMOD->Row				= 0 ;
	pMOD->BreakSequence		= -1 ;
	pMOD->BreakRow			= -1 ;
	pMOD->PatternDelay		= 0 ;
	pMOD->FinePatternDelay	= 0 ;

	pMOD->idxSequenceData	= 0 ;

	pMOD->GlobalVolume_		= 0x40 << SFT ;
	pMOD->GlobalVolumeSlide	= 0 ;
	pMOD->GainControlScale_	= ONE ;

	pMOD->AntiNoiseVal_L	= 0 ;
	pMOD->AntiNoiseVal_R	= 0 ;


	/* e`l̏Ԃ */
	for( i=0 ; i<MAX_CHANNELS ; i++ ){
		CHANSTAT	*pCHANSTAT = &(pMOD->aCHANSTAT[ i ]);

		pCHANSTAT->idxNowPatternNote		= -1 ;
		pCHANSTAT->idxNowRealNote			= -1 ;
		pCHANSTAT->NowVolumeColumn			= 0 ;
		pCHANSTAT->NowCommand				= 0 ;
		pCHANSTAT->NowParam					= 0 ;
		pCHANSTAT->NowPeriod_				= 0 ;
		pCHANSTAT->idxNowInst				= -1 ;

		pCHANSTAT->pPendingXM_INSTRUMENT	= NULL ;
		pCHANSTAT->pPlayingXM_INSTRUMENT	= NULL ;
		pCHANSTAT->pPlayingXM_SAMPLE		= NULL ;

		pCHANSTAT->idxLastRealNote			= 0 ;

		pCHANSTAT->PendingPeriod_			= 0 ;
		pCHANSTAT->PlayingPeriod_			= 0 ;
		pCHANSTAT->FinalPeriod_				= 0 ;
		pCHANSTAT->PeriodLowLimit_			= 0 ;
		pCHANSTAT->PeriodHighLimit_			= 0 ;

		pCHANSTAT->PlayingFineTune			= 0 ;

		pCHANSTAT->PlayingVolume_			= 0 ;
		pCHANSTAT->FinalVolume_				= 0 ;
		pCHANSTAT->FinalVolume_L_			= 0 ;
		pCHANSTAT->FinalVolume_R_			= 0 ;
		pCHANSTAT->VolumeSlide				= 0 ;
		pCHANSTAT->FineVolumeSlide			= 0 ;
		pCHANSTAT->VolumeScale_				= ONE ;

		if(	pMOD->FormatType == TYPE_MOD ){
			static const S32 DefaultPanning[4] = { 0x00 , 0xFF , 0xFF , 0x00 };
			pCHANSTAT->PlayingPanning_		= DefaultPanning[ i & 3 ] << SFT ;
			pCHANSTAT->FinalPanning_		= DefaultPanning[ i & 3 ] << SFT ;
		} else {
			pCHANSTAT->PlayingPanning_		= 0x80 << SFT ;
			pCHANSTAT->FinalPanning_		= 0x80 << SFT ;
		}
		pCHANSTAT->PanningSlide				= 0 ;

		pCHANSTAT->idxVolumeEnvelopeTable	= 0 ;
		pCHANSTAT->idxPanningEnvelopeTable	= 0 ;

		pCHANSTAT->VibratoType				= 0 ;
		pCHANSTAT->VibratoPosition_			= 0 ;
		pCHANSTAT->VibratoRate				= 0 ;
		pCHANSTAT->VibratoDepth				= 0 ;

		pCHANSTAT->TremoloType				= 0 ;
		pCHANSTAT->TremoloPosition_			= 0 ;
		pCHANSTAT->TremoloRate				= 0 ;
		pCHANSTAT->TremoloDepth				= 0 ;

		pCHANSTAT->PortamentoInc			= 0 ;
		pCHANSTAT->TonePortamentoInc		= 0 ;
		pCHANSTAT->TonePortamentoDst_		= 0 ;
		pCHANSTAT->FinePortamentoInc		= 0 ;
		pCHANSTAT->ExtraFinePortamentoInc	= 0 ;

		pCHANSTAT->ArpeggioPeriod_[0]		= 0 ;
		pCHANSTAT->ArpeggioPeriod_[1]		= 0 ;
		pCHANSTAT->idxArpeggio				= 0 ;

		pCHANSTAT->TremorCount				= 0 ;
		pCHANSTAT->TremorOnTime				= 0 ;
		pCHANSTAT->TremorOffTime			= 0 ;
		pCHANSTAT->bTremorMute				= FALSE ;

		pCHANSTAT->MultiRetrigCount			= 0 ;
		pCHANSTAT->MultiRetrigInterval		= 1 ;
		pCHANSTAT->MultiRetrigVolumeChange	= 1 ;

		pCHANSTAT->PanbrelloType			= 0 ;
		pCHANSTAT->PanbrelloPosition		= 0 ;
		pCHANSTAT->PanbrelloRate			= 0 ;
		pCHANSTAT->PanbrelloDepth			= 0 ;

		pCHANSTAT->bFadeOut					= FALSE ;
		pCHANSTAT->FadeOutVolume_1_15_16	= 1 << 16 ;

		pCHANSTAT->AutoVibratoPosition		= 0 ;
		pCHANSTAT->AutoVibratoDepth_		= 0 ;

		pCHANSTAT->bSurround				= FALSE ;

		pCHANSTAT->SamplePosition_			= 0 ;
		pCHANSTAT->SampleRate_				= 0 ;
		pCHANSTAT->SampleOffset				= 0 ;
		pCHANSTAT->SampleHighOffset			= 0 ;
		pCHANSTAT->bGrissando				= FALSE ;
		pCHANSTAT->VolumeColumnContinueValue= 0 ;

		pCHANSTAT->pLastPlayingXM_SAMPLE	= NULL ;
		pCHANSTAT->LastSamplePosition_		= 0 ;
		pCHANSTAT->LastWaveVal_L			= 0 ;
		pCHANSTAT->LastWaveVal_R			= 0 ;
		pCHANSTAT->LastSampleVolume_L_		= 0 ;
		pCHANSTAT->LastSampleVolume_R_		= 0 ;
	}

	MOD__InitPatternLoop( pMOD );

	return( TRUE );
}



/*
	g`f[^̏o 16bit stereo

	g`̃~LVOsĂBœKȂ炱d_IɁB

	ߒlETRUE  = 
		EFALSE = s
*/
static S32 MOD__OutPut_16BitStereo(
	 MOD	*pMOD
	,U32	*pWaveOutPut	/* g`o͐iL R ЂƂ܂Ƃ߂ɂāAU32 Pʂŏo͂j*/
	,S32	 nWaveOutPut	/* o͔g` */
){
	#define	N_MIX	( 256 )

	S32	aMixBuff[ N_MIX * 2 ];	/* ~LVOpe|obt@iL R ݁j*/
	S32	i ;

	/* Ȃ狭I */
	if(	pMOD == NULL
	||	pWaveOutPut == NULL
	) return( FALSE );

	if(	pMOD->FormatType == TYPE_NOTAVAILABLE ) return( FALSE );

	while( nWaveOutPut > 0 ){
		S32	nWaveOutPutSub ;


		/* g` */
		if(	nWaveOutPut >= N_MIX ){
			nWaveOutPutSub = N_MIX ;
		} else {
			nWaveOutPutSub = nWaveOutPut ;
		}
		nWaveOutPut -= nWaveOutPutSub ;


		/* v`mCY΍ */
		for( i=0 ; i<pMOD->XmHeader.NumberOfChannels ; i++ ){
			CHANSTAT	*pCHANSTAT	= &(pMOD->aCHANSTAT[ i ]);

			/* ʁi0_ ` 1_j */
			S32	SampleVolume_L_	= (pCHANSTAT->FinalVolume_L_ >> 6) * pMOD->GainControlScale_ >> SFT ;
			S32	SampleVolume_R_	= (pCHANSTAT->FinalVolume_R_ >> 6) * pMOD->GainControlScale_ >> SFT ;

			/*
				FւĂꍇ
				g`|WVւĂꍇ
				ʂωĂꍇ
			*/
			if(	pCHANSTAT->LastSamplePosition_	 != pCHANSTAT->SamplePosition_
			||	pCHANSTAT->pLastPlayingXM_SAMPLE != pCHANSTAT->pPlayingXM_SAMPLE
			||	pCHANSTAT->LastSampleVolume_L_	 != SampleVolume_L_
			||	pCHANSTAT->LastSampleVolume_R_	 != SampleVolume_R_
			){
				XM_SAMPLE	*pXM_SAMPLE	= pCHANSTAT->pPlayingXM_SAMPLE ;
				S32	NowVal_L	= 0 ;
				S32	NowVal_R	= 0 ;

				if(	pXM_SAMPLE != NULL ){
					U32	SamplePosition_	= pCHANSTAT->SamplePosition_ ;
					U32	SampleLength_	= pXM_SAMPLE->SampleLength << SFT ;
					if(	SamplePosition_ < SampleLength_ ){
						S32	Val	 = 0 ;
						S32	Val0 = 0 ;
						S32	Val1 = 0 ;

						if(	(pXM_SAMPLE->VoiceMode & VM_16BIT) == 0 ){
							S8	*pSampleData = pXM_SAMPLE->pSampleData ;
							if(	pSampleData != NULL ){
								Val0	= (S32)pSampleData[  SamplePosition_ >> SFT ] << 8 ;
								Val1	= (S32)pSampleData[ (SamplePosition_ >> SFT) + 1 ] << 8 ;
							}
						} else {
							S16	*pSampleData = pXM_SAMPLE->pSampleData ;
							if(	pSampleData != NULL ){
								Val0	= (S32)pSampleData[  SamplePosition_ >> SFT ];
								Val1	= (S32)pSampleData[ (SamplePosition_ >> SFT) + 1 ];
							}
						}

						Val			= Val0 + (((Val1 - Val0) * ((S32)SamplePosition_ & DECIMAL)) >> SFT) ;
						NowVal_L	= Val * SampleVolume_L_ >> SFT ;
						NowVal_R	= Val * SampleVolume_R_ >> SFT ;
					}
				}

				pMOD->AntiNoiseVal_L += pCHANSTAT->LastWaveVal_L - NowVal_L ;
				pMOD->AntiNoiseVal_R += pCHANSTAT->LastWaveVal_R - NowVal_R ;
			}
		}


		/* v`mCY΍􂵂Aobt@NA */
		{
			S32	AntiNoiseVal_L = pMOD->AntiNoiseVal_L ;
			S32	AntiNoiseVal_R = pMOD->AntiNoiseVal_R ;

			for( i=0 ; i<nWaveOutPutSub*2 ; i+=2 ){
				aMixBuff[i  ] = AntiNoiseVal_L ;
				aMixBuff[i+1] = AntiNoiseVal_R ;
				AntiNoiseVal_L -= AntiNoiseVal_L >> 6 ;
				AntiNoiseVal_R -= AntiNoiseVal_R >> 6 ;
			}

			pMOD->AntiNoiseVal_L = AntiNoiseVal_L ;
			pMOD->AntiNoiseVal_R = AntiNoiseVal_R ;
		}


		/* `lJԂ */
		for( i=0 ; i<pMOD->XmHeader.NumberOfChannels ; i++ ){
			CHANSTAT	*pCHANSTAT	= &(pMOD->aCHANSTAT[ i ]);
			XM_SAMPLE	*pXM_SAMPLE	= pCHANSTAT->pPlayingXM_SAMPLE ;

			/* ʁi0_ ` 1_j */
			S32	SampleVolume_L_		= (pCHANSTAT->FinalVolume_L_ >> 6) * pMOD->GainControlScale_ >> SFT ;
			S32	SampleVolume_R_		= (pCHANSTAT->FinalVolume_R_ >> 6) * pMOD->GainControlScale_ >> SFT ;

			S32	Val_L	= 0 ;
			S32	Val_R	= 0 ;

			S32	CaseVal = 0 ;

			/* ʂ 0 ̎̂߂̏ꍇivZ덷lĔÂĂj*/
			if(	SampleVolume_L_ < -ONE/128  ||  ONE/128 < SampleVolume_L_ ) CaseVal |= 1 ;
			if(	SampleVolume_R_ < -ONE/128  ||  ONE/128 < SampleVolume_R_ ) CaseVal |= 2 ;

			if(	pXM_SAMPLE != NULL ){
				S32	*pMixBuff			= &(aMixBuff[ 0 ]) ;
				S32	*pMixEnd			= &(aMixBuff[ nWaveOutPutSub * 2 ]) ;
				U32	SampleRate_			= pCHANSTAT->SampleRate_ ;
				U32	SamplePosition_		= pCHANSTAT->SamplePosition_ ;
				U32	SampleLength_		= pXM_SAMPLE->SampleLength << SFT ;
				U32	SampleLoopLength_	= pXM_SAMPLE->SampleLoopLength << SFT ;

				/* `⊮g` */
				if(	pXM_SAMPLE->pSampleData != NULL
				&&	pXM_SAMPLE->VoiceMode & VM_ON
				&&	SampleRate_
				){
					S32	bLoop = ((pXM_SAMPLE->VoiceMode & VM_LOOP) != 0) ;

					/*-------- }N̒`ij--------*/

					#undef	MACRO
					#define	MACRO( _CaseVal_ , _nShift_ )												\
					while( pMixBuff < pMixEnd ){														\
						if(	SamplePosition_ >= SampleLength_ ){											\
							if(	bLoop == FALSE ) break ;												\
							do {																		\
								SamplePosition_ -= SampleLoopLength_ ;									\
							} while( SamplePosition_ >= SampleLength_ );								\
						}																				\
																										\
						if(	_CaseVal_ & 3 ){															\
							S32	Val0 , Val1 , Val ;														\
							Val0 = (S32)pSampleData[  SamplePosition_ >> SFT ];							\
							if(	_nShift_ ) Val0 <<= _nShift_ ;											\
							Val1 = (S32)pSampleData[ (SamplePosition_ >> SFT) + 1 ];					\
							if(	_nShift_ ) Val1 <<= _nShift_ ;											\
							Val = Val0 + (((Val1 - Val0) * ((S32)SamplePosition_ & DECIMAL)) >> SFT) ;	\
							if( _CaseVal_ & 1 ) Val_L = Val * SampleVolume_L_ >> SFT ;					\
							if( _CaseVal_ & 2 ) Val_R = Val * SampleVolume_R_ >> SFT ;					\
							if( _CaseVal_ & 1 ) pMixBuff[0]	+= Val_L ;									\
							if( _CaseVal_ & 2 ) pMixBuff[1]	+= Val_R ;									\
						}																				\
						pMixBuff += 2 ;																	\
						SamplePosition_ += SampleRate_ ;												\
					}																					\

					/*-------- }N̒`i܂Łj--------*/

					if(	(pXM_SAMPLE->VoiceMode & VM_16BIT) == 0 ){
					/* 8 bit sample */
						S8	*pSampleData = (S8*)pXM_SAMPLE->pSampleData ;
						switch( CaseVal ){
							/* L R ƂȂ */
							case 0 :{
								MACRO( 0 , 8 );
							} break ;

							/* L ̂ݏ */
							case 1 :{
								MACRO( 1 , 8 );
							} break ;

							/* R ̂ݏ */
							case 2 :{
								MACRO( 2 , 8 );
							} break ;

							/* L R Ƃ */
							case 3 :{
								MACRO( 3 , 8 );
							} break ;
						}
					} else {
					/* 16 bit sample */
						S16	*pSampleData = (S16*)pXM_SAMPLE->pSampleData ;
						switch( CaseVal ){
							/* L R ƂȂ */
							case 0 :{
								MACRO( 0 , 0 );
							} break ;

							/* L ̂ݏ */
							case 1 :{
								MACRO( 1 , 0 );
							} break ;

							/* R ̂ݏ */
							case 2 :{
								MACRO( 2 , 0 );
							} break ;

							/* L R Ƃ */
							case 3 :{
								MACRO( 3 , 0 );
							} break ;
						}
					}

					pCHANSTAT->SamplePosition_ = SamplePosition_ ;
				}
			}

			/* v`mCY΍p */
			pCHANSTAT->pLastPlayingXM_SAMPLE	= pCHANSTAT->pPlayingXM_SAMPLE ;
			pCHANSTAT->LastSamplePosition_		= pCHANSTAT->SamplePosition_ ;
			pCHANSTAT->LastWaveVal_L			= Val_L ;
			pCHANSTAT->LastWaveVal_R			= Val_R ;
			pCHANSTAT->LastSampleVolume_L_		= SampleVolume_L_ ;
			pCHANSTAT->LastSampleVolume_R_		= SampleVolume_R_ ;
		}


		/* OaAg`o */
		{
			S32	*pMixBuff = &(aMixBuff[0]) ;
			S32	nOver = 0 ;

			while( nWaveOutPutSub > 0 ){
				S32	ValL = pMixBuff[0] ;
				S32	ValR = pMixBuff[1] ;
				pMixBuff += 2 ;

				if(	ValL < -0x7FFF ){ ValL = -0x7FFF ; nOver++ ; }
				if(	ValL >  0x7FFF ){ ValL =  0x7FFF ; nOver++ ; }
				if(	ValR < -0x7FFF ){ ValR = -0x7FFF ; nOver++ ; }
				if(	ValR >  0x7FFF ){ ValR =  0x7FFF ; nOver++ ; }

				//*pWaveOutPut = (U32)((ValL & 0xFFFF) | (ValR << 16)) ;
				//allegrounsignedȔg`ɂĂ܂.
				*pWaveOutPut = ((U32)((ValL & 0xFFFF) | (ValR << 16))) ^ 0x80008000 ;
				 pWaveOutPut++ ;
				nWaveOutPutSub-- ;
			}

			/* QCRg[ */
			if(	pMOD->bAutoGainControl ){
				if(	nOver > 8 ){
					pMOD->GainControlScale_ -= pMOD->GainControlScale_ >> 8 ;
				} else {
					pMOD->GainControlScale_ += pMOD->GainControlScale_ >> 8 ;
					pMOD->GainControlScale_++ ;
					if(	pMOD->GainControlScale_ > ONE ){
						pMOD->GainControlScale_ = ONE ;
					}
				}
			} else {
				pMOD->GainControlScale_ = ONE ;
			}
		}
	}


	return( TRUE );
}



/*
	MOD f[^̍Đ

	w萔 16bit stereo g`𐶐B

	ߒlETRUE  = 
		EFALSE = s
*/
S32 MOD__PlaySong(
	 MOD	*pMOD			/* this |C^[ */
	,U32	*pWaveOutPut	/* g`o͐iL R ЂƂ܂Ƃ߂ɂāAU32 Pʂŏo͂j*/
	,S32	 nWaveOutPut	/* o͔g` */
){
	if(	pMOD == NULL ) return( FALSE );
	if(	pMOD->FormatType == TYPE_NOTAVAILABLE ) return( FALSE );

	/* m}B܂Ń[v */
	while( TRUE ){

		/* g`̏o */
		if(	pMOD->nRestWave > 0 ){
			if(	pMOD->nRestWave >= nWaveOutPut ){
			/* cg`̏o݂͂̂ō̃m}͒BB*/
				MOD__OutPut_16BitStereo(
					 pMOD
					,pWaveOutPut
					,nWaveOutPut
				);

				pMOD->nRestWave -= nWaveOutPut ;

				pWaveOutPut += nWaveOutPut ;
				nWaveOutPut -= nWaveOutPut ;

				return( TRUE );

			} else {
			/* cg`ȂI o镪oB*/
				MOD__OutPut_16BitStereo(
					 pMOD
					,pWaveOutPut
					,pMOD->nRestWave
				);

				pWaveOutPut += pMOD->nRestWave ;
				nWaveOutPut -= pMOD->nRestWave ;

				pMOD->nRestWave = 0 ;
			}
		}



		/* ȉA1 tick ̔g` */



		/* ĐIĂ */
		if(	pMOD->bDone == TRUE ){

			if(	pMOD->bLoopMode == FALSE ){
				/* ~[gԂɂ */
				MOD__InitPlay( pMOD );

				/* Ԃێ */
				pMOD->nRestWave += pMOD->nWavePerTick ;
				continue ;

			} else {
				/* [v_Đ */
				pMOD->idxSequenceData = pMOD->XmHeader.RestartPosition ;
				if(	pMOD->idxSequenceData >= pMOD->XmHeader.SongLength ){	/* ͈̓I[o[H */
					pMOD->idxSequenceData = 0 ;
				}

				/*
					[vĐLȃf[^ł́Aœɏ葱͎ȂB
					A[vĐLǂ𔻒fiB
					ނ𓾂A擪Đ̏ꍇ́A[vĐƔfB
					ModPlug ł@pĂ炵B
				*/
				if(	pMOD->idxSequenceData == 0 ){
					MOD__InitPlay( pMOD );
				}

				pMOD->bDone = FALSE ;
			}
		}


		while( TRUE ){	/* xWvp */
			S32	i ;
			S32	ModifyVal_	= ONE * (pMOD->nTickPerRow - 1) / pMOD->nTickPerRow ;
			S32	idxPattern	= pMOD->XmHeader.aPatternOrderTable[ pMOD->idxSequenceData ];
			XM_PATTERN *pXM_PATTERN = pMOD->apXM_PATTERN[ idxPattern ];
			U8	*pPatternData ;

			if(	pXM_PATTERN == NULL ){
				#if (WARNING_LEVEL >= 2)
					LogMsg(
						"MOD__PlaySong : x \n"
						"	pMOD->apXM_PATTERN[ %d ] == NULL łB\n"
						,idxPattern
					);
				#endif
				break ;
			}

			pPatternData = pXM_PATTERN->pPatternData ;
			if(	pPatternData == NULL ){
				#if (WARNING_LEVEL >= 2)
					LogMsg(
						"MOD__PlaySong : x \n"
						"	pMOD->apXM_PATTERN[ %d ]->pPatternData == NULL łB\n"
						,idxPattern
					);
				#endif
				break ;
			}

			#if (WARNING_LEVEL >= 2)
				if(	pMOD->TickCount == 0
				&&	pMOD->Row == 0
				){
					LogMsg(
						"Pos[%02d] Pat[%02d] ----------------------------------- \n"
						,pMOD->idxSequenceData
						,idxPattern
					);
				}
			#endif

			#if (WARNING_LEVEL >= 3)
				if(	pMOD->TickCount == 0 ){
					LogMsg(
						"Pos[%02d] Pat[%02d] ROW[%02d] "
						,pMOD->idxSequenceData
						,idxPattern
						,pMOD->Row
					);
				}
			#endif


			/* `lJԂ */
			for( i=0 ; i < pMOD->XmHeader.NumberOfChannels ; i++ ){
				CHANSTAT *pCHANSTAT = &(pMOD->aCHANSTAT[i]) ;
				U8	*pNote			= &pPatternData[ (pMOD->XmHeader.NumberOfChannels * pMOD->Row + i) * 5 ];
				S32	idxNowPatternNote ;
				S32	idxNowRealNote ;
				S32	idxNowInst ;
				S32	NowVolumeColumn ;
				S32	NowCommand ;
				S32	NowParam ;
				S32	NowPeriod_ ;
				S32	bArpeggio		= FALSE ;		/* Arpeggio ͗LHiTRUE / FALSEj*/
				S32	bVibrato		= FALSE ;		/* Vibrato ͗LHiTRUE / FALSEj*/
				S32	bTremolo		= FALSE ;		/* Tremolo ͗LHiTRUE / FALSEj*/
				S32	bPanbrello		= FALSE ;		/* Panbrello ͗LHiTRUE / FALSEj*/
				S32	bNoteDelay		= FALSE ;		/* NoteDelay ̍ŒHiTRUE / FALSEj*/
				S32	bFirstTrigger	= FALSE ;		/* gK[H */

				/* j^O */
				#if (WARNING_LEVEL >= 3)
					if(	pMOD->TickCount == 0 ){
						if(	pNote[0] ){
							LogMsg( ":k%02X " , pNote[0] );
						} else {
							LogMsg( ":--- " );
						}

						if(	pNote[1] ){
							LogMsg( "@%02X " , pNote[1] );
						} else {
							LogMsg( "--- " );
						}

						if(	pNote[2] ){
							LogMsg( "v%02X " , pNote[2] );
						} else {
							LogMsg( "--- " );
						}

						if(	pNote[3] ){
							LogMsg( "e[%02X%02X]" , pNote[3] , pNote[4] );
						} else {
							LogMsg( "-------" );
						}
					}
				#endif

				/* ݍs̃Xe[^X  & ϐ̍XV */
				{
					S32	idxPatternNote	= ((S32)pNote[0]) - 1 ;		/* 0..95 (0 = C-0, 95 = B-7) */
					S32	idxInst			= ((S32)pNote[1]) - 1 ;		/* Instrument (0-128) */
					S32	VolumeColumn	= ((S32)pNote[2]) ;			/* Volume column byte */
					S32	Command			= ((S32)pNote[3]) << 4 ;	/* Effect type */
					S32	Param			= ((S32)pNote[4]) ;			/* Effect parameter */
					S32	idxRealNote		= -1 ;
					S32	Period_			= 0 ;

					/* gR}hAParam  4 bit ̓R}hԍɂȂ */
					if(	Command == 0x0E0
					||	Command == 0x210
					){
						Command |= Param >> 4 ;
						Param &= 0xF ;
					}

					/*
						NoteDelay ̉ & gK[B
						R}h 0xED ́AParam ==0 ł continue ƂȂiMOD XM ʁjB
						Delay ́AGtFNg~B
						p[^[̍XV́ADelay ꂽ^C~OōsB
						āADelay Ԃ TickPerRow 𒴂鎞Ap[^[
						XVsȂB
						ȏAModPlug ̎dlB
					*/
					if(	Command == 0xED ){
						if(	pMOD->TickCount < Param ){
							bNoteDelay = TRUE ;
						}
						if(	pMOD->TickCount == Param ) bFirstTrigger = TRUE ;
					} else {
						if(	pMOD->TickCount == 0 ) bFirstTrigger = TRUE ;
					}

					/* gK[H */
					if(	bFirstTrigger ){
						S32	bPlay = FALSE ;		/* H */

						/* Ȓlr */
						if(	idxInst >= pMOD->XmHeader.NumberOfInstruments ) idxInst = -1 ;
						if(	idxPatternNote > 96 ) idxPatternNote = -1 ;

						/*
							K F NoteOff ̉߂́̕AgbJ[̏t[
							ˑő̍̉ƂȂĂB̌ő̍Čɂ́A
							gbJ[̏t[\zĐ^Kv邪A
							΂΂̂ŁAȉAׂẴP[XꍇđΏB
						*/

						/* CASE 1 : NoteOff  &  FL */
						if(	idxPatternNote == 96
						&&	idxInst != -1
						){
							pCHANSTAT->pPendingXM_INSTRUMENT = pMOD->apXM_INSTRUMENT[ idxInst ];

						/* CASE 2 : KL */
						} else
						if(	idxPatternNote != -1
						&&	idxPatternNote != 96	/* NoteOff ł͂Ȃ */
						){
							/*
								̏A₱B
								Tone-Portamento ̓gK[͖B
								Tone-Portamento łAVKF̎w肪鎞̓gK[B
							*/

							if(	!(	Command == 0x30					/* Tone-Portamento */
								||	Command == 0x50					/* Tone-Portamento + Volume Slide */
								||	(VolumeColumn & 0xF0) == 0xF0	/* Tone-Portamento */
								)
							){
								bPlay = TRUE ;
							}

							if(	idxInst != -1 ){
								pCHANSTAT->bFadeOut					= FALSE ;
								pCHANSTAT->pPendingXM_INSTRUMENT	= pMOD->apXM_INSTRUMENT[ idxInst ];
								pCHANSTAT->idxVolumeEnvelopeTable	= 0 ;
								pCHANSTAT->idxPanningEnvelopeTable	= 0 ;
								pCHANSTAT->AutoVibratoPosition		= 0 ;
								pCHANSTAT->AutoVibratoDepth_		= 0 ;
								pCHANSTAT->MultiRetrigCount			= 0 ;
								if(	pCHANSTAT->pPlayingXM_INSTRUMENT != pCHANSTAT->pPendingXM_INSTRUMENT ) bPlay = TRUE ;
							}
							pCHANSTAT->pPlayingXM_INSTRUMENT = pCHANSTAT->pPendingXM_INSTRUMENT ;

							if(	pCHANSTAT->pPlayingXM_INSTRUMENT != NULL ){
								pCHANSTAT->pPlayingXM_SAMPLE
								=	pCHANSTAT->pPlayingXM_INSTRUMENT->apAllNoteXM_SAMPLE[ idxPatternNote ];
							}

							if(	pCHANSTAT->pPlayingXM_SAMPLE != NULL ){
								if(	idxInst != -1 ){
									pCHANSTAT->PlayingVolume_	= pCHANSTAT->pPlayingXM_SAMPLE->Volume << SFT ;
									if(	pMOD->FormatType == TYPE_XM ){
										pCHANSTAT->PlayingPanning_	= pCHANSTAT->pPlayingXM_SAMPLE->Panning << SFT ;
									}
								}
								pCHANSTAT->PlayingFineTune = pCHANSTAT->pPlayingXM_SAMPLE->FineTune ;
								idxRealNote = idxPatternNote + pCHANSTAT->pPlayingXM_SAMPLE->RelativeNoteNumber ;
								Period_
								=	pCHANSTAT->PendingPeriod_
								=	MOD__KeyToPeriod_( pMOD , idxRealNote , pCHANSTAT->PlayingFineTune );

								/* Tone-Portamento ڕWĺAǂ̂悤ȃR}h̍ŒłXV */
								pCHANSTAT->TonePortamentoDst_ = Period_ ;

								/* tOLȂ */
								if(	bPlay ){
									pCHANSTAT->idxLastRealNote	= idxRealNote ;
									pCHANSTAT->SamplePosition_	= 0 ;
									pCHANSTAT->PlayingPeriod_	= Period_ ;
									pCHANSTAT->PeriodLowLimit_	= MOD__KeyToPeriod_( pMOD , 12*10 - 1 , 0 );
									pCHANSTAT->PeriodHighLimit_	= MOD__KeyToPeriod_( pMOD ,         0 , 0 );
									if(	(pCHANSTAT->VibratoType & 4) == 0 ) pCHANSTAT->VibratoPosition_ = 0 ;
									if(	(pCHANSTAT->TremoloType & 4) == 0 ) pCHANSTAT->TremoloPosition_ = 0 ;
								}

							} else {
								pCHANSTAT->PlayingVolume_  = 0 ;
							}

						/* CASE 3 : K  &  NoteOff łȂ  &  FL */
						} else
						if(	idxPatternNote == -1	/* K */
						&&	idxPatternNote != 96	/* NoteOff ł͂Ȃ */
						&&	idxInst != -1			/* FL */
						){
							pCHANSTAT->bFadeOut					= FALSE ;
							pCHANSTAT->pPendingXM_INSTRUMENT	= pMOD->apXM_INSTRUMENT[ idxInst ];

							if(	pCHANSTAT->pPlayingXM_SAMPLE != NULL ){
								pCHANSTAT->PlayingVolume_	= pCHANSTAT->pPlayingXM_SAMPLE->Volume << SFT ;
								if( pMOD->FormatType == TYPE_XM ){
									pCHANSTAT->PlayingPanning_	= pCHANSTAT->pPlayingXM_SAMPLE->Panning << SFT ;
								}
							}

							pCHANSTAT->idxVolumeEnvelopeTable	= 0 ;
							pCHANSTAT->idxPanningEnvelopeTable	= 0 ;
							pCHANSTAT->AutoVibratoPosition		= 0 ;
							pCHANSTAT->AutoVibratoDepth_		= 0 ;
							pCHANSTAT->MultiRetrigCount			= 0 ;
						}

						/* NoteOff */
						if(	idxPatternNote == 96 ) pCHANSTAT->bFadeOut = TRUE ;

						/* ϐ̍XV */
						pCHANSTAT->idxNowPatternNote	= idxPatternNote ;
						pCHANSTAT->idxNowRealNote		= idxRealNote ;
						pCHANSTAT->idxNowInst			= idxInst ;
						pCHANSTAT->NowVolumeColumn		= VolumeColumn ;
						pCHANSTAT->NowCommand			= Command ;
						pCHANSTAT->NowParam				= Param ;
						pCHANSTAT->NowPeriod_			= Period_ ;

						#if (WARNING_LEVEL >= 3)
							/* ȂA! \ */
							if(	bPlay ){
							//	LogMsg( "![%04X][%s]" , Period_ >> SFT , pCHANSTAT->pPlayingXM_SAMPLE->aszSampleName );
								LogMsg( "!" );
							} else {
								LogMsg( " " );
							}
						#endif
					}
				}

				idxNowPatternNote	= pCHANSTAT->idxNowPatternNote ;
				idxNowRealNote		= pCHANSTAT->idxNowRealNote ;
				idxNowInst			= pCHANSTAT->idxNowInst ;
				NowVolumeColumn		= pCHANSTAT->NowVolumeColumn ;
				NowCommand			= pCHANSTAT->NowCommand ;
				NowParam			= pCHANSTAT->NowParam ;
				NowPeriod_			= pCHANSTAT->NowPeriod_ ;


				/* VolumeColumn R}h */
				if(	bNoteDelay == FALSE ){
					/*
						ModPlugTracker œmF͈͂ł킩ȂA
						VolumeColumn ̃p[^[ȗɂ continue ͂ȂB
						Â@\䂦AЂǂdlB
						R}h 6x 7x 8x 9x ax bx dx ex ŁAʂ continue lĂB
						A̒l̓W[R}hɏ㏑̂łB
					*/
					if(	(NowVolumeColumn & 0xF0) == 0x60
					||	(NowVolumeColumn & 0xF0) == 0x70
					||	(NowVolumeColumn & 0xF0) == 0x80
					||	(NowVolumeColumn & 0xF0) == 0x90
					||	(NowVolumeColumn & 0xF0) == 0xA0
					||	(NowVolumeColumn & 0xF0) == 0xB0
					||	(NowVolumeColumn & 0xF0) == 0xD0
					||	(NowVolumeColumn & 0xF0) == 0xE0
					){
						if(	(NowVolumeColumn & 0xF) == 0 ){
							NowVolumeColumn = (NowVolumeColumn & 0xF0) | pCHANSTAT->VolumeColumnContinueValue ;
						} else {
							pCHANSTAT->VolumeColumnContinueValue = NowVolumeColumn & 0xF ;
						}
					}

					switch( NowVolumeColumn & 0xF0 ){
						case 0x00 :{
						} break ;

						/* Set volume */
						case 0x10 :
						case 0x20 :
						case 0x30 :
						case 0x40 :
						case 0x50 :{
							if(	bFirstTrigger ){
								/*
									Ȃ 0x10 ̂H
										voleffect = 0x1* -> notevol = 0
										voleffect = 0x2* -> notevol = 0x10
										voleffect = 0x3* -> notevol = 0x20
										voleffect = 0x4* -> notevol = 0x30
										voleffect = 0x5* -> notevol = 0x40
									ƂƂ炵B
								*/
								pCHANSTAT->PlayingVolume_ = (NowVolumeColumn - 0x10) << SFT ;
							}
						} break ;

						/* $60-$6f : Volume slide down */
						/* $70-$7f : Volume slide up */
						/*
							R}h Axy 5xy 6xy Ƃ̕pōp͉ZB
						*/
						case 0x60 :
						case 0x70 :{
							if(	bFirstTrigger ){
								if(	(NowVolumeColumn & 0xF0) == 0x60 ){
									pCHANSTAT->VolumeSlide = -(NowVolumeColumn & 0x0F) ;
								}
								if(	(NowVolumeColumn & 0xF0) == 0x70 ){
									pCHANSTAT->VolumeSlide =  (NowVolumeColumn & 0x0F) ;
								}
							}
							pCHANSTAT->PlayingVolume_ += pCHANSTAT->VolumeSlide * ModifyVal_ ;
						} break ;

						/* $80-$8f : Fine volume slide down */
						/* $90-$9f : Fine volume slide up */
						/*
							R}h EAx EBx Ƃ̕pōp͉ZB
						*/
						case 0x80 :
						case 0x90 :{
							if(	bFirstTrigger ){
								if(	(NowVolumeColumn & 0xF0) == 0x80 ){
									pCHANSTAT->FineVolumeSlide = -(NowVolumeColumn & 0x0F) ;
								}
								if(	(NowVolumeColumn & 0xF0) == 0x90 ){
									pCHANSTAT->FineVolumeSlide =  (NowVolumeColumn & 0x0F) ;
								}
								pCHANSTAT->PlayingVolume_ += pCHANSTAT->FineVolumeSlide << SFT ;
							}
						} break ;

						/* $a0-$af : Set vibrato speed */
						/* $b0-$bf : Vibrato depth */
						/*
							IWi FT2 ł́A$Ax ł́AXs[hݒ肵悤B
							AModPlug ł́A$Ax $Bx ƂɁAru[gB
							ʂ́AR}h 4xy ƓB
							R}h 4xy Ƃ̕pŁAp̑͂ȂB
							ϐ 4xy ƋʁB
						*/
						case 0xA0 :
						case 0xB0 :{
							if(	bFirstTrigger ){
								if(	(NowVolumeColumn & 0xF0) == 0xA0 ){
									pCHANSTAT->VibratoRate	= NowVolumeColumn & 0xF ;
								}
								if(	(NowVolumeColumn & 0xF0) == 0xB0 ){
									pCHANSTAT->VibratoDepth	= NowVolumeColumn & 0xF ;
								}
							}
							bVibrato = TRUE ;
						} break ;

						/* $c0-$cf : Set panning */
						case 0xC0 :{
							if(	bFirstTrigger ){
								pCHANSTAT->PlayingPanning_ = (NowVolumeColumn & 0xF) * ((0xFF << SFT) / 0xF) ;
							}
						} break ;

						/* $d0-$df : Panning slide left */
						/* $e0-$ef : Panning slide right */
						/*
							R}h Pxy Ƃ̕pōp͉ZB
							p[^[ϐAŋʂƂȂĂB
						*/
						case 0xD0 :
						case 0xE0 :{
							if(	bFirstTrigger ){
								if(	(NowVolumeColumn & 0xF0) == 0xD0 ){
									pCHANSTAT->PanningSlide = -((S32)NowVolumeColumn & 0x0F) * 4 ;	/*  */
								}
								if(	(NowVolumeColumn & 0xF0) == 0xE0 ){
									pCHANSTAT->PanningSlide =  ((S32)NowVolumeColumn & 0x0F) * 4 ;	/* E */
								}
							}
							pCHANSTAT->PlayingPanning_ += pCHANSTAT->PanningSlide * ModifyVal_ ;
						} break ;

						/* $f0-$ff : Tone porta */
						/*
							W[GtFNg̋Lqy[XgB
							p[^[́A3xx R}h 16 {̌ʂB
							W[GtFNg 3xx ƕp鎞AʂZB
						*/
						case 0xF0 :{
							if(	bFirstTrigger ){
								if(	NowVolumeColumn & 0xF ){
									pCHANSTAT->TonePortamentoInc = (NowVolumeColumn & 0xF) * 64 ;
								}
							}

							if(	pCHANSTAT->TonePortamentoDst_ > pCHANSTAT->PlayingPeriod_ ){
								if(	(pCHANSTAT->PlayingPeriod_ += pCHANSTAT->TonePortamentoInc * ModifyVal_)
								>	pCHANSTAT->TonePortamentoDst_
								){
									pCHANSTAT->PlayingPeriod_ = pCHANSTAT->TonePortamentoDst_ ;
								}
							} else
							if(	pCHANSTAT->TonePortamentoDst_ < pCHANSTAT->PlayingPeriod_ ){
								if(	(pCHANSTAT->PlayingPeriod_ -= pCHANSTAT->TonePortamentoInc * ModifyVal_)
								<	pCHANSTAT->TonePortamentoDst_
								){
									pCHANSTAT->PlayingPeriod_ = pCHANSTAT->TonePortamentoDst_ ;
								}
							}
						} break ;
					}

					/*
						ňxAp[^[̖OaKvB
						W[R}h̏ɂA͂Oâ
						QxԂAModPlug ̎dlłB
					*/
					if(	pCHANSTAT->PlayingVolume_  <            0  ) pCHANSTAT->PlayingVolume_  = 0 ;
					if(	pCHANSTAT->PlayingVolume_  > (0x40 << SFT) ) pCHANSTAT->PlayingVolume_  = 0x40 << SFT ;
					if(	pCHANSTAT->PlayingPanning_ <            0  ) pCHANSTAT->PlayingPanning_ = 0 ;
					if(	pCHANSTAT->PlayingPanning_ > (0xFF << SFT) ) pCHANSTAT->PlayingPanning_ = 0xFF << SFT ;
				}


				/* W[R}h */
				if(	bNoteDelay == FALSE ){

					/* Arpeggio */
					if(	NowCommand == 0x00 ){
						/* GtFNgi= 0x000j Arpeggio ƍȂ */
						if(	NowParam ){
							if(	bFirstTrigger ){
								S32	FineTune		= pCHANSTAT->PlayingFineTune ;
								S32	idxLastRealNote	= pCHANSTAT->idxLastRealNote ;

								pCHANSTAT->ArpeggioPeriod_[0]
								=	MOD__KeyToPeriod_( pMOD , idxLastRealNote +  (NowParam & 0x0F)       , FineTune );
								pCHANSTAT->ArpeggioPeriod_[1]
								=	MOD__KeyToPeriod_( pMOD , idxLastRealNote + ((NowParam & 0xF0) >> 4) , FineTune );
								pCHANSTAT->idxArpeggio = 0 ;
							}
							bArpeggio = TRUE ;
						}
					}

					/* Portamento Up */
					if(	NowCommand == 0x10 ){
						if(	bFirstTrigger ){
							if(	pMOD->FormatType == TYPE_MOD	/* MOD `ł NowParam == 0 ł continue ƂȂ */
							||	(	pMOD->FormatType == TYPE_XM	/* XM `ł NowParam == 0  continue */
								&&	NowParam
								)
							){
								pCHANSTAT->PortamentoInc = NowParam * 4 ;
							}
						}

						pCHANSTAT->PlayingPeriod_ -= pCHANSTAT->PortamentoInc * ModifyVal_ ;
					}

					/* Portamento Down */
					if(	NowCommand == 0x20 ){
						if(	bFirstTrigger ){
							if(	pMOD->FormatType == TYPE_MOD	/* MOD `ł NowParam == 0 ł continue ƂȂ */
							||	(	pMOD->FormatType == TYPE_XM	/* XM `ł NowParam == 0  continue */
								&&	NowParam
								)
							){
								pCHANSTAT->PortamentoInc = NowParam * 4 ;
							}
						}

						pCHANSTAT->PlayingPeriod_ += pCHANSTAT->PortamentoInc * ModifyVal_ ;
					}

					/* Tone-Portamento */
					/* Tone-Portamento + Volume Slidei NowParam  Volume Slide ɓKpj*/
					if(	NowCommand == 0x30
					||	NowCommand == 0x50
					){
						if(	bFirstTrigger ){
							if(	NowCommand != 0x50 ){		/* 0x50 ̎ANowParam  Volume Slide ɓKp */
								/* MOD/XM `ɁANowParam == 0  continue */
								if(	NowParam ){
									pCHANSTAT->TonePortamentoInc = NowParam * 4 ;
								}
							}
						}

						if(	pCHANSTAT->TonePortamentoDst_ > pCHANSTAT->PlayingPeriod_ ){
							if(	(pCHANSTAT->PlayingPeriod_ += pCHANSTAT->TonePortamentoInc * ModifyVal_)
							>	pCHANSTAT->TonePortamentoDst_
							){
								pCHANSTAT->PlayingPeriod_ = pCHANSTAT->TonePortamentoDst_ ;
							}
						} else
						if(	pCHANSTAT->TonePortamentoDst_ < pCHANSTAT->PlayingPeriod_ ){
							if(	(pCHANSTAT->PlayingPeriod_ -= pCHANSTAT->TonePortamentoInc * ModifyVal_)
							<	pCHANSTAT->TonePortamentoDst_
							){
								pCHANSTAT->PlayingPeriod_ = pCHANSTAT->TonePortamentoDst_ ;
							}
						}
					}

					/* Vibrato */
					/* Vibrato + Volume Slidei NowParam  Volume Slide ɓKpj*/
					if(	NowCommand == 0x40
					||	NowCommand == 0x60
					){
						if(	bFirstTrigger ){
							if(	NowCommand != 0x60 ){		/* 0x60 ̎ANowParam  Volume Slide ɓKp */
								/* MOD/XM `ƂɁADepth Rate ʂ 0 Ȃ continue Ƃ */
								if(	NowParam & 0x0F ){
									pCHANSTAT->VibratoDepth = NowParam & 0x0F ;
								}
								if(	NowParam & 0xF0 ){
									pCHANSTAT->VibratoRate = (NowParam & 0xF0) >> 4 ;
								}
							}
						}
						bVibrato = TRUE ;
					}

					/* Tone-Portamento + Volume Slidei NowParam  Volume Slide ɓKpj*/
					/* Vibrato + Volume Slidei NowParam  Volume Slide ɓKpj*/
					/* Volume Slide */
					if(	NowCommand == 0x50
					||	NowCommand == 0x60
					||	NowCommand == 0xA0
					){
						if(	bFirstTrigger ){
							if(	pMOD->FormatType == TYPE_MOD	/* MOD `ł NowParam == 0 ł continue ƂȂ */
							||	(	pMOD->FormatType == TYPE_XM	/* XM `ł NowParam == 0  continue */
								&&	NowParam
								)
							){
								/* NowParam  4 bit DIɎQƂB*/
								if(	NowParam & 0xF0 ){
									pCHANSTAT->VolumeSlide = ((NowParam & 0xF0) >> 4) ;
								} else {
									pCHANSTAT->VolumeSlide = -((S32)NowParam & 0x0F) ;
								}
							}
						}
						pCHANSTAT->PlayingVolume_ += pCHANSTAT->VolumeSlide * ModifyVal_ ;
					}

					/* Tremolo */
					if(	NowCommand == 0x70 ){
						if(	bFirstTrigger ){
							/* MOD/XM `ƂɁADepth Rate ʂɁA0 Ȃ continue */
							if(	NowParam & 0x0F ){
								pCHANSTAT->TremoloDepth = NowParam & 0x0F ;
							}
							if(	NowParam & 0xF0 ){
								pCHANSTAT->TremoloRate = (NowParam & 0xF0) >> 4 ;
							}
						}
						bTremolo = TRUE ;
					}

					/* Set Panning */
					if(	NowCommand == 0x80 ){
						if(	bFirstTrigger ){
							pCHANSTAT->bSurround = FALSE ;

							/*
								XM/IT `ł́AĺA00 ()  FF (E)łB
								MOD/S3M `ł́AĺA00 ()  80 (E)łB
								MOD/S3M `ɂāAl A4 w肳ƁATEh[hijɂȂ܂B
							*/
							if(	pMOD->FormatType == TYPE_MOD
							||	pMOD->FormatType == TYPE_S3M
							){
								S32	zxc = NowParam ;
								if( zxc == 0xA4 ){		/* R}h 8A4 */
									pCHANSTAT->PlayingPanning_	= (0xFF << SFT) / 2 ;
									pCHANSTAT->bSurround		= TRUE ;
								} else {
									if( zxc <= 0x80 ){
										pCHANSTAT->PlayingPanning_ = zxc * ((0xFF << SFT) / 0x80) ;
									}
								}
							} else
							if(	pMOD->FormatType == TYPE_XM
							||	pMOD->FormatType == TYPE_IT
							){
								pCHANSTAT->PlayingPanning_ = NowParam << SFT ;
							}
						}
					}

					/* Set Sample Offset */
					if(	NowCommand == 0x90 ){
						if(	bFirstTrigger
						&&	NowPeriod_
						){
							XM_SAMPLE	*pXM_SAMPLE = pCHANSTAT->pPlayingXM_SAMPLE ;
							U32	SamplePosition = 0 ;

							/* MOD/XM `ƂɁAParam == 0 Ȃ continue */
							if(	NowParam ){
								pCHANSTAT->SampleOffset	= NowParam ;
							}
							SamplePosition = pCHANSTAT->SampleOffset * 0x100 + pCHANSTAT->SampleHighOffset * 0x10000 ;

							if(	pXM_SAMPLE ){
								/*	!!
									MOD `̏ꍇATvOI_𒴂Ȃ擪ɖ߂
									[vLȂAlʒuɍĐ_uB
									ƂĂ悤ȋC邪sB
								*/
								if(	SamplePosition >= (U32)pXM_SAMPLE->SampleLength ){
									#if (WARNING_LEVEL >= 1)
										LogMsg(
											"\n"
											"MOD__PlaySong : x \n"
											"	CH = %d : R}h 9%02X ɂāA͈̓I[o[oBPOS=[%X / %X] \n"
											,i
											,NowParam
											,SamplePosition
											,pXM_SAMPLE->SampleLength
										);
									#endif
									if(	pXM_SAMPLE->VoiceMode & VM_LOOP ){
										SamplePosition -= pXM_SAMPLE->SampleLoopStart ;
										SamplePosition %= pXM_SAMPLE->SampleLoopLength ;
										SamplePosition += pXM_SAMPLE->SampleLoopStart ;
									}
								}
							}

							pCHANSTAT->SamplePosition_ = SamplePosition << SFT ;
						}
					}

					/* Position Jumpi̍ŝ͉tj*/
					if(	NowCommand == 0xB0 ){
						if(	bFirstTrigger ){
							if(	pMOD->bLoopMode == TRUE					/* [vĐ͖ɋ */
							||	NowParam >= pMOD->idxSequenceData		/* ÕWv͖ɋ */
							){
								pMOD->BreakSequence = NowParam ;
							}
						}
					}

					/* Set Volume */
					if(	NowCommand == 0xC0 ){
						if(	bFirstTrigger ){
							pCHANSTAT->PlayingVolume_ = NowParam << SFT ;
						}
					}

					/* Pattern Breaki̍ŝ͉tj*/
					if(	NowCommand == 0xD0 ){
						if(	bFirstTrigger ){
							pMOD->BreakRow		= ((NowParam & 0xF0) >> 4) * 10 + (NowParam & 0x0F) ;
							pMOD->BreakSequence	= pMOD->idxSequenceData + 1 ;
						}
					}

					/* Extended MOD Commands */
					if(	(NowCommand & 0xFF0) == 0x0E0 ){
						switch( NowCommand ){
							/* E0x : Set Filter */
							case 0xE0 :{
								switch( NowParam ){
									//	!! Ή
									#if (WARNING_LEVEL >= 1)
										LogMsg(
											"MOD__PlaySong : x \n"
											"	Ή̃R}h %03X łB\n"
											,NowCommand
										);
									#endif
									/*
										Amiga n[hEFAxŎĂ@\Rg[
										R}h炵BËB
									*/
								}
							} break ;

							/* E1x : Fine Portamento Up */
							/* E2x : Fine Portamento Down */
							case 0xE1 :
							case 0xE2 :{
								if(	bFirstTrigger ){
									if(	pMOD->FormatType == TYPE_MOD	/* MOD `ł NowParam == 0 ł continue ƂȂ */
									||	(	pMOD->FormatType == TYPE_XM	/* XM `ł NowParam == 0  continue */
										&&	NowParam
										)
									){
										pCHANSTAT->FinePortamentoInc = NowParam * 4 ;
									}
									if(	NowCommand == 0xE1 ){
										pCHANSTAT->PlayingPeriod_ -= pCHANSTAT->FinePortamentoInc << SFT ;
									}
									if(	NowCommand == 0xE2 ){
										pCHANSTAT->PlayingPeriod_ += pCHANSTAT->FinePortamentoInc << SFT ;
									}
								}
							} break ;

							/* E3x : Grissando Control */
							case 0xE3 :{
								if(	bFirstTrigger ){
									if(	NowParam ){
										pCHANSTAT->bGrissando = TRUE ;
									} else {
										pCHANSTAT->bGrissando = FALSE ;
									}
								}
							} break ;

							/* E4x : Vibrato waveform */
							case 0xE4 :{
								if(	bFirstTrigger ){
									pCHANSTAT->VibratoType = NowParam ;
								}
							} break ;

							/* E5x : Set FineTuneiMOD `̂݃T|[gj*/
							case 0xE5 :{
								if(	bFirstTrigger
								&&	pMOD->FormatType == TYPE_MOD
								){
									S32	Val = NowParam ;
									if(	Val >= 8 ) Val = Val - 16 ;

									/* Period ĎZo */
									pCHANSTAT->PlayingFineTune = Val << 4 ;
									pCHANSTAT->PendingPeriod_
									=	pCHANSTAT->PlayingPeriod_
									=	MOD__KeyToPeriod_( pMOD , pCHANSTAT->idxLastRealNote , pCHANSTAT->PlayingFineTune );
								}
							} break ;

							/* E6x : Pattern loop */
							case 0xE6 :{
								if(	bFirstTrigger ){
									/*
										A_ݒ
										dݒ肪sꂽꍇAŐV̂̂L
									*/
									if(	NowParam == 0 ){
										/* ɕA_Đݒ肷ꍇ̓LZ */
										if(	pCHANSTAT->PatternLoopRow != pMOD->Row ){
											pCHANSTAT->PatternLoopRow	= pMOD->Row ;
											pCHANSTAT->PatternLoopCount	= 0 ;
										}
									}

									/* Kvȉ񐔕򂷂 */
									if(	NowParam ){
										if(	NowParam > pCHANSTAT->PatternLoopCount ){
											pCHANSTAT->PatternLoopCount++ ;
											pMOD->BreakRow = pCHANSTAT->PatternLoopRow ;
										}
									}
								}
							} break ;

							/* E7x : Tremolo waveform */
							case 0xE7 :{
								if(	bFirstTrigger ){
									pCHANSTAT->TremoloType = NowParam ;
								}
							} break ;

							/* E8x : Set Pannning */
							case 0xE8 :{
								if(	bFirstTrigger ){
									pCHANSTAT->PlayingPanning_ = NowParam * ((0xFF << SFT) / 0x0F) ;
								}
							} break ;

							/* E9x : Retrigger note */
							/*
								̋R}h́Aɂ₱dlĂB
								tick 0 ̃gK[́Aʏ Note ̓eŏB
								ȍ~̃gK[͂ŏȂ΂ȂȂB
								҂̌ʂ͈قȂĂB
								XpQeB[KBŐƂۏ؂B
							*/
							case 0xE9 :{
								S32	zxc = NowParam ;
								if( zxc <= 0 ) zxc = 1 ;
								if(	bFirstTrigger == FALSE
								&&	(pMOD->TickCount % zxc) == 0
								){
									/*
										NowInst L
										->	PendingInst   = NowInst
											PlayingInst   = NowInst
											PlayingPeriod = PendingPeriod
											PlayingInst.Sample X^[g
											Env ` = PlayingInst
											Env X^[g
											Auto-Vibrato  PlayingInst ŃX^[g
										else
										->	PendingInst   = PlayingInst		itBЂǂBj
											PlayingPeriod = PendingPeriod
											PlayingInst.Sample X^[g
											Env ` = PlayingInst
											Env X^[g
											Auto-Vibrato  PlayingInst ŃX^[g

										APendingInst łȂ NowInst QƂĂ_sRB
										Âf[^̌݊̂߂Ȃ̂AModPlug ̃oOȂ̂AꂳsB
									*/
									if(	idxNowInst != -1 ){
										pCHANSTAT->pPlayingXM_INSTRUMENT	= pCHANSTAT->pPendingXM_INSTRUMENT
																			= pMOD->apXM_INSTRUMENT[ idxNowInst ];
										pCHANSTAT->PlayingPeriod_			= pCHANSTAT->PendingPeriod_ ;
										if(	pCHANSTAT->pPlayingXM_INSTRUMENT != NULL ){
											pCHANSTAT->pPlayingXM_SAMPLE
											=	pCHANSTAT->
												pPlayingXM_INSTRUMENT->
												apAllNoteXM_SAMPLE[ pCHANSTAT->idxLastRealNote ];
										}
									} else {
										pCHANSTAT->pPendingXM_INSTRUMENT	= pCHANSTAT->pPlayingXM_INSTRUMENT ;
										pCHANSTAT->PlayingPeriod_			= pCHANSTAT->PendingPeriod_ ;
									}
									pCHANSTAT->SamplePosition_			= 0 ;
									pCHANSTAT->idxVolumeEnvelopeTable	= 0 ;
									pCHANSTAT->idxPanningEnvelopeTable	= 0 ;
									pCHANSTAT->AutoVibratoPosition		= 0 ;
									pCHANSTAT->AutoVibratoDepth_		= 0 ;
								}
							} break ;

							/* EAx : Fine volslide up  */
							/* EBx : Fine volslide down */
							case 0xEA :
							case 0xEB :{
								if(	bFirstTrigger ){
									if(	pMOD->FormatType == TYPE_MOD	/* MOD `ł NowParam == 0 ł continue ƂȂ */
									||	(	pMOD->FormatType == TYPE_XM	/* XM `ł NowParam == 0  continue */
										&&	NowParam
										)
									){
										pCHANSTAT->FineVolumeSlide = NowParam ;
									}
									if(	NowCommand == 0xEA ){
										pCHANSTAT->PlayingVolume_ += pCHANSTAT->FineVolumeSlide << SFT ;
									}
									if(	NowCommand == 0xEB ){
										pCHANSTAT->PlayingVolume_ -= pCHANSTAT->FineVolumeSlide << SFT ;
									}
								}
							} break ;

							/* Note cut */
							case 0xEC :{
								if(	pMOD->TickCount == NowParam ){
									pCHANSTAT->PlayingVolume_ = 0 ;
								}
							} break ;

							/* Note delay */
							case 0xED :{
								/* `ɂďς */
							} break ;

							/* Pattern delay */
							case 0xEE :{
								if(	bFirstTrigger ){
									pMOD->PatternDelay = NowParam ;
								}
							} break ;

							/* Set active macroiXM`̂݃T|[gj*/
							case 0xEF :{
								//	!! Ή
								#if (WARNING_LEVEL >= 1)
									LogMsg(
										"MOD__PlaySong : x \n"
										"	Ή̃R}h %03X łB\n"
										,NowCommand
									);
								#endif
								/*
									̃R}hAǂ̂悤ȋ@\Ȃ͕̂sB
									MOD `̏ꍇ́Aꕔ̃gbJ[ɂāATvOĐ̕
									Ił悤AModPlug ɂ͂̂悤ȋ@\݂͑ȂB
									XM `̏ꍇ́AMIDI MACRO ֌W̋@\Ă邪A
									ڍוsBƂAgĂf[^ƂȂB
								*/
							} break ;
						}
					}

					/* Set Speed/Tempo (R}h Fxx) */
					if(	NowCommand == 0xF0 ){
						if(	bFirstTrigger ){
							if(	NowParam ){
								if(	NowParam <= 0x20  &&  pMOD->FormatType == TYPE_MOD
								||	NowParam <  0x20  &&  pMOD->FormatType == TYPE_XM
								){
									pMOD->nTickPerRow = NowParam ;
									if(	pMOD->nTickPerRow <= 0 ) pMOD->nTickPerRow = 1 ;
								} else {
									pMOD->BPM = NowParam ;
								}
							} else {
								/* ȗ́AO܂ł̒lpĎgp */
							}
						}
					}

					/* Global volumeiR}h Gxxj*/
					if(	NowCommand == 0x100 ){
						if(	bFirstTrigger ){
							pMOD->GlobalVolume_ = NowParam << SFT ;
						}
					}

					/* Global volume slideiR}h Hxyj*/
					if(	NowCommand == 0x110 ){
						if(	bFirstTrigger ){
							if( NowParam ){
								/* NowParam  4 bit DIɎQƂB*/
								if(	NowParam & 0xF0 ){
									pMOD->GlobalVolumeSlide = ((NowParam & 0xF0) >> 4) ;
								} else {
									pMOD->GlobalVolumeSlide = -((S32)NowParam & 0x0F) ;
								}
							}
						}
						pMOD->GlobalVolume_ += pMOD->GlobalVolumeSlide * ModifyVal_ ;
					}

					/* KeyoffiR}h Kxxj*/
					/*
						p[^[ xx ɈӖ͂ȂA炵B
					*/
					if(	NowCommand == 0x140 ){
						if(	bFirstTrigger ){
							pCHANSTAT->bFadeOut = TRUE ;
						}
					}

					/* Set envposiR}h Lxxj*/
					if(	NowCommand == 0x150 ){
						if(	bFirstTrigger ){
							pCHANSTAT->idxVolumeEnvelopeTable	= NowParam ;
							pCHANSTAT->idxPanningEnvelopeTable	= NowParam ;
						}
					}

					/* Panning slideiR}h Pxyj*/
					if(	NowCommand == 0x190 ){
						if(	bFirstTrigger ){
							if(	NowParam ){
								/* OIɁANowParam  4 bit DIɎQƂB*/
								if(	NowParam & 0x0F ){
									pCHANSTAT->PanningSlide = -((S32)NowParam & 0x0F) * 4 ;		/* փXCh */
								} else {
									pCHANSTAT->PanningSlide = ((NowParam & 0xF0) >> 4) * 4 ;	/* EփXCh */
								}
							}
						}
						pCHANSTAT->PlayingPanning_ += pCHANSTAT->PanningSlide * ModifyVal_ ;
					}

					/* Multi retrigiR}h Rxyj*/
					/*
						tick 0 甭AModifyVal_ ̕␳͕svB
						Â XM ł́Atick 0 ł͔AModifyVal_ ̕␳Kv炵iΉjB
					*/
					if(	NowCommand == 0x1B0 ){
						/*                                        +0  +1  +2  +3  +4  +5  +6  +7  +8  +9  +A  +B  +C  +D  +E  +F */
						static const S8	aMultiRetrigMulTable[] = { 0,  0,  0,  0,  0,  0, 10,  8,  0,  0,  0,  0,  0,  0, 24, 32 };
						static const S8	aMultiRetrigAddTable[] = { 0, -1, -2, -4, -8,-16,  0,  0,  0, +1, +2, +4, +8,+16,  0,  0 };

						if(	bFirstTrigger ){
							/* x y ʂɁA0 Ȃ continue */
							if(	NowParam & 0x0F ){
								pCHANSTAT->MultiRetrigInterval = NowParam & 0x0F ;
							}
							if(	NowParam & 0xF0 ){
								pCHANSTAT->MultiRetrigVolumeChange = (NowParam & 0xF0) >> 4 ;
							}
						}

						if(	pCHANSTAT->MultiRetrigCount >= pCHANSTAT->MultiRetrigInterval
						&&	pCHANSTAT->MultiRetrigInterval
						){
							pCHANSTAT->SamplePosition_	= 0 ;	/* Đʒȕ̂ */
							pCHANSTAT->MultiRetrigCount	= 0 ;

							if(	aMultiRetrigMulTable[ pCHANSTAT->MultiRetrigVolumeChange ] == 0 ){
								pCHANSTAT->PlayingVolume_ += aMultiRetrigAddTable[ pCHANSTAT->MultiRetrigVolumeChange ] << SFT ;
								if(	pCHANSTAT->PlayingVolume_ < (   0 << SFT) ) pCHANSTAT->PlayingVolume_ = (   0 << SFT) ;
								if(	pCHANSTAT->PlayingVolume_ > (0x40 << SFT) ) pCHANSTAT->PlayingVolume_ = (0x40 << SFT) ;
							} else {
								pCHANSTAT->PlayingVolume_
								=	pCHANSTAT->PlayingVolume_ * aMultiRetrigMulTable[ pCHANSTAT->MultiRetrigVolumeChange ] >> 4 ;
								if(	pCHANSTAT->PlayingVolume_ > (0x40 << SFT) ) pCHANSTAT->PlayingVolume_ = (0x40 << SFT) ;
							}
						}
						pCHANSTAT->MultiRetrigCount++ ;
					}

					/* TremoriR}h Txyj*/
					/*
						̃R}h́Ã݂`l̔Aw frame Pʂ ON OFF @\łB
						Ⴆ΁AT[ontime][offtime] ̗lɋLq܂B
						x=ontime, y=offtime ƂƁAx frame ̊ԃ{[l͕ωA
						̌ y frame ̊ԃ~[gԁijɂȂ܂B
						ontime / offtime ̐mȎԂ MOD / XM / S3M / IT ̊ԂňقȂ̂ŒӂłB 
					*/
					if(	NowCommand == 0x1D0 ){
						pCHANSTAT->bTremorMute = FALSE ;

						if(	bFirstTrigger ){
							/* x y  0 ̎̂ continue */
							if(	NowParam ){
								pCHANSTAT->TremorOnTime = ((NowParam >> 4) & 0xF) + 1 ;
								pCHANSTAT->TremorOffTime = (NowParam & 0xF) + 1 ;
							}
							pCHANSTAT->TremorCount = 0 ;

						} else {
							/*
								TickPerRow = (TremorOnTime + TremorOffTime) * n + 1
								𖞂ȂꍇAModPlug ł͈肵ȂioOHjA
								܂ł͍ČłĂȂBȂ薳Ӗۂ̂ŁAËB
							*/

							if(	pCHANSTAT->TremorCount >= pCHANSTAT->TremorOnTime ){
								pCHANSTAT->bTremorMute = TRUE ;
							}

							pCHANSTAT->TremorCount++ ;
							if( pCHANSTAT->TremorCount >= pCHANSTAT->TremorOnTime + pCHANSTAT->TremorOffTime ){
								pCHANSTAT->TremorCount = 0 ;
							}
						}
					} else {
						pCHANSTAT->bTremorMute = FALSE ;
					}

					/* Extended XM Effects (R}h Xxy) */
					if(	(NowCommand & 0xFF0) == 0x210 ){
						switch( NowCommand ){
							/* X1x : Extra Fine Portamento Up */
							/* X2x : Extra Fine Portamento Down */
							case 0x211 :
							case 0x212 :{
								if(	bFirstTrigger ){
									if(	NowParam ){
										pCHANSTAT->ExtraFinePortamentoInc = NowParam ;
									}
									if(	NowCommand == 0x211 ){
										pCHANSTAT->PlayingPeriod_ -= pCHANSTAT->ExtraFinePortamentoInc << SFT ;
									}
									if(	NowCommand == 0x212 ){
										pCHANSTAT->PlayingPeriod_ += pCHANSTAT->ExtraFinePortamentoInc << SFT ;
									}
								}
							} break ;

							/* X5x : Panbrello wave form */
							case 0x215 :{
								pCHANSTAT->PanbrelloType = NowParam ;
							} break ;

							/* X6x : Fine pattern delay */
							case 0x216 :{
								if(	bFirstTrigger ){
									pMOD->FinePatternDelay = NowParam ;
								}
							} break ;

							/* X9x : Surround control */
							case 0x219 :{
								switch(	NowParam ){
									/* X90 : Surround Off */
									case 0x0 :{
										pCHANSTAT->bSurround		= FALSE ;
									} break ;

									/* X91 : Surround On */
									case 0x1 :{
										pCHANSTAT->PlayingPanning_	= (0xFF << SFT) / 2 ;
										pCHANSTAT->bSurround		= TRUE ;
									} break ;

									/* X98 : Reverb Off */
									case 0x8 :{
										//	!! Ή
										#if (WARNING_LEVEL >= 1)
											LogMsg(
												"MOD__PlaySong : x \n"
												"	Ή̃R}h %03X łB\n"
												,NowCommand
											);
										#endif
									} break ;

									/* X99 : Reverb On */
									case 0x9 :{
										//	!! Ή
										#if (WARNING_LEVEL >= 1)
											LogMsg(
												"MOD__PlaySong : x \n"
												"	Ή̃R}h %03X łB\n"
												,NowCommand
											);
										#endif
									} break ;

									/* X9A : Center surround */
									case 0xA :{
										//	!! Ή
										#if (WARNING_LEVEL >= 1)
											LogMsg(
												"MOD__PlaySong : x \n"
												"	Ή̃R}h %03X łB\n"
												,NowCommand
											);
										#endif
									} break ;

									/* X9B : Quad surround */
									case 0xB :{
										//	!! Ή
										#if (WARNING_LEVEL >= 1)
											LogMsg(
												"MOD__PlaySong : x \n"
												"	Ή̃R}h %03X łB\n"
												,NowCommand
											);
										#endif
									} break ;

									/* X9C : Grobal filters */
									case 0xC :{
										//	!! Ή
										#if (WARNING_LEVEL >= 1)
											LogMsg(
												"MOD__PlaySong : x \n"
												"	Ή̃R}h %03X łB\n"
												,NowCommand
											);
										#endif
									} break ;

									/* X9D : Local filters */
									case 0xD :{
										//	!! Ή
										#if (WARNING_LEVEL >= 1)
											LogMsg(
												"MOD__PlaySong : x \n"
												"	Ή̃R}h %03X łB\n"
												,NowCommand
											);
										#endif
									} break ;

									/* X9E : Play Forward */
									case 0xE :{
										//	!! Ή
										#if (WARNING_LEVEL >= 1)
											LogMsg(
												"MOD__PlaySong : x \n"
												"	Ή̃R}h %03X łB\n"
												,NowCommand
											);
										#endif
									} break ;

									/* X9F : Play Backward */
									case 0xF :{
										//	!! Ή
										#if (WARNING_LEVEL >= 1)
											LogMsg(
												"MOD__PlaySong : x \n"
												"	Ή̃R}h %03X łB\n"
												,NowCommand
											);
										#endif
									} break ;
								}
							} break ;

							/* XAx : Set high offset */
							case 0x21A :{
								pCHANSTAT->SampleHighOffset = NowParam ;
							} break ;
						}
					}

					/* PanbrelloiR}h Yxyj*/
					if(	NowCommand == 0x220 ){
						if(	bFirstTrigger ){
							/* Depth Rate ʂɁA0 Ȃ continue */
							if(	NowParam & 0x0F ){
								pCHANSTAT->PanbrelloDepth = NowParam & 0x0F ;
							}
							if(	NowParam & 0xF0 ){
								pCHANSTAT->PanbrelloRate = (NowParam & 0xF0) >> 4 ;
							}
						}
						bPanbrello = TRUE ;
					}

					/* Midi macroiR}h Zxyj*/
					if(	NowCommand == 0x230 ){
						//	!!	Ή
						#if (WARNING_LEVEL >= 1)
							LogMsg(
								"MOD__PlaySong : x \n"
								"	Ή̃R}h %03X łB\n"
								,NowCommand
							);
						#endif
					}

				}


				/* p̍ŏIl߂ */
				if(	pCHANSTAT->pPlayingXM_INSTRUMENT != NULL
				&&	pCHANSTAT->pPlayingXM_SAMPLE != NULL
				){
					XM_INSTRUMENT	*pXM_INSTRUMENT = pCHANSTAT->pPlayingXM_INSTRUMENT ;
					S32	FinalPanning_ ;

					/* lL͈͓ */
					if(	pCHANSTAT->PlayingPanning_ <            0  ) pCHANSTAT->PlayingPanning_ =  0 ;
					if(	pCHANSTAT->PlayingPanning_ > (0xFF << SFT) ) pCHANSTAT->PlayingPanning_ = (0xFF << SFT) ;

					/* 0x000 ` 0x0FF -> 0x000 ` 0x100 */
					FinalPanning_ = pCHANSTAT->PlayingPanning_ * 0x100 / 0xFF ;

					/*
						Panbrello ̔f
						ModfyVal_ ̔{͔fȂ̂B
						Ȃ݂ɁAPanbrello g`ɂ́AX^[g̊TO悤B
					*/
					if(	bPanbrello ){
						S32	Val =	(	(	_aaWaveTable[
												_aPanbrelloWaveType[
													pCHANSTAT->PanbrelloType & 3
												]
											][
												((pCHANSTAT->PanbrelloPosition + 0x10) >> 2) & 0x3F
											] * pCHANSTAT->PanbrelloDepth
										) + 2
									) >> 3 ;
						pCHANSTAT->PanbrelloPosition += pCHANSTAT->PanbrelloRate ;

						FinalPanning_ += Val << SFT ;

						/* lL͈͓ */
						if(	FinalPanning_ > (0x100 << SFT) ) FinalPanning_ = 0x100 << SFT ;
						if(	FinalPanning_ <  0             ) FinalPanning_ = 0 ;
					}

					/* pGx[v */
					if(	pXM_INSTRUMENT->PanningType & ENV_ON ){
						if(	pCHANSTAT->idxPanningEnvelopeTable > 324 ) pCHANSTAT->idxPanningEnvelopeTable = 324 ;

						{
							S32	Val = pXM_INSTRUMENT->PanningEnvelopeTable[ pCHANSTAT->idxPanningEnvelopeTable ];
							if(	FinalPanning_ >= (0x80 << SFT) ){
								FinalPanning_ += (Val - 32) * ((0x100 << SFT) - FinalPanning_) / 32 ;
							} else {
								FinalPanning_ += (Val - 32) * FinalPanning_ / 32 ;
							}
						}

						/* lL͈͓ */
						if(	FinalPanning_ > (0x100 << SFT) ) FinalPanning_ = 0x100 << SFT ;
						if(	FinalPanning_ <  0             ) FinalPanning_ = 0 ;

						if(	!(	pXM_INSTRUMENT->PanningType & ENV_SUSTAIN
							&&	pCHANSTAT->bFadeOut == FALSE
							&&	pCHANSTAT->idxPanningEnvelopeTable == pXM_INSTRUMENT->PanningSustainPoint
							)
						){
							pCHANSTAT->idxPanningEnvelopeTable++ ;
		
							if(	pXM_INSTRUMENT->PanningType & ENV_LOOP ){
								if(	pCHANSTAT->idxPanningEnvelopeTable >= pXM_INSTRUMENT->PanningLoopEndPoint ){
									pCHANSTAT->idxPanningEnvelopeTable = pXM_INSTRUMENT->PanningLoopStartPoint ;
								}
							}
						}

						/* lL͈͓ */
						if(	FinalPanning_ > (0x100 << SFT) ) FinalPanning_ = 0x100 << SFT ;
						if(	FinalPanning_ <  0             ) FinalPanning_ = 0 ;
					}

					pCHANSTAT->FinalPanning_ = FinalPanning_ ;
				}

				/* ʂ̍ŏIl߂ */
				if(	pCHANSTAT->pPlayingXM_INSTRUMENT != NULL
				&&	pCHANSTAT->pPlayingXM_SAMPLE != NULL
				){
					XM_INSTRUMENT	*pXM_INSTRUMENT = pCHANSTAT->pPlayingXM_INSTRUMENT ;
					S32	FinalVolume_ ;

					/* lL͈͓ */
					if(	pCHANSTAT->PlayingVolume_ > (0x40 << SFT) ) pCHANSTAT->PlayingVolume_ = 0x40 << SFT ;
					if(	pCHANSTAT->PlayingVolume_ < 0             ) pCHANSTAT->PlayingVolume_ = 0 ;
					if(	pMOD->GlobalVolume_       > (0x40 << SFT) ) pMOD->GlobalVolume_       = 0x40 << SFT ;
					if(	pMOD->GlobalVolume_       < 0             ) pMOD->GlobalVolume_       = 0 ;

					FinalVolume_ = pCHANSTAT->PlayingVolume_ ;

					/* Tremolo ̔f */
					if(	bTremolo ){
						S32	Val =	_aaWaveTable[
										_aTremoloWaveType[ pCHANSTAT->TremoloType & 3 ]
									][
										(pCHANSTAT->TremoloPosition_ >> SFT) & 0x3F
									];
						pCHANSTAT->TremoloPosition_ += pCHANSTAT->TremoloRate * ModifyVal_ ;

						/* MOD `ł́AőU -0x1F ` +0x1F */
						if(	pMOD->FormatType == TYPE_MOD ){
							FinalVolume_ += (Val << (SFT - 6)) * pCHANSTAT->TremoloDepth ;
						}

						/* XM `ł́AőU -0x3F ` +0x3F */
						if(	pMOD->FormatType == TYPE_XM ){
							FinalVolume_ += (Val << (SFT - 5)) * pCHANSTAT->TremoloDepth ;
						}

						/* lL͈͓ */
						if(	FinalVolume_ > (0x40 << SFT) ) FinalVolume_ = 0x40 << SFT ;
						if(	FinalVolume_ < 0             ) FinalVolume_ = 0 ;
					}

					/* Tremoro ̔f */
					if(	pCHANSTAT->bTremorMute ) FinalVolume_ = 0 ;

					/* L[It tF[hAEg */
					{
						if(	pCHANSTAT->bFadeOut == TRUE ){
							if(	(pCHANSTAT->pPlayingXM_INSTRUMENT->VolumeType & ENV_ON) == 0 ){
							/* {[Gx[v̏ꍇ́Auɉ 0 ƂȂ */
								pCHANSTAT->PlayingVolume_ = 0 ;
								FinalVolume_ = 0 ;
								pCHANSTAT->bFadeOut = FALSE ;
							} else {
							/* {[Gx[vL̏ꍇ̓tF[hAEg */
								pCHANSTAT->FadeOutVolume_1_15_16 -= (S32)pXM_INSTRUMENT->VolumeFadeout * 2 ;
								if(	pCHANSTAT->FadeOutVolume_1_15_16 < 0 ) pCHANSTAT->FadeOutVolume_1_15_16 = 0 ;
							}
						} else {
							pCHANSTAT->FadeOutVolume_1_15_16 = 1 << 16 ;
						}
						FinalVolume_ = (FinalVolume_ * (pCHANSTAT->FadeOutVolume_1_15_16 >> 8)) >> 8 ;
					}

					/* {[Gx[v */
					if(	pXM_INSTRUMENT->VolumeType & ENV_ON ){
						if(	pCHANSTAT->idxVolumeEnvelopeTable > 324 ) pCHANSTAT->idxVolumeEnvelopeTable = 324 ;
						FinalVolume_ =	(	FinalVolume_
										*	pXM_INSTRUMENT->VolumeEnvelopeTable[ pCHANSTAT->idxVolumeEnvelopeTable ]
										) >> 6 ;

						if(	!(	pXM_INSTRUMENT->VolumeType & ENV_SUSTAIN
							&&	pCHANSTAT->bFadeOut == FALSE
							&&	pCHANSTAT->idxVolumeEnvelopeTable == pXM_INSTRUMENT->VolumeSustainPoint
							)
						){
							pCHANSTAT->idxVolumeEnvelopeTable++ ;

							if(	pXM_INSTRUMENT->VolumeType & ENV_LOOP ){
								if(	pCHANSTAT->idxVolumeEnvelopeTable >= pXM_INSTRUMENT->VolumeLoopEndPoint ){
									pCHANSTAT->idxVolumeEnvelopeTable = pXM_INSTRUMENT->VolumeLoopStartPoint ;
								}
							}
						}

						/* lL͈͓ */
						if(	FinalVolume_ > (0x40 << SFT) ) FinalVolume_ = 0x40 << SFT ;
						if(	FinalVolume_ < 0             ) FinalVolume_ = 0 ;
					}

					/* O[o{[̔f */
					FinalVolume_ = (FinalVolume_ >> 6) * (pMOD->GlobalVolume_ >> 6) >> (SFT - 6) ;

					/* Ǝ̉ʃXP[O */
					FinalVolume_ = (FinalVolume_ >> 6) * pCHANSTAT->VolumeScale_ >> (SFT - 6) ;
					FinalVolume_ = (FinalVolume_ >> 6) * pMOD->GlobalVolumeScale_ >> (SFT - 6) ;

					/* L R ʂɍŏIl߂ */
					pCHANSTAT->FinalVolume_		= FinalVolume_ ;
					pCHANSTAT->FinalVolume_R_	= FinalVolume_ * (pCHANSTAT->FinalPanning_ >> SFT) >> 8 ;
					pCHANSTAT->FinalVolume_L_	= FinalVolume_ - pCHANSTAT->FinalVolume_R_ ;

					/* Surround LȂA`l̈ʑ𔽓] */
					if(	pCHANSTAT->bSurround ){
						pCHANSTAT->FinalVolume_L_ = -pCHANSTAT->FinalVolume_L_ ;
					}
				}

				/* Period ̍ŏIl߂ */
				if(	pCHANSTAT->pPlayingXM_INSTRUMENT != NULL
				&&	pCHANSTAT->pPlayingXM_SAMPLE != NULL
				){
					/* lL͈͓ */
					if( pCHANSTAT->PlayingPeriod_ > pCHANSTAT->PeriodHighLimit_ ){
						pCHANSTAT->PlayingPeriod_ = pCHANSTAT->PeriodHighLimit_ ;
					}
					if( pCHANSTAT->PlayingPeriod_ < pCHANSTAT->PeriodLowLimit_ ){
						pCHANSTAT->PlayingPeriod_ = pCHANSTAT->PeriodLowLimit_ ;
					}

					pCHANSTAT->FinalPeriod_ = pCHANSTAT->PlayingPeriod_ ;

					/* Arpeggio LȂ炻̏ */
					if(	bArpeggio ){
						if(	pCHANSTAT->idxArpeggio == 1 ){
							pCHANSTAT->FinalPeriod_ = pCHANSTAT->ArpeggioPeriod_[0] ;
						}
						if(	pCHANSTAT->idxArpeggio == 2 ){
							pCHANSTAT->FinalPeriod_ = pCHANSTAT->ArpeggioPeriod_[1] ;
						}
						if(	++pCHANSTAT->idxArpeggio >= 3 ) pCHANSTAT->idxArpeggio = 0 ;
					}

					/* Grissando LȂAŊ̔K */
					if( pCHANSTAT->bGrissando ){
						S32	FineTune = pCHANSTAT->PlayingFineTune ;
						pCHANSTAT->FinalPeriod_
						=	MOD__KeyToPeriod_(
								 pMOD
								,MOD__Period_ToKey( pMOD ,pCHANSTAT->FinalPeriod_ , FineTune )
								,FineTune
							);
					}

					/*
						Vibrato ̔fiGrissando ɍsj
						ModPlug ł́AVolumeColumn  Uxx Hxx ̍pƁA
						W[R}h 4xy ̍ṕA݂ɉZȂB
					*/
					if(	bVibrato ){
						S32	Val =	_aaWaveTable[
										_aVibratoWaveType[ pCHANSTAT->VibratoType & 3 ]
									][
										(pCHANSTAT->VibratoPosition_ >> SFT) & 0x3F
									];
						pCHANSTAT->VibratoPosition_ += pCHANSTAT->VibratoRate * ModifyVal_ ;

						/*
							AmigaPeriod [hA`g[hA
							ƂɁAőU -0x7F ` +0x7F
						*/
						pCHANSTAT->FinalPeriod_ += (Val << (SFT - 4)) * pCHANSTAT->VibratoDepth ;
					}

					/*
						Auto-Vibrato ̔f
						ModfyVal_ ̔{͔fȂ̂B
					*/
					{
						S32	InstAutoVibratoType	 = pCHANSTAT->pPlayingXM_INSTRUMENT->AutoVibratoType ;
						S32	InstAutoVibratoSweep = pCHANSTAT->pPlayingXM_INSTRUMENT->AutoVibratoSweep ;
						S32	InstAutoVibratoDepth = pCHANSTAT->pPlayingXM_INSTRUMENT->AutoVibratoDepth ;
						S32	InstAutoVibratoRate	 = pCHANSTAT->pPlayingXM_INSTRUMENT->AutoVibratoRate ;

						if(	InstAutoVibratoDepth
						&&	InstAutoVibratoRate
						){
							if(	InstAutoVibratoSweep ){
								if(	pCHANSTAT->bFadeOut == FALSE ){
									pCHANSTAT->AutoVibratoDepth_ += (InstAutoVibratoDepth << SFT) / InstAutoVibratoSweep ;
									if(	pCHANSTAT->AutoVibratoDepth_ > (InstAutoVibratoDepth << SFT) ){
										pCHANSTAT->AutoVibratoDepth_ = (InstAutoVibratoDepth << SFT) ;
									}
								}
							} else {
								pCHANSTAT->AutoVibratoDepth_ = (InstAutoVibratoDepth << SFT) ;
							}
							pCHANSTAT->AutoVibratoPosition += InstAutoVibratoRate ;

							/* őU -AutoVibratoDepth ` +AutoVibratoDepth */
							{
								if(	InstAutoVibratoType > 4 ) InstAutoVibratoType = 0 ;
								if(	InstAutoVibratoType == 4 ){
									/* OIɁAg`xɈˑȂ_ggp */
									pCHANSTAT->FinalPeriod_ += ((rand() & 0x1FF) - 0x100) * pCHANSTAT->AutoVibratoDepth_ >> 7 ;
								} else {
									pCHANSTAT->FinalPeriod_ +=	(	_aaWaveTable[
																		_aAutoVibratoWaveType[ InstAutoVibratoType ]
																	][
																		(pCHANSTAT->AutoVibratoPosition >> 2) & 0x3F
																	] * pCHANSTAT->AutoVibratoDepth_
																) >> 7 ;
								}
							}
						}
					}
				}

				/* gZo */
				if(	pCHANSTAT->pPlayingXM_SAMPLE != NULL ){
					if(	pCHANSTAT->FinalPeriod_
					&&	pMOD->nWavePerSec
					){
						F64	f64Freq ;

						if(	pMOD->XmHeader.Flags & LINEAR_FREQUENCY ){
						/* `g[h */
							f64Freq	=	(F64)8363
									*	pow( 2 , ((F64)(6*12*16*4) - (F64)pCHANSTAT->FinalPeriod_ / (F64)ONE) / (F64)(12*16*4) );
						} else {
						/* AmigaPeriod [h */
							F64	AmigaClock = 3579364 ;
							if(	pMOD->FormatType == TYPE_MOD ) AmigaClock = 3546894.6 ;
							f64Freq	= AmigaClock * 4 / ((F64)pCHANSTAT->FinalPeriod_ / (F64)ONE) ;
						}

						pCHANSTAT->SampleRate_ = (U32)(f64Freq * (F64)ONE / (F64)pMOD->nWavePerSec) ;
					}
				}

			}	/* end of for */

			break ;		/* Eo */
		}	/* end of while */

		pMOD->TickCount++ ;

		/* 莞Ԃ 1 Row i */
		if(	pMOD->TickCount >= pMOD->nTickPerRow * (1 + pMOD->PatternDelay) + pMOD->FinePatternDelay ){
			#if (WARNING_LEVEL >= 3)
				LogMsg(
					"\n"
				);
			#endif

			pMOD->TickCount			= 0 ;
			pMOD->PatternDelay		= 0 ;
			pMOD->FinePatternDelay	= 0 ;

			/* Sequence ̕ */
			if(	pMOD->BreakSequence != -1 ){
				pMOD->idxSequenceData	= pMOD->BreakSequence ;
				pMOD->BreakSequence		= -1 ;
				pMOD->Row				= -1 ;	/* ɃCNĝ -1 */
				MOD__InitPatternLoop( pMOD );
			}

			/* Row ̕ */
			if(	pMOD->BreakRow != -1 ){
				pMOD->Row		= pMOD->BreakRow ;
				pMOD->BreakRow	= -1 ;
			} else {
				pMOD->Row++ ;
			}

			/* p^[[ɒBꍇ̏ */
			{
				XM_PATTERN *pXM_PATTERN
				=	pMOD->apXM_PATTERN[ pMOD->XmHeader.aPatternOrderTable[ pMOD->idxSequenceData ] ];
				if(	pXM_PATTERN != NULL ){
					if(	pMOD->Row >= pXM_PATTERN->NumberOfRowsInPattern ){
						pMOD->Row = 0 ;
						pMOD->idxSequenceData++ ;
						MOD__InitPatternLoop( pMOD );
					}
				} else {
					/*  NULL ȂI_ɒBƂ݂Ȃ */
					pMOD->bDone = TRUE ;
				}
			}

			/* I_ɒBH */
			if(	pMOD->idxSequenceData >= 256 ){
				pMOD->bDone = TRUE ;
			} else
			if(	pMOD->XmHeader.aPatternOrderTable[ pMOD->idxSequenceData ] == 0xFF
			||	pMOD->idxSequenceData >= pMOD->XmHeader.SongLength
			){
				pMOD->bDone = TRUE ;		/* Ō܂ōĐ */
			}
		}


		/*
			܂łǂ蒅_ŁA1 tick ̔g`̏o͂B

			́A1 tick ̔g`𒲐邱ƂŁAm BPM Čdg݁B
			nWavePerTick ̎Z͗lXȃvC[œ̃mBe̓C}C`ǂȂB
		*/
		pMOD->nWavePerTick	= (pMOD->nWavePerSec * 5) / (pMOD->BPM * 2);
		pMOD->nRestWave += pMOD->nWavePerTick ;
	}
}



/*
	MOD \̂̔j

	ߒlETRUE  = 
		EFALSE = s
*/
S32 MOD__Destruct(
	MOD	*p		/* this |C^[ */
){
	if(	p == NULL ) return( FALSE );

	if(	MOD__ReleaseSong( p ) == FALSE ) return( FALSE );
//	FreeMemory( p );
	free( p );
	return( TRUE );
}



/*
	MOD \̂̊mۂƏ

	ߒlF	mۂ\̂ւ̃|C^[
			NULL Ȃ玸s
*/
MOD *MOD__Create(
){
	S32	i ;
	S32	size = sizeof( MOD );
//	MOD	*p = AllocMemory( size );
	MOD	*p = malloc( size );

	if( p == NULL ) return( NULL );

	/* ʓ|Ȃ̂łOŃNA */
	for( i=0 ; i<size ; i++ ) ((U8*)p)[i] = 0 ;

	/* o[̏l */
	p->FormatType			= TYPE_NOTAVAILABLE ;
	p->nWavePerSec			= 44100 ;
	p->bLoopMode			= TRUE ;
	p->bAutoGainControl		= TRUE ;
	p->GlobalVolumeScale_	= ONE ;
	for( i=0 ; i<MAX_PATTERNS ; i++ ) p->apXM_PATTERN[ i ] = NULL ;
	for( i=0 ; i<MAX_INSTRUMENTS ; i++ ) p->apXM_INSTRUMENT[ i ] = NULL ;
	for( i=0 ; i<MAX_SAMPLES ; i++ ) p->apXM_SAMPLE[ i ] = NULL ;

	return( p );
}



