// YMod.cpp
// t@~x̂񎁂ɂ Ȉ MOD / XM vC[ modĐNX.
// git@C͂Ƃ̒xj.
#include "YMod.h"
#include <string.h>


//public:static
YMod *YMod::createN(char *aModFileName){
	YMod *self = new YMod();
	if(self->constructE(aModFileName) != ERROR_NONE){
		delete self;
		self = NULL;
	}
	return self;
}

//private:
YMod::YMod():
	iYMod(NULL),
	iAudioStream(NULL) {
}

#define YMOD_FILENAME_MAX 255

int YMod::constructE(char *aModFileName){
	int ret;
	char fn[YMOD_FILENAME_MAX + 1];

	if(strlen(aModFileName) > YMOD_FILENAME_MAX){
		return ERROR_ARGUMENT;
	}
	strcpy(fn, aModFileName);

	// _mod 쐬
	RETURN_ERROR_IF_NULL(iYMod, MOD__Create());

	FILE *fp;
	RETURN_ERROR_IF_NULL(fp, fopen(fn, "rb"));
	
	int cacheBlock = 4096;
	int cacheLast = 0;
	int cacheLength = 0;
	unsigned char *cache = NULL;
		for(int i = 1; !(feof(fp)); i++){
			cache = (unsigned char *)realloc(cache, sizeof(unsigned char) * cacheBlock * i);
			cacheLength+=cacheBlock;
			cacheLast += fread(&cache[cacheLast], sizeof(unsigned char), cacheBlock, fp);
		}
		fclose(fp);

		// _modɋȃt@Cǂ܂
		ret = MOD__LoadSong(iYMod, cache, cacheLast);
	free(cache);
	cache = NULL;
	cacheLast = 0;
	cacheLength = 0;

	if(ret == FALSE){
		// Ȃǂݍ߂ȂƂ
		return ERROR_ARGUMENT;
	}

	// _mod̏ݒ
	MOD__Set_nWavePerSec(iYMod, YMOD_STREAM_FREQ);
	MOD__Set_bLoopMode(iYMod, TRUE);
	MOD__Set_Volume(iYMod, 255);
	MOD__Set_bAutoGainControl(iYMod, TRUE);
	MOD__InitPlay(iYMod);

	// AllegroAudioStreamJ
//	iAudioStream = play_audio_stream(YMOD_STREAM_BUFFER_LENGTH, 16/*bit*/, 1/*STEREO*/, YMOD_STREAM_FREQ, 255, 128);

	// Ƃ肠ĐJnĂHȂĂ悳
/*	void *p = get_audio_stream_buffer(iAudioStream);
	if(p != NULL){
		MOD__PlaySong(iYMod, (unsigned long *)p, YMOD_STREAM_BUFFER_LENGTH);
		free_audio_stream_buffer(iAudioStream);
	}*/
	return ERROR_NONE;
}

YMod::~YMod(){
	if(iAudioStream != NULL){
		stop_audio_stream(iAudioStream);
		iAudioStream = NULL;
	}
	if(iYMod != NULL){
		MOD__ReleaseSong(iYMod);
		MOD__Destruct(iYMod);
		iYMod = NULL;
	}
}


//virtual	
int YMod::playE(int aVol, int aPan, int aFreq, int aLoop){
	adjust(aVol, aPan, aFreq, aLoop);
	// AllegroAudioStreamJ
	if(!iAudioStream){
		iAudioStream = play_audio_stream(YMOD_STREAM_BUFFER_LENGTH, 16/*bit*/, 1/*STEREO*/, YMOD_STREAM_FREQ, 255, 128);
	}
	if(!iAudioStream){
		return ERROR_GENERAL;
	}
	update();
	return ERROR_NONE;
}

//virtual 
void YMod::adjust(int aVol, int aPan, int aFreq, int aLoop){
	iVol = aVol;
	iPan = aPan;
	iFreq = aFreq;
	iLoop = aLoop;
	//modvC[̃TvO[gς邱Ƃőx̒sĂ܂.
	//Ȃ̂nWavePerSecɓnl2{ɂȂƑxA1/2ɂȂƔ{BĂƂɂȂ_ɒ.
	MOD__Set_nWavePerSec(iYMod, YMOD_STREAM_FREQ * 1000 / iFreq);
	MOD__Set_bLoopMode(iYMod, iLoop);
	MOD__Set_Volume(iYMod, iVol);
}

//virtual 
void YMod::stop(){
	if(iAudioStream){
		stop_audio_stream(iAudioStream);
		iAudioStream = NULL;
	}
	MOD__InitPlay(iYMod);
}

void YMod::update(){
	//MODĐ
	if(!iAudioStream){
		return;
	}

	void *p = get_audio_stream_buffer(iAudioStream);
	if(p != NULL){
		if( ! (MOD__PlaySong(iYMod, (unsigned long *)p, YMOD_STREAM_BUFFER_LENGTH)) ){
			//Đs
			return;
		}
		free_audio_stream_buffer(iAudioStream);
	}
	return;
}





//private:
//	MOD *iYMod;
//	AUDIOSTREAM *iAudioStream;

