#include "TStage.h"
#include "TMovie.h"
#include "TPlayer.h"
#include "TDragon.h"

extern Settings *GE_settings;

TStage::TStage(GmTask *aParent) : GmTask(aParent){
	iParent = aParent;
	iX = 320;
	iY = 240;
	iAge = 0;
	iStatus = ST_TITLEINIT;
	this->setPriotiyy(GmTask::EPriorityExLow+10);
	iSprite[0] = NULL;
	iSprite[1] = NULL;
	iSprite[2] = NULL;
	iSprite[3] = NULL;
}

int TStage::initializeE(){
	GmMain *parent = (GmMain *)iParent;
	BITMAP *src = parent->getGmGfxN()->getSprite();

	//^Cg.
	iSprite[0] = create_sub_bitmap(src, 0*2, 32*2, 192*2, 128*2);
	if(!(iSprite[0])){ return ERROR_GENERAL; }
	//}EXJ[\.
	iSprite[1] = create_sub_bitmap(src, 48*2, 0*2, 32*2, 32*2);
	if(!(iSprite[1])){ return ERROR_GENERAL; }
	//NA.
	iSprite[2] = create_sub_bitmap(src, 0*2, 160*2, 192*2, 128*2);
	if(!(iSprite[2])){ return ERROR_GENERAL; }
	//Q[I[o[.
	iSprite[3] = create_sub_bitmap(src, 80*2, 0*2, 64*2, 8*2);
	if(!(iSprite[3])){ return ERROR_GENERAL; }

	return ERROR_NONE;
}

TStage::~TStage(){
	if(iSprite[0]){
		destroy_bitmap(iSprite[0]);
		iSprite[0] = NULL;
	}
	if(iSprite[1]){
		destroy_bitmap(iSprite[1]);
		iSprite[1] = NULL;
	}
	if(iSprite[2]){
		destroy_bitmap(iSprite[2]);
		iSprite[2] = NULL;
	}
	if(iSprite[3]){
		destroy_bitmap(iSprite[3]);
		iSprite[3] = NULL;
	}
}

void TStage::update(){
	GmMain *parent = (GmMain *)iParent;
	GmGfx *gfx = parent->getGmGfxN();
	BITMAP *dst = gfx->getBackBuffer();
	GmInput *in = ((GmMain *)iParent)->getGmInputN();
	iAge++;

	switch(iStatus){
		case ST_TITLEINIT:{
			iAge = 0;
			parent->getGmInputN()->setListener(this);
			((GmMain *)iParent)->getGmSoundN()->stopToySound(5);
			((GmMain *)iParent)->getGmSoundN()->stopToySound(6);
			((GmMain *)iParent)->getGmSoundN()->playToySoundE(5, 1);
			gfx->setBrightness(0);
			iStatus = ST_TITLE;
		}break;
		case ST_TITLE:{
			//^CgS\.
			draw_sprite(dst, iSprite[0], (dst->w / 2) - (iSprite[0]->w / 2), (dst->h / 2) - (iSprite[0]->h / 2) + (fixcos(itofix(iAge&0x000000ff)) >> 13) );
		}break;
		case ST_GAMEINIT:{
			iAge = 0;
			parent->getGmInputN()->releaseListener(this);			
			GmTask *t = NULL;
			int i;

			srand(GE_getCurrentTime());
			GE_settings->score = 0;

			t = TPlayer::createN(iParent);
			if(((GmMain *)iParent)->addChildE(t) != ERROR_NONE){
				delete t;
			}
			t = NULL;
			((GmMain *)iParent)->getGmSoundN()->stopToySound(5);
			((GmMain *)iParent)->getGmSoundN()->stopToySound(6);
			((GmMain *)iParent)->getGmSoundN()->playToySoundE(6, 1);
			iStatus = ST_GAME;

			t = TMovie::createN(iParent);
			if(((GmMain *)iParent)->addChildE(t) != ERROR_NONE){
				delete t;
			}else{
				((TMovie *)t)->playFile("stage.flc");
			}
			t = NULL;

			t = TDragon::createN(iParent);
			if(((GmMain *)iParent)->addChildE(t) != ERROR_NONE){
				delete t;
			}
			t = NULL;
		}break;
		case ST_GAME:{
			/*if(getTime() >= 128){
				iStatus = ST_OVERINIT;
			}*/

			if(key[KEY_Q]){
				iStatus = ST_RESET;
			}

			GmTask *t = parent->getGmTaskByTypeN(typeid(TDragon));
			int dPow = 0;
			if(t){ dPow = ((TDragon *)t)->getPow(); }
			t = parent->getGmTaskByTypeN(typeid(TPlayer));
			int pPow = 0;
			if(t){ pPow = ((TPlayer *)t)->getPow(); }

			if(dPow <= 0 || pPow <= 0){
				iStatus = ST_OVERINIT;
			}

			//drawing:
			//rectfill(dst, BB_MARGIN, BB_MARGIN, BB_MARGIN + (128 - getTime()) * (dst->w - BB_MARGIN*2) / 128, BB_MARGIN+8, makecol(255,64,64) );
			rectfill(dst, BB_MARGIN, BB_MARGIN, BB_MARGIN + dPow * (dst->w - BB_MARGIN*2) / TDragon::MAX_POW, BB_MARGIN+8, makecol(255,255,255) );
			rectfill(dst, BB_MARGIN, dst->h - BB_MARGIN - 8, BB_MARGIN + pPow * (dst->w - BB_MARGIN*2) / TPlayer::MAX_POW, dst->h - BB_MARGIN, makecol(200,128,255) );
		}break;
		case ST_OVERINIT:{
			TMovie *tmv = (TMovie *)parent->getGmTaskByTypeN(typeid(TMovie));
			if(tmv){
				tmv->stop();
			}
			parent->getGmInputN()->setListener(this);
			iAge = 0;
			GmTask *t = parent->getGmTaskByTypeN(typeid(TDragon));
			if(t){
				t->setDelete();
				iStatus = ST_OVERNG;
			}else{
				iStatus = ST_OVEROK;
			}
		}break;
		case ST_OVERNG:
		case ST_OVEROK:{
			//nCXRAXV
			if(GE_settings->highScore < GE_settings->score){
				GE_settings->highScore = GE_settings->score;
			}
			//draw something.
			int addY;
			if(iAge < 32){
				addY = -32 / iAge;
			}else{
				addY = 0;
			}
			int spriteIndex = 2;
			if(iStatus == ST_OVERNG){
				spriteIndex = 3;
			}
			draw_sprite(dst, iSprite[spriteIndex], (dst->w / 2) - (iSprite[spriteIndex]->w / 2), (dst->h / 2) - (iSprite[spriteIndex]->h / 2) + (fixcos(itofix(iAge&0x000000ff)) >> 13) + addY );
		}break;
		case ST_RESET:{
			iStatus = ST_TITLEINIT;
			parent->requestFlood(this);
		}break;
		default:{
		}break;
	}
	//J[\`.
	draw_sprite(dst, iSprite[1], BB_MARGIN + in->getMouseX() - (iSprite[1]->w >> 1), BB_MARGIN + in->getMouseY() - (iSprite[1]->h >> 1));
	//score.
	textprintf_ex(dst, font, BB_MARGIN+2, BB_MARGIN+1, makecol(128,128,128), -1, "SCORE%8d / HI%8d", GE_settings->score, GE_settings->highScore);
}

void TStage::keyPressed(int aKeyCode){
}
void TStage::keyReleased(int aKeyCode){
	if(aKeyCode == KEY_Z && iStatus == ST_TITLE){
		iStatus = ST_GAMEINIT;
	}else if(aKeyCode == KEY_Z && iAge > 30 && (iStatus == ST_OVEROK || iStatus == ST_OVERNG)){
		iStatus = ST_RESET;
	}
}
