#include "TPlayer.h"
#include "TPBul.h"
#include "TDBul.h"
#include "TShilu.h"

//static
TPlayer *TPlayer::createN(GmTask *aParent){
	TPlayer *self = new TPlayer(aParent);
	if(self->initializeE() != ERROR_NONE){
		delete self;
		self = NULL;
	}
	return self;
}

TPlayer::TPlayer(GmTask *aParent) : GmTask(aParent){
	iParent = aParent;
	iX = 320;
	iY = 480 - 32;
	iAge = 0;
	this->setPriotiyy(GmTask::EPriorityLow);

	for(int i = 0; i < TPlayer_SPRITE_NUM; i++){
		iSprite[i] = NULL;
	}

	iColW = 64;
	iColH = 64;

	iStage = NULL;
	iPow = TPlayer::MAX_POW;
	iTargetX = 0;
	iTargetY = 0;
}

int TPlayer::initializeE(){
	GmGfx *gfx = NULL;
	gfx = ((GmMain *)iParent)->getGmGfxN();
	if(!gfx){
		return ERROR_NOT_EXISTS;
	}
	BITMAP *src = NULL;
	src = gfx->getSprite();
	if(!src){
		return ERROR_NOT_EXISTS;
	}

	iSprite[0] = create_sub_bitmap(src, 0*2, 0*2, 32*2, 32*2);
	iSprite[1] = create_sub_bitmap(src, 32*2, 0*2, 16*2, 16*2);
	for(int i = 0; i < TPlayer_SPRITE_NUM; i++){
		if(!(iSprite[i])){
			return ERROR_GENERAL;
		}
	}

	GmInput *in = NULL;
	in = ((GmMain *)iParent)->getGmInputN();
	if(!in){
		return ERROR_NOT_EXISTS;
	}
	in->setListener(this);

	iStage = (TStage *)((GmMain *)iParent)->getGmTaskByTypeN(typeid(TStage));

	return ERROR_NONE;	
}

TPlayer::~TPlayer(){
	if(iParent){
		GmInput *in = ((GmMain *)iParent)->getGmInputN();
		if(in){
			in->releaseListener(this);
		}
	}
	
	for(int i = 0; i < TPlayer_SPRITE_NUM; i++){
		if(iSprite[i]){
			destroy_bitmap(iSprite[i]);
			iSprite[i] = NULL;
		}
	}
}


void TPlayer::keyPressed(int aKeyCode){
	if(aKeyCode == KEY_Z || aKeyCode == KEY_X){
		TPBul *t = TPBul::createN(iParent, iX + (fixcos(iAngle)>>(16-6)), iY + (fixsin(iAngle)>>(16-6)), iAngle, iTargetX, iTargetY);
		if(((GmMain *)iParent)->addChildE((GmTask *)t) != ERROR_NONE){
			delete t;
		}
		t = NULL;
		((GmMain *)iParent)->getGmSoundN()->playToySoundE(0);
	}
}

void TPlayer::keyReleased(int aKeyCode){
	keyPressed(aKeyCode);
}

void TPlayer::update(){
	int i;
	GmMain *parent = (GmMain *)iParent;
	GmInput *in = parent->getGmInputN();
	BITMAP *dst = parent->getGmGfxN()->getBackBuffer();
//	BITMAP *src = parent->getGmGfxN()->getSprite();
	iAge++;

	//Q[I[o[ŏ
	if(iStage && (iStage->getStatus() == TStage::ST_OVEROK || iStage->getStatus() == TStage::ST_OVERNG)){
		iColW = 0;
		iColH = 0;
		setDelete();
		//iAllowKey = 0;
	}

	iTargetX = in->getMouseX();
	iTargetY = in->getMouseY();

//move
	iAngle = fixatan2(in->getMouseY() - iY, in->getMouseX() - iX);

//drawing.
	draw_sprite(dst, iSprite[0], BB_MARGIN + iX - (iSprite[0]->w >> 1), BB_MARGIN + iY - (iSprite[0]->h >> 1));
	draw_sprite(dst, iSprite[1], BB_MARGIN + iX - (iSprite[1]->w >> 1) + (fixcos(iAngle)>>(16-6)), BB_MARGIN + iY - (iSprite[1]->h >> 1) + (fixsin(iAngle)>>(16-6)));
}
void TPlayer::notifyCollision(GmTask *aTask){
	if(typeid(*aTask) == typeid(TDBul) && iPow < 30){
		iPow--;
		aTask->setDelete();
		TShilu::createAndAdd(iParent, iX, iY, makecol(150,90,220));
		TShilu::createAndAdd(iParent, iX, iY, makecol(150,90,220));
		TShilu::createAndAdd(iParent, iX, iY, makecol(150,90,220));
		((GmMain *)iParent)->getGmSoundN()->playToySoundE(3);
		if(iPow <= 0){
			for(int i = 0; i < 128; i++){
				TShilu::createAndAdd(iParent, iX, iY, makecol(150,90,220));
			}
			setDelete();
		}
	}
}