#include "TPBul.h"
#include "TDBul.h"
#include "TDragon.h"

TPBul::TPBul(GmTask *aParent, int aX, int aY, fixed aAngle, int aTargetX, int aTargetY) : GmTask(aParent){
	iParent = aParent;
	iX = aX;
	iY = aY;
	iAngle = aAngle;
	iAge = 0;
	this->setPriotiyy(GmTask::EPriorityStandard);

	iStatus = 0;
	iCol = makecol(64 + (rand() * 96 / RAND_MAX), 128, 192);
	iPow = 2;
	iTargetX = aTargetX;
	iTargetY = aTargetY;

	for(int i = 0; i < TPBul_VTX_NUM*2; i++){
		iVtx[i] = 0;
	}
	iVtxNum = 0;
	iScale = itofix(1);
}

//public virtual 
int TPBul::initializeE(){
	iVtxNum = 4;
	//E̞`.
	iVtx[0] = itofix(20);
	iVtx[1] = itofix(0);

	iVtx[2] = itofix(-20);
	iVtx[3] = itofix(-16);

	iVtx[4] = itofix(-10);
	iVtx[5] = itofix(0);

	iVtx[6] = itofix(-20);
	iVtx[7] = itofix(16);

	return ERROR_NONE;
}


//public virtual
TPBul::~TPBul(){
}

void TPBul::update(){
	BITMAP *dst = ((GmMain *)iParent)->getGmGfxN()->getBackBuffer();
//	BITMAP *src = ((GmMain *)iParent)->getGmGfxN()->getSprite();
	iAge++;

	if(iStatus == 0) {
		iX += fixcos(iAngle) >> (16 - 5);
		iY += fixsin(iAngle) >> (16 - 5);

		if(abs(iTargetX - iX) < 16 && abs(iTargetY - iY) < 16){
			iVtxNum = 8;
			iVtx[0] = itofix( 20);
			iVtx[1] = itofix( 20);

			iVtx[2] = itofix(  0);
			iVtx[3] = itofix( 15);

			iVtx[4] = itofix(-20);
			iVtx[5] = itofix( 20);

			iVtx[6] = itofix(-15);
			iVtx[7] = itofix(  0);

			iVtx[8] = itofix(-20);
			iVtx[9] = itofix(-20);

			iVtx[10] = itofix(  0);
			iVtx[11] = itofix(-15);

			iVtx[12] = itofix( 20);
			iVtx[13] = itofix(-20);

			iVtx[14] = itofix( 15);
			iVtx[15] = itofix(  0);
			iStatus = 1;
			iPow+=2;
			((GmMain *)iParent)->getGmSoundN()->playToySoundE(1);
		}
	}else {
		if(iStatus < 7*2){
			iScale = fixmul(iScale, ftofix(1.05));
		}else if(20*2 < iStatus){
			iScale = fixmul(iScale, ftofix(0.8));
		}
		iStatus++;
		iAngle += itofix(12);
		if(35*2 < iStatus){
			setDelete();
		}
	}

	iColW = fixtoi( fixmul(itofix(32), iScale) );
	iColH = iColW;

	//draw
	int vtx[TPBul_VTX_NUM*2];
	for(int i = 0; i < iVtxNum; i++){
		//e_]Ăintɂ.
		//vtx[i*2  ] = fixtoi( fixmul(fixcos(iAngle), iVtx[i*2]) - fixmul(fixsin(iAngle), iVtx[i*2+1])) + BB_MARGIN + iX;/* x */
		//vtx[i*2+1] = fixtoi( fixmul(fixsin(iAngle), iVtx[i*2]) + fixmul(fixcos(iAngle), iVtx[i*2+1])) + BB_MARGIN + iY;/* y */
		vtx[i*2  ] = fixtoi( fixmul(iScale, fixmul(fixcos(iAngle), iVtx[i*2]) - fixmul(fixsin(iAngle), iVtx[i*2+1]))) + BB_MARGIN + iX;/* x */
		vtx[i*2+1] = fixtoi( fixmul(iScale, fixmul(fixsin(iAngle), iVtx[i*2]) + fixmul(fixcos(iAngle), iVtx[i*2+1]))) + BB_MARGIN + iY;/* y */
	}
	polygon(dst, iVtxNum, vtx, iCol);


	if(iX < -iColW || dst->w - BB_MARGIN*2 + iColW < iX ||
	   iY < -iColH || dst->h - BB_MARGIN*2 + iColH < iY){
		setDelete();
	}
}

//ՓˎɌĂ΂.
//public virtual 
void TPBul::notifyCollision(GmTask *aTask){
	if(typeid(*aTask) == typeid(TDBul) || typeid(*aTask) == typeid(TDragon)){
		iPow--;
		if(iPow <= 0){
			this->setDelete();
			iColW = 0;
			iColH = 0;
		}
	}
}