#include "TDragon.h"
#include "TPBul.h"
#include "TDBul.h"
#include "TShilu.h"

extern Settings *GE_settings;

TDragon::TDragon(GmTask *aParent) : GmTask(aParent){
	iParent = aParent;
	iAge = 0;
	iPow = TDragon::MAX_POW;
	iLevel = 1;
	this->setPriotiyy(GmTask::EPriorityLow);
}

TDragon::~TDragon(){
}

void TDragon::update(){
//	BITMAP *dst = ((GmMain *)iParent)->getGmGfxN()->getBackBuffer();
//	BITMAP *src = ((GmMain *)iParent)->getGmGfxN()->getSprite();
	iAge++;

	//ViIorz
	if(iPow < 0){
		iColW = 0;
		iColH = 0;
	}else if(fli_frame < 26){
		iColW = 0;
		iColH = 0;
#if 0
		//eo^C~O炷.
		if(rand() < RAND_MAX/5){
			iAge++;
		}
#endif
	}else if(fli_frame < 130){
		//z.
		iX = 112;
		iY = 119/2;
		iColW = 170;
		iColH = 230/2;
		if((iAge & 0x0000007f) == 0){
			fire(5 + iLevel*2);
		}
	}else if(fli_frame < 179){
		iColW = 0;
		iColH = 0;
	}else if(fli_frame < 200){
		//z.
		iX = 424;
		iY = 126/2;
		iColW = 180;
		iColH = 230/2;
		if((iAge & 0x0000007f) == 0){
			fire(7 + iLevel*2);
		}
	}else if(fli_frame < 260){
		iColW = 0;
		iColH = 0;
	}else if(fli_frame < 403){
		//.
		iX = 205;
		iY = 118/2;
		iColW = 200;
		iColH = 261/2;
		if(rand() < (iLevel+1) * RAND_MAX / 50){
			fire(1);
		}
	}else{
		iColW = 0;
		iColH = 0;
		if(fli_frame == 404){
			iLevel++;
		}
	}

}

//private
void TDragon::fire(int aNum){
	TDBul *t;
	for(int i = 0; i < aNum; i++){
		t = TDBul::createN(iParent, iX, iY, itofix(rand() * 255 / RAND_MAX));
		if(((GmMain *)iParent)->addChildE((GmTask *)t) != ERROR_NONE){
			delete t;
		}
	}
	((GmMain *)iParent)->getGmSoundN()->playToySoundE(4);
}

//ՓˎɌĂ΂.
//public virtual 
void TDragon::notifyCollision(GmTask *aTask){
	if(typeid(*aTask) == typeid(TPBul)){
		//TShilu::createAndAdd(iParent, iX, iY, ((TPBul *)aTask)->getCol());
		TShilu::createAndAdd(iParent, aTask->getX(), aTask->getY(), makecol(255,255,255));
		iPow--;
		GE_settings->score += 50;
		if(iPow <= 0){
			GE_settings->score += 10000;
			for(int i = 0; i < 128; i++){
				TShilu::createAndAdd(iParent, aTask->getX(), aTask->getY(), makecol(255,255,255));
			}
			setDelete();
			((GmMain *)iParent)->getGmSoundN()->playToySoundE(3);
		}else{
			((GmMain *)iParent)->getGmSoundN()->playToySoundE(2);
		}
	}
}
