#include "TDBul.h"
#include "TPlayer.h"
#include "TPBul.h"
#include "TShilu.h"

extern Settings *GE_settings;

TDBul::TDBul(GmTask *aParent, int aX, int aY, fixed aAngle) : GmTask(aParent){
	iParent = aParent;
	iX = aX;
	iY = aY;
	iAngle = aAngle;
	iAge = 0;
	this->setPriotiyy(GmTask::EPriorityStandard);

	iCol = makecol(230, 32 + (rand() * 64 / RAND_MAX), 32);
	iPow = 5;

	for(int i = 0; i < TDBul_VTX_NUM*2; i++){
		iVtx[i] = 0;
	}
	iVtxNum = 0;

	iSpeed = itofix(0.5);
	iScale = ftofix(0.5);
}

//public virtual 
int TDBul::initializeE(){
	iVtxNum = 8;
	//Ẻ΂̋?
	iVtx[0] = itofix(25);
	iVtx[1] = itofix(0);

	iVtx[2] = itofix(10);
	iVtx[3] = itofix(-20);

	iVtx[4] = itofix(-24);
	iVtx[5] = itofix(-25);

	iVtx[6] = itofix(-20);
	iVtx[7] = itofix(-10);

	iVtx[8] = itofix(-35);
	iVtx[9] = itofix(0);

	iVtx[10] = itofix(-20);
	iVtx[11] = itofix(10);

	iVtx[12] = itofix(-24);
	iVtx[13] = itofix(25);

	iVtx[14] = itofix(10);
	iVtx[15] = itofix(20);


	//iVtx[] = itofix();

	return ERROR_NONE;
}


//public virtual
TDBul::~TDBul(){
}

void TDBul::update(){
	BITMAP *dst = ((GmMain *)iParent)->getGmGfxN()->getBackBuffer();
//	BITMAP *src = ((GmMain *)iParent)->getGmGfxN()->getSprite();
	TPlayer *player = (TPlayer *)((GmMain *)iParent)->getGmTaskByTypeN(typeid(TPlayer));

	iAge++;

	//oď̊Ԃ͊px
		int intPlayerAngle = 0;
		if(player){
			intPlayerAngle = fixtoi( fixatan2(player->getY() - iY, player->getX() - iX) );
		}
		int intAngle = fixtoi(iAngle) % 256;
		while(intAngle < 0){
			intAngle+=256;
		}
	//if(iAge < 90){
	if(abs(intAngle - intPlayerAngle) > 16){
		if(intPlayerAngle - 64 + 64 < intAngle && intAngle <= intPlayerAngle - 64 + 192){
			iAngle -= itofix(2);
		}else{
			iAngle += itofix(2);
		}
	}else{
		iSpeed += iAge<<4;
	}

	iScale += ftofix(0.01);
	iColW = fixtoi( fixmul(itofix(32), iScale) );
	iColH = iColW;
	iSpeed += ftofix(0.05);

	iX += fixtoi( fixmul(fixcos(iAngle), iSpeed) );
	iY += fixtoi( fixmul(fixsin(iAngle), iSpeed) );

	//draw
	int vtx[TDBul_VTX_NUM*2];
	for(int i = 0; i < iVtxNum; i++){
		//e_]Eg債Ăintɂ.
		//vtx[i*2  ] = fixtoi( fixmul(iScale, fixmul(fixcos(iAngle), iVtx[i*2])) - fixmul(iScale, fixmul(fixsin(iAngle), iVtx[i*2+1]))) + BB_MARGIN + iX;/* x */
		//vtx[i*2+1] = fixtoi( fixmul(iScale, fixmul(fixsin(iAngle), iVtx[i*2])) + fixmul(iScale, fixmul(fixcos(iAngle), iVtx[i*2+1]))) + BB_MARGIN + iY;/* y */
		vtx[i*2  ] = fixtoi( fixmul(iScale, fixmul(fixcos(iAngle), iVtx[i*2]) - fixmul(fixsin(iAngle), iVtx[i*2+1]))) + BB_MARGIN + iX;/* x */
		vtx[i*2+1] = fixtoi( fixmul(iScale, fixmul(fixsin(iAngle), iVtx[i*2]) + fixmul(fixcos(iAngle), iVtx[i*2+1]))) + BB_MARGIN + iY;/* y */
	}
	polygon(dst, iVtxNum, vtx, iCol);


	if(iX < -iColW || dst->w - BB_MARGIN*2 + iColW < iX ||
	   iY < -iColH || dst->h - BB_MARGIN*2 + iColH < iY){
		setDelete();
	}
}

//ՓˎɌĂ΂.
//public virtual 
void TDBul::notifyCollision(GmTask *aTask){
	if(typeid(*aTask) == typeid(TPBul)){
		iPow--;
		//TShilu::createAndAdd(iParent, iX, iY, makecol(64 + rand() * 64 / RAND_MAX, 32, 32));
		TShilu::createAndAdd(iParent, iX, iY, iCol);
		if(iPow <= 0){
			TShilu::createAndAdd(iParent, iX, iY, iCol);
			TShilu::createAndAdd(iParent, iX, iY, iCol);
			TShilu::createAndAdd(iParent, iX, iY, iCol);
			TShilu::createAndAdd(iParent, iX, iY, iCol);
			this->setDelete();
			iColW = 0;
			iColH = 0;
			GE_settings->score += 100;
		}
	}
}