// GmSound.cpp
// TEh̍ĐǗƃ[U͂̎t.
#include "GmEntry.h"
#include "GmSound.h"
#include "GmMain.h"
#include <string.h>
#include <math.h>

//GmEntry
extern Settings *GE_settings;

//private static (ʓ|Ă̗Rstaticłyo)
//const char GmSound::iMappedKey[ToySoundNum] = { KEY_1, KEY_2, KEY_Q, KEY_W, KEY_A, KEY_S, KEY_Z, KEY_X };
char GmSound::iMappedKey[ToySoundNum] = { KEY_Q, KEY_W, KEY_E, KEY_R, KEY_A, KEY_S, KEY_D, KEY_F };

//public:static
GmSound *GmSound::createN(){
	GmSound *self = new GmSound();
	if(self->constructE() != ERROR_NONE){
		delete self;
		self = NULL;
	}
	return self;
}

//private:
GmSound::GmSound()
		{
	for(int i = 0; i < ToySoundNum; i++){
	iToySound[0] = NULL;
	}
}

//private:
int GmSound::constructE(){
	int ret, i;

	reserve_voices(ToySoundNum, 0);
	RETURN_IF_NEGATIVE(ret, install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL));
	set_volume(255,-1);

	for(i = 0; i < ToySoundNum; i++){
		ret = createToySoundE(i, GE_settings->soundFileName[i]);
		if(ret != ERROR_NONE){
			//t@CȂĂs.
			RELEASE_PRINT1("failed to open %s \n", GE_settings->soundFileName[i]);
			strcpy(GE_settings->soundFileName[i], "failed to load");
			GE_settings->soundFilePureFileName[i] = GE_settings->soundFileName[i];
		}else{
			RELEASE_PRINT1("%s \n", GE_settings->soundFileName[i]);
		}
	}

	return ERROR_NONE;
}


//public:
GmSound::~GmSound(){
	for(int i = 0; i < ToySoundNum; i++){
		stopToySound(i);
		destroyToySound(i);
	}
}

//public
void GmSound::receiveMessage(char *aData){
	size_t len;
	int index = atoi(&(aData[0])) - 1; //1~8̃CfbNXw0~7ɂ
	//1ڂ͐ŁAXbg̃CfbNXw.
	if(0 <= index && index < ToySoundNum){
		//2ڂ͋؂̔pXy[X.
		if(aData[1] == ' '){
			//256܂ł̃t@CɑΉ.
			len = strlen(&(aData[2]));
			if(len < 256){
				if(changeToySoundE(index, &(aData[2])) == ERROR_NONE){
					strcpy(GE_settings->soundFileName[index], &(aData[2]));
					GE_settings->soundFilePureFileName[index] = get_filename(GE_settings->soundFileName[index]);
				}
			}
		}
	}
}

//public:
ToySound *GmSound::getToySoundN(int aIndex){
	if(aIndex < ToySoundNum){
		return iToySound[aIndex];
	}else{
		return NULL;
	}
}

//public:
void GmSound::update(){
//	int curVol, curFreq;
	int i;

	for(i = 0; i < ToySoundNum; i++){
		if(iToySound[i] != NULL){
			iToySound[i]->iSound->update();
		}
	}
	
	//}EXʒu𒆉set.
	//position_mouse((GmMain::getCurrentGmMain()->getGmGfxN()->getScreenW())>>1, (GmMain::getCurrentGmMain()->getGmGfxN()->getScreenH())>>1);
}

//private
int GmSound::changeToySoundE(int aIndex, char *aSampleFileName){
	WrappedSample *tmpSound = NULL;

	//͈̓`FbN.
	if(aIndex < ToySoundNum){

		//݂ȂXbgȂVɐďI.
		if(iToySound[aIndex] == NULL){
			return createToySoundE(aIndex, aSampleFileName);
		}

		//݂XbgȂ特̂ݓւ
		if(ustricmp(get_extension(aSampleFileName), "xm" ) == 0 ||
		   ustricmp(get_extension(aSampleFileName), "mod" ) == 0) {
			tmpSound = YMod::createN(aSampleFileName);
		}else{
			//wavTEh
			tmpSound = WrappedSample::createN(aSampleFileName);
		}

		if(!tmpSound){
			return ERROR_GENERAL;
		}

		iToySound[aIndex]->iSound->stop();
		delete iToySound[aIndex]->iSound;
		iToySound[aIndex]->iSound = tmpSound;
		iToySound[aIndex]->iVol = 0;
		playToySoundE(aIndex);
	}else{
		return ERROR_ARGUMENT;
	}
	return ERROR_NONE;
}

int GmSound::createToySoundE(int aIndex, char *aSampleFileName){
	ToySound *ret;
	WrappedSample *tmpSound = NULL;
	iToySound[aIndex] = NULL;
	
	if(ustricmp(get_extension(aSampleFileName), "xm" ) == 0 ||
	   ustricmp(get_extension(aSampleFileName), "mod" ) == 0) {
		tmpSound = YMod::createN(aSampleFileName);
	}else{
		//wavTEh
		tmpSound = WrappedSample::createN(aSampleFileName);
	}
	if(!tmpSound){
		return -1;
	}

	ret = (ToySound *)malloc(sizeof(ToySound));
	if(ret == NULL){
		return -1;
	}

	ret->iVol = VOL_MAX;
	ret->iPan = PAN_MID;
	ret->iFreq = FREQ_MID;
	ret->iLog10Freq = LOG10FREQ_MID;
	ret->iLog10FreqSnap = LOG10FREQ_MID;
	ret->iMute = FALSE;
	ret->iHold = 0;
	ret->iRestartFlag = FALSE;
	ret->iAdditionalFreq = 0;
	ret->iSound = tmpSound;
	iToySound[aIndex] = ret;
	return 0;
}

void GmSound::destroyToySound(int aIndex){
	if(iToySound[aIndex] == NULL){
		return;
	}
	delete iToySound[aIndex]->iSound;
	iToySound[aIndex]->iSound = NULL;

	free(iToySound[aIndex]);
	iToySound[aIndex] = NULL;
}

//public
int GmSound::playToySoundE(int aIndex, int aLoop){
	int vol;
	if(iToySound[aIndex] == NULL){
		return ERROR_NOT_EXISTS;
	}

	//Mute==TRUEȂ~[gAFALSEȂvol=iVol.
	if(iToySound[aIndex]->iMute){
		vol = iToySound[aIndex]->iVol - (iToySound[aIndex]->iMute)*20;
		if(vol < VOL_MIN){
			vol = VOL_MIN;
		}
	}else{
		vol = iToySound[aIndex]->iVol;
	}
	return iToySound[aIndex]->iSound->playE(vol, iToySound[aIndex]->iPan, iToySound[aIndex]->iFreq, aLoop);
}

//public
void GmSound::adjustToySound(int aIndex, int aLoop){
	int vol;
	int freq;
	if(iToySound[aIndex] == NULL){
		DEBUG_PRINT1("adjustToySound: #%d is null.\n", aIndex);
		return;
	}
	//Mute==TRUEȂ~[gAFALSEȂvol=iVol.
	if(iToySound[aIndex]->iMute){
		vol = iToySound[aIndex]->iVol - (iToySound[aIndex]->iMute)*20;
		if(vol < VOL_MIN){
			vol = VOL_MIN;
		}
	}else{
		vol = iToySound[aIndex]->iVol;
	}

	//hold==TRUEȂxBFALSEȂiFreq̂܂
	if(iToySound[aIndex]->iHold){
		freq = iToySound[aIndex]->iFreq / iToySound[aIndex]->iHold;
		if(freq < 1){
			freq = 1;
		}
	}else{
		freq = iToySound[aIndex]->iFreq;
	}

	//additionalFreqΓKɉZ.
	if(iToySound[aIndex]->iAdditionalFreq){
		int vf = iToySound[aIndex]->iAdditionalFreq*10;
		//+-1IN^[u܂.
		if(vf < -1 * freq/2){
			vf = -1 * freq/2;
			iToySound[aIndex]->iAdditionalFreq = vf / 10;
		}else if(vf > freq){
			vf = freq;
			iToySound[aIndex]->iAdditionalFreq = vf / 10;
		}

		freq = iToySound[aIndex]->iFreq + vf;
		//g[͕s.
		if(freq < 1){
			freq = 1;
		}
	}

	iToySound[aIndex]->iSound->adjust(vol, iToySound[aIndex]->iPan, freq, aLoop);
}

//public
void GmSound::stopToySound(int aIndex){
	if(iToySound[aIndex] == NULL){
		return;
	}
	iToySound[aIndex]->iSound->stop();
}


