// GmMain.cpp
// C[v܂킵܂.
#include "GmMain.h"
#include "GmEntry.h"
#include "TStage.h"
//#include "UserWindow.h"


//private static
GmMain* GmMain::currentGmMain = NULL;

//public: static:
GmMain *GmMain::createN(GmTask *aParent){
	GmMain *self = new GmMain(aParent);
	if(self->initializeE() != ERROR_NONE){
		delete self;
		self = NULL;
	}
	GmMain::currentGmMain = self;
	return self;
}

//private:
GmMain::GmMain(GmTask *aParent):
	iGmGfx(NULL),
	iGmSound(NULL),
	iGmInput(NULL),
	iStringReceiver(NULL),
	iLoopCount(0),
	iGmTaskNum(0),
	iNoah(NULL),
	iGmTaskTop(NULL){
	iParent = aParent;
}

//private
int GmMain::initializeE(){
	int ret;

	set_window_title("FLDR");

	RETURN_IF_NEGATIVE(ret, install_mouse());

	RETURN_IF_NEGATIVE(ret, install_keyboard());

	RETURN_ERROR_IF_NULL(iGmGfx, GmGfx::createN());

	RETURN_ERROR_IF_NULL(iGmSound, GmSound::createN());

	RETURN_ERROR_IF_NULL(iGmInput, GmInput::createN());

//͎gȂ.
//	RETURN_ERROR_IF_NULL(iStringReceiver, StringReceiver::createN());

	//Q[̃C^XN𐶐.
	GmTask *t = NULL;
	RETURN_ERROR_IF_NULL(t, TStage::createN(this));
	if(addChildE(t) != ERROR_NONE){
		delete t;
		return ERROR_GENERAL;
	}
	t = NULL;

	return ERROR_NONE;
}

//public
GmMain::~GmMain(){
	delete iGmSound;
	iGmSound = NULL;
	delete iGmGfx;
	iGmGfx = NULL;
	delete iGmInput;
	iGmInput = NULL;
	while(iGmTaskTop){
		removeChildE(iGmTaskTop);
	}
	delete iStringReceiver;
	iStringReceiver = NULL;
	//̑̏I(mouseƂkeyboardƂ)allegroIɂĂ邻łBLł.
}

//public
//C[v.
void GmMain::update(){
	while(!GE_getExitFlag()){

		cleanupChild();
		updateChild();
		checkChildCollision();

		iGmGfx->update();//t[܂ł̃EGCg܂. łd.
		iGmSound->update();
		iGmInput->update();

		if(iNoah){
			flood();
		}
		if(key[KEY_ESC]){
			break;
		}

		//}`^XNōsV悭߂̂Ȃ.
		//VisualBasicDoEventsɎ悤Ȃ́HƂƓȂƂ܂񂾂,
		//܂̂Ƃ떳ĂႢ킩Ȃ.
		yield_timeslice();

		//1b1AOXNvg̎Mpt@C̓ǂݍ݂݂.
		iLoopCount++;
		if(iStringReceiver && iLoopCount == 60){
			char *rec = iStringReceiver->getStringN();
			if(rec){
				iGmSound->receiveMessage(rec);
			}
			//rec ͊JȂB(stringReceiverJ)
			iLoopCount = 0;
		}
	}
	return;
}

void GmMain::updateChild(){
	GmTask *t;
	for(t = iGmTaskTop; t /* != NULL*/; t = t->getLinkNext()){
		t->update();
	}
}

int GmMain::addChildE(GmTask *aGmTask){
	if(!aGmTask){
		return ERROR_NULL;
	}
	if(iGmTaskNum < GM_STUFF_MAX){
		GmTask *t;
		for(t = iGmTaskTop; t /* != NULL*/ ; t = t->getLinkNext()){
			if(t->getPriority() < aGmTask->getPriority()){
				//t->prev  t ̊ԂaGmTask.
				aGmTask->setLinkPrev(t->getLinkPrev());
				aGmTask->setLinkNext(t);
				if(t->getLinkPrev()){
					t->getLinkPrev()->setLinkNext(aGmTask);
				}
				t->setLinkPrev(aGmTask);

				if(!aGmTask->getLinkPrev()){
					//prev==NULLȂ킿擪ɒǉꍇ.
					iGmTaskTop = aGmTask;
				}
				iGmTaskNum++;
				return ERROR_NONE;
			}
		}
		//t==NULLȂ烊XgŌ.ǉTaskpriorityŒ̏ꍇ.
		if(iGmTaskTop == NULL){
			//ŏ1ڂ̏ꍇ.
			iGmTaskTop = aGmTask;
			iGmTaskTop->setLinkPrev(NULL);
			iGmTaskTop->setLinkNext(NULL);
		}else{
			if(t->getLinkNext() != NULL){
				//ŌȂnextNULL̂͂.ɓ邱Ƃ͖nY...
				allegro_message("!!!ILLEGAL TASK STATE!!!@addChildE");
				RELEASE_PRINT0("!!!ILLEGAL TASK STATE!!!@addChildE\n");
				return ERROR_GENERAL;
			}else{
				t->setLinkNext(aGmTask);
				aGmTask->setLinkPrev(t);
				//ŌnextNULL.
				aGmTask->setLinkNext(NULL);
			}
		}
		iGmTaskNum++;
		return ERROR_NONE;
	}else{
		return ERROR_NO_RESOURCES;
	}
}

//DeleteFlag̗Task폜.
void GmMain::cleanupChild(){
	GmTask *t;
	GmTask *tempLinkNext;
	for(t = iGmTaskTop; t /* != NULL*/;){
		//폜ONextƂĂ.
		tempLinkNext = t->getLinkNext();
		if(t->getDeleteFlag()){
			removeChildE(t);
			if(!iGmTaskTop){
				//ChildTaskȂꍇ.
				break;
			}
		}
		t = tempLinkNext;
	}
}

//wTask폜.
int GmMain::removeChildE(GmTask *aGmTask){
	if(!aGmTask || !iGmTaskTop){
		return ERROR_NULL;
	}
	GmTask *t;
	for(t = iGmTaskTop; t /* !- NULL */; t = t->getLinkNext()){
		if(t == aGmTask){
			if(!t->getLinkNext() && !t->getLinkPrev()){
				//Ō1removeꍇ.
				iGmTaskTop = NULL;
			}else{
				if(t->getLinkPrev()){
					t->getLinkPrev()->setLinkNext(t->getLinkNext());
				}else{
					//prev==NULL,Ȃ킿擪^XN폜.Ȃ̂2Ԗڂ̃^XN擪ɂ.
					iGmTaskTop = t->getLinkNext();
				}
				if(t->getLinkNext()){
					t->getLinkNext()->setLinkPrev(t->getLinkPrev());
				}
			}
			delete t;
			t = NULL;
			iGmTaskNum--;
			return ERROR_NONE;
		}
	}
	return ERROR_NOT_EXISTS;
}

void GmMain::checkChildCollision(){
	GmTask *t;
	GmTask *t2;
	for(t = iGmTaskTop; t /* != NULL */; t = t->getLinkNext()){
		for(t2 = t->getLinkNext(); t2 /* != NULL */; t2 = t2->getLinkNext()){
			if( t->getColW() && t->getColH() && t2->getColW() && t2->getColH()
			  &&(abs(t->getX() - t2->getX()) < ((t->getColW() + t2->getColW())>>1) )
			  &&(abs(t->getY() - t2->getY()) < ((t->getColH() + t2->getColH())>>1) ) ){
				t->notifyCollision(t2);
				t2->notifyCollision(t);
			}
		}
	}
}


//Ɏw肵̈ȊÔׂĂ폜.^̃C[W.
void GmMain::requestFlood(GmTask *aNoah){
	iNoah = aNoah;
}

//private
void GmMain::flood(){
	if(!iNoah){
		return;
	}
	int noahExists = FALSE;
	GmTask *t;
	for(t = iGmTaskTop; t /* != NULL */; t = t->getLinkNext()){
		if(t == iNoah){
			noahExists = TRUE;
		}else{
			t->setDelete();
		}
	}
	cleanupChild();

	if(!noahExists){
		//childiNoahȂꍇǉĂ.sv.
		addChildE(iNoah);
	}
	iNoah = NULL;
}

//w̌^̃^XNTāAŏɌ̂Ԃ܂.
//{glbNɂȂĂ邩.
GmTask *GmMain::getGmTaskByTypeN(const type_info &aType){
	GmTask *t;
	for(t = iGmTaskTop; t /* != NULL */; t = t->getLinkNext()){
		if(typeid(*t) == aType){
			return t;
		}
	}
	return NULL;
}
