// GmGfx.cpp
// ʂ̏EXVƃt[̃EGCg.
#include "GmEntry.h"
#include "GmGfx.h"
#include "GmSound.h"
#include "GmMain.h"


extern Settings *GE_settings;

#define iBitCol   (unsigned long(0x00ffffff))
#define iBitR     (unsigned long(0x00ff0000))
#define iBitG     (unsigned long(0x0000ff00))
#define iBitB     (unsigned long(0x000000ff))
#define iBitOverR (unsigned long(0xff000000))
#define iBitOverG (unsigned long(0xffff0000))
#define iBitOverB (unsigned long(0xffffff00))
#define DIRECT_PIXEL32(aBitmap, aX, aY) (((long *)aBitmap->line[aY])[aX])
#define DIRECT_PIXEL16(aBitmap, aX, aY) (((unsigned short *)aBitmap->line[aY])[aX])

//public:static
GmGfx *GmGfx::createN(){
	GmGfx *self = new GmGfx();
	if(self->constructE() != ERROR_NONE){
		delete self;
		self = NULL;
	}
	return self;
}

//private:
GmGfx::GmGfx() :
	iBackBuffer(NULL),
	iBackBuffer2(NULL),
	iSprite(NULL),
	iFilterRatio(1),
	iBrightness(0) {
}

//private:
int GmGfx::constructE(){
	int ret;

	//F̐ݒ
	ret = desktop_color_depth();
	if(ret == 0 /*|| ret < 16*/){
		RELEASE_PRINT1("ERROR: cant get desktop_color_depth (%d) \n", ret);
		return ERROR_GENERAL;
	}

	set_color_depth(ret);
	iColorDepth = ret;
	RELEASE_PRINT1("color_depth = %d \n", iColorDepth);

	//ʃ[hݒ
	ret = 0;
	//tXN[w̏ꍇ܂tXN[ŏ݂
	if(!(GE_settings->showAsWindow)){
		ret = set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, GE_settings->screenW, GE_settings->screenH, 0,0);
	}
	//tXN[sE܂̓EChE[hw(ftHg)̏ꍇ
	if(ret < 0 || GE_settings->showAsWindow){
		ret = set_gfx_mode(GFX_AUTODETECT_WINDOWED, GE_settings->screenW, GE_settings->screenH, 0,0);
		if(ret >= 0){
			ret = set_display_switch_mode(SWITCH_BACKGROUND);
		}
	}
	if(ret < 0){
		return ret;
	}
	iScreenW = SCREEN_W;
	iScreenH = SCREEN_H;
	RELEASE_PRINT2("gfx_mode width = %d, height = %d \n", iScreenW, iScreenH);

	iRefreshRate = get_refresh_rate();
	//iRefreshRate = 0;
	RELEASE_PRINT1("refresh rate = %d \n", iRefreshRate);

	//obNobt@.
	iBackBuffer = create_bitmap_ex(iColorDepth, (iScreenW + BB_MARGIN*2), (iScreenH + BB_MARGIN*2));
	if(iBackBuffer == 0){
		return -1;
	}
	iBackBuffer2 = create_bitmap_ex(iColorDepth, (iScreenW + BB_MARGIN*2), (iScreenH + BB_MARGIN*2));
	if(iBackBuffer2 == 0){
		return -1;
	}
	DEBUG_PRINT2("create backBuffer width = %d, height = %d \n", iBackBuffer->w, iBackBuffer->h);
	rectfill(iBackBuffer, 0,0, iBackBuffer->w, iBackBuffer->h, makecol(0,0,0));
	rectfill(iBackBuffer2, 0,0, iBackBuffer->w, iBackBuffer->h, makecol(0,0,0));

	//XvCgǂݍ.
	BITMAP *tmpSprite = load_bitmap("./sprite.bmp", NULL);
	iSprite = create_bitmap_ex(bitmap_color_depth(tmpSprite), tmpSprite->w*2, tmpSprite->h*2);
	stretch_blit(tmpSprite, iSprite, 0,0, tmpSprite->w, tmpSprite->h, 0, 0, iSprite->w, iSprite->h);
	destroy_bitmap(tmpSprite);
	tmpSprite = NULL;

	//tB^𔽉f.
	if(iColorDepth == 32){
		iFilterRatio = GE_settings->filterRatio;
	}else{
		iFilterRatio = 0;
	}

	return ERROR_NONE;
}

//public:
GmGfx::~GmGfx(){
	destroy_bitmap(iBackBuffer);
	destroy_bitmap(iBackBuffer2);
	destroy_bitmap(iSprite);
}


//public:
void GmGfx::update(){
	static int age = 0, prevTime = 0;
	age++;
	if(age > 0x00ffffff){
		age = 0;
	}


	//iFilterRatio = (mouse_x * 8 / this->iScreenW);
	if(iFilterRatio != 0){
		//screenvideoBitmapȂ̂Œx. memoryBitmapiBackBuffer2ɈUo.
		blitRomanticFilter(iBackBuffer, iBackBuffer2, iFilterRatio);
	}

	//screenւ̓]̑Ovsync҂.
	if(iRefreshRate == 60){
		//1t[̏ɂԂo.
		int curTime = GE_getCurrentTime();
		DEBUG_PRINT1("%d\n", curTime - prevTime);
		if(curTime - prevTime < 16){
			vsync();
			//todo: blit΃t[Ă\ȂȂ?
		}
		prevTime = GE_getCurrentTime();
	}else{
		//tbV[g60ȊȌꍇ̓eLg[Ƀ^C}ő҂.
		//1t[̏ɂԂo.
		DEBUG_PRINT1("%d\n", GE_getCurrentTime() - prevTime);
		int curTime = GE_getCurrentTime();
		//̃Q[60fpsڎŵ(1000/16)msec҂.
		while(prevTime <= curTime && curTime < prevTime + 16){
			yield_timeslice();
			curTime = GE_getCurrentTime();
		}
		prevTime = curTime;
	}

	if(iFilterRatio <= 0){
		//globalScreenlock
		acquire_screen();
		//\XV.
		blit(iBackBuffer, screen, BB_MARGIN, BB_MARGIN, 0,0, iScreenW,iScreenH);
		//globalscreenunlock
		release_screen();
	}else{
		//globalScreenlock
		acquire_screen();
		//\XV
		blit(iBackBuffer2, screen, BB_MARGIN, BB_MARGIN, 0,0, iScreenW,iScreenH);
		//globalscreenunlock
		release_screen();
	}

	//obNobt@̃NA.
	rectfill(iBackBuffer, 0,0, iBackBuffer->w, iBackBuffer->h, makecol(iBrightness, iBrightness, iBrightness) );
	//xallegroZ[h.
	//set_add_blender(255, 255, 255, 128);
	//drawing_mode(DRAW_MODE_TRANS, NULL, 0,0);

	return;
}



//J[Ή̏cڂ.Ȃx.
void GmGfx::blitBlurScreen(register BITMAP *aSrc, register BITMAP *aDst){
	int x,y;
	int endY = aSrc->h - BB_MARGIN;
	int endX = aSrc->w - BB_MARGIN;
	for(y=BB_MARGIN; y < endY; y++){
		for(x=BB_MARGIN; x < endX; x++){
			DIRECT_PIXEL32(aDst, x, y) =  
			(
				((
				(DIRECT_PIXEL32(aSrc, x, y-4)&iBitG) + 
				(DIRECT_PIXEL32(aSrc, x, y-3)&iBitG) + 
				(DIRECT_PIXEL32(aSrc, x, y-2)&iBitG) + 
				(DIRECT_PIXEL32(aSrc, x, y+1)&iBitG) + 
				(DIRECT_PIXEL32(aSrc, x, y  )&iBitG) + 
				(DIRECT_PIXEL32(aSrc, x, y+1)&iBitG) + 
				(DIRECT_PIXEL32(aSrc, x, y+2)&iBitG) + 
				(DIRECT_PIXEL32(aSrc, x, y+3)&iBitG)
				) >> 3) & iBitG 
			)
			+
			(
				((
				(DIRECT_PIXEL32(aSrc, x, y-4)&iBitB) + 
				(DIRECT_PIXEL32(aSrc, x, y-3)&iBitB) + 
				(DIRECT_PIXEL32(aSrc, x, y-2)&iBitB) + 
				(DIRECT_PIXEL32(aSrc, x, y+1)&iBitB) + 
				(DIRECT_PIXEL32(aSrc, x, y  )&iBitB) + 
				(DIRECT_PIXEL32(aSrc, x, y+1)&iBitB) + 
				(DIRECT_PIXEL32(aSrc, x, y+2)&iBitB) + 
				(DIRECT_PIXEL32(aSrc, x, y+3)&iBitB)
				) >> 3) & iBitB 
			)
			+
			(
				((
				(DIRECT_PIXEL32(aSrc, x, y-4)&iBitR) + 
				(DIRECT_PIXEL32(aSrc, x, y-3)&iBitR) + 
				(DIRECT_PIXEL32(aSrc, x, y-2)&iBitR) + 
				(DIRECT_PIXEL32(aSrc, x, y+1)&iBitR) + 
				(DIRECT_PIXEL32(aSrc, x, y  )&iBitR) + 
				(DIRECT_PIXEL32(aSrc, x, y+1)&iBitR) + 
				(DIRECT_PIXEL32(aSrc, x, y+2)&iBitR) + 
				(DIRECT_PIXEL32(aSrc, x, y+3)&iBitR)
				) >> 3) & iBitR
			);
		}
	}
}


//#define DIRECT_PIXEL32(aBitmap, aX, aY) (((long *)aBitmap->line[aY])[aX])
#define DIRECT_GETLINE(aBitmap, aY) ((unsigned long *)aBitmap->line[aY])

//YꂽBx.
void GmGfx::blitBlurScreen2(register BITMAP *aSrc, register BITMAP *aDst, int aDepth){
	int x,y;
	long depthPix = 1 << aDepth;
	int endY = aSrc->h - depthPix;
	int endX = aSrc->w - depthPix;

	unsigned long *curLine;
	unsigned long curCol;
	for(y=depthPix; y < endY; y++){
		curLine = DIRECT_GETLINE(aSrc, y) + depthPix;
		curCol = 0;
		unsigned long curR = 0;
		unsigned long curG = 0;
		unsigned long curB = 0;
		for(int i = -(depthPix>>1); i < (depthPix>>1); i++){
			curR += (*(curLine + i) & iBitR) >> 16 >> aDepth;
			curG += (*(curLine + i) & iBitG) >> 8 >> aDepth;
			curB += (*(curLine + i) & iBitB) >> aDepth;
		}
		curR = (curR << 16) & iBitR;
		curG = (curG <<  8) & iBitG;
		curB = (curB      ) & iBitB;
		curCol = (curR | curG | curB);
		for(x=depthPix; x < endX; x++){
			DIRECT_PIXEL32(aDst, x, y) =  curCol;
//			curCol += 
//					-(((*(curLine - depthPix) & iBitR) >> aDepth) & iBitR)
//					-(((*(curLine - depthPix) & iBitG) >> aDepth) & iBitG)
//					-(((*(curLine - depthPix) & iBitB) >> aDepth) & iBitB);
			curCol = ( ((curCol & iBitR) - (((*(curLine - (depthPix>>1)) & iBitR) >> aDepth) & iBitR) + (((*(curLine + (depthPix>>1)) & iBitR) >> aDepth) & iBitR)) & iBitR)
					|( ((curCol & iBitG) - (((*(curLine - (depthPix>>1)) & iBitG) >> aDepth) & iBitG) + (((*(curLine + (depthPix>>1)) & iBitG) >> aDepth) & iBitG)) & iBitG)
					|( ((curCol & iBitB) - (((*(curLine - (depthPix>>1)) & iBitB) >> aDepth) & iBitB) + (((*(curLine + (depthPix>>1)) & iBitB) >> aDepth) & iBitB)) & iBitB);

//			curCol = ( ((curCol & iBitR) + (((*(curLine + depthPix) & iBitR) >> aDepth) & iBitR)) & iBitR)
//					|( ((curCol & iBitG) + (((*(curLine + depthPix) & iBitG) >> aDepth) & iBitG)) & iBitG)
//					|( ((curCol & iBitB) + (((*(curLine + depthPix) & iBitB) >> aDepth) & iBitB)) & iBitB);

			*curLine++;
		}
	}
}


//RGB܂Ƃ߂Ă؂ɉZ.
#define RGB_PARALLEL 1

//ZRGB܂Ƃ߂ĉZ.ڂ̌덷Ȃ̂ŏLCȂ.
//#define RGB_PARALLEL_ADD 1

//blitBlurScreen2ɉāAڂỎ摜Ƃ̉Z𓯎ɍs. Z̐[x̓CCJQ.
void GmGfx::blitRomanticFilter(register BITMAP *aSrc, register BITMAP *aDst, int aDepth){
	int x,y;
	long depthPix = 1 << aDepth;//Ȃ񂩂̕ӂungied/unsigned ۂH
	unsigned long depthMask = (0x00808080 >> (aDepth-1)) - 0x00010101;
	int endY = aDst->h;
	int endX = aDst->w - (depthPix>>1);
	if(endX <= depthPix || endY <= depthPix){
		return;
	}

	unsigned long *curLine; //].
	unsigned long *dst;     //].
	unsigned long curCol;   //ڂr̐F.
	unsigned long curR = 0;
	unsigned long curG = 0;
	unsigned long curB = 0;
	unsigned long a1;       //e|.
	for(y = 0; y != endY; y++){
		curLine = DIRECT_GETLINE(aSrc, y);
		dst = DIRECT_GETLINE(aDst, y) + (depthPix>>1);
#if RGB_PARALLEL
		//܂ԍ̃sNZڂ̒lo.
		curCol = 0;
		for(int i = 0; i < depthPix; i++){
			curCol += ((*(curLine + i)) >> aDepth) & depthMask;
		}
#else
		curR = 0;
		curG = 0;
		curB = 0;
		for(int i = 0; i < depthPix; i++){
			curR += (*(curLine + i) & iBitR) >> (16 + aDepth);
			curG += (*(curLine + i) & iBitG) >> (8 + aDepth);
			curB += (*(curLine + i) & iBitB) >> aDepth;
		}
		curR = (curR << 16) & iBitR;
		curG = (curG <<  8) & iBitG;
		curB = (curB      ) & iBitB;
		curCol = (curR | curG | curB);
#endif
		curLine += depthPix >> 1;
		for(x = depthPix>>1; x != endX; x++){
#if RGB_PARALLEL | RGB_PARALLEL_ADD
			//curColsrc1:2ŖOaZďo.
			a1 = ((curCol & 0x00fefeff) + (((*curLine) & 0x00fcfcff)>>1));
			*dst = a1 | ((a1 & 0x01010100) - ((a1 & 0x01010100)>>8));
#else
			curR = (((curCol & iBitR)<<1) + ((*curLine) & iBitR)) >> 1;
			if(curR & iBitOverR){ curR = iBitR; } else { curR = curR & iBitR; }
			curG = (((curCol & iBitG)<<1) + ((*curLine) & iBitG)) >> 1;
			if(curG & iBitOverG){ curG = iBitG; } else { curG = curG & iBitG; }
			curB = (((curCol & iBitB)<<1) + ((*curLine) & iBitB)) >> 1;
			if(curB & iBitOverB){ curB = iBitB; } else { curB = curB & iBitB; }
			*dst = (curR | curG | curB);
#endif
#if RGB_PARALLEL
			//ԍ̃sNZ̐FĂԉE̎̐F𑫂Ƃłڂ̒S炵Ă.

			//[RGBlOaZ.܂萳młȂC.
			a1 = ((curCol & 0x00fefeff) | 0x80000000) - (((*(curLine - (depthPix>>1))) >> aDepth) & depthMask & 0x00fefeff);
			curCol =  0x00ffffff & ( a1 & ~((a1 & 0x01010100) - ((a1 & 0x01010100)>>8)) );

			//E[̎RGBlZ.(aDepthVtgĂ̂ŖOa邱Ƃ͖ Ǝv)
			curCol += ((*(curLine + (depthPix>>1))) >> aDepth) & depthMask;
#else
			curCol = ( ((curCol & iBitR) - (((*(curLine - (depthPix>>1)) & iBitR) >> aDepth) & iBitR) + (((*(curLine + (depthPix>>1)) & iBitR) >> aDepth) & iBitR)) & iBitR)
					|( ((curCol & iBitG) - (((*(curLine - (depthPix>>1)) & iBitG) >> aDepth) & iBitG) + (((*(curLine + (depthPix>>1)) & iBitG) >> aDepth) & iBitG)) & iBitG)
					|( ((curCol & iBitB) - (((*(curLine - (depthPix>>1)) & iBitB) >> aDepth) & iBitB) + (((*(curLine + (depthPix>>1)) & iBitB) >> aDepth) & iBitB)) & iBitB);
#endif
			curLine++;
			dst++;
		}
	}
}