// GmEntry.h
#ifndef _GMENTRY_HEAD_
#define _GMENTRY_HEAD_

#include "ALLEGRO.H"
#include <typeinfo.h>

/*already defined. see include\allegro\base.h
#define TRUE -1
#define FALSE 0
*/

#include "stdio.h" //printf-debugging
#define RELEASE_PRINT0(aStr) printf(aStr)
#define RELEASE_PRINT1(aStr, aArg1) printf(aStr, aArg1)
#define RELEASE_PRINT2(aStr, aArg1, aArg2) printf(aStr, aArg1, aArg2)
#define RELEASE_PRINT3(aStr, aArg1, aArg2, aArg3) printf(aStr, aArg1, aArg2, aArg3)
#define RELEASE_PRINT4(aStr, aArg1, aArg2, aArg3, aArg4) printf(aStr, aArg1, aArg2, aArg3, aArg4)

#if _DEBUG
//#if 1

	#define DEBUG_PRINT0(aStr) printf(aStr)
	#define DEBUG_PRINT1(aStr, aArg1) printf(aStr, aArg1)
	#define DEBUG_PRINT2(aStr, aArg1, aArg2) printf(aStr, aArg1, aArg2)
	#define DEBUG_PRINT3(aStr, aArg1, aArg2, aArg3) printf(aStr, aArg1, aArg2, aArg3)
	#define DEBUG_PRINT4(aStr, aArg1, aArg2, aArg3, aArg4) printf(aStr, aArg1, aArg2, aArg3, aArg4)
#else
	#define DEBUG_PRINT0(aStr) 
	#define DEBUG_PRINT1(aStr, aArg1) 
	#define DEBUG_PRINT2(aStr, aArg1, aArg2) 
	#define DEBUG_PRINT3(aStr, aArg1, aArg2, aArg3) 
	#define DEBUG_PRINT4(aStr, aArg1, aArg2, aArg3, aArg4) 
#endif

//ERRORS
//windows.h̃G[ƖOԂ邱ƂĂ܂BvΏ.
#define ERROR_NONE (0)
#define ERROR_GENERAL (-1)
#define ERROR_ARGUMENT (-2)
#define ERROR_NOT_EXISTS (-3)
#define ERROR_NO_RESOURCES (-4)
#define ERROR_NULL (-5)

//ERROR HANDLERS
//܂g񂶂Ȃ.
//todo: 
//		returnOɉł悤ɂ悤(cleanup stackƂ)
//		void^̊֐ł͎gȂǂǂ.
#define RETURN_IF_NEGATIVE(aRet, aOperation) { \
	aRet = aOperation; \
	if(aRet < 0){ \
		RELEASE_PRINT2("ERROR: %d returned @ %s\n", aRet, # aOperation);\
		return aRet; \
	} \
}

#define RETURN_IF_ERROR(aRet, aOperation) { \
	aRet = aOperation; \
	if(aRet != ERROR_NONE){ \
		RELEASE_PRINT2("ERROR: %d returned @ %s\n", aRet, # aOperation);\
		return aRet; \
	} \
}

#define RETURN_IF_NULL(aRet, aOperation) { \
	aRet = aOperation;\
	if(aRet == NULL) {\
		RELEASE_PRINT1("ERROR: NULL returned @ %s\n", # aOperation);\
		return NULL; \
	} \
}

#define RETURN_ERROR_IF_NULL(aRet, aOperation) { \
	aRet = aOperation;\
	if(aRet == NULL) {\
		RELEASE_PRINT1("ERROR: NULL returned @ %s\n", # aOperation);\
		return ERROR_NULL; \
	} \
}

int GE_getCurrentTime();

void GE_setExitFlag();
int GE_getExitFlag();

typedef struct Settings{
	//EChE\[hۂ
	int showAsWindow;
	//ʂ̕E(܂ňŎw肳ꂽl)
	int screenW;
	int screenH;
	//tB^̋.
	int filterRatio;
	//L[oCh
	char bindedKey[16+1];

	//t@C̐.
	int soundFileNum;
	//t@C(tpX΃pX͕s)ւ̃|C^.
	char soundFileName[16][256];
	//,t@Cւ̃|C^.ɕ\p.
	char* soundFilePureFileName[16];

	//XRAƃnCXRA.sɏ܂...
	int highScore;
	int score;

}Settings;

#endif //_GMENTRY_HEAD_
